/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.dataservice.relational.datasource.FormulaMapping;
import com.jinfonet.dataservice.relational.datasource.NormalParameter;
import com.jinfonet.dataservice.relational.datasource.ParameterMapping;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.connect.DbValue;
import jet.dataengine8.core.queryengine.transform.AttributeContainer;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.datasource.JRParameter;
import jet.datasource.JRResultSet;
import jet.datasource.JRUDSHostVariableContainer;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.datasource.LoadUserDataSourceException;
import jet.datasource.enterprisedb.EnterpriseDbProcedureUDS;
import jet.datasource.oracle.OracleProcedureUDS;
import jet.formula.JavaFormula;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.engine.UUDSEngine;
import jet.universe.exception.CannotFindEntity;
import toolkit.db.DbTools;
import toolkit.db.ResultSetInfo;
import toolkit.db.gui.MappingSQLType;

public class DataSourceInfo
extends ResultSetInfo {
    protected String strDSName;
    protected String strDescription;
    protected String strClassName;
    protected String strParameter;
    protected boolean bSpecifyMetaData = false;
    protected boolean useDefaultConnection = false;
    JRUDSHostVariableContainer parameterContainer;
    private JetUUniverse SEDU;
    private String add;
    private static JRLogger addEscapeChar = JRLogger.getLogger(DataSourceInfo.class.getName());
    private Hashtable append;

    public DataSourceInfo() {
    }

    public DataSourceInfo(String string, String string2, String string3) {
        this.strDSName = string;
        this.strClassName = string2;
        this.strParameter = string3;
    }

    public DataSourceInfo(String string, String string2, String string3, JRUDSHostVariableContainer jRUDSHostVariableContainer) {
        this.strDSName = string;
        this.strClassName = string2;
        this.strParameter = string3;
        this.parameterContainer = jRUDSHostVariableContainer;
    }

    public DataSourceInfo(JetUUniverse jetUUniverse, String string, String string2, String string3, String string4, JRUDSHostVariableContainer jRUDSHostVariableContainer) {
        this.SEDU = jetUUniverse;
        this.add = string;
        this.strDSName = string2;
        this.strClassName = string3;
        this.strParameter = string4;
        this.parameterContainer = jRUDSHostVariableContainer;
    }

    public DataSourceInfo(String string, String string2, String string3, Vector vector) {
        this.strDSName = string;
        this.strClassName = string2;
        this.strParameter = string3;
        this.vecColumns = vector;
        this.bSpecifyMetaData = true;
    }

    public DataSourceInfo(String string, String string2, String string3, Vector vector, JRUDSHostVariableContainer jRUDSHostVariableContainer) {
        this.strDSName = string;
        this.strClassName = string2;
        this.strParameter = string3;
        this.vecColumns = vector;
        this.parameterContainer = jRUDSHostVariableContainer;
        this.bSpecifyMetaData = true;
    }

    public DataSourceInfo(JetUUniverse jetUUniverse, String string, String string2, String string3, String string4, Vector vector, JRUDSHostVariableContainer jRUDSHostVariableContainer) {
        this.SEDU = jetUUniverse;
        this.add = string;
        this.strDSName = string2;
        this.strClassName = string3;
        this.strParameter = string4;
        this.vecColumns = vector;
        this.parameterContainer = jRUDSHostVariableContainer;
        this.bSpecifyMetaData = true;
    }

    public void initialize() throws LoadUserDataSourceException {
        if (this.strClassName.equals("jet.datasource.oracle.OracleProcedureUDS")) {
            this.bOracleRS = true;
        }
        if (this.strClassName.equals("jet.datasource.enterprisedb.EnterpriseDbProcedureUDS")) {
            this.bEnterpriseDb = true;
        }
        String string = this.resolveParaString(this.strParameter);
        if (addEscapeChar.isDebugEnabled()) {
            addEscapeChar.debug("Catalog\n" + string);
        }
        try {
            Class<?> clazz = Class.forName(this.strClassName);
            Object obj = clazz.newInstance();
            if (!(obj instanceof JRResultSet) && !(obj instanceof JRUserDataSource)) {
                throw new LoadUserDataSourceException(6, this.strClassName);
            }
            if (this.vecColumns.size() == 0 && obj instanceof JRUserDataSource) {
                JetUJDBCConnection jetUJDBCConnection;
                Object object;
                if (this.bOracleRS && string.indexOf("DRIVER") == -1 && string.indexOf("URL") == -1 && (object = this.SEDU.getDatabase(this.add).getConnection()) instanceof JetUJDBCConnection) {
                    jetUJDBCConnection = (JetUJDBCConnection)object;
                    ((OracleProcedureUDS)obj).setCatalogConnectionInfo(jetUJDBCConnection.getURL(), jetUJDBCConnection.getJdbcDriver(), jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD());
                    this.useDefaultConnection = true;
                }
                if (this.bEnterpriseDb && string.indexOf("DRIVER") == -1 && string.indexOf("URL") == -1 && (object = this.SEDU.getDatabase(this.add).getConnection()) instanceof JetUJDBCConnection) {
                    jetUJDBCConnection = (JetUJDBCConnection)object;
                    ((EnterpriseDbProcedureUDS)obj).setCatalogConnectionInfo(jetUJDBCConnection.getURL(), jetUJDBCConnection.getJdbcDriver(), jetUJDBCConnection.getUID(), jetUJDBCConnection.getPSWD());
                    this.useDefaultConnection = true;
                }
                if ((object = ((JRUserDataSource)obj).getResultSet(string)) != null) {
                    if (!this.bSpecifyMetaData) {
                        this.setResultSet((ResultSet)object);
                    }
                } else {
                    throw new LoadUserDataSourceException(8, this.strClassName);
                }
                ((JRUserDataSource)obj).releaseResultSet();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoadUserDataSourceException(1, this.strClassName);
        }
        catch (InstantiationException instantiationException) {
            throw new LoadUserDataSourceException(2, this.strClassName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LoadUserDataSourceException(3, this.strClassName);
        }
        catch (SQLException sQLException) {
            throw new LoadUserDataSourceException(-1, sQLException.getMessage());
        }
    }

    public String getDSName() {
        return this.strDSName;
    }

    public void setDSName(String string) {
        this.strDSName = string;
    }

    public String getDescription() {
        return this.strDescription;
    }

    public void setDescription(String string) {
        this.strDescription = string;
    }

    public String getClassName() {
        return this.strClassName;
    }

    public void setClassName(String string) {
        this.strClassName = string;
    }

    public String getParameter() {
        return this.strParameter;
    }

    public void setParameter(String string) {
        this.strParameter = string;
    }

    public boolean isSpecifyMetaData() {
        return this.bSpecifyMetaData;
    }

    public boolean isUseDefaultConnection() {
        return this.useDefaultConnection;
    }

    public void setSpecifyMetaData(boolean bl) {
        this.bSpecifyMetaData = bl;
    }

    public String resolveParaString(String string) throws LoadUserDataSourceException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        StringBuffer stringBuffer3 = new StringBuffer();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this.bOracleRS) {
            try {
                Properties properties = OracleProcedureUDS.string2Properties(string);
                string3 = properties.getProperty(UUDSEngine.inparamvalue);
                string4 = properties.getProperty("PARAMVALUE");
            }
            catch (JRUserDataSourceException jRUserDataSourceException) {
                // empty catch block
            }
        }
        boolean bl = false;
        while ((string2 = DbTools.getFirstParameterNameInString(stringBuffer2, stringBuffer3)) != null) {
            stringBuffer.append(stringBuffer3);
            if (DbTools.isSpecialField(string2) == -1) {
                JetUResourceEntity jetUResourceEntity = this.SEDU.getResourceByName(this.add, null, string2);
                String string5 = null;
                if (jetUResourceEntity instanceof JetUFormula) {
                    try {
                        DbValue[] dbValueArray;
                        AttributeContainer attributeContainer = new AttributeContainer();
                        FormulaMapping formulaMapping = QueryTransform.createFormulaMapping((JetUFormula)jetUResourceEntity);
                        attributeContainer.add(formulaMapping);
                        Vector vector = ((JetUFormula)jetUResourceEntity).getRefAllFormuFld();
                        JetUDatabase jetUDatabase = this.SEDU.getDatabase(this.add);
                        int n = vector.size();
                        for (int i = 0; i < n; ++i) {
                            dbValueArray = jetUDatabase.getFormulaByResourceName((String)vector.get(i));
                            formulaMapping = QueryTransform.createFormulaMapping((JetUFormula)dbValueArray);
                            attributeContainer.add(formulaMapping);
                        }
                        JavaFormula javaFormula = this.SEDU.loadJavaFormula();
                        Vector vector2 = this.SEDU.getParameters(this.add);
                        int n2 = vector2.size();
                        for (int i = 0; i < n2; ++i) {
                            JetUParameter jetUParameter = (JetUParameter)vector2.get(i);
                            ParamDesc paramDesc = jetUParameter.getParamDesc();
                            String string6 = paramDesc.getName();
                            NormalParameter normalParameter = new NormalParameter(paramDesc.getName(), paramDesc.isReferedBy(), paramDesc.getValue(), Types.sqlTypeToType(MappingSQLType.mapSQLTypeToInt(paramDesc.getType())), paramDesc.getFormat(), -1, -1, -1, paramDesc);
                            ParameterMapping parameterMapping = new ParameterMapping(normalParameter.getName(), normalParameter);
                            parameterMapping.setAliasName(string6);
                            attributeContainer.add(parameterMapping);
                        }
                        dbValueArray = QueryTransform.computeConstantFormulas(attributeContainer, null, javaFormula);
                        string5 = dbValueArray[0].toString();
                    }
                    catch (CannotFindEntity cannotFindEntity) {
                        throw new LoadUserDataSourceException(7, cannotFindEntity.getEntityName());
                    }
                    catch (Exception exception) {
                        throw new LoadUserDataSourceException(7, string2);
                    }
                } else {
                    string5 = this.getParaDefaultValue(string2);
                }
                if (this.bOracleRS) {
                    if (string3 != null && string3.indexOf(string2) != -1) {
                        bl = true;
                    } else if (string4 != null && string4.indexOf(string2) != -1) {
                        bl = true;
                    }
                }
                if (bl) {
                    stringBuffer.append(UUDSEngine.addEscapeChar(string5, string));
                    continue;
                }
                stringBuffer.append(string5);
                continue;
            }
            stringBuffer.append("@" + string2);
        }
        stringBuffer.append(stringBuffer3);
        return stringBuffer.toString();
    }

    public void setParamNameFormatPair(Hashtable hashtable) {
        this.append = hashtable;
    }

    public Hashtable getParamNameFormatPair() {
        return this.append;
    }

    public String getParaDefaultValue(String string) throws LoadUserDataSourceException {
        Vector vector = this.parameterContainer.getHostVariables();
        String string2 = (String)this.append.get(string);
        if (string2 != null) {
            for (int i = 0; i < vector.size(); ++i) {
                JetUParameter jetUParameter = (JetUParameter)vector.elementAt(i);
                if (!jetUParameter.getParamDesc().name.equalsIgnoreCase(string)) continue;
                ParamDesc paramDesc = jetUParameter.getParamDesc();
                if (paramDesc.type.equalsIgnoreCase("String")) {
                    return paramDesc.getDefaultValue();
                }
                String string3 = paramDesc.getFormat();
                paramDesc.setFormat(string2);
                String string4 = paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault());
                paramDesc.setFormat(string3);
                return string4;
            }
            throw new LoadUserDataSourceException(7, string);
        }
        JRParameter jRParameter = this.parameterContainer.getHostVariable(string);
        if (jRParameter != null) {
            return jRParameter.getValue().toString();
        }
        throw new LoadUserDataSourceException(7, string);
    }
}

