/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.dataengine.util.StringTools;
import jet.log.JRLogger;
import jet.universe.psql.PointEx;
import toolkit.db.DbToolsConstants;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.SQLKeywords;

public class DbTools
implements DbToolsConstants {
    public static String sQuoteChar = "\"";
    private static final int SEDU = 100;
    private static int[] add = new int[26];
    private static JRLogger addElement = JRLogger.getLogger(DbTools.class.getName());
    public static int unx = 10;
    private static final int append = 0;
    private static final int canCastAsSQLIdentifier = 1;
    private static final int charAt = 2;
    private static final int concat = 3;

    public static void setQuoteChar(String string) {
        sQuoteChar = string;
    }

    public static String getQuoteChar() {
        return sQuoteChar;
    }

    public static boolean hasTheStringInVector(String string, Vector vector) {
        if (vector != null && string != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(vector.elementAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStringSame(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean isStringSameNull(String string, String string2) {
        if (string == null || string2 == null) {
            if (string == null && string2 == null) {
                return true;
            }
            return string == null ? string2.length() == 0 : string.length() == 0;
        }
        return string.equals(string2);
    }

    public static String makeQuotedString(String string) {
        if (string != null) {
            String string2 = "'";
            if (sQuoteChar.trim().length() != 0) {
                string2 = sQuoteChar;
            }
            string = string2 + string + string2;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string) {
        String string2 = sQuoteChar.trim().length() > 0 ? sQuoteChar : "\"";
        if (string.startsWith(string2) && string.endsWith(string2)) {
            return true;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String quotedWhenNeed(String string) {
        if (StringTools.isEmptyStringWithTrim(string)) {
            return string;
        }
        if (!DbTools.canCastAsSQLIdentifier(string)) {
            return sQuoteChar + string + sQuoteChar;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string, String string2) {
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || string2.indexOf(c) != -1)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || string2.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static String quotedWhenNeed(String string, String string2, String string3) {
        if (StringTools.isEmptyStringWithTrim(string)) {
            return string;
        }
        if (string.startsWith(string3) && string.endsWith(string3)) {
            return string;
        }
        if (!DbTools.canCastAsSQLIdentifier(string, string2)) {
            return string3 + string + string3;
        }
        return string;
    }

    public static boolean canCastAsSQLIdentifier(String string, String string2, String string3) {
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || string2.indexOf(c) != -1)) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || string2.indexOf(c) != -1) continue;
            return false;
        }
        return !SQLKeywords.isKeywords(string3, string);
    }

    public static String quotedWhenNeed(String string, String string2, String string3, String string4) {
        if (StringTools.isEmptyStringWithTrim(string)) {
            return string;
        }
        if (string.startsWith(string3) && string.endsWith(string3)) {
            return string;
        }
        if (string3.equals("`")) {
            string2 = "";
        }
        if (!DbTools.canCastAsSQLIdentifier(string, string2, string4)) {
            return string3 + string + string3;
        }
        return string;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static int bytesToInt(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return 0;
        }
        return byArray[0] | byArray[1] << 8 | byArray[2] << 16 | byArray[3] << 24;
    }

    private static int SEDU(String string) {
        if (string != null && string.length() == 1) {
            char c = string.charAt(0);
            if (c >= 'a' && c <= 'z') {
                return c - 97;
            }
            if (c >= 'A' && c <= 'Z') {
                return c - 65;
            }
        }
        return -1;
    }

    public static String getCorrelationNameOfTable(int n, String string) {
        int n2;
        String string2 = "";
        String string3 = "";
        int n3 = 0;
        if (string.length() > 0) {
            string2 = string.substring(0, 1);
            n3 = DbTools.SEDU(string2);
        }
        if (n > 1) {
            int n4 = n3;
            int n5 = add[n4];
            add[n4] = n5 + 1;
            n2 = n5 % 100;
        } else {
            n2 = 1;
        }
        string3 = string2.concat(String.valueOf(n2));
        return string3;
    }

    public static String getFirstName(String string) {
        char c;
        int n;
        String string2 = null;
        String string3 = string.trim();
        for (n = 0; n < string3.length() && (c = string3.charAt(n)) != '('; ++n) {
        }
        string2 = string3.substring(0, n);
        return string2;
    }

    public static String getColumnsTableName(PsqlSelColumn psqlSelColumn) {
        String string = "";
        PsqlTable psqlTable = psqlSelColumn.getPsqlTable();
        if (psqlTable != null && (string = psqlTable.getCorrelationName()) == null) {
            string = psqlSelColumn.getTableName();
        }
        return string;
    }

    public static PsqlSelColumn getPsqlSelColumnByTableAndName(String string, String string2, Vector vector) {
        PsqlSelColumn psqlSelColumn = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            psqlSelColumn = (PsqlSelColumn)vector.elementAt(i);
            if (psqlSelColumn.isCompCol() || !DbTools.getColumnsTableName(psqlSelColumn).equals(string) || !psqlSelColumn.getName().equals(string2)) continue;
            return psqlSelColumn;
        }
        return psqlSelColumn;
    }

    public static void copyVector(Vector vector, Vector vector2) {
        if (!vector.isEmpty()) {
            vector.removeAllElements();
        }
        if (!vector2.isEmpty()) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                Object e = vector2.elementAt(i);
                vector.addElement(e);
            }
        }
    }

    public static Vector getNamesByColumns(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)vector.elementAt(i);
            if (psqlSelColumn.isCompCol()) {
                vector2.addElement(psqlSelColumn.getName());
                continue;
            }
            String string = "";
            string = DbTools.getColumnsTableName(psqlSelColumn);
            string = string.concat(".");
            string = string.concat(psqlSelColumn.getName());
            vector2.addElement(string);
        }
        return vector2;
    }

    public static void setCertainTableByCorrelationName(String string) {
        if (string.length() > 0) {
            String string2 = string.substring(0, 1);
            DbTools.SEDU(string2);
            String string3 = string.substring(1);
            Integer.valueOf(string3).intValue();
        }
    }

    public static String printSQLExceptionMessage(SQLException sQLException) {
        if (sQLException == null) {
            return "";
        }
        if (addElement.isErrorEnabled()) {
            addElement.error("", sQLException);
        }
        String string = sQLException.getMessage();
        return string;
    }

    public static boolean hasCompCols(Vector vector) {
        if (vector != null) {
            for (int i = vector.size() - 1; i >= 0; --i) {
                if (!((PsqlSelColumn)vector.elementAt(i)).isCompCol()) continue;
                return true;
            }
        }
        return false;
    }

    public static int isWhichDB(String string) {
        int n = 0;
        if (string != null) {
            if ((string = string.toUpperCase()).startsWith("ACCESS")) {
                n = 2;
            } else if (string.startsWith("Microsoft SQL Server")) {
                n = 1;
            } else if (string.startsWith("TEXT")) {
                n = 4;
            } else if (string.startsWith("XDB")) {
                n = 3;
            } else if (string.startsWith("ORACLE")) {
                n = 5;
            } else if (string.startsWith("MONGODB")) {
                n = 6;
            }
        }
        return n;
    }

    public static boolean hasJdbcOdbcBridge(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("jdbc:odbc:");
        }
        return bl;
    }

    public static Vector concatVectors(Vector vector, Vector vector2) {
        int n;
        Vector vector3 = new Vector();
        int n2 = 0;
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                vector3.addElement(vector.elementAt(n));
            }
        }
        if (vector2 != null) {
            n2 = vector2.size();
            for (n = 0; n < n2; ++n) {
                vector3.addElement(vector2.elementAt(n));
            }
        }
        return vector3;
    }

    public static String convertToAndExpressionString(Vector vector) {
        String string = "";
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            if (i >= n) {
                return string;
            }
            String string3 = (String)vector.elementAt(++i);
            if (i >= n) {
                return string;
            }
            String string4 = (String)vector.elementAt(++i);
            if (i >= n) {
                return string;
            }
            String string5 = (String)vector.elementAt(++i);
            string2.trim();
            string3.trim();
            string4.trim();
            string5.trim();
            if (string2.length() > 0) {
                string2 = " " + string2 + " ";
            }
            string4 = " " + string4 + " ";
            string = string + string2 + string3 + string4 + string5;
        }
        return string;
    }

    public static String getReversedOperator(String string) {
        String string2 = string;
        if (string != null) {
            if (string.equals(">")) {
                string2 = "<";
            } else if (string.equals("<")) {
                string2 = ">";
            } else if (string.equals(">=")) {
                string2 = "<=";
            } else if (string.equals("<=")) {
                string2 = ">=";
            }
        }
        return string2;
    }

    public static String getNotOperator(String string) {
        String string2 = string;
        if (string != null) {
            if (string.equals("=")) {
                string2 = "<>";
            } else if (string.equals(">")) {
                string2 = "<=";
            } else if (string.equals("<")) {
                string2 = ">=";
            } else if (string.equals(">=")) {
                string2 = "<";
            } else if (string.equals("<=")) {
                string2 = ">";
            } else if (string.equals("<>")) {
                string2 = "=";
            } else if (string.equals("between")) {
                string2 = "not between";
            } else if (string.equals("like")) {
                string2 = "not like";
            } else if (string.equals("in")) {
                string2 = "not in";
            } else if (string.equals("exists")) {
                string2 = "not ";
            } else if (string.equals("is null")) {
                string2 = "is not null";
            } else if (string.equals("not between")) {
                string2 = "between";
            } else if (string.equals("not like")) {
                string2 = "like";
            } else if (string.equals("not in")) {
                string2 = "in";
            } else if (string.equals("not exists")) {
                string2 = "exists";
            } else if (string.equals("is not null")) {
                string2 = "is null";
            } else if (string.equals("(+)=")) {
                string2 = "(+)<>";
            } else if (string.equals("(+)>")) {
                string2 = "(+)<=";
            } else if (string.equals("(+)<")) {
                string2 = "(+)>=";
            } else if (string.equals("(+)>=")) {
                string2 = "(+)<";
            } else if (string.equals("(+)<=")) {
                string2 = "(+)>";
            } else if (string.equals("(+)<>")) {
                string2 = "(+)=";
            } else if (string.equals("=(+)")) {
                string2 = "<>(+)";
            } else if (string.equals(">(+)")) {
                string2 = "<=(+)";
            } else if (string.equals("<(+)")) {
                string2 = ">=(+)";
            } else if (string.equals(">=(+)")) {
                string2 = "<(+)";
            } else if (string.equals("<=(+)")) {
                string2 = ">(+)";
            } else if (string.equals("<>(+)")) {
                string2 = "=(+)";
            } else if (string.equals("*=")) {
                string2 = "*<>";
            } else if (string.equals("*>")) {
                string2 = "*<=";
            } else if (string.equals("*<")) {
                string2 = "*>=";
            } else if (string.equals("*>=")) {
                string2 = "*<";
            } else if (string.equals("*<=")) {
                string2 = "*>";
            } else if (string.equals("*<>")) {
                string2 = "*=";
            } else if (string.equals("=*")) {
                string2 = "<>*";
            } else if (string.equals(">*")) {
                string2 = "<=*";
            } else if (string.equals("<*")) {
                string2 = ">=*";
            } else if (string.equals(">=*")) {
                string2 = "<*";
            } else if (string.equals("<=*")) {
                string2 = ">*";
            } else if (string.equals("<>*")) {
                string2 = "=*";
            }
        }
        return string2;
    }

    public static String makeSqlString(String string) {
        if (string != null) {
            return "'" + DbTools.replaceQuotes(string) + "'";
        }
        return "''";
    }

    public static String makeDqString(String string) {
        if (string != null) {
            return "\"" + DbTools.replaceQuotes(string) + "\"";
        }
        return "\"\"";
    }

    public static String replaceQuotes(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '\'') continue;
            if (i > 0) {
                if (stringBuffer.charAt(i - 1) != '\'') {
                    stringBuffer.insert(i, '\'');
                    continue;
                }
                --i;
                continue;
            }
            stringBuffer.insert(i, '\'');
        }
        if (stringBuffer.length() > string.length()) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        if (string == null) {
            return false;
        }
        return string.startsWith("Windows");
    }

    public static String getStackTraceString(Exception exception) {
        return "";
    }

    public static Vector getMappingNamesInRawSql(String string) {
        return DbTools.getMappingNamesInRawSql(string, true);
    }

    public static Vector getMappingNamesInRawSql(String string, boolean bl) {
        Vector<String> vector = new Vector<String>(10);
        if (string == null || string.trim().length() == 0) {
            return vector;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '@' || bl && c == ':') {
                        n = 1;
                        stringBuffer.setLength(0);
                        continue block6;
                    }
                    if (c != '\'' && c != '\"') continue block6;
                    n = 3;
                    continue block6;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        n = 0;
                        vector.addElement(stringBuffer.toString());
                        --i;
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '\"') {
                        n = 0;
                        vector.addElement(stringBuffer.toString());
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case 3: {
                    if (c != '\'' && c != '\"') continue block6;
                    n = 0;
                }
            }
        }
        if (n != 0 && n != 3) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public static ArrayList getMappingNamesInRawSql(String string, String string2) {
        ArrayList<PointEx> arrayList = new ArrayList<PointEx>();
        if (string == null || string.trim().length() == 0) {
            return arrayList;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        PointEx pointEx = new PointEx();
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer.setLength(0);
                        pointEx.x = i;
                        continue block6;
                    }
                    if (c != '\'' && c != '\"') continue block6;
                    n = 3;
                    continue block6;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        n = 0;
                        pointEx.y = i;
                        if (string2 == null || string2.equalsIgnoreCase(stringBuffer.toString())) {
                            arrayList.add(new PointEx(pointEx));
                        }
                        --i;
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '\"') {
                        n = 0;
                        pointEx.y = i + 1;
                        if (string2 != null && !string2.equalsIgnoreCase(stringBuffer.toString())) continue block6;
                        arrayList.add(new PointEx(pointEx));
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case 3: {
                    if (c != '\'' && c != '\"') continue block6;
                    n = 0;
                }
            }
        }
        if (n != 0 && n != 3) {
            pointEx.y = string.length();
            if (string2 == null || string2.equalsIgnoreCase(stringBuffer.toString())) {
                arrayList.add(new PointEx(pointEx));
            }
        }
        return arrayList;
    }

    public static String getFirstParameterNameInString(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        return DbTools.getFirstParameterNameInString(stringBuffer, stringBuffer2, true);
    }

    public static String getFirstParameterNameInString(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        if (stringBuffer == null) {
            return null;
        }
        int n = 0;
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.setLength(0);
        int n3 = 0;
        block6: for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '@' || bl && c == ':') {
                        n = 1;
                        stringBuffer3.setLength(0);
                        continue block6;
                    }
                    if (c == '\"') {
                        n3 = stringBuffer2.length();
                        n = 3;
                        continue block6;
                    }
                    stringBuffer2.append(c);
                    continue block6;
                }
                case 1: {
                    if (c == '\"' && stringBuffer3.length() == 0) {
                        n = 2;
                        continue block6;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        DbTools.delete(stringBuffer, i);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '\"') {
                        DbTools.delete(stringBuffer, i + 1);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    continue block6;
                }
                case 3: {
                    if (c == '\"') {
                        if (n3 == stringBuffer2.length()) {
                            stringBuffer2.append('\"');
                        }
                        n = 0;
                        continue block6;
                    }
                    stringBuffer2.append(c);
                }
            }
        }
        if (n == 1 || n == 2) {
            DbTools.delete(stringBuffer, n2);
            if (stringBuffer3.length() == 0) {
                return null;
            }
            return stringBuffer3.toString();
        }
        if (n == 3) {
            stringBuffer2.insert(n3, '\"');
        }
        return null;
    }

    public static String getFirstParameterNameInString2(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (stringBuffer == null) {
            return null;
        }
        int n = 0;
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.setLength(0);
        int n3 = 0;
        block6: for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '@' || c == ':') {
                        n = 1;
                        stringBuffer3.setLength(0);
                        continue block6;
                    }
                    if (c == '\"') {
                        stringBuffer2.append('\"');
                        n = 3;
                        continue block6;
                    }
                    stringBuffer2.append(c);
                    continue block6;
                }
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        DbTools.delete(stringBuffer, i);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '\"') {
                        DbTools.delete(stringBuffer, i + 1);
                        return stringBuffer3.toString();
                    }
                    stringBuffer3.append(c);
                    continue block6;
                }
                case 3: {
                    if (c == '\"') {
                        stringBuffer2.append('\"');
                        n = 0;
                        continue block6;
                    }
                    stringBuffer2.append(c);
                }
            }
        }
        if (n == 1) {
            DbTools.delete(stringBuffer, n2);
            return stringBuffer3.toString();
        }
        if (n == 3) {
            stringBuffer2.insert(n3, '\"');
        }
        return null;
    }

    public static String[] toArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement((String)stringTokenizer.nextElement());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void delete(StringBuffer stringBuffer, int n) {
        String string = stringBuffer.toString();
        string = string.substring(n);
        stringBuffer.setLength(0);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string.charAt(i));
        }
    }

    public static int mergeReadOnly(int n, int n2) {
        int n3 = n;
        if (n2 != 1) {
            n3 = n2;
        }
        return n3;
    }

    public static int mergeTransactionIsolation(int n, int n2) {
        int n3 = n;
        if (n2 != 0) {
            n3 = n2;
        }
        int n4 = 0;
        switch (n3) {
            case 2: {
                n4 = 1;
                break;
            }
            case 3: {
                n4 = 2;
                break;
            }
            case 4: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 8;
            }
        }
        return n4;
    }

    public static boolean isJinfonetObjProtocal(String string) {
        return string != null && string.toLowerCase().startsWith("jdbc:jinfonet:object");
    }

    public static String toFmlOperator(String string) {
        if (string != null && string.trim().length() > 0) {
            String string2 = string.trim();
            if (string2.equals("=")) {
                string2 = "==";
            } else if (string2.equals("<>")) {
                string2 = "!=";
            } else if (string2.equals(">")) {
                string2 = ">";
            } else if (string2.equals("<")) {
                string2 = "<";
            } else if (string2.equals(">=")) {
                string2 = ">=";
            } else if (string2.equals("<=")) {
                string2 = "<=";
            } else if (string2.equalsIgnoreCase("AND")) {
                string2 = "&&";
            } else if (string2.equalsIgnoreCase("OR")) {
                string2 = "||";
            } else if (string2.equalsIgnoreCase("And Not")) {
                string2 = "&&!";
            } else if (string2.equalsIgnoreCase("Or Not")) {
                string2 = "||!";
            }
            return string2;
        }
        return "";
    }

    public static void copyHT(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (v == null || hashtable2.contains(k)) continue;
            hashtable2.put(k, v);
        }
    }

    public static void updateHT(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (v == null) continue;
            hashtable2.put(k, v);
        }
    }

    public static String getTransactionStringFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_TRANSACTION_DEFAULT;
                break;
            }
            case 1: {
                string = STR_TRANSACTION_NONE;
                break;
            }
            case 2: {
                string = STR_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            case 3: {
                string = STR_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 4: {
                string = STR_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 5: {
                string = STR_TRANSACTION_SERIALIZABLE;
                break;
            }
            default: {
                string = "Unsupported Transaction Level";
            }
        }
        return string;
    }

    public static String getReadOnlyStringFromInt(int n) {
        String string;
        switch (n) {
            case 1: {
                string = STR_READ_ONLY_DEFAULT;
                break;
            }
            case 2: {
                string = STR_READ_ONLY_TRUE;
                break;
            }
            case 0: {
                string = STR_READ_ONLY_FALSE;
                break;
            }
            default: {
                string = "Unsupported Read Only Level";
            }
        }
        return string;
    }

    public static String getQualifyOptionStringFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_ENCODING_AUTO;
                break;
            }
            case 1: {
                string = STR_ENCODING_YES;
                break;
            }
            case 2: {
                string = STR_ENCODING_NO;
                break;
            }
            default: {
                string = "Unsupported Qualify Option";
            }
        }
        return string;
    }

    public static String getExtraNamePatternFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_EXTRA_NAME_USERDEFINED;
                break;
            }
            case 1: {
                string = STR_EXTRA_NAME_USERDEFINED;
                break;
            }
            default: {
                string = "Unsupported extra name pattern";
            }
        }
        return string;
    }

    public static String getEncodingPatternFromInt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = STR_ENCODING_AUTO;
                break;
            }
            case 1: {
                string = STR_ENCODING_YES;
                break;
            }
            case 2: {
                string = STR_ENCODING_NO;
                break;
            }
            default: {
                string = "Unsupported extra name pattern";
            }
        }
        return string;
    }

    public static int isSpecialField(String string) {
        int n = SPECIAL_FIELDS.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(SPECIAL_FIELDS[i])) continue;
            return i;
        }
        return -1;
    }
}

