/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.dataengine.util.DSLog;

public class JdbcScalarFunctions {
    public static String[] getSupported(Connection connection) {
        String string;
        DatabaseMetaData databaseMetaData;
        Vector vector = new Vector();
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            return null;
        }
        try {
            string = databaseMetaData.getStringFunctions();
            JdbcScalarFunctions.convertFuncsStringToVector(string, vector);
        }
        catch (SQLException sQLException) {
            DSLog.getDSLog(JdbcScalarFunctions.class.getName()).debug(sQLException.getMessage());
        }
        try {
            string = databaseMetaData.getNumericFunctions();
            JdbcScalarFunctions.convertFuncsStringToVector(string, vector);
        }
        catch (SQLException sQLException) {
            DSLog.getDSLog(JdbcScalarFunctions.class.getName()).debug(sQLException.getMessage());
        }
        try {
            string = databaseMetaData.getTimeDateFunctions();
            JdbcScalarFunctions.convertFuncsStringToVector(string, vector);
        }
        catch (SQLException sQLException) {
            DSLog.getDSLog(JdbcScalarFunctions.class.getName()).debug(sQLException.getMessage());
        }
        int n = vector.size();
        if (n != 0) {
            Object[] objectArray = new String[n];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public static void convertFuncsStringToVector(String string, Vector vector) {
        if (string == null || string.trim().length() == 0 || vector == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken() + "()");
        }
    }

    public static String[] convertFuncsStringToArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Vector vector = new Vector();
        JdbcScalarFunctions.convertFuncsStringToVector(string, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

