/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import toolkit.db.DataSourceInfo;
import toolkit.db.DateTimeFormat;
import toolkit.db.JdbcScalarFunctions;
import toolkit.db.ProcColumnInfo;
import toolkit.db.ProcParaInfo;
import toolkit.db.gui.MappingSQLType;

public class ProcInfo
extends DataSourceInfo {
    public static final int PROCEDURE_CATALOG = 1;
    public static final int PROCEDURE_SCHEMA = 2;
    public static final int PROCEDURE_NAME = 3;
    public static final int REMARKS = 4;
    public static final int PROCEDURE_TYPE = 8;
    public static final int PARAM_NAME = 4;
    public static final int PARAM_TYPE = 5;
    public static final int DATA_TYPE = 6;
    public static final int TYPE_NAME = 7;
    public static final int PRECISION = 8;
    public static final int LENGTH = 9;
    public static final int SCALE = 10;
    public static final int RADIX = 11;
    public static final int NULLABLE = 12;
    public static final int procedureResultUnknown = 0;
    public static final int procedureNoResult = 1;
    public static final int procedureReturnsResult = 2;
    public String strCatalog;
    public String strSchema;
    public String strName;
    public String strRemarks;
    public int iType;
    public Vector vecParams = null;
    private static JRLogger SEDU = JRLogger.getLogger(ProcInfo.class.getName());

    public ProcInfo(String string, String string2, String string3, String string4, int n) {
        this.strCatalog = string;
        this.strSchema = string2;
        this.strName = string3;
        this.strRemarks = string4;
        this.iType = n;
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String string) {
        this.strName = string;
    }

    public String getCatalog() {
        return this.strCatalog;
    }

    public String getSchema() {
        return this.strSchema;
    }

    public void setType(int n) {
        this.iType = n;
    }

    public int getType() {
        return this.iType;
    }

    public Vector getParameters() {
        return this.vecParams;
    }

    public void setParams(Vector vector) {
        this.vecParams = vector;
    }

    public int getParamsCount() {
        return this.vecParams == null ? -1 : this.vecParams.size();
    }

    public int getINParamsCount() {
        if (this.vecParams != null) {
            int n = 0;
            int n2 = this.vecParams.size();
            for (int i = 0; i < n2; ++i) {
                ProcParaInfo procParaInfo = (ProcParaInfo)this.vecParams.elementAt(i);
                if (!procParaInfo.isINParameter()) continue;
                ++n;
            }
            return n;
        }
        return -1;
    }

    @Override
    public Vector getColumns() {
        return this.vecColumns;
    }

    @Override
    public void setColumns(Vector vector) {
        this.vecColumns = vector;
    }

    public void fetchProcedureParams(Connection connection, DateTimeFormat dateTimeFormat) throws SQLException {
        this.vecParams = ProcInfo.getProcedureParams(connection, this, dateTimeFormat);
    }

    public void fetchProcColumns(ResultSet resultSet) throws SQLException {
        this.vecColumns = ProcInfo.getProcColumns(resultSet);
    }

    public void fetchProcColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.vecColumns = ProcInfo.getProcColumns(resultSetMetaData);
    }

    public static Vector getProcedures(Connection connection) throws SQLException {
        Object object;
        Object object2;
        Vector<ProcInfo> vector = new Vector<ProcInfo>();
        DatabaseMetaData databaseMetaData = null;
        databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ProcInfo procInfo = null;
        if (connection.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
            object2 = connection.getClass();
            try {
                object = ((Class)object2).getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                ((Method)object).invoke((Object)connection, new Integer(300));
            }
            catch (Throwable throwable) {
                DSLog.getDSLog(JdbcScalarFunctions.class.getName()).debug(throwable.getMessage());
            }
        }
        resultSet = databaseMetaData.getProcedures(null, null, "%");
        object2 = null;
        object = null;
        String string = null;
        boolean bl = false;
        try {
            bl = ProcInfo.SEDU(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (resultSet.next()) {
            object = resultSet.getString(1);
            string = resultSet.getString(2);
            object2 = resultSet.getString(3);
            if (bl && ((String)object2).lastIndexOf(59) > 0) {
                object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(59));
            }
            procInfo = new ProcInfo((String)object, string, (String)object2, resultSet.getString(4), resultSet.getShort(8));
            vector.addElement(procInfo);
        }
        resultSet.close();
        return vector;
    }

    private static boolean SEDU(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        return "1".equals(String.valueOf(databaseMetaData.getDriverMajorVersion())) && "2".equals(String.valueOf(databaseMetaData.getDriverMinorVersion())) && "Microsoft SQL Server 2005 JDBC Driver".equals(databaseMetaData.getDriverName()) && "1.2.2828.100".equals(databaseMetaData.getDriverVersion());
    }

    public static Vector getProcedures(Connection connection, String string) throws SQLException {
        Vector<ProcInfo> vector = new Vector<ProcInfo>();
        DatabaseMetaData databaseMetaData = null;
        databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ProcInfo procInfo = null;
        if (connection.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
            Class<?> clazz = connection.getClass();
            try {
                Method method = clazz.getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                method.invoke((Object)connection, new Integer(300));
            }
            catch (Throwable throwable) {
                DSLog.getDSLog(JdbcScalarFunctions.class.getName()).debug(throwable.getMessage());
            }
        }
        if ((resultSet = databaseMetaData.getProcedures(string, null, "%")) != null) {
            while (resultSet.next()) {
                procInfo = new ProcInfo(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getShort(8));
                vector.addElement(procInfo);
            }
            resultSet.close();
        }
        return vector;
    }

    public static Vector getProcedureParams(Connection connection, ProcInfo procInfo, DateTimeFormat dateTimeFormat) throws SQLException {
        Vector<ProcParaInfo> vector = new Vector<ProcParaInfo>();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName().toUpperCase();
        boolean bl = string.indexOf("SQL SERVER") != -1;
        ResultSet resultSet = databaseMetaData.getProcedureColumns(procInfo.getCatalog(), procInfo.getSchema(), procInfo.getName(), "%");
        int n = 1;
        ProcParaInfo procParaInfo = null;
        boolean bl2 = true;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            int n2 = resultSet.getInt(5);
            if (SEDU.isDebugEnabled()) {
                SEDU.debug("All of the parameters of this stored procedure: \ntype =  " + n2 + " name =" + string2);
            }
            if (n2 != 1 && n2 != 2 && n2 != 4) continue;
            int n3 = resultSet.getInt(6);
            String string3 = resultSet.getString(7);
            if (bl && n3 == -9 && "date".equals(string3)) {
                n3 = 91;
            }
            procParaInfo = new ProcParaInfo(n, string2, n2, JetUConnection.mapColType(n3), string3, resultSet.getInt(8), resultSet.getInt(9), resultSet.getShort(10), resultSet.getShort(11), resultSet.getShort(12), bl2, dateTimeFormat);
            vector.addElement(procParaInfo);
            ++n;
        }
        resultSet.close();
        return vector;
    }

    public static Vector getProcColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        Vector<ProcColumnInfo> vector = new Vector<ProcColumnInfo>();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            int n2 = resultSetMetaData.getPrecision(i);
            if (n2 <= 0) {
                n2 = resultSetMetaData.getColumnDisplaySize(i);
            }
            vector.addElement(new ProcColumnInfo(i, resultSetMetaData.getColumnLabel(i), MappingSQLType.mapColType(resultSetMetaData.getColumnType(i)), n2, 0, resultSetMetaData.getScale(i), 0, resultSetMetaData.isNullable(i), resultSetMetaData.getColumnType(i) == 2003));
        }
        return vector;
    }

    public static Vector getProcColumns(ResultSet resultSet) throws SQLException {
        return ProcInfo.getProcColumns(resultSet.getMetaData());
    }

    public boolean hasBinaryParameter() {
        if (this.vecParams == null) {
            return false;
        }
        ProcParaInfo procParaInfo = null;
        int n = this.vecParams.size();
        for (int i = 0; i < n; ++i) {
            procParaInfo = (ProcParaInfo)this.vecParams.elementAt(i);
            if (!procParaInfo.isBinaryParameter()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName() + "|" + this.getParameters() + "|" + this.getColumns();
    }
}

