/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import toolkit.db.DbTools;
import toolkit.db.api.SQLMapInfo;

public class PsqlColumn {
    public String name = null;
    public int type = -1;
    public String type_name = null;
    public int precision = 0;
    public int length = 0;
    public int scale = 0;
    public int radix = 10;
    public int nullable = 0;
    public String remarks = null;
    public String mappingName = null;
    public boolean array = false;
    private boolean append = false;
    public boolean bHideId = false;

    public PsqlColumn() {
    }

    public PsqlColumn(String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, String string3) {
        this(string, n, string2, n2, n3, n4, n5, n6, string3, false);
    }

    public PsqlColumn(String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, String string3, boolean bl) {
        this.name = string;
        this.type = n;
        this.type_name = string2;
        this.precision = n2;
        this.length = n3;
        this.scale = n4;
        this.radix = n5;
        this.nullable = n6;
        this.remarks = string3;
        this.array = bl;
    }

    public PsqlColumn getCopy() {
        PsqlColumn psqlColumn = new PsqlColumn(this.name, this.type, this.type_name, this.precision, this.length, this.scale, this.radix, this.nullable, this.remarks, this.array);
        psqlColumn.mappingName = this.mappingName;
        psqlColumn.append = this.append;
        return psqlColumn;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(SQLMapInfo sQLMapInfo) {
        return sQLMapInfo == null ? this.name : (String)sQLMapInfo.getColMap().get(this.mappingName.toUpperCase());
    }

    public String getQuotedName(String string, String string2, String string3, SQLMapInfo sQLMapInfo) {
        return PsqlColumn.getQuotedName(this.name, this.mappingName, string, string2, string3, sQLMapInfo);
    }

    public static String getQuotedName(String string, String string2, String string3, String string4, String string5, SQLMapInfo sQLMapInfo) {
        return DbTools.quotedWhenNeed(sQLMapInfo == null ? string : (String)sQLMapInfo.getColMap().get(string2.toUpperCase()), string3, string4, string5);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setArray(boolean bl) {
        this.array = bl;
    }

    public boolean getArray() {
        return this.array;
    }

    public boolean isShowMappingName() {
        return this.append;
    }

    public void setShowMappingName(boolean bl) {
        this.append = bl;
    }

    public String getShowName() {
        return this.getShowName(this.append);
    }

    public String getShowName(boolean bl) {
        if (bl) {
            if (this.mappingName == null) {
                return this.name;
            }
            return this.mappingName;
        }
        return this.name;
    }

    public static boolean canJoin(PsqlColumn psqlColumn, PsqlColumn psqlColumn2) {
        int n;
        if (psqlColumn == null || psqlColumn2 == null || psqlColumn.array != psqlColumn2.array) {
            return false;
        }
        int n2 = psqlColumn.getType();
        if (n2 == (n = psqlColumn2.getType()) && n != 1111) {
            return true;
        }
        switch (n2) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (n != 4 && n != -5 && n != 5 && n != -6) break;
                return true;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (n != 3 && n != 8 && n != 6 && n != 2 && n != 7) break;
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                if (n != 1 && n != 12 && n != -1) break;
                return true;
            }
            case -4: 
            case -3: 
            case -2: {
                if (n != -2 && n != -3 && n != -4) break;
                return true;
            }
        }
        return false;
    }

    public boolean isHide() {
        return this.bHideId;
    }

    public void setHide(boolean bl) {
        this.bHideId = bl;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + " " + this.name + "(" + this.mappingName + ")";
    }
}

