/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import jet.dataengine.api.datasource.xml.XmlTransformationService;
import jet.log.JRLogger;
import jet.universe.JetUJsonConnection;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlFKey;
import toolkit.db.PsqlFKeyCol;
import toolkit.db.PsqlKeyCol;
import toolkit.db.PsqlTable;
import toolkit.db.SQLKeywords;
import toolkit.db.SqlSupportInfo;

public class PsqlJdbcDSInfo
implements SqlSupportInfo {
    public Connection dbcon = null;
    public Vector vQualifiers = new Vector();
    public Vector vOwners = new Vector();
    public Vector vPsqlTables = new Vector();
    public Vector vQlfs1 = new Vector();
    public Vector vOwners1 = new Vector();
    public boolean bSuppOwner = false;
    public boolean bSuppQlf = false;
    public boolean bSuppQlfStart = false;
    public boolean bSuppQlfEnd = false;
    public boolean bSuppPKey = false;
    public boolean bSuppFKey = false;
    public boolean bSuppAlias = false;
    public boolean bSuppCorr = false;
    public boolean bSuppOuterJoin = false;
    public boolean bSuppCatInProc = false;
    public boolean bSuppSchInProc = false;
    public String sQlfSep = ".";
    public String sQuoteChar = "\"";
    public String sExtraNameChar = "";
    public String sStringFuncs = null;
    public String sNumericFuncs = null;
    public String sTimeDateFuncs = null;
    public String sDatabaseName = null;
    public String strExtraKeywords = "";
    private static JRLogger NFKName = JRLogger.getLogger(PsqlJdbcDSInfo.class.getName());

    public PsqlJdbcDSInfo() {
    }

    public PsqlJdbcDSInfo(Connection connection) {
        this(connection, true);
    }

    public PsqlJdbcDSInfo(Connection connection, boolean bl) {
        this.dbcon = connection;
        if (bl) {
            this.init();
        }
    }

    public void init() {
        this.getSupportInfo();
        if (this.bSuppOwner) {
            this.getOwners();
        }
        if (this.bSuppQlf) {
            this.getQualifiers();
        }
    }

    public void setConnection(Connection connection) {
        this.dbcon = connection;
    }

    public Vector getPsqlTablesVector() {
        if (this.vPsqlTables.size() < 1) {
            this.getTables();
        }
        return this.vPsqlTables;
    }

    public Vector getOwnersVector() {
        return this.vOwners;
    }

    public Vector getQualifiersVector() {
        return this.vQualifiers;
    }

    public PsqlTable getOnePsqlTable(String string, String string2, String string3) {
        if (this.dbcon == null) {
            return null;
        }
        PsqlTable psqlTable = null;
        try {
            try {
                if (string != null && string.trim().length() > 0 && this.canSetCatalog(this.dbcon)) {
                    this.dbcon.setCatalog(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(string, string2, string3, null);
            boolean bl = resultSet.next();
            if (bl) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                psqlTable = new PsqlTable(string4, string5, resultSet.getString(3), resultSet.getString(4));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        return psqlTable;
    }

    public void addTables(String string, String string2) {
        Vector vector = this.addTables(string, string2, null);
        for (int i = 0; i < vector.size(); ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            if (PsqlTable.getTableByName(this.vPsqlTables, psqlTable.getQualifier(), psqlTable.getOwner(), psqlTable.getName(), false) != null) continue;
            this.vPsqlTables.addElement(psqlTable);
        }
    }

    public Vector addTables(String string, String string2, String string3) {
        Vector<PsqlTable> vector = new Vector<PsqlTable>();
        if (this.dbcon == null) {
            return vector;
        }
        try {
            if (string != null && string.trim().length() > 0 && this.canSetCatalog(this.dbcon)) {
                this.dbcon.setCatalog(string);
            }
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            boolean bl;
            Object object;
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            String string4 = string3;
            String string5 = databaseMetaData.getDriverName();
            if (string5.equals("InterClient")) {
                if (NFKName.isDebugEnabled()) {
                    NFKName.debug("JDBC Connection\nThe current JDBC driver is InterClient.  Use \"%\" to get information.");
                }
                if (string4 == null) {
                    string4 = "%";
                }
            } else if (this.dbcon.getClass().getName().equals("oracle.jdbc.driver.OracleConnection") && Locale.getDefault().toString().startsWith("zh")) {
                object = this.dbcon.getClass();
                try {
                    Method method = ((Class)object).getDeclaredMethod("setDefaultRowPrefetch", Integer.TYPE);
                    method.invoke((Object)this.dbcon, new Integer(300));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (!(bl = (object = databaseMetaData.getTables(string, string2, string4, null)).next()) && string4 == null) {
                object.close();
                string4 = "%";
                object = databaseMetaData.getTables(string, string2, string4, null);
                bl = object.next();
            }
            while (bl) {
                String string6 = object.getString(1);
                String string7 = object.getString(2);
                PsqlTable psqlTable = new PsqlTable(string6, string7, object.getString(3).trim(), object.getString(4));
                if (string == null || string2 == null) {
                    vector.addElement(psqlTable);
                    if (string == null && string6 != null && !DbTools.hasTheStringInVector(string6, this.vQlfs1)) {
                        this.vQlfs1.addElement(string6);
                    }
                    if (string2 == null && string7 != null && !DbTools.hasTheStringInVector(string7, this.vOwners1)) {
                        this.vOwners1.addElement(string7);
                    }
                } else {
                    vector.addElement(psqlTable);
                }
                bl = object.next();
            }
            object.close();
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public void getTables() {
        this.vQlfs1.removeAllElements();
        this.vOwners1.removeAllElements();
        try {
            int n = 0;
            int n2 = 0;
            Object var3_4 = null;
            Object var4_5 = null;
            if (this.vQualifiers.size() == 0 && this.vOwners.size() == 0) {
                this.addTables(null, null);
            } else if (this.vQualifiers.size() == 0) {
                for (n2 = 0; n2 < this.vOwners.size(); ++n2) {
                    this.addTables(null, (String)this.vOwners.elementAt(n2));
                }
            } else if (this.vOwners.size() == 0) {
                for (n = 0; n < this.vQualifiers.size(); ++n) {
                    this.addTables((String)this.vQualifiers.elementAt(n), null);
                }
            } else {
                for (n = 0; n < this.vQualifiers.size(); ++n) {
                    for (n2 = 0; n2 < this.vOwners.size(); ++n2) {
                        this.addTables((String)this.vQualifiers.elementAt(n), (String)this.vOwners.elementAt(n2));
                    }
                }
            }
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        if (this.vQlfs1.size() > 0) {
            this.vQualifiers = this.vQlfs1;
        }
        if (this.vOwners1.size() > 0) {
            this.vOwners = this.vOwners1;
        }
    }

    public void getOwners() {
        if (this.dbcon == null) {
            return;
        }
        try {
            boolean bl;
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            boolean bl2 = false;
            if (databaseMetaData.getDriverName().equals("ca.edbc.jdbc.EdbcDriver")) {
                if (NFKName.isDebugEnabled()) {
                    NFKName.debug("Get Owners\nThe current JDBC driver is ca.edbc.jdbc.EdbcDriver, trim owner names!");
                }
                bl2 = true;
            } else if (databaseMetaData.getDriverName().toLowerCase().indexOf("informix") != -1) {
                if (NFKName.isDebugEnabled()) {
                    NFKName.debug("Get Owners\nThe current JDBC driver is informix, trim owner names!");
                }
                bl2 = true;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            boolean bl3 = resultSet.next();
            while (bl3) {
                String string;
                String string2 = string = bl2 ? resultSet.getString(1).trim() : resultSet.getString(1);
                if (string.trim().length() != 0 && !DbTools.hasTheStringInVector(string, this.vOwners)) {
                    this.vOwners.addElement(string);
                }
                bl3 = resultSet.next();
            }
            resultSet.close();
            String string = databaseMetaData.getDatabaseProductName().toUpperCase();
            boolean bl4 = bl = string.indexOf("ORACLE") != -1;
            if (bl && !this.vOwners.contains("PUBLIC")) {
                this.vOwners.addElement("PUBLIC");
            }
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
    }

    public void getQualifiers() {
        try {
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            boolean bl = false;
            if (databaseMetaData.getDriverName().toLowerCase().indexOf("informix") != -1) {
                if (NFKName.isDebugEnabled()) {
                    NFKName.debug("Get getQualifiers\nThe current JDBC driver is informix, trim qualifier names!");
                }
                bl = true;
            }
            ResultSet resultSet = databaseMetaData.getCatalogs();
            boolean bl2 = resultSet.next();
            while (bl2) {
                String string;
                String string2 = string = bl ? resultSet.getString(1).trim() : resultSet.getString(1);
                if (string.trim().length() != 0 && !DbTools.hasTheStringInVector(string, this.vQualifiers)) {
                    this.vQualifiers.addElement(string);
                }
                bl2 = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
    }

    public String getOwnerByName(String string) {
        int n = this.vOwners.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.vOwners.elementAt(i);
            if (!string2.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public String getQualifierByName(String string) {
        int n = this.vQualifiers.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.vQualifiers.elementAt(i);
            if (!string2.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void addColumnsToPsqlTablesVector(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addColumnsOfTable((PsqlTable)vector.elementAt(i));
        }
    }

    public void updatePFKeysToPsqlTablesVector(Vector vector) {
        this.updatePFKeysToPsqlTablesVector(vector, false);
    }

    public void updatePFKeysToPsqlTablesVector(Vector vector, boolean bl) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            if (psqlTable != null) {
                if (bl) {
                    this.updatePKeyNoCheck(psqlTable);
                    this.updateFKeysNoCheck(psqlTable);
                } else {
                    this.updatePKey(psqlTable);
                    this.updateFKeys(psqlTable);
                }
            }
            psqlTable.gotPFK = true;
        }
    }

    public void addColumnsOfTable(PsqlTable psqlTable) {
        if (psqlTable == null) {
            return;
        }
        if (psqlTable.getColumns().size() != 0) {
            return;
        }
        try {
            ResultSet resultSet;
            boolean bl;
            String string = psqlTable.getQualifier();
            String string2 = psqlTable.getOwner();
            if (string != null && string.length() == 0) {
                string = null;
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            try {
                if (string != null && string.trim().length() > 0 && this.canSetCatalog(this.dbcon)) {
                    this.dbcon.setCatalog(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            String string3 = null;
            String string4 = databaseMetaData.getDriverName();
            if (string4.equals("InterClient")) {
                if (NFKName.isDebugEnabled()) {
                    NFKName.debug("JDBC Connection\nThe current JDBC driver is InterClient.  Use \"%\" to get information.");
                }
                string3 = "%";
            }
            if (!(bl = (resultSet = databaseMetaData.getColumns(string, string2, psqlTable.getName(), string3)).next())) {
                resultSet.close();
                string3 = "%";
                resultSet = databaseMetaData.getColumns(string, string2, psqlTable.getName(), string3);
                bl = resultSet.next();
            }
            while (bl) {
                String string5 = resultSet.getString(4).trim();
                int n = resultSet.getInt(5);
                String string6 = resultSet.getString(6);
                int n2 = resultSet.getInt(7);
                int n3 = resultSet.getInt(9);
                int n4 = resultSet.getInt(10);
                int n5 = resultSet.getInt(11);
                String string7 = resultSet.getString(12);
                PsqlColumn psqlColumn = new PsqlColumn(string5, n, string6, n2, n2, n3, n4, n5, string7);
                psqlTable.addPsqlColumn(psqlColumn);
                bl = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
    }

    public void getSupportInfo() {
        String string;
        boolean bl;
        DatabaseMetaData databaseMetaData;
        block45: {
            if (this.dbcon == null) {
                return;
            }
            try {
                databaseMetaData = this.dbcon.getMetaData();
            }
            catch (SQLException sQLException) {
                return;
            }
            bl = false;
            try {
                if (!this.dbcon.getMetaData().getDriverName().startsWith("Pervasive")) {
                    try {
                        string = databaseMetaData.getSchemaTerm();
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (string != null && string.trim().length() != 0) {
                        this.bSuppOwner = true;
                    }
                    try {
                        bl = databaseMetaData.supportsSchemasInDataManipulation();
                    }
                    catch (Exception exception) {
                        NFKName.debug(exception.getMessage());
                    }
                    if (!this.bSuppOwner && bl) {
                        this.bSuppOwner = true;
                    }
                    break block45;
                }
                this.bSuppOwner = false;
            }
            catch (SQLException sQLException) {
                NFKName.debug(sQLException.getMessage());
            }
        }
        try {
            string = databaseMetaData.getCatalogTerm();
        }
        catch (Exception exception) {
            string = "";
        }
        if (string != null && string.trim().length() != 0) {
            this.bSuppQlf = true;
        }
        bl = false;
        try {
            bl = databaseMetaData.supportsCatalogsInDataManipulation();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        if (!this.bSuppQlf && bl) {
            this.bSuppQlf = true;
        }
        bl = false;
        try {
            bl = databaseMetaData.isCatalogAtStart();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        if (!this.bSuppQlf) {
            if (bl) {
                this.bSuppQlfStart = true;
                this.bSuppQlfEnd = false;
            } else {
                this.bSuppQlfEnd = true;
                this.bSuppQlfStart = false;
            }
        }
        try {
            this.sQlfSep = databaseMetaData.getCatalogSeparator();
        }
        catch (Exception exception) {
            this.sQlfSep = ".";
        }
        try {
            this.bSuppCorr = databaseMetaData.supportsTableCorrelationNames();
        }
        catch (Exception exception) {
            this.bSuppCorr = false;
        }
        try {
            this.bSuppAlias = databaseMetaData.supportsColumnAliasing();
        }
        catch (Exception exception) {
            this.bSuppAlias = false;
        }
        try {
            this.bSuppOuterJoin = databaseMetaData.supportsOuterJoins();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            this.sDatabaseName = databaseMetaData.getDatabaseProductName();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            this.sQuoteChar = databaseMetaData.getIdentifierQuoteString();
        }
        catch (Exception exception) {
            this.sQuoteChar = "\"";
        }
        this.bSuppPKey = true;
        this.bSuppFKey = true;
        try {
            this.sStringFuncs = databaseMetaData.getStringFunctions();
            this.sNumericFuncs = databaseMetaData.getNumericFunctions();
            this.sTimeDateFuncs = databaseMetaData.getTimeDateFunctions();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            this.sExtraNameChar = databaseMetaData.getExtraNameCharacters();
        }
        catch (Exception exception) {
            this.sExtraNameChar = "";
        }
        try {
            this.bSuppCatInProc = databaseMetaData.supportsCatalogsInProcedureCalls();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            this.bSuppSchInProc = databaseMetaData.supportsSchemasInProcedureCalls();
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        try {
            this.strExtraKeywords = databaseMetaData.getSQLKeywords();
            SQLKeywords.setDBMSExtraKeywords(this.strExtraKeywords);
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
    }

    public void updatePKey(PsqlTable psqlTable) {
        if (!this.bSuppPKey) {
            return;
        }
        this.updatePKeyNoCheck(psqlTable);
    }

    public void updatePKeyNoCheck(PsqlTable psqlTable) {
        if (psqlTable == null) {
            return;
        }
        if (psqlTable.getColumns().size() == 0) {
            return;
        }
        try {
            ResultSet resultSet;
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            String string = psqlTable.getQualifier();
            String string2 = psqlTable.getOwner();
            String string3 = psqlTable.getName();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            try {
                resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
            }
            catch (SQLException sQLException) {
                this.bSuppPKey = false;
                return;
            }
            String string4 = null;
            boolean bl = false;
            int n = 0;
            boolean bl2 = false;
            boolean bl3 = resultSet.next();
            if (bl3) {
                psqlTable.vPKeyCols.removeAllElements();
            }
            while (bl3) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                string4 = resultSet.getString(4);
                n = resultSet.getInt(5);
                if (string7.equals(string3)) {
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (string6 == null) {
                        string6 = "";
                    }
                    if (string.equals(string5) && string2.equals(string6)) {
                        psqlTable.vPKeyCols.addElement(new PsqlKeyCol(string4, n));
                    }
                }
                bl3 = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
    }

    public void updateFKeys(PsqlTable psqlTable) {
        if (psqlTable.oData instanceof JetUJsonConnection) {
            this.NFKName(psqlTable);
            return;
        }
        if (!this.bSuppFKey) {
            return;
        }
        this.updateFKeysNoCheck(psqlTable);
    }

    private void NFKName(PsqlTable psqlTable) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector vector = psqlTable.getColumns();
        for (int i = 0; i < vector.size(); ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)vector.get(i);
            String string4 = psqlColumn.getName();
            if (!string4.endsWith(XmlTransformationService.NFKName)) continue;
            string3 = string4;
            string = string3.substring(0, string4.length() - XmlTransformationService.NFKName.length());
            string2 = string + XmlTransformationService.NPKName;
            psqlTable.vFKeys.removeAllElements();
            PsqlFKey psqlFKey = new PsqlFKey(psqlTable.getQualifier(), psqlTable.getOwner(), string);
            psqlTable.vFKeys.addElement(psqlFKey);
            psqlFKey.keycols.addElement(new PsqlFKeyCol(string2, string3, 1));
            break;
        }
    }

    public void updateFKeysNoCheck(PsqlTable psqlTable) {
        if (psqlTable == null) {
            return;
        }
        if (psqlTable.getColumns().size() == 0) {
            return;
        }
        try {
            ResultSet resultSet;
            DatabaseMetaData databaseMetaData = this.dbcon.getMetaData();
            String string = psqlTable.getQualifier();
            String string2 = psqlTable.getOwner();
            String string3 = psqlTable.getName();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            try {
                resultSet = databaseMetaData.getImportedKeys(string, string2, string3);
            }
            catch (SQLException sQLException) {
                this.bSuppFKey = false;
                return;
            }
            boolean bl = resultSet.next();
            if (bl) {
                psqlTable.vFKeys.removeAllElements();
            }
            while (bl) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                String string9 = resultSet.getString(6);
                String string10 = resultSet.getString(7);
                String string11 = resultSet.getString(8);
                int n = resultSet.getInt(9);
                PsqlFKey psqlFKey = psqlTable.findSameFKey(string4, string5, string6);
                if (psqlFKey == null) {
                    psqlFKey = new PsqlFKey(string4, string5, string6);
                    psqlTable.vFKeys.addElement(psqlFKey);
                }
                psqlFKey.keycols.addElement(new PsqlFKeyCol(string7, string11, n));
                bl = resultSet.next();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NFKName.debug(sQLException.getMessage());
        }
    }

    @Override
    public boolean isSupportPKey() {
        return this.bSuppPKey;
    }

    @Override
    public boolean isSupportFKey() {
        return this.bSuppFKey;
    }

    @Override
    public boolean isSupportOwner() {
        return this.bSuppOwner;
    }

    @Override
    public boolean isSupportQualifier() {
        return this.bSuppQlf;
    }

    @Override
    public boolean isQualifierAtStart() {
        return this.bSuppQlfStart;
    }

    @Override
    public boolean isQualifierAtEnd() {
        return this.bSuppQlfEnd;
    }

    @Override
    public String getQualifierSeparator() {
        return this.sQlfSep;
    }

    @Override
    public boolean isSupportAlias() {
        return this.bSuppAlias;
    }

    @Override
    public boolean isSupportCorrelation() {
        return this.bSuppCorr;
    }

    @Override
    public boolean isSupportOuterJoin() {
        return this.bSuppOuterJoin;
    }

    @Override
    public String getQuoteChar() {
        return this.sQuoteChar;
    }

    @Override
    public String getStringFunctions() {
        return this.sStringFuncs;
    }

    @Override
    public String getNumericFunctions() {
        return this.sNumericFuncs;
    }

    @Override
    public String getTimeDateFunctions() {
        return this.sTimeDateFuncs;
    }

    public String getDatabaseName() {
        return this.sDatabaseName;
    }

    @Override
    public String getExtraNameChar() {
        return this.sExtraNameChar;
    }

    @Override
    public String getExtraKeywords() {
        return this.strExtraKeywords;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return this.bSuppCatInProc;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return this.bSuppSchInProc;
    }

    public boolean canSetCatalog(Connection connection) {
        try {
            String string;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null && (string = databaseMetaData.getDriverName()) != null && ((string = string.toUpperCase()).indexOf("WEBLOGIC.JDBC.MSSQLSERVER4") >= 0 || string.indexOf("SQLSRV") >= 0 || string.indexOf("SQLServer") >= 0 || string.indexOf("I-NET UNA") >= 0)) {
                return true;
            }
        }
        catch (Exception exception) {
            NFKName.debug(exception.getMessage());
        }
        return false;
    }
}

