/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.Vector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.tuple.IUnCheckedBinaryExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlObjectInputStream;
import toolkit.db.PsqlObjectOutputStream;
import toolkit.db.PsqlStorable;
import toolkit.db.PsqlTable;
import toolkit.db.api.SQLMapInfo;

public class PsqlJoin
implements Serializable,
PsqlStorable {
    protected final byte version = 1;
    transient PsqlTable tableFrom = null;
    transient PsqlTable tableTo = null;
    transient PsqlColumn columnFrom = null;
    transient PsqlColumn columnTo = null;
    public String name = "";
    public int idxTblFrom;
    public int idxTblTo;
    public int idxColFrom;
    public int idxColTo;
    public String strOperator;
    public String sColFrom = null;
    public String sColTo = null;
    private static final String SEDU = ".";
    int outerJoin = 0;
    boolean isSql92 = true;
    boolean selfJoin = false;
    private transient boolean append = false;
    private IExpression joinCondition;

    public PsqlJoin() {
    }

    public PsqlJoin(Vector vector, PsqlTable psqlTable, PsqlTable psqlTable2, PsqlColumn psqlColumn, PsqlColumn psqlColumn2, String string, IExpression iExpression) {
        this.tableFrom = psqlTable;
        this.tableTo = psqlTable2;
        this.columnFrom = psqlColumn;
        this.columnTo = psqlColumn2;
        this.strOperator = string;
        this.joinCondition = iExpression;
        this.idxTblFrom = vector.indexOf(psqlTable);
        this.idxTblTo = vector.indexOf(psqlTable2);
        this.idxColFrom = psqlTable.getColumns().indexOf(psqlColumn);
        this.idxColTo = psqlTable2.getColumns().indexOf(psqlColumn2);
        this.sColFrom = psqlColumn.getName();
        this.sColTo = psqlColumn2.getName();
    }

    public PsqlJoin(Vector vector, PsqlTable psqlTable, PsqlTable psqlTable2, PsqlColumn psqlColumn, PsqlColumn psqlColumn2, String string) {
        this.tableFrom = psqlTable;
        this.tableTo = psqlTable2;
        this.columnFrom = psqlColumn;
        this.columnTo = psqlColumn2;
        this.strOperator = string;
        this.idxTblFrom = vector.indexOf(psqlTable);
        this.idxTblTo = vector.indexOf(psqlTable2);
        this.idxColFrom = psqlTable.getColumns().indexOf(psqlColumn);
        this.idxColTo = psqlTable2.getColumns().indexOf(psqlColumn2);
        this.sColFrom = psqlColumn.getName();
        this.sColTo = psqlColumn2.getName();
        this.joinCondition = PsqlJoin.createJoinCondition(this);
    }

    public static IExpression createJoinCondition(PsqlJoin psqlJoin) {
        IUnCheckedBinaryExpression iUnCheckedBinaryExpression = null;
        try {
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(PsqlJoin.SEDU(psqlJoin.getTableFrom(), psqlJoin.getColumnFrom()));
            IUnCheckedVariableExpression iUnCheckedVariableExpression2 = iExpressionFactory.createUnCheckedVariableExpression(PsqlJoin.SEDU(psqlJoin.getTableTo(), psqlJoin.getColumnTo()));
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(psqlJoin.getOperator());
            iUnCheckedBinaryExpression = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return iUnCheckedBinaryExpression;
    }

    private static String SEDU(PsqlTable psqlTable, PsqlColumn psqlColumn) {
        if (psqlTable.correlationName == null || psqlTable.correlationName.trim().length() == 0) {
            return psqlTable.mappingName + SEDU + psqlColumn.mappingName;
        }
        return psqlTable.correlationName + SEDU + psqlTable.correlationName + "_" + psqlColumn.mappingName;
    }

    public int getIndexOfTableFrom() {
        return this.idxTblFrom;
    }

    public int getIndexOfTableTo() {
        return this.idxTblTo;
    }

    public void setIndexOfTableFrom(int n) {
        this.idxTblFrom = n;
    }

    public void setIndexOfTableTo(int n) {
        this.idxTblTo = n;
    }

    public int getIndexOfColumnFrom() {
        return this.idxColFrom;
    }

    public int getIndexOfColumnTo() {
        return this.idxColTo;
    }

    public PsqlTable getTableFrom() {
        return this.tableFrom;
    }

    public PsqlTable getTableTo() {
        return this.tableTo;
    }

    public PsqlColumn getColumnFrom() {
        return this.columnFrom;
    }

    public PsqlColumn getColumnTo() {
        return this.columnTo;
    }

    public void setTableFrom(PsqlTable psqlTable) {
        this.tableFrom = psqlTable;
    }

    public void setTableTo(PsqlTable psqlTable) {
        this.tableTo = psqlTable;
    }

    public void setColumnFrom(PsqlColumn psqlColumn) {
        this.columnFrom = psqlColumn;
    }

    public void setColumnTo(PsqlColumn psqlColumn) {
        this.columnTo = psqlColumn;
    }

    public String getOperator() {
        return this.strOperator;
    }

    public void setOuterJoin(int n) {
        this.outerJoin = n;
    }

    public int getOuterJoin() {
        return this.outerJoin;
    }

    public boolean isOuterJoin() {
        return (this.outerJoin & 7) != 0;
    }

    public boolean isLeftOuterJoin() {
        return (this.outerJoin & 4) != 0;
    }

    public boolean isRightOuterJoin() {
        return (this.outerJoin & 1) != 0;
    }

    public boolean isFullOuterJoin() {
        return (this.outerJoin & 2) != 0;
    }

    public boolean isSelfJoin() {
        return this.selfJoin;
    }

    public void setSelfJoin(boolean bl) {
        this.selfJoin = bl;
    }

    public void setSql92(boolean bl) {
        this.isSql92 = bl;
    }

    public String getLeftString(int n, String string, String string2, String string3, boolean bl, SQLMapInfo sQLMapInfo) {
        return this.append(true, n, string, string2, string3, bl, sQLMapInfo);
    }

    public String getRightString(int n, String string, String string2, String string3, boolean bl, SQLMapInfo sQLMapInfo) {
        return this.append(false, n, string, string2, string3, bl, sQLMapInfo);
    }

    public String getOperatorString(boolean bl, boolean bl2) {
        String string = !this.isOuterJoin() ? this.strOperator : (bl2 ? this.strOperator : (this.isLeftOuterJoin() ? "(+)" + DbTools.getReversedOperator(this.strOperator) : (this.isRightOuterJoin() ? "(+)" + this.strOperator : this.strOperator)));
        if (bl) {
            string = DbTools.toFmlOperator(string);
        }
        return string;
    }

    public static String getOperatorString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2 = !bl2 ? string : (bl3 ? string : (bl4 ? "(+)" + DbTools.getReversedOperator(string) : (bl5 ? "(+)" + string : string)));
        if (bl) {
            string2 = DbTools.toFmlOperator(string2);
        }
        return string2;
    }

    private String append(boolean bl, int n, String string, String string2, String string3, boolean bl2, SQLMapInfo sQLMapInfo) {
        PsqlTable psqlTable;
        PsqlColumn psqlColumn;
        String string4 = "";
        if (bl ^ this.isLeftOuterJoin()) {
            psqlColumn = this.columnFrom;
            psqlTable = this.tableFrom;
        } else {
            psqlColumn = this.columnTo;
            psqlTable = this.tableTo;
        }
        if (bl2) {
            string4 = string4 + "@\"" + psqlColumn.getMappingName() + "\"";
        } else {
            if (psqlTable != null) {
                string4 = string4 + psqlTable.getQaulifiedNameCorr(n, string, string2, string3, sQLMapInfo) + SEDU;
            }
            string4 = string4 + DbTools.quotedWhenNeed(psqlColumn.getName(sQLMapInfo), string, string2, string3);
        }
        return string4;
    }

    public PsqlJoin getCopy() {
        PsqlJoin psqlJoin = new PsqlJoin();
        psqlJoin.name = new String(this.name);
        psqlJoin.tableFrom = this.tableFrom.getCopy();
        psqlJoin.tableTo = this.tableTo.getCopy();
        psqlJoin.columnFrom = this.columnFrom.getCopy();
        psqlJoin.columnTo = this.columnTo.getCopy();
        psqlJoin.idxTblFrom = this.idxTblFrom;
        psqlJoin.idxTblTo = this.idxTblTo;
        psqlJoin.idxColFrom = this.idxColFrom;
        psqlJoin.idxColTo = this.idxColTo;
        psqlJoin.strOperator = this.strOperator;
        psqlJoin.sColFrom = this.sColFrom;
        psqlJoin.sColTo = this.sColTo;
        psqlJoin.isSql92 = this.isSql92;
        psqlJoin.outerJoin = this.outerJoin;
        psqlJoin.selfJoin = this.selfJoin;
        psqlJoin.append = this.append;
        try {
            psqlJoin.setJoinCondition(ExpressionToolKit.cloneExpression(this.getJoinCondition()));
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return psqlJoin;
    }

    public void setNotResolved() {
        this.append = true;
    }

    public boolean isNotResolved() {
        return this.append;
    }

    @Override
    public void readObj(PsqlObjectInputStream psqlObjectInputStream) throws IOException, ClassNotFoundException, OptionalDataException {
        int n = psqlObjectInputStream.read();
        this.idxTblFrom = psqlObjectInputStream.readInt();
        this.idxTblTo = psqlObjectInputStream.readInt();
        this.idxColFrom = psqlObjectInputStream.readInt();
        this.idxColTo = psqlObjectInputStream.readInt();
        this.strOperator = (String)psqlObjectInputStream.readObject();
    }

    @Override
    public void writeObj(PsqlObjectOutputStream psqlObjectOutputStream) throws IOException {
        psqlObjectOutputStream.write(1);
        psqlObjectOutputStream.writeInt(this.idxTblFrom);
        psqlObjectOutputStream.writeInt(this.idxTblTo);
        psqlObjectOutputStream.writeInt(this.idxColFrom);
        psqlObjectOutputStream.writeInt(this.idxColTo);
        psqlObjectOutputStream.writeObject(this.strOperator);
    }

    public String toString() {
        return this.tableFrom.name + SEDU + this.columnFrom.name + "=>" + this.tableTo.name + SEDU + this.columnTo.name;
    }

    public IExpression getJoinCondition() {
        return this.joinCondition;
    }

    public void setJoinCondition(IExpression iExpression) {
        this.joinCondition = iExpression;
    }
}

