/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import jet.JResource;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.IUnCheckedExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedBinaryExpression;
import jet.dataengine.api.expression.tuple.IUnCheckedMultiExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.dataengine.util.DSLog;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCConnection;
import jet.util.SQLTraveler;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.ReloadQueryException;
import toolkit.db.api.SQLMapInfo;
import toolkit.db.query.parser.ASTBooleanFactor;
import toolkit.db.query.parser.ASTBooleanTerm;
import toolkit.db.query.parser.ASTExplicitBoolean;
import toolkit.db.query.parser.ASTPredicate;
import toolkit.db.query.parser.ASTQueryStatement;
import toolkit.db.query.parser.ASTSearchCondition;
import toolkit.db.query.parser.ASTSelectListContainer;
import toolkit.db.query.parser.ASTWhereClause;
import toolkit.db.query.parser.Node;
import toolkit.db.query.parser.ParseException;
import toolkit.db.query.parser.QueryParser;
import toolkit.db.query.parser.SimpleNode;

public class PsqlQuery
implements Serializable {
    public static final String LOGIC_AND = "AND";
    public static final String LOGIC_OR = "OR";
    public static final String LOGIC_NOT = "NOT";
    public static boolean bStateOfJoinOnForeignKeys_Def = true;
    public static boolean bStateOfJoinOnPrimaryKey_Def = true;
    public static boolean bStateOfJoinOnLikeName_Def = true;
    public static boolean bStateOfShowTableNames_Def = false;
    public static boolean bShowMappingName_Def = false;
    public static boolean bStateOfProhibitCartesianProducts_Def = true;
    public static boolean bAutoQuote_Def = false;
    public static int maxSize = 50;
    public static int pageSize = 100;
    public static int maxCurPage = 400;
    private static DSLog columns = DSLog.getDSLog(PsqlQuery.class.getName());
    protected String mappingName = null;
    protected boolean checkId = true;
    protected transient String errors = "";
    public Vector vTables;
    public Vector vSelCols;
    public Vector vGroupbySelCols;
    public Vector vOrderbySelCols;
    public Vector vPsqlJoin;
    public Vector vSCGrps = null;
    protected IExpression searchConditionExpression;
    public String sAndExpression = null;
    public Vector vAndExpression;
    public String sHavingExpression = null;
    public Vector vHavingExpression;
    public Vector vUnion;
    protected String sExtWhere = null;
    protected String sReplWhere = null;
    protected String altWhereClause = null;
    protected String userDefinedQueryStmt = "";
    protected String username;
    protected String password;
    protected boolean share;
    public boolean bStateOfUnqualifiedName = true;
    public boolean bStateOfJoinOnForeignKeys = true;
    public boolean bStateOfJoinOnPrimaryKey = true;
    public boolean bStateOfJoinOnLikeName = true;
    public boolean bStateOfShowTableNames = false;
    public boolean bShowMappingName = false;
    public boolean bStateOfProhibitCartesianProducts = true;
    public boolean bAutoQuote = false;
    public boolean bDistinct = false;
    protected boolean bIgnorePredicateIfParamIsNull = false;
    public Object objConnectInfo = null;
    public int ver = 1;
    protected SQLMapInfo sqlMapInfo = null;
    protected boolean convertFromOldSCGroup = true;
    private static final String createJoinCondition = ".";
    protected Vector vecSelColMappingNames = null;

    public PsqlQuery() {
        this.SEDU();
        this.bStateOfJoinOnForeignKeys = bStateOfJoinOnForeignKeys_Def;
        this.bStateOfJoinOnPrimaryKey = bStateOfJoinOnPrimaryKey_Def;
        this.bStateOfJoinOnLikeName = bStateOfJoinOnLikeName_Def;
        this.bStateOfShowTableNames = bStateOfShowTableNames_Def;
        this.bShowMappingName = bShowMappingName_Def;
        this.bStateOfProhibitCartesianProducts = bStateOfProhibitCartesianProducts_Def;
        this.bAutoQuote = bAutoQuote_Def;
    }

    private void SEDU() {
        this.vTables = new Vector();
        this.vSelCols = new Vector();
        this.vGroupbySelCols = new Vector();
        this.vOrderbySelCols = new Vector();
        this.vPsqlJoin = new Vector();
        this.vAndExpression = new Vector();
        this.vHavingExpression = new Vector();
        this.vUnion = new Vector();
        this.vecSelColMappingNames = new Vector();
    }

    public void reloadFromQueryTree(ASTQueryStatement aSTQueryStatement) throws ReloadQueryException {
    }

    protected void removeTables() {
        this.vTables.removeAllElements();
    }

    public void removeJoins() {
        this.vPsqlJoin.removeAllElements();
    }

    public void removeAndConditions() {
        this.vAndExpression.removeAllElements();
        this.sAndExpression = null;
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setExtendedWhere(String string) {
        this.sExtWhere = string;
    }

    public String getExtendedWhere() {
        return this.sExtWhere;
    }

    public void setReplacedWhere(String string) {
        this.sReplWhere = string;
        if (string != null && string.trim().length() == 0) {
            this.sReplWhere = null;
        }
    }

    public String getReplacedWhere() {
        return this.sReplWhere;
    }

    public void setAltWhereClause(String string) {
        this.altWhereClause = string;
    }

    public String getAltWhereClause() {
        return this.altWhereClause;
    }

    public void setConnectInfo(Object object) {
        this.objConnectInfo = object;
    }

    public Object getConnectInfoObj() {
        return this.objConnectInfo;
    }

    public boolean isDistinct() {
        return this.bDistinct;
    }

    public void setDistinct(boolean bl) {
        this.bDistinct = bl;
    }

    public boolean isIgnorePredicateIfParamIsNull() {
        return this.bIgnorePredicateIfParamIsNull;
    }

    public void setIgnorePredicateIfParamIsNull(boolean bl) {
        this.bIgnorePredicateIfParamIsNull = bl;
    }

    protected void update(Vector vector) {
        this.updateSelColumns();
        this.updatePsqlJoins();
    }

    public void initialPsqlTables(Vector vector) {
        for (int i = this.vTables.size() - 1; i >= 0; --i) {
            PsqlTable psqlTable = (PsqlTable)this.vTables.elementAt(i);
            if (psqlTable == null) {
                this.vTables.removeElementAt(i);
                continue;
            }
            PsqlTable psqlTable2 = PsqlTable.getTableByName(vector, psqlTable.getQualifier(), psqlTable.getOwner(), psqlTable.getName(), false);
            if (psqlTable2 == null) {
                this.vTables.removeElementAt(i);
                continue;
            }
            psqlTable.newVectors();
            psqlTable.setColumns(psqlTable2.getColumns());
        }
    }

    public void updateSelColumns() {
        for (int i = this.vSelCols.size() - 1; i >= 0; --i) {
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)this.vSelCols.elementAt(i);
            if (psqlSelColumn == null || psqlSelColumn.isCompCol()) continue;
            psqlSelColumn.table = PsqlTable.getTableByName(this.vTables, psqlSelColumn.getQualifier(), psqlSelColumn.getOwner(), psqlSelColumn.getTableName(), false);
            if (psqlSelColumn.table != null) continue;
            this.vSelCols.removeElementAt(i);
        }
    }

    public void updatePsqlJoins() {
        int n = this.vTables.size();
        Object var9_2 = null;
        for (int i = this.vPsqlJoin.size() - 1; i >= 0; --i) {
            PsqlColumn psqlColumn;
            PsqlColumn psqlColumn2;
            PsqlJoin psqlJoin = (PsqlJoin)this.vPsqlJoin.elementAt(i);
            int n2 = psqlJoin.getIndexOfTableFrom();
            if (n2 >= n) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_10", (Object)String.valueOf(i + 1)) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            PsqlTable psqlTable = (PsqlTable)this.vTables.elementAt(n2);
            if (psqlTable == null) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_11", (Object)String.valueOf(i + 1)) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            psqlJoin.setTableFrom(psqlTable);
            int n3 = n2;
            n2 = psqlJoin.getIndexOfTableTo();
            if (n2 >= n) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_12", (Object)String.valueOf(i + 1)) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            PsqlTable psqlTable2 = (PsqlTable)this.vTables.elementAt(n2);
            if (psqlTable2 == null) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_13", (Object)String.valueOf(i + 1)) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            psqlJoin.setTableTo(psqlTable2);
            if (n2 != n3) {
                // empty if block
            }
            if (psqlJoin.getColumnFrom() == null) {
                psqlColumn2 = this.ver == 0 ? psqlTable.getColumnByName(psqlJoin.sColFrom) : psqlTable.getColumnByMappingName(psqlJoin.sColFrom);
            } else {
                PsqlColumn psqlColumn3 = psqlColumn2 = this.ver == 0 ? psqlTable.getColumnByName(psqlJoin.getColumnFrom().getName()) : psqlTable.getColumnByMappingName(psqlJoin.getColumnFrom().getMappingName());
            }
            if (psqlColumn2 == null) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_14", new Object[]{String.valueOf(i + 1), psqlJoin.sColFrom}) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            psqlJoin.setColumnFrom(psqlColumn2);
            psqlJoin.idxColFrom = psqlTable.getColumns().indexOf(psqlColumn2);
            if (psqlJoin.getColumnTo() == null) {
                psqlColumn = this.ver == 0 ? psqlTable2.getColumnByName(psqlJoin.sColTo) : psqlTable2.getColumnByMappingName(psqlJoin.sColTo);
            } else {
                PsqlColumn psqlColumn4 = psqlColumn = this.ver == 0 ? psqlTable2.getColumnByName(psqlJoin.getColumnTo().getName()) : psqlTable2.getColumnByMappingName(psqlJoin.getColumnTo().getMappingName());
            }
            if (psqlColumn == null) {
                this.errors = this.errors + JResource.getMessage("CAT_PSQL_15", new Object[]{String.valueOf(i + 1), psqlJoin.sColTo}) + "\n";
                if (!this.checkId) {
                    this.vPsqlJoin.removeElementAt(i);
                }
                psqlJoin.setNotResolved();
                continue;
            }
            if (this.ver != 0) {
                psqlJoin.sColFrom = psqlColumn2.getName();
                psqlJoin.sColTo = psqlColumn.getName();
            }
            psqlJoin.setColumnTo(psqlColumn);
            psqlJoin.idxColTo = psqlTable2.getColumns().indexOf(psqlColumn);
            if (psqlJoin.getJoinCondition() != null) continue;
            psqlJoin.setJoinCondition(PsqlJoin.createJoinCondition(psqlJoin));
        }
    }

    public Vector getPsqlTablesVector() {
        return this.vTables;
    }

    public Vector getSelColsVector() {
        return this.vSelCols;
    }

    public Vector getTablesForUnselectedCols() {
        PsqlTable psqlTable;
        Vector<PsqlTable> vector = new Vector<PsqlTable>();
        int n = this.vTables.size();
        for (int i = 0; i < n; ++i) {
            psqlTable = (PsqlTable)this.vTables.elementAt(i);
            vector.addElement(psqlTable.getCopy());
        }
        n = this.vSelCols.size();
        for (int i = 0; i < n; ++i) {
            PsqlColumn psqlColumn;
            PsqlSelColumn psqlSelColumn = (PsqlSelColumn)this.vSelCols.elementAt(i);
            if (psqlSelColumn.table == null || (psqlTable = PsqlTable.getTableByName(vector, psqlSelColumn.table.getQualifier(), psqlSelColumn.table.getOwner(), psqlSelColumn.table.getName(), psqlSelColumn.table.getCorrelationName(), false)) == null || (psqlColumn = psqlTable.getColumnByName(psqlSelColumn.getName())) == null) continue;
            psqlTable.columns.removeElement(psqlColumn);
        }
        return vector;
    }

    public Vector getGroupbyColsVector() {
        return this.vGroupbySelCols;
    }

    public Vector getOrderbyColsVector() {
        return this.vOrderbySelCols;
    }

    public Vector getPsqlJoinsVector() {
        return this.vPsqlJoin;
    }

    public IExpression getSearchConditionGroups() {
        return this.searchConditionExpression;
    }

    public String getStringOfSearchConditionGroups() {
        return PsqlQuery.getStringOfWPGroups(this.searchConditionExpression, null, true);
    }

    public String getStringOfSearchConditionGroups(Vector vector) {
        return PsqlQuery.getStringOfWPGroups(this.searchConditionExpression, vector, true);
    }

    public static Vector convertExpression2Vector(IExpression iExpression) {
        if (iExpression != null) {
            String string = null;
            SimpleNode simpleNode = null;
            try {
                string = iExpression.getStringValue(true);
                simpleNode = QueryParser.parse("select * from t where " + string);
            }
            catch (ParseException parseException) {
            }
            catch (ConditionException conditionException) {
                // empty catch block
            }
            if (simpleNode != null) {
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    Node node = simpleNode.jjtGetChild(i);
                    if (!(node instanceof ASTWhereClause)) continue;
                    ASTWhereClause aSTWhereClause = (ASTWhereClause)node;
                    ASTSearchCondition aSTSearchCondition = (ASTSearchCondition)aSTWhereClause.jjtGetChild(0);
                    try {
                        return PsqlQuery.convertASTSearchCondition2Vector(aSTSearchCondition);
                    }
                    catch (ReloadQueryException reloadQueryException) {
                        // empty catch block
                    }
                }
            } else {
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                return vector;
            }
        }
        return new Vector();
    }

    private static Vector _getLogic(ASTSearchCondition aSTSearchCondition, ASTBooleanFactor aSTBooleanFactor, Vector vector) throws ReloadQueryException {
        int n = aSTSearchCondition.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            ASTBooleanTerm aSTBooleanTerm = (ASTBooleanTerm)aSTSearchCondition.jjtGetChild(i);
            int n2 = aSTBooleanTerm.jjtGetNumChildren();
            for (int j = 0; j < n2; ++j) {
                Object object;
                ASTBooleanFactor aSTBooleanFactor2 = (ASTBooleanFactor)aSTBooleanTerm.jjtGetChild(j);
                Node node = aSTBooleanFactor2.jjtGetChild(0);
                if (node instanceof ASTExplicitBoolean || node instanceof ASTPredicate || node instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() != null) {
                    object = new Vector<String[]>();
                    vector.add(object);
                    if (aSTBooleanFactor != null) {
                        ((Vector)object).add(PsqlQuery._makeAndLine(aSTBooleanFactor2, node, PsqlQuery._getLogic(aSTBooleanFactor2, 2)));
                        continue;
                    }
                    ((Vector)object).add(PsqlQuery._makeAndLine(aSTBooleanFactor2, node, PsqlQuery._getLogic(aSTBooleanFactor2, 1)));
                    continue;
                }
                if (node instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                    object = (ASTSearchCondition)node;
                    Vector vector2 = new Vector();
                    vector.add(vector2);
                    PsqlQuery._getLogic((ASTSearchCondition)object, aSTBooleanFactor2, vector2);
                    continue;
                }
                throw new ReloadQueryException("Unexpected node '" + node.getClass().getName() + "' in search condition!");
            }
        }
        return vector;
    }

    protected static final String[] _makeAndLine(ASTBooleanFactor aSTBooleanFactor, Node node, String string) throws ReloadQueryException {
        String[] stringArray = new String[]{"", "", "", ""};
        if (node instanceof ASTExplicitBoolean) {
            ASTExplicitBoolean aSTExplicitBoolean = (ASTExplicitBoolean)node;
            stringArray[0] = aSTBooleanFactor.getPrefix() != null ? aSTBooleanFactor.getPrefix() + " " + aSTExplicitBoolean.getValue() : aSTExplicitBoolean.getValue();
            if (aSTBooleanFactor.getPostfix() != null) {
                stringArray[0] = stringArray[0] + " " + aSTBooleanFactor.getPostfix();
            }
        } else if (node instanceof ASTPredicate) {
            ASTPredicate aSTPredicate = (ASTPredicate)node;
            stringArray[0] = aSTBooleanFactor.getPrefix() != null ? aSTBooleanFactor.getPrefix() + " " + (aSTPredicate.getLeftExpression() == null ? "" : aSTPredicate.getLeftExpression()) : (aSTPredicate.getLeftExpression() == null ? "" : aSTPredicate.getLeftExpression());
            String string2 = stringArray[1] = aSTPredicate.getOperator() == null ? "" : aSTPredicate.getOperator();
            stringArray[2] = aSTBooleanFactor.getPostfix() != null ? (aSTPredicate.getRightExpression() == null ? "" : aSTPredicate.getRightExpression()) + " " + aSTBooleanFactor.getPostfix() : (aSTPredicate.getRightExpression() == null ? "" : aSTPredicate.getRightExpression());
        } else if (node instanceof ASTSearchCondition) {
            ASTSearchCondition aSTSearchCondition = (ASTSearchCondition)node;
            if (aSTBooleanFactor.getPrefix() != null) {
                stringArray[0] = aSTBooleanFactor.getPrefix() + " " + (aSTSearchCondition.getExpression() == null ? "" : aSTSearchCondition.getExpression());
            } else {
                String string3 = stringArray[0] = aSTSearchCondition.getExpression() == null ? "" : aSTSearchCondition.getExpression();
            }
            if (aSTBooleanFactor.getPostfix() != null) {
                stringArray[0] = stringArray[0] + " " + aSTBooleanFactor.getPostfix();
            }
        } else {
            throw new ReloadQueryException("Unexpected node '" + node.getClass().getName() + "' in search condition!");
        }
        stringArray[3] = string;
        return stringArray;
    }

    protected static final String _getLogic(ASTBooleanFactor aSTBooleanFactor, int n) throws ReloadQueryException {
        Node node = aSTBooleanFactor;
        Node node2 = null;
        Node node3 = null;
        ASTBooleanFactor aSTBooleanFactor2 = null;
        int n2 = 0;
        while (!(node instanceof ASTWhereClause)) {
            node2 = node.jjtGetParent();
            n2 = node2.jjtIndexOf(node);
            if (n2 < node2.jjtGetNumChildren() - 1) {
                if (n == 1) {
                    if (node2 instanceof ASTSearchCondition) {
                        aSTBooleanFactor2 = (ASTBooleanFactor)node2.jjtGetChild(n2 + 1).jjtGetChild(0);
                        node3 = aSTBooleanFactor2.jjtGetChild(0);
                        if (node3 instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                            return LOGIC_OR + (aSTBooleanFactor2.getPrefix() == null ? "" : " NOT");
                        }
                        return LOGIC_OR;
                    }
                    if (node2 instanceof ASTBooleanTerm) {
                        aSTBooleanFactor2 = (ASTBooleanFactor)node2.jjtGetChild(n2 + 1);
                        node3 = aSTBooleanFactor2.jjtGetChild(0);
                        if (node3 instanceof ASTSearchCondition && aSTBooleanFactor2.getPostfix() == null) {
                            return LOGIC_AND + (aSTBooleanFactor2.getPrefix() == null ? "" : " NOT");
                        }
                        return LOGIC_AND;
                    }
                    throw new ReloadQueryException("Brench in other node '" + node2.getClass().getName() + "'!");
                }
                if (n == 2) {
                    if (node2 instanceof ASTSearchCondition) {
                        return LOGIC_OR;
                    }
                    if (node2 instanceof ASTBooleanTerm) {
                        return LOGIC_AND;
                    }
                    throw new ReloadQueryException("Brench in other node '" + node2.getClass().getName() + "'!");
                }
            }
            if (!((node = node2) instanceof ASTSearchCondition)) continue;
            --n;
        }
        return LOGIC_AND;
    }

    public static Vector convertASTSearchCondition2Vector(ASTSearchCondition aSTSearchCondition) throws ReloadQueryException {
        Node node = aSTSearchCondition;
        while (node.jjtGetNumChildren() <= 1) {
            if (node.jjtGetNumChildren() == 0) {
                throw new ReloadQueryException("No child in search condition node!");
            }
            if ((node = node.jjtGetChild(0)).jjtGetNumChildren() > 1) break;
            if (node.jjtGetNumChildren() == 0) {
                throw new ReloadQueryException("No child in boolean term node!");
            }
            if (!((node = node.jjtGetChild(0).jjtGetChild(0)) instanceof ASTSearchCondition)) break;
            aSTSearchCondition = (ASTSearchCondition)node;
        }
        Vector vector = new Vector();
        PsqlQuery._getLogic(aSTSearchCondition, null, vector);
        PsqlQuery._makeAndLine(vector);
        return vector;
    }

    private static void _makeAndLine(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof Vector)) continue;
            Vector vector2 = (Vector)e;
            if (vector2.size() == 0) {
                vector.remove(i);
                --i;
                continue;
            }
            PsqlQuery._makeAndLine(vector2);
        }
    }

    public Vector getAndExpressionVector() {
        return this.vAndExpression;
    }

    public String getAndExpressionString() {
        return this.sAndExpression;
    }

    public Vector getHavingExpressionVector() {
        return this.vHavingExpression;
    }

    public String getHavingExpressionString() {
        return this.sHavingExpression;
    }

    public Vector getUnionVector() {
        return this.vUnion;
    }

    public boolean getStateOfUnqualifiedName() {
        return this.bStateOfUnqualifiedName;
    }

    public boolean getStateOfJoinOnForeignKeys() {
        return this.bStateOfJoinOnForeignKeys;
    }

    public boolean getStateOfJoinOnPrimaryKey() {
        return this.bStateOfJoinOnPrimaryKey;
    }

    public boolean getStateOfJoinOnLikeName() {
        return this.bStateOfJoinOnLikeName;
    }

    public boolean getStateOfShowTableNames() {
        return this.bStateOfShowTableNames;
    }

    public boolean getStateOfProhibitCartesianProducts() {
        return this.bStateOfProhibitCartesianProducts;
    }

    public boolean getStateOfAutoQuote() {
        return this.bAutoQuote;
    }

    public boolean isShowMappingName() {
        return this.bShowMappingName;
    }

    public void setShowMappingName(boolean bl) {
        this.bShowMappingName = bl;
    }

    public boolean hasCompCols() {
        return DbTools.hasCompCols(this.vSelCols);
    }

    public void setPsqlJoinsVector(Vector vector) {
        this.vPsqlJoin = vector;
    }

    public String getResolveErrors() {
        return this.errors.length() == 0 ? null : this.errors;
    }

    public void setCheckId(boolean bl) {
        this.checkId = bl;
    }

    public static String getStringOfWPGroups(Vector vector) {
        return PsqlQuery.getStringOfWPGroups(vector, null);
    }

    public static String getStringOfWPGroups(IExpression iExpression) {
        return PsqlQuery.getStringOfWPGroups(iExpression, null, true);
    }

    public static String getStringOfWPGroups(IExpression iExpression, Vector vector) {
        return PsqlQuery.getStringOfWPGroups(iExpression, vector, true);
    }

    public static String getStringOfWPGroups(IExpression iExpression, Vector vector, boolean bl) {
        if (iExpression == null) {
            return "";
        }
        if (vector == null || vector.size() == 0) {
            try {
                return iExpression.getStringValue(true);
            }
            catch (ConditionException conditionException) {
                return "";
            }
        }
        if (iExpression instanceof IUnCheckedExpression) {
            IUnCheckedExpression iUnCheckedExpression = (IUnCheckedExpression)iExpression;
            try {
                IUnCheckedExpression iUnCheckedExpression2 = PsqlQuery.removeExp4NullParameter(iUnCheckedExpression, vector);
                if (iUnCheckedExpression2 == null) {
                    return "";
                }
                return iUnCheckedExpression2.getStringValue(true);
            }
            catch (ConditionException conditionException) {
                return "";
            }
        }
        return "";
    }

    public static String getStringOfWPGroups(Vector vector, Vector vector2) {
        String string = null;
        if (vector != null) {
            Vector vector3 = null;
            String string2 = null;
            String[] stringArray = null;
            int n = vector.size();
            if (vector2 == null || vector2.size() == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    vector3 = (Vector)vector.elementAt(i);
                    int n2 = vector3.size();
                    stringBuffer.append("(");
                    for (int j = 0; j < n2; ++j) {
                        stringArray = (String[])vector3.elementAt(j);
                        stringBuffer.append(stringArray[0]);
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[1]);
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[2]);
                        if (j == n2 - 1) {
                            string2 = stringArray[3];
                            continue;
                        }
                        stringBuffer.append(" ");
                        stringBuffer.append(stringArray[3]);
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(")");
                    if (i >= n - 1) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" ");
                }
                string = stringBuffer.toString();
            } else {
                Vector vector4 = new Vector(n);
                Vector<Vector> vector5 = new Vector<Vector>(n);
                Vector vector6 = null;
                Vector vector7 = null;
                for (int i = 0; i < n; ++i) {
                    vector3 = (Vector)vector.elementAt(i);
                    int n3 = vector3.size();
                    vector6 = new Vector(n3);
                    vector7 = new Vector(n3);
                    for (int j = 0; j < n3; ++j) {
                        stringArray = (String[])vector3.elementAt(j);
                        vector7.addElement(stringArray);
                        if (j < n3 - 1) {
                            if (!stringArray[3].equals(LOGIC_OR)) continue;
                            vector6.addElement(vector7);
                            vector7 = new Vector(n3 - j);
                            continue;
                        }
                        string2 = stringArray[3];
                        vector6.addElement(vector7);
                    }
                    vector5.addElement(vector6);
                    if (i < n - 1) {
                        if (!string2.startsWith(LOGIC_OR)) continue;
                        vector4.addElement(vector5);
                        vector5 = new Vector<Vector>(n - i);
                        continue;
                    }
                    vector4.addElement(vector5);
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n4 = vector4.size();
                for (int i = 0; i < n4; ++i) {
                    vector5 = (Vector<Vector>)vector4.elementAt(i);
                    stringBuffer2.setLength(0);
                    boolean bl4 = false;
                    int n5 = vector5.size();
                    for (int j = 0; j < n5; ++j) {
                        bl2 = bl;
                        vector6 = (Vector)vector5.elementAt(j);
                        stringBuffer3.setLength(0);
                        stringBuffer3.append('(');
                        boolean bl5 = false;
                        int n6 = vector6.size();
                        for (int k = 0; k < n6; ++k) {
                            vector7 = (Vector)vector6.elementAt(k);
                            stringBuffer4.setLength(0);
                            boolean bl6 = false;
                            int n7 = vector7.size();
                            for (int i2 = 0; i2 < n7; ++i2) {
                                stringArray = (String[])vector7.elementAt(i2);
                                string2 = stringArray[3];
                                if (string2.endsWith(LOGIC_NOT)) {
                                    bl = true;
                                }
                                if (vector2 != null && PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector2)) continue;
                                if (bl6) {
                                    stringBuffer4.append(' ').append(LOGIC_AND).append(' ');
                                }
                                stringBuffer4.append(stringArray[0]).append(' ').append(stringArray[1]).append(' ').append(stringArray[2]);
                                bl6 = true;
                            }
                            if (stringBuffer4.length() <= 0) continue;
                            if (bl5) {
                                stringBuffer3.append(' ').append(LOGIC_OR).append(' ');
                            }
                            stringBuffer3.append(stringBuffer4);
                            bl5 = true;
                        }
                        if (stringBuffer3.length() > 1) {
                            stringBuffer3.append(')');
                        } else {
                            stringBuffer3.setLength(0);
                        }
                        if (stringBuffer3.length() <= 0) continue;
                        if (bl4) {
                            stringBuffer2.append(' ').append(LOGIC_AND).append(bl2 ? " NOT" : "").append(' ');
                        }
                        stringBuffer2.append(stringBuffer3);
                        bl4 = true;
                    }
                    if (stringBuffer2.length() <= 0) continue;
                    if (bl3) {
                        stringBuffer.append(' ').append(LOGIC_OR).append(bl2 ? " NOT" : "").append(' ');
                    }
                    stringBuffer.append(stringBuffer2);
                    bl3 = true;
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public String getUserDefinedQueryStmt() {
        return this.userDefinedQueryStmt;
    }

    public void setUserDefinedQueryStmt(String string) {
        if (columns.isDebugEnabled()) {
            columns.debug(this.toName() + "setUserDefinedQueryStmt ... s = " + string);
        }
        this.userDefinedQueryStmt = string == null ? "" : string;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getShare() {
        return this.share;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean hasUnion() {
        return this.vUnion.size() != 0;
    }

    public void setSQLMapInfo(SQLMapInfo sQLMapInfo) {
        this.sqlMapInfo = sQLMapInfo;
    }

    public SQLMapInfo getSQLMapInfo() {
        return this.sqlMapInfo;
    }

    protected static boolean hasNullValueParamInThisPredicate(String[] stringArray, Vector vector) {
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector2 = SQLTraveler.find(stringArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                SQLTraveler.Position position = (SQLTraveler.Position)vector2.elementAt(j);
                if (!vector.contains(stringArray[i].substring(position.start, position.end).toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public void setSearchConditionGroups(IExpression iExpression) {
        this.searchConditionExpression = iExpression;
    }

    public static IExpression scGroup2scExpression(Vector vector) {
        if (vector == null) {
            return null;
        }
        String string = PsqlQuery.add(vector);
        Vector vector2 = PsqlQuery.addElement(vector);
        try {
            ExpWithLastOP expWithLastOP = PsqlQuery.altWhereClause(vector2);
            if (expWithLastOP == null) {
                return null;
            }
            return expWithLastOP.getExp();
        }
        catch (RuntimeException runtimeException) {
            try {
                IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
                IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(string);
                UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl("");
                IUnCheckedVariableExpression iUnCheckedVariableExpression2 = iExpressionFactory.createUnCheckedVariableExpression("");
                IUnCheckedBinaryExpression iUnCheckedBinaryExpression = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2);
                return iUnCheckedBinaryExpression;
            }
            catch (ConditionException conditionException) {
                if (columns.isDebugEnabled()) {
                    columns.debug(" psqlquery scGroup2scExpression has error " + conditionException.getMessage());
                }
                return null;
            }
        }
    }

    private static String add(Vector vector) {
        int n;
        Vector vector2 = PsqlQuery.addAll(vector);
        String string = "";
        int n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            Object e = vector2.elementAt(n);
            String[] stringArray = (String[])e;
            string = string + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] + " ";
        }
        n = string.indexOf(40);
        n2 = string.lastIndexOf(41);
        string = string.substring(n + 1, n2);
        return string;
    }

    private static Vector addAll(Vector vector) {
        Vector<String[]> vector2 = new Vector<String[]>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            String[] stringArray2;
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                stringArray2 = (String[])e;
                stringArray = PsqlQuery.addAll((Vector)stringArray2);
                vector2.addAll((Collection<String[]>)stringArray);
                continue;
            }
            if (!(e instanceof String[])) continue;
            stringArray2 = new String[4];
            stringArray = (String[])e;
            stringArray2[0] = stringArray[0];
            stringArray2[1] = stringArray[1];
            stringArray2[2] = stringArray[2];
            stringArray2[3] = stringArray[3];
            vector2.add(stringArray2);
        }
        String[] stringArray = (String[])vector2.get(0);
        stringArray[0] = "(" + stringArray[0];
        String[] stringArray3 = (String[])vector2.get(vector2.size() - 1);
        stringArray3[2] = stringArray3[2] + ")";
        return vector2;
    }

    private static Vector addElement(Vector vector) {
        Vector vector2 = new Vector();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                Vector vector3 = (Vector)e;
                Vector vector4 = PsqlQuery.addElement(vector3);
                vector2.addAll(vector4);
                continue;
            }
            if (!(e instanceof String[])) continue;
            vector2.add(e);
        }
        if (vector2.size() > 1) {
            String[] stringArray = (String[])vector2.get(0);
            stringArray[0] = "(" + stringArray[0];
            String[] stringArray2 = (String[])vector2.get(vector2.size() - 1);
            stringArray2[2] = stringArray2[2] + ")";
        }
        return vector2;
    }

    private static ExpWithLastOP altWhereClause(Vector vector) {
        try {
            ArrayList<ExpWithLastOP> arrayList = new ArrayList<ExpWithLastOP>();
            ExpWithLastOP expWithLastOP = null;
            Vector<String[]> vector2 = new Vector<String[]>();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object e = vector.elementAt(i);
                if (e instanceof String[]) {
                    String[] stringArray = (String[])e;
                    if (vector2.size() != 0) {
                        vector2.add(stringArray);
                        if (!PsqlQuery.bIgnorePredicateIfParamIsNull(vector2)) continue;
                        Vector vector3 = PsqlQuery.bAutoQuote_Def(vector2);
                        expWithLastOP = PsqlQuery.altWhereClause(vector3);
                        vector2.clear();
                    } else {
                        if (PsqlQuery.bDistinct(stringArray) != 0) {
                            vector2.add(stringArray);
                            continue;
                        }
                        IUnCheckedExpression iUnCheckedExpression = PsqlQuery.bShowMappingName(stringArray);
                        String string = stringArray[3];
                        PsqlQuery psqlQuery = new PsqlQuery();
                        psqlQuery.getClass();
                        expWithLastOP = psqlQuery.new ExpWithLastOP(iUnCheckedExpression, string);
                    }
                } else {
                    throw new IllegalArgumentException("the Four element group is wrong");
                }
                if (expWithLastOP == null) continue;
                arrayList.add(expWithLastOP);
            }
            if (vector2.size() != 0 || arrayList.isEmpty()) {
                throw new RuntimeException("Convert four element group to IExpression failed!, parenthesis is not matched.");
            }
            return PsqlQuery.append(arrayList);
        }
        catch (ConditionException conditionException) {
            if (columns.isDebugEnabled()) {
                columns.debug(" psqlquery vec2expWithOp has error " + conditionException.getClass().getName() + "  " + conditionException.getMessage());
            }
            return null;
        }
    }

    private static ExpWithLastOP append(List list) throws ConditionException {
        if (list.size() == 0) {
            return null;
        }
        ExpWithLastOP[] expWithLastOPArray = new ExpWithLastOP[list.size()];
        list.toArray(expWithLastOPArray);
        expWithLastOPArray = PsqlQuery.bAutoQuote(expWithLastOPArray, "AND NOT");
        expWithLastOPArray = PsqlQuery.bAutoQuote(expWithLastOPArray, LOGIC_AND);
        expWithLastOPArray = PsqlQuery.bAutoQuote(expWithLastOPArray, "OR NOT");
        expWithLastOPArray = PsqlQuery.bAutoQuote(expWithLastOPArray, LOGIC_OR);
        if (expWithLastOPArray.length != 1) {
            throw new RuntimeException("Convert four element group to IExpression failed! unkonw logic operatior: " + expWithLastOPArray[0].getLastLogicOperator());
        }
        return expWithLastOPArray[0];
    }

    private static ExpWithLastOP[] bAutoQuote(ExpWithLastOP[] expWithLastOPArray, String string) throws ConditionException {
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        ArrayList<IUnCheckedExpression> arrayList = new ArrayList<IUnCheckedExpression>();
        ArrayList<ExpWithLastOP> arrayList2 = new ArrayList<ExpWithLastOP>();
        for (int i = 0; i < expWithLastOPArray.length; ++i) {
            if (expWithLastOPArray[i].getLastLogicOperator().equalsIgnoreCase(string) && i != expWithLastOPArray.length - 1) {
                arrayList.add(expWithLastOPArray[i].getExp());
                continue;
            }
            if (arrayList.isEmpty()) {
                arrayList2.add(expWithLastOPArray[i]);
                continue;
            }
            arrayList.add(expWithLastOPArray[i].getExp());
            IUnCheckedExpression[] iUnCheckedExpressionArray = new IUnCheckedExpression[arrayList.size()];
            arrayList.toArray(iUnCheckedExpressionArray);
            IUnCheckedMultiExpression iUnCheckedMultiExpression = iExpressionFactory.createUnCheckedMultiExpression(new UnCheckedOperatorImpl(string), iUnCheckedExpressionArray);
            arrayList.clear();
            PsqlQuery psqlQuery = new PsqlQuery();
            psqlQuery.getClass();
            arrayList2.add(psqlQuery.new ExpWithLastOP(iUnCheckedMultiExpression, expWithLastOPArray[i].getLastLogicOperator()));
        }
        ExpWithLastOP[] expWithLastOPArray2 = new ExpWithLastOP[arrayList2.size()];
        arrayList2.toArray(expWithLastOPArray2);
        return expWithLastOPArray2;
    }

    private static Vector bAutoQuote_Def(Vector vector) {
        Vector vector2 = new Vector();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string;
            String[] stringArray;
            Object e = vector.get(i);
            if (i == 0) {
                stringArray = (String[])e;
                string = stringArray[0];
                n2 = string.indexOf(40);
                stringArray[0] = string.substring(0, n2) + string.substring(n2 + 1);
            }
            if (i == n - 1) {
                stringArray = (String[])e;
                string = stringArray[2];
                n2 = string.lastIndexOf(41);
                if (n2 != -1) {
                    stringArray[2] = string.substring(0, n2) + string.substring(n2 + 1);
                } else {
                    string = stringArray[0];
                    n2 = string.lastIndexOf(41);
                    stringArray[0] = string.substring(0, n2) + string.substring(n2 + 1);
                }
            }
            vector2.add(e);
        }
        return vector2;
    }

    private static int bDistinct(String[] stringArray) {
        int n = 0;
        char[] cArray = (stringArray[0] + stringArray[2]).toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '(') {
                ++n;
                continue;
            }
            if (cArray[i] != ')') continue;
            --n;
        }
        return n;
    }

    private static boolean bIgnorePredicateIfParamIsNull(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = (String[])vector.get(i);
            n += PsqlQuery.bDistinct(stringArray);
        }
        return n == 0;
    }

    private static IUnCheckedExpression bShowMappingName(String[] stringArray) throws ConditionException {
        IUnCheckedExpression iUnCheckedExpression = null;
        IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
        if (stringArray[1].equalsIgnoreCase("is null") || stringArray[1].equalsIgnoreCase("is not null")) {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedSingleExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression);
        } else if (stringArray[1].equalsIgnoreCase("between") || stringArray[1].equalsIgnoreCase("not between")) {
            String[] stringArray2 = stringArray[2].split("and");
            if (stringArray2[0].equals(stringArray[2]) && (stringArray2 = stringArray[2].split(LOGIC_AND))[0].equals(stringArray[2])) {
                stringArray2 = stringArray[2].split("And");
            }
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression2 = iExpressionFactory.createUnCheckedVariableExpression(stringArray2[0]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression3 = null;
            iUnCheckedVariableExpression3 = stringArray2.length == 1 ? iExpressionFactory.createUnCheckedVariableExpression("") : iExpressionFactory.createUnCheckedVariableExpression(stringArray2[1]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedTripleExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression2, iUnCheckedVariableExpression3);
        } else {
            IUnCheckedVariableExpression iUnCheckedVariableExpression = iExpressionFactory.createUnCheckedVariableExpression(stringArray[0]);
            UnCheckedOperatorImpl unCheckedOperatorImpl = new UnCheckedOperatorImpl(stringArray[1]);
            IUnCheckedVariableExpression iUnCheckedVariableExpression4 = iExpressionFactory.createUnCheckedVariableExpression(stringArray[2]);
            iUnCheckedExpression = iExpressionFactory.createUnCheckedBinaryExpression(unCheckedOperatorImpl, iUnCheckedVariableExpression, iUnCheckedVariableExpression4);
        }
        return iUnCheckedExpression;
    }

    public static IUnCheckedExpression removeExp4NullParameter(IUnCheckedExpression iUnCheckedExpression, Vector vector) throws ConditionException {
        if (iUnCheckedExpression == null) {
            return iUnCheckedExpression;
        }
        if (vector == null || vector.size() == 0) {
            return iUnCheckedExpression;
        }
        IUnCheckedExpression iUnCheckedExpression2 = (IUnCheckedExpression)ExpressionToolKit.cloneExpression(iUnCheckedExpression);
        if (ExpressionToolKit.isMultiExp((iUnCheckedExpression2 = (IUnCheckedExpression)ExpressionToolKit.compressExpression(iUnCheckedExpression2)).expressionType())) {
            IUnCheckedExpression[] iUnCheckedExpressionArray = ((IUnCheckedMultiExpression)iUnCheckedExpression2).getExpressions();
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                PsqlQuery.bStateOfJoinOnForeignKeys(i, iUnCheckedExpressionArray[i], iUnCheckedExpression2, vector);
            }
            IUnCheckedExpression iUnCheckedExpression3 = PsqlQuery.bShowMappingName_Def(iUnCheckedExpression2);
            return iUnCheckedExpression3;
        }
        String string = iUnCheckedExpression2.getStringValue(true);
        String[] stringArray = new String[]{string};
        if (PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector)) {
            return null;
        }
        return iUnCheckedExpression2;
    }

    private static IUnCheckedExpression bShowMappingName_Def(IUnCheckedExpression iUnCheckedExpression) {
        IUnCheckedExpression iUnCheckedExpression2 = null;
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression;
            IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
            ArrayList<IUnCheckedExpression> arrayList = new ArrayList<IUnCheckedExpression>();
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                if (iUnCheckedExpressionArray[i] == null) continue;
                if (ExpressionToolKit.isMultiExp(iUnCheckedExpressionArray[i].expressionType())) {
                    IUnCheckedExpression iUnCheckedExpression3 = PsqlQuery.bShowMappingName_Def(iUnCheckedExpressionArray[i]);
                    if (iUnCheckedExpression3 == null) continue;
                    arrayList.add(iUnCheckedExpression3);
                    continue;
                }
                arrayList.add(iUnCheckedExpressionArray[i]);
            }
            if (arrayList.size() >= 2) {
                iUnCheckedMultiExpression.setExpressions(arrayList.toArray(new IUnCheckedExpression[0]));
                iUnCheckedExpression2 = iUnCheckedMultiExpression;
            } else {
                iUnCheckedExpression2 = arrayList.size() == 1 ? (IUnCheckedExpression)arrayList.get(0) : null;
            }
        }
        return iUnCheckedExpression2;
    }

    private static void bStateOfJoinOnForeignKeys(int n, IUnCheckedExpression iUnCheckedExpression, IUnCheckedExpression iUnCheckedExpression2, Vector vector) throws ConditionException {
        if (ExpressionToolKit.isMultiExp(iUnCheckedExpression.expressionType())) {
            IUnCheckedExpression[] iUnCheckedExpressionArray = ((IUnCheckedMultiExpression)iUnCheckedExpression).getExpressions();
            for (int i = 0; i < iUnCheckedExpressionArray.length; ++i) {
                PsqlQuery.bStateOfJoinOnForeignKeys(i, iUnCheckedExpressionArray[i], iUnCheckedExpression, vector);
            }
        } else {
            String string = iUnCheckedExpression.getStringValue(true);
            String[] stringArray = new String[]{string};
            if (PsqlQuery.hasNullValueParamInThisPredicate(stringArray, vector)) {
                IUnCheckedMultiExpression iUnCheckedMultiExpression = (IUnCheckedMultiExpression)iUnCheckedExpression2;
                IUnCheckedExpression[] iUnCheckedExpressionArray = iUnCheckedMultiExpression.getExpressions();
                iUnCheckedExpressionArray[n] = null;
            }
        }
    }

    public void setUserDefinedQueryStmt(String string, ASTSelectListContainer aSTSelectListContainer) {
        if (columns.isDebugEnabled()) {
            columns.debug(this.toName() + " SetUserDefinedQueryStmt...begin.  aSTSelectListContainer = " + aSTSelectListContainer + " , the userDefinedQueryStmt is: " + string);
        }
        if (columns.isDebugEnabled()) {
            columns.debug(this.toName() + " SetUserDefinedQueryStmt...end.   vecSelColMappingNames = " + this.vecSelColMappingNames);
        }
    }

    public boolean isPrepareSelColsOK() {
        return this.vecSelColMappingNames != null && this.vecSelColMappingNames.size() > 0;
    }

    public Vector getSelColMappingNamesFromParse() {
        return this.vecSelColMappingNames;
    }

    public String toName() {
        String string = this.getClass().getName();
        return string + "(/mappingName:" + this.mappingName + "):";
    }

    public boolean isPureJdbc() {
        JetUConnection jetUConnection = null;
        Vector vector = this.getPsqlTablesVector();
        if (vector.size() == 0) {
            return false;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.get(i);
            if (psqlTable.isQueriable()) {
                return false;
            }
            JetUConnection jetUConnection2 = psqlTable.getDataObj();
            if (!(jetUConnection2 instanceof JetUJDBCConnection)) {
                return false;
            }
            if (jetUConnection == null) {
                jetUConnection = jetUConnection2;
            }
            if (jetUConnection == jetUConnection2) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleConnection() {
        JetUConnection jetUConnection = null;
        Vector vector = this.getPsqlTablesVector();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.get(i);
            if (psqlTable.isQueriable()) {
                return false;
            }
            JetUConnection jetUConnection2 = psqlTable.getDataObj();
            if (jetUConnection == null) {
                jetUConnection = jetUConnection2;
            }
            if (jetUConnection == jetUConnection2) continue;
            return false;
        }
        return true;
    }

    class ExpWithLastOP {
        private final IUnCheckedExpression SEDU;
        private final String I;

        public ExpWithLastOP(IUnCheckedExpression iUnCheckedExpression, String string) {
            this.SEDU = iUnCheckedExpression;
            this.I = string;
        }

        public IUnCheckedExpression getExp() {
            return this.SEDU;
        }

        public String getLastLogicOperator() {
            return this.I;
        }
    }
}

