/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.util.StringTokenizer;
import java.util.Vector;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlTable;

public class PsqlSelColumn
extends PsqlColumn {
    public boolean bCompCol = false;
    public boolean bAggrCompCol = false;
    public String sExpression = null;
    public boolean bSortId = false;
    public boolean bAscentId = false;
    public int iOrderIndex = -1;
    public boolean bGrpById = false;
    public int iGroupbyIndex = -1;
    public String qualifier = null;
    public String owner = null;
    public String corr = null;
    public String sTableName = null;
    public transient PsqlTable table = null;
    public int tableIndex = 0;
    public String mappingName = null;
    public Vector vConditions = new Vector();
    public transient boolean isTypeSet = false;
    protected transient boolean isNotResolved = false;

    public PsqlSelColumn() {
    }

    public PsqlSelColumn(PsqlTable psqlTable, String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, String string3) {
        this(psqlTable, string, n, string2, n2, n3, n4, n5, n6, string3, false);
    }

    public PsqlSelColumn(PsqlTable psqlTable, String string, int n, String string2, int n2, int n3, int n4, int n5, int n6, String string3, boolean bl) {
        super(string, n, string2, n2, n3, n4, n5, n6, string3, bl);
        this.table = psqlTable;
        if (psqlTable != null) {
            this.sTableName = psqlTable.getName();
            this.qualifier = psqlTable.getQualifier();
            this.owner = psqlTable.getOwner();
            this.corr = psqlTable.getCorrelationName();
        }
    }

    public PsqlSelColumn(PsqlTable psqlTable, PsqlColumn psqlColumn) {
        this(psqlTable, psqlColumn.name, psqlColumn.type, psqlColumn.type_name, psqlColumn.precision, psqlColumn.length, psqlColumn.scale, psqlColumn.radix, psqlColumn.nullable, psqlColumn.remarks, psqlColumn.array);
    }

    public PsqlTable getPsqlTable() {
        return this.table;
    }

    public String getTableName() {
        return this.sTableName;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTableCorrName() {
        return this.corr;
    }

    public String getExpressionOfCompCol() {
        return this.sExpression;
    }

    public void setExpressionOfCompCol(String string) {
        this.sExpression = string;
    }

    public boolean isCompCol() {
        return this.bCompCol;
    }

    public void setCompCol(boolean bl) {
        this.bCompCol = bl;
    }

    public boolean isSort() {
        return this.bSortId;
    }

    public boolean isAscent() {
        return this.bAscentId;
    }

    public boolean isGrpBy() {
        return this.bGrpById;
    }

    public boolean isAggregateColumn() {
        return this.bAggrCompCol;
    }

    public void setAggregateColumn(boolean bl) {
        this.bAggrCompCol = bl;
        if (bl) {
            this.setCompCol(true);
        }
    }

    public void setSort(boolean bl) {
        this.bSortId = bl;
        if (!bl) {
            this.iOrderIndex = -1;
        }
    }

    public void setAscent(boolean bl) {
        this.bAscentId = bl;
    }

    public int getOrderIndex() {
        return this.iOrderIndex;
    }

    public void setOrderIndex(int n) {
        this.iOrderIndex = n;
    }

    public int getGroupbyIndex() {
        return this.iGroupbyIndex;
    }

    public void setGroupbyIndex(int n) {
        this.iGroupbyIndex = n;
    }

    public void setGrpBy(boolean bl) {
        this.bGrpById = bl;
        if (!bl) {
            this.iGroupbyIndex = -1;
        }
    }

    public String getSqlColumnName(boolean bl) {
        if (this.isCompCol()) {
            return this.sExpression == null ? "" : this.sExpression;
        }
        if (this.table != null) {
            String string = DbTools.quotedWhenNeed(this.table.getNameCorr());
            if (this.getName() != null) {
                return string + "." + DbTools.quotedWhenNeed(this.getName());
            }
        }
        if (this.getName() != null) {
            return DbTools.quotedWhenNeed(this.getName());
        }
        return "";
    }

    public static boolean isAggrExpression(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim().toUpperCase();
            if (string2.equals("COUNT")) {
                return true;
            }
            if (string2.equals("SUM")) {
                return true;
            }
            if (string2.equals("MIN")) {
                return true;
            }
            if (string2.equals("MAX")) {
                return true;
            }
            if (string2.equals("AVG")) {
                return true;
            }
        }
        return false;
    }

    public Vector getConditionsVector() {
        return this.vConditions;
    }

    @Override
    public void setMappingName(String string) {
        this.mappingName = string;
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public String getShowName() {
        if (this.table != null) {
            if (this.table.isShowMappingName()) {
                if (this.mappingName == null) {
                    return this.name;
                }
                return this.mappingName;
            }
            return this.name;
        }
        if (this.mappingName != null) {
            return this.mappingName;
        }
        return this.name;
    }

    public PsqlTable getSameTableFrom(Vector vector) {
        PsqlTable psqlTable = null;
        if (this.table != null) {
            int n = vector == null ? 0 : vector.size();
            for (int i = 0; i < n; ++i) {
                PsqlTable psqlTable2 = (PsqlTable)vector.elementAt(i);
                if (!psqlTable2.equals(this.table)) continue;
                psqlTable = psqlTable2;
                break;
            }
        }
        return psqlTable;
    }

    public PsqlSelColumn getCopy(Vector vector) {
        PsqlSelColumn psqlSelColumn = new PsqlSelColumn(this.getSameTableFrom(vector), this.getName(), this.type, this.type_name, this.precision, this.length, this.scale, this.radix, this.nullable, this.remarks, this.array);
        psqlSelColumn.bCompCol = this.bCompCol;
        psqlSelColumn.bAggrCompCol = this.bAggrCompCol;
        psqlSelColumn.sExpression = this.sExpression;
        psqlSelColumn.bSortId = this.bSortId;
        psqlSelColumn.bAscentId = this.bAscentId;
        psqlSelColumn.iOrderIndex = this.iOrderIndex;
        psqlSelColumn.bGrpById = this.bGrpById;
        psqlSelColumn.iGroupbyIndex = this.iGroupbyIndex;
        psqlSelColumn.bHideId = this.bHideId;
        psqlSelColumn.tableIndex = this.tableIndex;
        psqlSelColumn.qualifier = this.qualifier;
        psqlSelColumn.owner = this.owner;
        psqlSelColumn.corr = this.corr;
        psqlSelColumn.sTableName = this.sTableName;
        psqlSelColumn.vConditions = (Vector)this.vConditions.clone();
        psqlSelColumn.mappingName = this.mappingName;
        psqlSelColumn.setSuperMappingName(((PsqlColumn)this).mappingName);
        psqlSelColumn.isNotResolved = this.isNotResolved;
        return psqlSelColumn;
    }

    public String getSuperShowName() {
        return super.getShowName();
    }

    public String getSuperMappingName() {
        return ((PsqlColumn)this).mappingName;
    }

    public void setSuperMappingName(String string) {
        ((PsqlColumn)this).mappingName = string;
    }

    public static PsqlSelColumn getSelColByDBColumnName(Vector vector, String string) {
        return PsqlSelColumn.getSelColByName(vector, string, false);
    }

    public static PsqlSelColumn getSelColByMappingName(Vector vector, String string) {
        return PsqlSelColumn.getSelColByName(vector, string, true);
    }

    public static PsqlSelColumn getSelColByName(Vector vector, String string, boolean bl) {
        PsqlSelColumn psqlSelColumn = null;
        if (vector == null || string == null) {
            return null;
        }
        String string2 = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            psqlSelColumn = (PsqlSelColumn)vector.elementAt(i);
            if (!(bl ? (string2 = psqlSelColumn.getMappingName()) != null && string2.equalsIgnoreCase(string) : (string2 = psqlSelColumn.getTableName() + "." + psqlSelColumn.getName()).equalsIgnoreCase(string) || psqlSelColumn.getName().equalsIgnoreCase(string))) continue;
            return psqlSelColumn;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.name + "(" + ((PsqlColumn)this).mappingName + ", " + this.mappingName + ", " + (this.bCompCol ? this.sExpression : "") + ")]";
    }

    public void setNotResolved() {
        this.isNotResolved = true;
    }

    public boolean isNotResolved() {
        return this.isNotResolved;
    }
}

