/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import guitools.GuiUtil;
import java.util.Vector;
import jet.universe.JetUConnection;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlFKey;
import toolkit.db.PsqlKeyCol;
import toolkit.db.api.SQLMapInfo;

public class PsqlTable {
    public String connection = null;
    public String qualifier = null;
    public String owner = null;
    public String name = null;
    public String correlationName = null;
    public String mappingName = null;
    public transient Vector columns;
    public transient Vector vFKeys;
    public transient Vector vPKeyCols;
    public transient boolean isTable = true;
    public transient boolean isSystemTable = false;
    public transient boolean isView = false;
    public transient boolean isSynonym = false;
    public transient boolean isAlias = false;
    private transient boolean SEDU = false;
    public transient JetUConnection oData = null;
    private boolean addElement = false;
    private transient boolean append = false;
    public transient boolean gotPFK = false;

    public PsqlTable() {
        this.newVectors();
    }

    public PsqlTable(String string, String string2, String string3, String string4) {
        this.newVectors();
        this.qualifier = string;
        this.owner = string2;
        this.name = string3;
        if (string4 == null || string4.trim().equals("")) {
            string4 = new String("TABLE");
        }
        this.isTable = string4.indexOf("TABLE") != -1;
        this.isSystemTable = string4.indexOf("SYSTEM TABLE") != -1;
        this.isView = string4.indexOf("VIEW") != -1;
        this.isSynonym = string4.indexOf("SYNONYM") != -1;
        this.isAlias = string4.indexOf("ALIAS") != -1;
    }

    public void newVectors() {
        this.columns = new Vector();
        this.vFKeys = new Vector();
        this.vPKeyCols = new Vector();
    }

    public PsqlFKey findSameFKey(String string, String string2, String string3) {
        int n = this.vFKeys.size();
        for (int i = 0; i < n; ++i) {
            PsqlFKey psqlFKey = (PsqlFKey)this.vFKeys.elementAt(i);
            if (psqlFKey == null) continue;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            if (!string.equalsIgnoreCase(psqlFKey.pkqlf == null ? "" : psqlFKey.pkqlf) || !string2.equalsIgnoreCase(psqlFKey.pkowner == null ? "" : psqlFKey.pkowner) || !string3.equalsIgnoreCase(psqlFKey.pkname == null ? "" : psqlFKey.pkname)) continue;
            return psqlFKey;
        }
        return null;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String string) {
        this.connection = string;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String string) {
        this.qualifier = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setNotResolved() {
        this.append = true;
    }

    public boolean isNotResolved() {
        return this.append;
    }

    public Vector getFKeys() {
        return this.vFKeys;
    }

    public Vector getPKeyCols() {
        return this.vPKeyCols;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(String string) {
        if (string == null) {
            string = new String();
        }
        this.isTable = string.indexOf("TABLE") != -1;
        this.isSystemTable = string.indexOf("SYSTEM TABLE") != -1;
        this.isView = string.indexOf("VIEW") != -1;
        this.isSynonym = string.indexOf("SYNONYM") != -1;
        this.isAlias = string.indexOf("ALIAS") != -1;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public PsqlColumn getColumnByName(String string) {
        return this.getColumnByWhichName(string, false);
    }

    public PsqlColumn getColumnByShowName(String string) {
        return this.getColumnByWhichName(string, true);
    }

    public PsqlColumn getColumnByWhichName(String string, boolean bl) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)this.columns.elementAt(i);
            if (!(bl ? psqlColumn.getShowName() : psqlColumn.getName()).equalsIgnoreCase(string)) continue;
            return psqlColumn;
        }
        return null;
    }

    public PsqlColumn getColumnByMappingName(String string) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)this.columns.elementAt(i);
            if (!psqlColumn.getMappingName().equalsIgnoreCase(string)) continue;
            return psqlColumn;
        }
        return null;
    }

    public void setColumns(Vector vector) {
        if (this.columns != null) {
            this.columns.removeAllElements();
        }
        this.columns = vector;
    }

    public void addPsqlColumn(PsqlColumn psqlColumn) {
        this.columns.addElement(psqlColumn);
    }

    public boolean isTable() {
        return this.isTable;
    }

    public boolean isSystemTable() {
        return this.isSystemTable;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean isSynonym() {
        return this.isSynonym;
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public static PsqlTable getTableByName(Vector vector, String string) {
        return PsqlTable.getTableByWitchName(vector, string, false);
    }

    public static PsqlTable getTableByMappingName(Vector vector, String string) {
        return PsqlTable.getTableByWitchName(vector, string, true);
    }

    public static PsqlTable getTableByCorrName(Vector vector, String string) {
        if (vector == null || string == null) {
            return null;
        }
        String string2 = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            string2 = psqlTable.getCorrelationName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return psqlTable;
        }
        return null;
    }

    public static PsqlTable getTableByWitchName(Vector vector, String string, boolean bl) {
        if (vector == null) {
            return null;
        }
        String string2 = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            String string3 = string2 = bl ? psqlTable.getMappingName() : psqlTable.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return psqlTable;
        }
        return null;
    }

    public static PsqlTable getTableByName(Vector vector, String string, String string2, String string3, boolean bl) {
        return PsqlTable.getTableByName(vector, string, string2, string3, null, bl);
    }

    public static PsqlTable getTableByTable(Vector vector, PsqlTable psqlTable) {
        if (psqlTable == null) {
            return null;
        }
        return PsqlTable.getTableByName(vector, psqlTable.getQualifier(), psqlTable.getOwner(), psqlTable.getName(), false);
    }

    public void setCorrelationName(String string) {
        this.correlationName = string != null && string.length() <= 0 ? null : string;
    }

    public void copyTableTypesFrom(PsqlTable psqlTable) {
        if (psqlTable == null) {
            return;
        }
        this.isTable = psqlTable.isTable();
        this.isSystemTable = psqlTable.isSystemTable();
        this.isView = psqlTable.isView();
        this.isSynonym = psqlTable.isSynonym();
        this.isAlias = psqlTable.isAlias();
    }

    public void setMappingName(String string) {
        this.mappingName = string;
    }

    public boolean isShowMappingName() {
        return this.addElement;
    }

    public void setShowMappingName(boolean bl) {
        this.addElement = bl;
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)this.columns.elementAt(i);
            psqlColumn.setShowMappingName(bl);
        }
    }

    public String getShowName() {
        return this.getShowName(this.addElement);
    }

    public String getShowName(boolean bl) {
        String string = null;
        string = bl ? (this.mappingName == null ? this.name : this.mappingName) : this.name;
        if (this.correlationName != null && this.correlationName.trim().length() != 0) {
            string = this.correlationName + " (" + string + ")";
        }
        return string;
    }

    public void setDataObj(JetUConnection jetUConnection) {
        this.oData = jetUConnection;
    }

    public JetUConnection getDataObj() {
        return this.oData;
    }

    public boolean equals(PsqlTable psqlTable) {
        return psqlTable != null && GuiUtil.areEqualIgnoreCase(this.qualifier, psqlTable.qualifier) && GuiUtil.areEqualIgnoreCase(this.owner, psqlTable.owner) && GuiUtil.areEqualIgnoreCase(this.name, psqlTable.name) && GuiUtil.areEqualIgnoreCase(this.correlationName, psqlTable.correlationName) && GuiUtil.areEqualIgnoreCase(this.mappingName, psqlTable.mappingName) && this.isTable == psqlTable.isTable && this.isSystemTable == psqlTable.isSystemTable && this.isView == psqlTable.isView && this.isSynonym == psqlTable.isSynonym && this.isAlias == psqlTable.isAlias;
    }

    public synchronized PsqlTable getCopy() {
        PsqlTable psqlTable = new PsqlTable();
        psqlTable.connection = this.connection;
        psqlTable.qualifier = this.qualifier;
        psqlTable.owner = this.owner;
        psqlTable.name = this.name;
        psqlTable.correlationName = this.correlationName;
        psqlTable.mappingName = this.mappingName;
        psqlTable.addElement = this.addElement;
        psqlTable.columns = this.columns == null ? new Vector() : new Vector(this.columns.size());
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            PsqlColumn psqlColumn = (PsqlColumn)this.columns.elementAt(i);
            psqlTable.columns.addElement(psqlColumn.getCopy());
        }
        psqlTable.vFKeys = this.vFKeys == null ? new Vector() : new Vector(this.vFKeys.size());
        n = this.vFKeys.size();
        for (int i = 0; i < n; ++i) {
            PsqlFKey psqlFKey = (PsqlFKey)this.vFKeys.elementAt(i);
            psqlTable.vFKeys.addElement(psqlFKey.getCopy());
        }
        psqlTable.vPKeyCols = this.vPKeyCols == null ? new Vector() : new Vector(this.vPKeyCols.size());
        n = this.vPKeyCols.size();
        for (int i = 0; i < n; ++i) {
            PsqlKeyCol psqlKeyCol = (PsqlKeyCol)this.vPKeyCols.elementAt(i);
            psqlTable.vPKeyCols.addElement(psqlKeyCol.getCopy());
        }
        psqlTable.gotPFK = this.gotPFK;
        psqlTable.isTable = this.isTable;
        psqlTable.isSystemTable = this.isSystemTable;
        psqlTable.isView = this.isView;
        psqlTable.isSynonym = this.isSynonym;
        psqlTable.isAlias = this.isAlias;
        psqlTable.SEDU = this.SEDU;
        psqlTable.oData = this.oData;
        psqlTable.append = this.append;
        return psqlTable;
    }

    public static PsqlTable getTableByName(Vector vector, String string, String string2, String string3, String string4, boolean bl) {
        if (vector == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string5;
            PsqlTable psqlTable = (PsqlTable)vector.elementAt(i);
            String string6 = string5 = bl ? psqlTable.getMappingName() : psqlTable.getName();
            if (!string5.equalsIgnoreCase(string3)) continue;
            String string7 = psqlTable.getQualifier();
            if (string7 == null) {
                string7 = "";
            }
            if (string7.trim().length() == 0) {
                string7 = "";
            }
            if (!string7.equalsIgnoreCase(string)) continue;
            String string8 = psqlTable.getOwner();
            if (string8 == null) {
                string8 = "";
            }
            if (string8.trim().length() == 0) {
                string8 = "";
            }
            if (!string8.equalsIgnoreCase(string2)) continue;
            String string9 = psqlTable.getCorrelationName();
            if (string9 == null) {
                string9 = "";
            }
            if (string9.trim().length() == 0) {
                string9 = "";
            }
            if (!string9.equalsIgnoreCase(string4)) continue;
            return psqlTable;
        }
        return null;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(SQLMapInfo sQLMapInfo) {
        return sQLMapInfo == null ? this.name : (String)sQLMapInfo.getTabMap().get(this.mappingName.toUpperCase());
    }

    public String getCorrelationName() {
        return this.getCorrelationName(null);
    }

    public String getCorrelationName(SQLMapInfo sQLMapInfo) {
        return sQLMapInfo == null ? this.correlationName : (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase());
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public String getNameCorr() {
        return this.getNameCorr(null);
    }

    public String getNameCorr(SQLMapInfo sQLMapInfo) {
        if (sQLMapInfo == null) {
            if (this.correlationName == null || this.correlationName.trim().length() == 0) {
                return this.name;
            }
            return this.correlationName;
        }
        if (this.correlationName == null || this.correlationName.trim().length() == 0) {
            return (String)sQLMapInfo.getTabMap().get(this.mappingName.toUpperCase());
        }
        return (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase());
    }

    public String getQaulifiedNameCorr(int n, SQLMapInfo sQLMapInfo) {
        if (this.correlationName == null || this.correlationName.trim().length() == 0) {
            return PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, sQLMapInfo);
        }
        return DbTools.quotedWhenNeed(sQLMapInfo == null ? this.correlationName : (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase()));
    }

    public String getQaulifiedNameCorr(int n, String string, String string2, String string3, SQLMapInfo sQLMapInfo) {
        if (this.correlationName == null || this.correlationName.trim().length() == 0) {
            return PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, string, string2, string3, sQLMapInfo);
        }
        return DbTools.quotedWhenNeed(sQLMapInfo == null ? this.correlationName : (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase()), string, string2, string3);
    }

    public String getQaulifiedName(int n, SQLMapInfo sQLMapInfo) {
        return PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, sQLMapInfo);
    }

    public String getQaulifiedQuotedName(int n, String string, String string2, String string3, SQLMapInfo sQLMapInfo) {
        return PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, string, string2, string3, sQLMapInfo);
    }

    public static String getQaulifiedName(int n, String string, String string2, String string3, String string4, SQLMapInfo sQLMapInfo) {
        String[] stringArray = PsqlTable.SEDU(string, string2, string3, string4, sQLMapInfo);
        String string5 = DbTools.quotedWhenNeed(stringArray[2]);
        switch (n) {
            case 1: {
                if (string2 == null || string2.length() <= 0) break;
                string5 = DbTools.quotedWhenNeed(stringArray[1]) + "." + string5;
                break;
            }
            case 2: {
                if (string2 != null && string2.length() > 0) {
                    string5 = DbTools.quotedWhenNeed(stringArray[1]) + "." + string5;
                }
                if (string == null || string.length() <= 0) break;
                string5 = DbTools.quotedWhenNeed(stringArray[0]) + "." + string5;
            }
        }
        return string5;
    }

    public static String getQaulifiedName(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, SQLMapInfo sQLMapInfo) {
        String[] stringArray = PsqlTable.SEDU(string, string2, string3, string4, sQLMapInfo);
        String string8 = DbTools.quotedWhenNeed(stringArray[2], string5, string6, string7);
        switch (n) {
            case 1: {
                if (string2 == null || string2.length() <= 0) break;
                string8 = DbTools.quotedWhenNeed(stringArray[1], string5, string6, string7) + "." + string8;
                break;
            }
            case 2: {
                if (string2 != null && string2.length() > 0) {
                    string8 = DbTools.quotedWhenNeed(stringArray[1], string5, string6, string7) + "." + string8;
                }
                if (string == null || string.length() <= 0) break;
                string8 = DbTools.quotedWhenNeed(stringArray[0], string5, string6, string7) + "." + string8;
            }
        }
        return string8;
    }

    public String getTableRef(int n, SQLMapInfo sQLMapInfo) {
        String string = PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, sQLMapInfo);
        if (this.correlationName == null || this.correlationName.trim().length() == 0) {
            return string;
        }
        return string + " " + DbTools.quotedWhenNeed(sQLMapInfo == null ? this.correlationName : (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase()));
    }

    public String getTableRef(int n, String string, String string2, String string3, SQLMapInfo sQLMapInfo) {
        String string4 = PsqlTable.getQaulifiedName(n, this.qualifier, this.owner, this.name, this.mappingName, string, string2, string3, sQLMapInfo);
        if (this.correlationName == null || this.correlationName.trim().length() == 0) {
            return string4;
        }
        return string4 + " " + DbTools.quotedWhenNeed(sQLMapInfo == null ? this.correlationName : (String)sQLMapInfo.getTabMap().get(this.correlationName.toUpperCase()), string, string2, string3);
    }

    private static String[] SEDU(String string, String string2, String string3, String string4, SQLMapInfo sQLMapInfo) {
        String[] stringArray = new String[3];
        if (sQLMapInfo == null) {
            stringArray[0] = string;
            stringArray[1] = string2;
            stringArray[2] = string3;
        } else {
            String string5 = (String)sQLMapInfo.getTabMap().get(string4.toUpperCase());
            int n = string5.indexOf(".");
            int n2 = string5.lastIndexOf(".");
            if (n2 == -1) {
                stringArray[2] = string5;
            } else if (n == n2) {
                stringArray[2] = string5.substring(n2 + 1);
                stringArray[1] = string5.substring(0, n);
            } else {
                stringArray[2] = string5.substring(n2 + 1);
                stringArray[1] = string5.substring(n + 1, n2);
                stringArray[0] = string5.substring(0, n);
            }
        }
        return stringArray;
    }

    public String toString() {
        return super.toString() + " [" + this.connection + " | " + this.qualifier + " | " + this.owner + " | " + this.name + " | " + this.correlationName + " | " + this.mappingName + "]";
    }

    public boolean isQueriable() {
        return this.SEDU;
    }

    public void setQueriable(boolean bl) {
        this.SEDU = bl;
    }
}

