/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import jet.datasource.LoadUserDataSourceException;
import toolkit.db.ColumnInfo;

public class ResultSetInfo {
    public ResultSet rs = null;
    public Vector vecColumns = new Vector();
    public boolean bOracleRS = false;
    public boolean bEnterpriseDb = false;

    public void setResultSet(ResultSet resultSet) throws LoadUserDataSourceException {
        this.rs = resultSet;
        this.buildColumnInfos();
    }

    protected void buildColumnInfos() throws LoadUserDataSourceException {
        try {
            ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            int n3 = 0;
            String string = null;
            for (int i = 1; i <= n; ++i) {
                int n4;
                int n5 = resultSetMetaData.getColumnDisplaySize(i);
                try {
                    n4 = resultSetMetaData.getPrecision(i);
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = n5;
                }
                n2 = resultSetMetaData.getScale(i);
                n3 = resultSetMetaData.getColumnType(i);
                string = resultSetMetaData.getColumnTypeName(i);
                if (this.bOracleRS && n3 == 2) {
                    if (n2 == -127) {
                        n3 = 8;
                        string = "DOUBLE";
                        n2 = 0;
                    } else if (n2 == 0) {
                        if (n4 == 0) {
                            n3 = 8;
                            string = "DOUBLE";
                            n4 = 126;
                        } else {
                            n3 = 3;
                            string = "DECIMAL";
                        }
                    } else {
                        n3 = 3;
                        string = "DECIMAL";
                    }
                }
                if (n4 <= 0 && n5 > 0) {
                    n4 = n5;
                }
                if (n2 < 0) {
                    n2 = n3 == 2 ? 2 : 0;
                }
                this.vecColumns.addElement(new ColumnInfo(resultSetMetaData.getColumnName(i), i, n3, string, n4, 0, n2, 10, resultSetMetaData.isNullable(i), "", n3 == 2003));
            }
        }
        catch (SQLException sQLException) {
            throw new LoadUserDataSourceException(0, sQLException.getMessage());
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public Vector getColumns() {
        return this.vecColumns;
    }

    public void setColumns(Vector vector) {
        this.vecColumns = vector;
    }
}

