/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.api;

import toolkit.db.api.ColumnInfo;
import toolkit.db.api.JoinInfoConstants;

public class JoinInfo
implements JoinInfoConstants {
    private ColumnInfo SEDU;
    private String append;
    private ColumnInfo equals;
    int iJoinType;
    boolean bSQL92;
    boolean bSelfJoin;

    public JoinInfo(ColumnInfo columnInfo, String string, ColumnInfo columnInfo2, int n, boolean bl, boolean bl2) {
        this.SEDU = columnInfo;
        this.append = string;
        this.equals = columnInfo2;
        this.iJoinType = n;
        this.bSQL92 = bl;
        this.bSelfJoin = bl2;
    }

    public ColumnInfo getColumnFrom() {
        return this.SEDU;
    }

    public String getOperator() {
        return this.append;
    }

    public ColumnInfo getColumnTo() {
        return this.equals;
    }

    public int getJoinType() {
        return this.iJoinType;
    }

    public boolean isOuterJoin() {
        return (this.iJoinType & 7) != 0;
    }

    public boolean isLeftOuterJoin() {
        return (this.iJoinType & 4) != 0;
    }

    public boolean isRightOuterJoin() {
        return (this.iJoinType & 1) != 0;
    }

    public boolean isFullOuterJoin() {
        return (this.iJoinType & 2) != 0;
    }

    public boolean isSQL92() {
        return this.bSQL92;
    }

    public boolean isSelfJoin() {
        return this.bSelfJoin;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JoinInfo) {
            JoinInfo joinInfo = (JoinInfo)object;
            return this.SEDU.equals(joinInfo.SEDU) && this.append.equalsIgnoreCase(joinInfo.append) && this.equals.equals(joinInfo.equals) && this.iJoinType == joinInfo.iJoinType && this.bSQL92 ^ joinInfo.bSQL92 && this.bSelfJoin ^ joinInfo.bSelfJoin;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[ " + this.SEDU == null ? "Null" : (this.SEDU.getMappingName() + " | " + this.append + " | " + this.equals == null ? "Null" : this.equals.getMappingName() + " | " + JoinInfo.SEDU(this.iJoinType) + " | " + this.bSQL92 + " | " + this.bSelfJoin + " ]");
    }

    private static String SEDU(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Inner Join";
                break;
            }
            case 1: {
                string = "Right Outer Join";
                break;
            }
            case 2: {
                string = "Full Outer Join";
                break;
            }
            case 4: {
                string = "Left Outer Join";
                break;
            }
            case 8: {
                string = "Union Join";
            }
        }
        return string;
    }
}

