/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.gui;

import java.util.Hashtable;
import jet.log.JRLogger;

public class MappingSQLType {
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_NUMBER = "Number";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_DECIMAL = "Decimal";
    public static final String TYPE_CURRENCY = "Currency";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATETIME = "DateTime";
    public static final String TYPE_BINARY = "Binary";
    public static final String TYPE_NULL = "Null";
    public static final String[] strSQLType = new String[]{"String", "java.math.BigDecimal", "boolean", "byte", "short", "int", "long", "float", "double", "java.io.InputStream", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp"};
    public static final String strDefaultSQLType = "String";
    public static final int[][] iColProperty = new int[][]{{254, 254, 0, 0}, {18, 20, 2, 10}, {1, 1, 0, 2}, {3, 1, 0, 10}, {5, 2, 0, 10}, {10, 4, 0, 10}, {19, 8, 0, 10}, {7, 4, 2, 10}, {15, 8, 2, 10}, {-1, -1, 0, 0}, {8, 8, 0, 0}, {16, 16, 0, 10}, {23, 16, 3, 10}, {0, 0, 0, 0}};
    public static final int VARCHAR = 0;
    public static final int NUMERIC = 1;
    public static final int BIT = 2;
    public static final int TINYINT = 3;
    public static final int SMALLINT = 4;
    public static final int INTEGER = 5;
    public static final int BIGINT = 6;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int LONGVARBINARY = 9;
    public static final int DATE = 10;
    public static final int TIME = 11;
    public static final int TIMESTAMP = 12;
    public static final int UNKNOWN = 13;
    public static final String[] strNullable = new String[]{"NO_NULLS", "NULLABLE", "NULLABLE_UNKNOWN"};
    private static JRLogger SEDU = JRLogger.getLogger(MappingSQLType.class.getName());
    static Hashtable SQLType = new Hashtable();
    static Hashtable NullableType;

    public static int mappingSQLTypeToInt(String string) {
        return (Integer)SQLType.get(string);
    }

    public static int mappingNullableType(String string) {
        return (Integer)NullableType.get(string);
    }

    public static String mappingIntToSQLType(int n) {
        switch (n) {
            case -7: {
                return "boolean";
            }
            case -6: {
                return "byte";
            }
            case 5: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 12: {
                return "String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -4: {
                return "java.io.InputStream";
            }
        }
        return "String";
    }

    public static int[] getColumnProperty(String string) {
        return MappingSQLType.getColumnProperty(MappingSQLType.mappingSQLTypeToInt(string));
    }

    public static int[] getColumnProperty(int n) {
        switch (n) {
            case -7: {
                return iColProperty[2];
            }
            case -6: {
                return iColProperty[3];
            }
            case 5: {
                return iColProperty[4];
            }
            case 4: {
                return iColProperty[5];
            }
            case -5: {
                return iColProperty[6];
            }
            case 7: {
                return iColProperty[7];
            }
            case 8: {
                return iColProperty[8];
            }
            case 2: 
            case 3: {
                return iColProperty[1];
            }
            case 12: {
                return iColProperty[0];
            }
            case 91: {
                return iColProperty[10];
            }
            case 92: {
                return iColProperty[11];
            }
            case 93: {
                return iColProperty[12];
            }
            case -4: {
                return iColProperty[9];
            }
        }
        return iColProperty[13];
    }

    public static final int mapColType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2003: 
            case 2004: 
            case 2005: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n += 82;
                break;
            }
            case -8: {
                n = 1;
                break;
            }
            case -9: {
                n = 12;
                break;
            }
            case -10: {
                n = -1;
                break;
            }
            case 16: {
                n = -7;
                break;
            }
            default: {
                if (!SEDU.isErrorEnabled()) break;
                SEDU.error("MappingSQLType\n" + n + " unknow type!");
            }
        }
        return n;
    }

    public static final int mapRelationTypeToSQLType(int n) {
        switch (n) {
            case -7: {
                return -7;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return -5;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case 3: {
                return 3;
            }
            case 12: {
                return 12;
            }
            case 91: {
                return 91;
            }
            case 92: {
                return 92;
            }
            case 93: {
                return 93;
            }
        }
        throw new RuntimeException("Invalid data type : " + n);
    }

    public static final int mergeParamTypeToSQLType(String string) {
        if (string.equals(TYPE_BOOLEAN)) {
            return -7;
        }
        if (string.equals(TYPE_INTEGER)) {
            return -5;
        }
        if (string.equals(TYPE_NUMBER)) {
            return 8;
        }
        if (string.equals(TYPE_CURRENCY)) {
            return 3;
        }
        if (string.equals("String")) {
            return 12;
        }
        if (string.equals(TYPE_DATE)) {
            return 91;
        }
        if (string.equals(TYPE_TIME)) {
            return 92;
        }
        if (string.equals(TYPE_DATETIME)) {
            return 93;
        }
        throw new RuntimeException("Not support parameter type : " + string);
    }

    public static final String mapSQLTypeToString(int n) {
        switch (n) {
            case -7: {
                return TYPE_BOOLEAN;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return TYPE_INTEGER;
            }
            case 6: 
            case 7: 
            case 8: {
                return TYPE_NUMBER;
            }
            case 2: 
            case 3: {
                return TYPE_CURRENCY;
            }
            case -1: 
            case 1: 
            case 12: {
                return "String";
            }
            case 91: {
                return TYPE_DATE;
            }
            case 92: {
                return TYPE_TIME;
            }
            case 93: {
                return TYPE_DATETIME;
            }
            case -4: 
            case -3: 
            case -2: {
                return TYPE_BINARY;
            }
            case 0: {
                return TYPE_NULL;
            }
        }
        return "";
    }

    public static final int mapSQLTypeToInt(String string) {
        if (string.equals(TYPE_BOOLEAN)) {
            return -7;
        }
        if (string.equals(TYPE_INTEGER)) {
            return 4;
        }
        if (string.equals(TYPE_NUMBER)) {
            return 8;
        }
        if (string.equals(TYPE_CURRENCY)) {
            return 3;
        }
        if (string.equals("String")) {
            return -1;
        }
        if (string.equals(TYPE_DATE)) {
            return 91;
        }
        if (string.equals(TYPE_TIME)) {
            return 92;
        }
        if (string.equals(TYPE_DATETIME)) {
            return 93;
        }
        if (string.equals(TYPE_BINARY)) {
            return -4;
        }
        if (string.equals(TYPE_NULL)) {
            return 0;
        }
        return 1111;
    }

    static {
        SQLType.put("boolean", new Integer(-7));
        SQLType.put("byte", new Integer(-6));
        SQLType.put("short", new Integer(5));
        SQLType.put("int", new Integer(4));
        SQLType.put("long", new Integer(-5));
        SQLType.put("float", new Integer(7));
        SQLType.put("double", new Integer(8));
        SQLType.put("java.math.BigDecimal", new Integer(2));
        SQLType.put("String", new Integer(12));
        SQLType.put("java.sql.Date", new Integer(91));
        SQLType.put("java.sql.Time", new Integer(92));
        SQLType.put("java.sql.Timestamp", new Integer(93));
        SQLType.put("java.io.InputStream", new Integer(-4));
        NullableType = new Hashtable();
        NullableType.put("NO_NULLS", new Integer(0));
        NullableType.put("NULLABLE", new Integer(1));
        NullableType.put("NULLABLE_UNKNOWN", new Integer(2));
    }
}

