/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import java.util.ArrayList;
import java.util.List;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoNode;

public class ElementNode
extends MongoNode {
    private boolean SEDU = false;
    private String add;
    private String append;
    private List endsWith;
    private int equals;
    private int getName = Integer.MAX_VALUE;
    private String getParent;

    public ElementNode(String string) {
        super(string);
        this.endsWith = new ArrayList();
    }

    public String getTypeName() throws MongoDbException {
        switch (this.getType()) {
            case 1: {
                return "Floating point";
            }
            case 2: {
                return "UTF-8 string";
            }
            case 4: {
                return "Array";
            }
            case 5: {
                return "Binary data";
            }
            case 7: {
                return "ObjectId";
            }
            case 8: {
                return "Boolean";
            }
            case 9: {
                return "UTC datetime";
            }
            case 11: {
                return "Regular expression";
            }
            case 13: {
                return "JavaScript code";
            }
            case 15: {
                return "JavaScript code w/ scope";
            }
            case 16: {
                return "32-bit Integer";
            }
            case 17: {
                return "Timestamp";
            }
            case 18: {
                return "64-bit integer";
            }
        }
        throw new MongoDbException(7115);
    }

    public String getSubtypeName() throws MongoDbException {
        switch (this.equals) {
            case 0: {
                return "Binary / Generic";
            }
            case 1: {
                return "Function";
            }
            case 2: {
                return "Binary (Old)";
            }
            case 3: {
                return "UUID (Old)";
            }
            case 4: {
                return "UUID";
            }
            case 5: {
                return "MD5";
            }
            case 128: {
                return "User defined";
            }
        }
        throw new MongoDbException(7115);
    }

    public boolean isValidColumn() {
        return this.getParent != null && this.getParent.length() > 0 && (this.getName != Integer.MAX_VALUE || this.add != null && this.add.length() > 0);
    }

    public String getSqlTypeName() {
        switch (this.getSqlType()) {
            case 8: {
                return "DOUBLE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2003: {
                return "ARRAY";
            }
            case -3: {
                return "VARBINARY";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
        }
        return "N/A";
    }

    public int getSqlType() {
        return ElementNode.getSqlTypeByMongoType(this.getType());
    }

    public static int getSqlTypeByMongoType(int n) {
        switch (n) {
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 4: {
                return 2003;
            }
            case 5: {
                return -3;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 93;
            }
            case 11: {
                return 12;
            }
            case 13: {
                return 12;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 93;
            }
            case 18: {
                return -5;
            }
        }
        return n;
    }

    public int getSubtype() {
        return this.equals;
    }

    public void setSubtype(int n) {
        this.equals = n;
    }

    public int getType() {
        if (this.getName != Integer.MAX_VALUE) {
            return this.getName;
        }
        return this.SEDU(this.add);
    }

    public void setType(int n) {
        this.getName = n;
    }

    private int SEDU(String string) {
        if (string == null) {
            return Integer.MAX_VALUE;
        }
        if (string.endsWith("Boolean")) {
            return 8;
        }
        if (string.endsWith("Integer")) {
            return 16;
        }
        if (string.endsWith("Double")) {
            return 1;
        }
        if (string.endsWith("String")) {
            return 2;
        }
        if (string.endsWith("Date")) {
            return 9;
        }
        if (string.endsWith("Array")) {
            return 4;
        }
        if (string.endsWith("ObjectId")) {
            return 7;
        }
        if (string.endsWith("List")) {
            return 3;
        }
        if (string.endsWith("Long")) {
            return 18;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isTable() {
        return this.SEDU;
    }

    public void setTable(boolean bl) {
        this.SEDU = bl;
    }

    public String getFullName() {
        if (this.getParent == null || this.getParent.length() == 0) {
            this.getParent = this.getName();
            MongoNode mongoNode = this.getParent();
            while (mongoNode instanceof ElementNode) {
                this.getParent = mongoNode.getName() + "." + this.getParent;
                mongoNode = mongoNode.getParent();
            }
        }
        return this.getParent;
    }

    public void setFullName(String string) {
        this.getParent = string;
    }

    public List getChildren() {
        return this.endsWith;
    }

    public String getClassName() {
        return this.add;
    }

    public void setClassName(String string) {
        this.add = string;
    }

    public ElementNode getOrAddChild(String string) {
        for (ElementNode elementNode : this.endsWith) {
            if (!elementNode.getName().equals(string)) continue;
            return elementNode;
        }
        ElementNode elementNode = new ElementNode(string);
        elementNode.setParent(this);
        this.endsWith.add(elementNode);
        return elementNode;
    }

    public int getArrayType() {
        return ElementNode.getSqlTypeByMongoType(this.SEDU(this.append));
    }

    public String getArrayClassName() {
        return this.append;
    }

    public void setArrayClassName(String string) {
        this.append = string;
    }

    public void setChildren(List list) {
        for (ElementNode elementNode : list) {
            elementNode.setParent(this);
        }
        this.endsWith = list;
    }
}

