/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.MongoURI;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.log.JRLogger;
import toolkit.db.mongo.MongoDatabaseMetaData;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoMetaDataProvider;
import toolkit.db.mongo.SchemaNode;

public class MongoConnection
implements Connection {
    private MongoClient I;
    private MongoClientURI SEDU;
    private String add;
    private String append;
    private DB authenticate;
    private SchemaNode buildMongoDb;
    private List close;
    private boolean contains = false;
    private final JRLogger equals = JRLogger.getLogger(MongoConnection.class.getName());

    public MongoConnection(List list, String string, String string2) throws MongoDbException, IOException {
        this(list, string, string2, "");
    }

    public MongoConnection(List list, String string, String string2, String string3) throws MongoDbException, IOException {
        StringBuilder stringBuilder = new StringBuilder("mongodb://");
        for (ServerAddress serverAddress : list) {
            stringBuilder.append(serverAddress.getHost());
            if (serverAddress.getPort() > 0) {
                stringBuilder.append(":" + serverAddress.getPort());
            }
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append("/?" + string3);
        }
        this.buildMongoDb(new MongoClientURI(stringBuilder.toString()), string, string2);
    }

    public MongoConnection(String string, int n, String string2, String string3) throws MongoDbException, IOException {
        this(string, n, string2, string3, "");
    }

    public MongoConnection(String string, int n, String string2, String string3, String string4) throws MongoDbException, IOException {
        StringBuilder stringBuilder = new StringBuilder("mongodb://");
        if (string != null || string.length() != 0) {
            stringBuilder.append(string);
        }
        if (n > 0) {
            stringBuilder.append(":" + n);
        }
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append("/?" + string4);
        }
        this.buildMongoDb(new MongoClientURI(stringBuilder.toString()), string2, string3);
    }

    public MongoConnection(String string, String string2, String string3) throws MongoDbException, IOException {
        this(new MongoClientURI(string), string2, string3);
    }

    protected MongoConnection(MongoClientURI mongoClientURI, String string, String string2) throws MongoDbException, IOException {
        this.buildMongoDb(mongoClientURI, string, string2);
    }

    void buildMongoDb(MongoClientURI mongoClientURI, String string, String string2) throws MongoDbException, IOException {
        this.SEDU = mongoClientURI;
        this.create();
        this.add = string;
        this.append = string2;
        if (string != null && string.length() > 0) {
            this.I();
        }
    }

    private void create() throws MongoDbException, UnknownHostException, IOException {
        try {
            this.I = new MongoClient(this.SEDU);
            this.I.getDatabaseNames();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MongoDbException(7013, (Throwable)illegalArgumentException);
        }
        catch (MongoException mongoException) {
            if (mongoException.getMessage().contains("need to login") || mongoException.getMessage().contains("unauthorized") || mongoException.getMessage().contains("not authorized")) {
                this.equals.info((Object)mongoException);
            }
            if (mongoException.getCause() instanceof IOException) {
                throw (IOException)mongoException.getCause();
            }
            this.I.close();
            throw new MongoDbException(7010, (Object[])new String[]{this.SEDU.toString()}, (Throwable)mongoException);
        }
    }

    private void I() throws MongoDbException {
        if (this.I == null) {
            this.equals.error("No client");
            return;
        }
        if (this.authenticate != null) {
            return;
        }
        this.authenticate = this.SEDU.getDatabase() != null && this.SEDU.getDatabase().length() > 0 ? this.I.getDB(this.SEDU.getDatabase()) : this.I.getDB("admin");
        try {
            this.SEDU();
        }
        catch (MongoDbException mongoDbException) {
            if (mongoDbException.key == 7025 || mongoDbException.key == 7030) {
                this.equals.warn(mongoDbException);
                this.contains = true;
            }
            throw mongoDbException;
        }
    }

    public boolean isNeedInputDb() {
        return this.contains;
    }

    private void SEDU() throws MongoDbException {
        block12: {
            String string;
            boolean bl = false;
            try {
                this.authenticate.getCollectionNames();
            }
            catch (Exception exception) {
                string = exception.getMessage();
                if (exception instanceof MongoException) {
                    if (string != null && (string.startsWith("unauthorized") || string.contains("auth fails") || string.contains("not authorized"))) {
                        bl = true;
                    }
                    this.equals.error(exception);
                    throw new MongoDbException(7015, (Throwable)exception);
                }
                this.equals.error(exception);
                throw new MongoDbException(7020, (Throwable)exception);
            }
            if (bl) {
                if (this.add != null && this.add.length() > 0 && this.append != null && this.append.length() > 0) {
                    try {
                        if (!this.authenticate.authenticate(this.add, this.append.toCharArray())) {
                            String string2 = this.authenticate.getName();
                            this.authenticate = this.I.getDB("admin");
                            if (this.authenticate.authenticate(this.add, this.append.toCharArray())) {
                                this.authenticate = this.I.getDB(string2);
                                return;
                            }
                            throw new MongoDbException(7025);
                        }
                        break block12;
                    }
                    catch (MongoException mongoException) {
                        string = this.authenticate.getName();
                        this.authenticate = this.I.getDB("admin");
                        if (this.authenticate.authenticate(this.add, this.append.toCharArray())) {
                            this.authenticate = this.I.getDB(string);
                            return;
                        }
                        throw new MongoDbException(7025);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new MongoDbException(7025);
                    }
                }
                throw new MongoDbException(7030);
            }
        }
    }

    public void useDatabase(String string) throws MongoDbException {
        if (this.authenticate == null || !this.authenticate.getName().equals(string)) {
            this.authenticate = this.I.getDB(string);
            this.SEDU();
        }
    }

    public List getDataBaseNames() {
        if (this.close != null && this.close.size() > 0) {
            return this.close;
        }
        try {
            return this.I.getDatabaseNames();
        }
        catch (MongoException mongoException) {
            if (!mongoException.getMessage().contains("need to login")) {
                throw mongoException;
            }
            return new ArrayList();
        }
    }

    public void setDatabases(List list) throws MongoDbException {
        this.close = new ArrayList();
        for (String string : list) {
            this.useDatabase(string);
            this.close.add(string);
        }
    }

    public void tryAccessRight(String string) throws MongoDbException {
        this.useDatabase(string);
    }

    public DB getMongoDatabase() {
        return this.authenticate;
    }

    public String getUsername() {
        return this.add;
    }

    public String getPassword() {
        return this.append;
    }

    @Override
    public void close() {
        if (this.I != null) {
            this.I.close();
            this.I = null;
        }
        this.SEDU = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.I == null;
    }

    public MongoURI getMongoURIObject() {
        return new MongoURI(this.SEDU.getURI());
    }

    public Mongo getClient() {
        return this.I;
    }

    public String test() throws MongoDbException {
        if (this.SEDU == null) {
            throw new MongoDbException(7045);
        }
        if (this.authenticate == null) {
            throw new MongoDbException(7050);
        }
        try {
            return "Connection test successful.\nMongo database name: " + this.authenticate.getName();
        }
        catch (Exception exception) {
            this.equals.error(exception);
            throw new MongoDbException(7040, (Throwable)exception);
        }
    }

    @Override
    public MongoDatabaseMetaData getMetaData() throws SQLException {
        try {
            MongoMetaDataProvider mongoMetaDataProvider = new MongoMetaDataProvider(this);
            return mongoMetaDataProvider.getMetaData();
        }
        catch (MongoDbException mongoDbException) {
            throw new SQLException(mongoDbException);
        }
    }

    public Object unwrap(Class clazz) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return null;
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
    }

    @Override
    public void setHoldability(int n) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return null;
    }

    public String getDatabaseName() {
        return this.authenticate.getName();
    }

    public SchemaNode getRoot() {
        return this.buildMongoDb;
    }

    public void setRoot(SchemaNode schemaNode) {
        this.buildMongoDb = schemaNode;
    }
}

