/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.MongoClientURI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import toolkit.db.mongo.MongoConnection;

public class MongoDriver
implements Driver {
    @Override
    public boolean acceptsURL(String string) {
        return string.startsWith("mongodb://");
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        if (properties != null && properties.size() > 0) {
            if (properties.containsKey("user")) {
                string2 = (String)properties.get("user");
            }
            if (properties.containsKey("password")) {
                string3 = (String)properties.get("password");
            }
        }
        try {
            MongoClientURI mongoClientURI = new MongoClientURI(string);
            return new MongoConnection(mongoClientURI, string2, string3);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        throw new UnsupportedOperationException("getPropertyInfo doesn't work yet");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new MongoDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }
}

