/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.sql.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.log.JRLogger;
import toolkit.db.mongo.CollectionNode;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoDatabaseMetaData;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoNode;
import toolkit.db.mongo.MongoResultSetMetaData;
import toolkit.db.mongo.SchemaNode;

public class MongoMetaDataProvider {
    private static final JRLogger SEDU = JRLogger.getLogger(MongoMetaDataProvider.class.getName());
    public static final String FIELD_NAME_SEPARATOR = ".";
    private int add = 10;
    private final MongoConnection append;
    private MongoNode close;

    public MongoMetaDataProvider(MongoConnection mongoConnection) throws MongoDbException {
        this.append = mongoConnection;
        this.close = mongoConnection.getRoot() != null ? mongoConnection.getRoot() : new SchemaNode(mongoConnection.getMongoURIObject().toString());
        this.close.setProvider(this);
    }

    public List getDataBaseNames() {
        return this.append.getDataBaseNames();
    }

    public List getAllCollectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.append.getMongoDatabase().getCollectionNames()) {
            if (string.startsWith("system.")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoResultSetMetaData getMetaData4Collection(CollectionNode collectionNode) throws MongoDbException {
        this.append.useDatabase(collectionNode.getParent().getName());
        DBCursor dBCursor = this.append.getMongoDatabase().getCollection(collectionNode.getName()).find();
        MongoResultSetMetaData mongoResultSetMetaData = null;
        try {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashSet hashSet = new HashSet();
            this.SEDU(dBCursor, hashMap, hashSet, hashMap2);
            mongoResultSetMetaData = new MongoResultSetMetaData(collectionNode.getName(), hashMap, hashSet, hashMap2);
        }
        finally {
            if (dBCursor != null) {
                dBCursor.close();
            }
        }
        return mongoResultSetMetaData;
    }

    private void SEDU(DBCursor dBCursor, Map map, Set set, Map map2) {
        for (int i = this.add; dBCursor.hasNext() && i >= 0; --i) {
            DBObject dBObject = dBCursor.next();
            this.processDBObject(null, dBObject, map, set, map2);
        }
    }

    protected void processDBObject(String string, DBObject dBObject, Map map, Set set, Map map2) {
        for (String string2 : dBObject.keySet()) {
            Object object = dBObject.get(string2);
            if (object == null) continue;
            if (object instanceof BasicDBList) {
                String string3 = (string == null ? "" : string + FIELD_NAME_SEPARATOR) + string2;
                BasicDBList basicDBList = (BasicDBList)object;
                if (basicDBList.isEmpty()) continue;
                if (basicDBList.get(0) instanceof DBObject) {
                    this.processDBObject(string3, (DBObject)basicDBList.get(0), map, set, map2);
                    set.add(string3);
                    map.put(string3, List.class);
                    continue;
                }
                map.put(string3, Array.class);
                map.put((string == null ? "" : string + FIELD_NAME_SEPARATOR) + string2, basicDBList.get(0).getClass());
                continue;
            }
            if (object instanceof BasicDBObject) {
                this.processDBObject((string == null ? "" : string + FIELD_NAME_SEPARATOR) + string2, (DBObject)object, map, set, map2);
                continue;
            }
            map.put((string == null ? "" : string + FIELD_NAME_SEPARATOR) + string2, object.getClass());
        }
    }

    public MongoNode getRoot() {
        return this.close;
    }

    public MongoDatabaseMetaData getMetaData() {
        return new MongoDatabaseMetaData((SchemaNode)this.close);
    }

    public List getCollectionbyDatabase(String string) throws MongoDbException {
        this.append.useDatabase(string);
        return new ArrayList(this.getAllCollectionNames());
    }
}

