/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jet.formula.Aggregation;
import toolkit.db.api.AggregationInfo;
import toolkit.db.api.ColumnInfo;
import toolkit.db.api.ConnectionInfo;
import toolkit.db.api.GroupInfo;
import toolkit.db.api.TableInfo;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoQueryExecuter;
import toolkit.db.mongo.MongoResultSet;

public class MongoQuery {
    private List SEDU;
    private List add;
    private List append;
    private List clear;
    private List close;
    private String contains;
    private String containsKey;
    private int equals;
    private int get;
    private boolean getCatalogName;
    private String getCollection;
    private String getColumnInfo;
    private ConnectionInfo getColumnName;
    private MongoQueryExecuter getDataset = null;

    public MongoQuery() {
        this.setProjections(new ArrayList());
        this.add = new ArrayList();
        this.setGroupBys(new ArrayList());
        this.setGroupAggs(new ArrayList());
    }

    public List getSorts() {
        return this.close;
    }

    public void setSorts(List list) {
        this.close = list;
    }

    public int getLimit() {
        return this.get;
    }

    public void setLimit(int n) {
        this.get = n;
    }

    public List getAggQueryOject() throws MongoDbException {
        ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>();
        if (this.add.size() > 0) {
            this.equals(arrayList);
        }
        if (this.contains != null && this.contains.length() > 0) {
            DBObject dBObject = (DBObject)JSON.parse((String)this.contains);
            arrayList.add(new BasicDBObject("$match", (Object)dBObject));
        }
        if (this.SEDU.size() > 0) {
            arrayList.add(new BasicDBObject("$project", (Object)this.get()));
        }
        if (this.close != null && this.close.size() > 0) {
            arrayList.add(new BasicDBObject("$sort", (Object)this.append()));
        }
        if (this.append != null && this.append.size() > 0 || this.clear != null && this.clear.size() > 0) {
            arrayList.add(new BasicDBObject("$group", (Object)this.contains()));
            if (this.append != null && this.append.size() > 0) {
                arrayList.add(new BasicDBObject("$sort", (Object)this.SEDU()));
            }
        }
        if (this.getCatalogName) {
            arrayList.add(new BasicDBObject("$group", this.add()));
        }
        return arrayList;
    }

    public DBObject getQueryOject() throws MongoDbException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (this.getColumnName()) {
            DBObject dBObject;
            ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>();
            if (this.add.size() > 0) {
                this.equals(arrayList);
            }
            if (this.contains != null && this.contains.length() > 0) {
                dBObject = (DBObject)JSON.parse((String)this.contains);
                arrayList.add(new BasicDBObject("$match", (Object)dBObject));
            }
            if (this.SEDU.size() > 0) {
                arrayList.add(new BasicDBObject("$project", (Object)this.get()));
            }
            if (this.close != null && this.close.size() > 0) {
                arrayList.add(new BasicDBObject("$sort", (Object)this.append()));
            }
            if (this.append != null && this.append.size() > 0 || this.clear != null && this.clear.size() > 0) {
                arrayList.add(new BasicDBObject("$group", (Object)this.contains()));
                if (this.append != null && this.append.size() > 0) {
                    arrayList.add(new BasicDBObject("$sort", (Object)this.SEDU()));
                }
            }
            if (this.getCatalogName) {
                arrayList.add(new BasicDBObject("$group", this.add()));
            }
            if (this.get > 0) {
                arrayList.add(new BasicDBObject("$limit", (Object)this.get));
            }
            if (this.equals > 0) {
                arrayList.add(new BasicDBObject("$skip", (Object)this.equals));
            }
            dBObject = new BasicDBObject();
            dBObject.append("aggregate", (Object)this.getCollection()).append("pipeline", arrayList);
            basicDBObject.append("runCommand", (Object)dBObject);
        } else {
            basicDBObject.append("collectionName", (Object)this.getCollection());
            basicDBObject.append("findFields", (Object)this.get());
            basicDBObject.append("findQuery", (Object)this.clear());
            if (this.close != null && this.close.size() > 0) {
                basicDBObject.append("sort", (Object)this.append());
            }
            if (this.get > 0) {
                basicDBObject.append("limit", (Object)this.get);
            }
            if (this.equals > 0) {
                basicDBObject.append("start", (Object)this.equals);
            }
        }
        return basicDBObject;
    }

    private BasicDBObject SEDU() {
        BasicDBObject basicDBObject = new BasicDBObject();
        for (int i = 0; i < this.getGroupBys().size(); ++i) {
            GroupInfo groupInfo = (GroupInfo)this.getGroupBys().get(i);
            if (groupInfo.getOrder() == 3) {
                return new BasicDBObject();
            }
            if (i != 0) continue;
            basicDBObject.append("_id", (Object)(groupInfo.getOrder() == 0 ? 1 : -1));
        }
        return basicDBObject;
    }

    private Object add() {
        BasicDBObject basicDBObject = new BasicDBObject();
        for (ColumnInfo columnInfo : this.getProjections()) {
            String string = this.getCatalogName(columnInfo);
            basicDBObject.append(string.replace('.', '_'), (Object)("$" + string));
        }
        BasicDBObject basicDBObject2 = new BasicDBObject("_id", (Object)basicDBObject);
        return basicDBObject2;
    }

    private BasicDBObject append() {
        BasicDBObject basicDBObject = new BasicDBObject();
        for (int i = 0; i < this.getSorts().size(); ++i) {
            GroupInfo groupInfo = (GroupInfo)this.getSorts().get(i);
            if (groupInfo.getOrder() == 3) continue;
            basicDBObject.append(this.getCatalogName(groupInfo.getColumnInfo()), (Object)(groupInfo.getOrder() == 0 ? 1 : -1));
        }
        return basicDBObject;
    }

    private BasicDBObject clear() {
        return null;
    }

    private BasicDBObject contains() throws MongoDbException {
        BasicDBObject basicDBObject = new BasicDBObject();
        for (Object object : this.getGroupBys()) {
            Object object2 = this.getCatalogName(((GroupInfo)object).getColumnInfo());
            basicDBObject.append(((String)object2).replace('.', '_'), (Object)("$" + (String)object2));
        }
        BasicDBObject basicDBObject2 = new BasicDBObject("_id", (Object)basicDBObject);
        for (Object object2 : this.getGroupAggs()) {
            String string = this.getCatalogName(((AggregationInfo)object2).getColumnInfo());
            basicDBObject2.append(string.replace('.', '_') + "_" + ((AggregationInfo)object2).getOrder(), (Object)this.containsKey((AggregationInfo)object2, string));
        }
        return basicDBObject2;
    }

    private DBObject containsKey(AggregationInfo aggregationInfo, String string) throws MongoDbException {
        switch (aggregationInfo.getOrder()) {
            case 1: {
                return new BasicDBObject("$sum", (Object)1);
            }
            case 2: {
                return new BasicDBObject("$sum", (Object)("$" + string));
            }
            case 6: {
                return new BasicDBObject("$avg", (Object)("$" + string));
            }
            case 4: {
                return new BasicDBObject("$max", (Object)("$" + string));
            }
            case 3: {
                return new BasicDBObject("$min", (Object)("$" + string));
            }
        }
        throw new MongoDbException(7175, new String[]{Aggregation.getFunctionName(aggregationInfo.getOrder())});
    }

    private void equals(List list) {
        TreeMap treeMap = this.getColumnInfo();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)treeMap.get(iterator.next());
            for (String string : arrayList) {
                if (string == null || string.length() <= 0) continue;
                list.add(new BasicDBObject("$unwind", (Object)("$" + string)));
            }
        }
    }

    private BasicDBObject get() {
        BasicDBObject basicDBObject;
        block4: {
            int n;
            block3: {
                basicDBObject = new BasicDBObject();
                if (this.getProjections().size() <= 0) break block3;
                for (int i = 0; i < this.getProjections().size(); ++i) {
                    basicDBObject.append(this.getCatalogName((ColumnInfo)this.getProjections().get(i)), (Object)1);
                }
                break block4;
            }
            if (this.getGroupBys().size() <= 0) break block4;
            for (n = 0; n < this.getGroupBys().size(); ++n) {
                basicDBObject.append(this.getCatalogName(((GroupInfo)this.getGroupBys().get(n)).getColumnInfo()), (Object)1);
            }
            for (n = 0; n < this.getGroupAggs().size(); ++n) {
                basicDBObject.append(this.getCatalogName(((AggregationInfo)this.getGroupAggs().get(n)).getColumnInfo()), (Object)1);
            }
        }
        return basicDBObject;
    }

    private String getCatalogName(ColumnInfo columnInfo) {
        String string = columnInfo.getTable().getTableName();
        if (string.length() == 0) {
            return columnInfo.getColumnName();
        }
        return string + "." + columnInfo.getColumnName();
    }

    private TreeMap getColumnInfo() {
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : this.getTables()) {
            if (this.getColumnInfo.equals(((TableInfo)object22).getTableName())) continue;
            arrayList.add(object22);
        }
        TreeMap treeMap = new TreeMap();
        object22 = new ArrayList();
        if (this.getGroupBys().size() > 0) {
            for (Object object3 : this.getGroupBys()) {
                object22.add(this.getCatalogName(((GroupInfo)object3).getColumnInfo()));
            }
            for (Object object3 : this.getGroupAggs()) {
                object22.add(this.getCatalogName(((AggregationInfo)object3).getColumnInfo()));
            }
        } else {
            for (Object object3 : this.getProjections()) {
                object22.add(this.getCatalogName((ColumnInfo)object3));
            }
        }
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            Object object3;
            object3 = (String)iterator.next();
            for (TableInfo tableInfo : arrayList) {
                String string = tableInfo.getTableName();
                if (!((String)object3).startsWith(string) || string.length() <= 0) continue;
                String[] stringArray = string.split("\\.");
                ArrayList arrayList2 = null;
                String string2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = i == 0 ? stringArray[i] : string2 + "." + stringArray[i];
                    if (treeMap.containsKey(i)) {
                        arrayList2 = (ArrayList)treeMap.get(i);
                    } else {
                        arrayList2 = new ArrayList();
                        treeMap.put(i, arrayList2);
                    }
                    if (arrayList2.contains(string2)) continue;
                    arrayList2.add(string2);
                }
            }
        }
        return treeMap;
    }

    private boolean getColumnName() {
        return true;
    }

    public String getCollection() {
        return this.getColumnInfo;
    }

    public void setCollection(String string) {
        this.getColumnInfo = string;
    }

    public List getProjections() {
        return this.SEDU;
    }

    public void setProjections(List list) {
        this.SEDU = list;
    }

    public List getTables() {
        return this.add;
    }

    public void setTables(List list) {
        this.add = list;
        if (list != null && list.size() > 0) {
            this.getColumnInfo = ((TableInfo)list.get(0)).getSchemaName();
            this.getCollection = ((TableInfo)list.get(0)).getCatalogName();
        }
    }

    public List getGroupBys() {
        return this.append;
    }

    public void setGroupBys(List list) {
        this.append = list;
    }

    public List getGroupAggs() {
        return this.clear;
    }

    public void setGroupAggs(List list) {
        this.clear = list;
    }

    public String getWhere() {
        return this.contains;
    }

    public void setWhere(String string) {
        this.contains = string;
    }

    public String getHaving() {
        return this.containsKey;
    }

    public void setHaving(String string) {
        this.containsKey = string;
    }

    public void close() throws SQLException {
        if (this.getDataset != null) {
            this.getDataset.close();
            this.getDataset = null;
        }
        this.getColumnName = null;
        if (this.SEDU != null) {
            this.SEDU.clear();
            this.SEDU = null;
        }
        if (this.add != null) {
            this.add.clear();
            this.add = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.close != null) {
            this.close.clear();
            this.close = null;
        }
    }

    public MongoResultSet getResultSet() throws SQLException, ClassNotFoundException {
        if (this.getDataset == null) {
            this.getDataset = new MongoQueryExecuter(this);
        }
        return this.getDataset.getDataset();
    }

    public ConnectionInfo getConnection() {
        return this.getColumnName;
    }

    public void setConnection(ConnectionInfo connectionInfo) {
        this.getColumnName = connectionInfo;
    }

    public boolean isDistinct() {
        return this.getCatalogName;
    }

    public void setDistinct(boolean bl) {
        this.getCatalogName = bl;
    }

    public String getDatabase() {
        return this.getCollection;
    }

    public void setDatabase(String string) {
        this.getCollection = string;
    }

    public List getMetadata() {
        if (this.append != null && this.append.size() > 0 || this.clear != null && this.clear.size() > 0) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object2 : this.append) {
                object = ((GroupInfo)object2).getColumnInfo();
                String string = "_id." + this.getCatalogName((ColumnInfo)object).replace('.', '_');
                arrayList.add(string);
            }
            for (Object object2 : this.clear) {
                object = this.getCatalogName(((AggregationInfo)object2).getColumnInfo()).replace('.', '_') + "_" + ((AggregationInfo)object2).getOrder();
                arrayList.add(object);
            }
            return arrayList;
        }
        if (this.SEDU != null && this.SEDU.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.getCatalogName) {
                for (ColumnInfo columnInfo : this.SEDU) {
                    String string = "_id." + this.getCatalogName(columnInfo).replace('.', '_');
                    arrayList.add(string);
                }
            } else {
                for (ColumnInfo columnInfo : this.SEDU) {
                    arrayList.add(this.getCatalogName(columnInfo));
                }
            }
            return arrayList;
        }
        return null;
    }

    public int getSkip() {
        return this.equals;
    }

    public void setSkip(int n) {
        this.equals = n;
    }
}

