/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandFailureException;
import com.mongodb.CommandResult;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jet.log.JRLogger;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoQuery;
import toolkit.db.mongo.MongoResultSet;
import toolkit.db.version2.ConnectionInfo;

public class MongoQueryExecuter {
    private static final JRLogger CURSOR = JRLogger.getLogger(MongoQueryExecuter.class.getName());
    public static final String FIND_QUERY_KEY = "findQuery";
    public static final String FIND_FIELDS_KEY = "findFields";
    public static final String SORT_KEY = "sort";
    public static final String LIMIT_KEY = "limit";
    public static final String START_KEY = "start";
    public static final String COLLECTION_NAME_KEY = "collectionName";
    public static final String ROWS_TO_PROCESS_KEY = "rowsToProcess";
    public static final String MAP_REDUCE_KEY = "mapReduce";
    public static final String MAP_KEY = "map";
    public static final String REDUCE_KEY = "reduce";
    public static final String OUT_KEY = "out";
    private static final String SEDU = "db";
    private static final String add = "finalize";
    public static final String RUN_COMMAND_KEY = "runCommand";
    public static final String AGGREGATE_KEY = "aggregate";
    public static final String PIPELINE_KEY = "pipeline";
    public static final String AGG_PROJECT_KEY = "$project";
    public static final String AGG_GROUP_KEY = "$group";
    public static final String AGG_MATCH_KEY = "$match";
    public static final String AGG_SORT_KEY = "$sort";
    public static final String AGG_LIMIT_KEY = "$limit";
    public static final String AGG_SUM_KEY = "$sum";
    public static final String AGG_COUNT_KEY = "$sum";
    public static final String AGG_UNWIND_KEY = "$unwind";
    private static final String aggregate = "result";
    public static final String AGG_SKIP_KEY = "$skip";
    private static final int allowDiskUse = 0xB33333;
    private static final int append = 10000;
    private DBCursor batchSize;
    private DBObject build;
    private MongoConnection builder;
    private ConnectionInfo clear;
    public List commandResults;
    private String close;
    private int containsField = 0;
    private int currentTimeMillis = 10000;
    private boolean debug = false;
    private List error;
    protected Cursor aggCur;
    private boolean find = true;
    private List freeConnection;
    private Object get;
    private int getAggQueryOject = 0;
    private boolean getCollection = true;

    public MongoQueryExecuter(MongoQuery mongoQuery) throws SQLException, ClassNotFoundException {
        toolkit.db.api.ConnectionInfo connectionInfo = mongoQuery.getConnection();
        this.clear = (ConnectionInfo)ConnectionsBroker.getConnection(this.CURSOR(connectionInfo.getURL(), mongoQuery.getDatabase()), connectionInfo.getUser(), connectionInfo.getPassword(), connectionInfo.getDriver());
        this.builder = (MongoConnection)this.clear.getRealConn();
        try {
            this.freeConnection = mongoQuery.getAggQueryOject();
            this.error = mongoQuery.getMetadata();
            this.error.add(0, null);
            this.close = mongoQuery.getDatabase();
            this.aggregate(mongoQuery);
        }
        catch (MongoDbException mongoDbException) {
            this.clear();
            throw new SQLException(mongoDbException);
        }
    }

    private String CURSOR(String string, String string2) {
        int n = string.indexOf(63);
        if (n < 0) {
            return string + "/" + string2;
        }
        return string.substring(0, n) + string2 + string.substring(n);
    }

    private void SEDU(DBObject dBObject) throws MongoDbException {
        Integer n;
        this.builder.useDatabase(this.close);
        if (dBObject.containsField(RUN_COMMAND_KEY)) {
            this.get = dBObject.removeField(RUN_COMMAND_KEY);
            this.runCommand(this.aggCur(this.get));
            if (!this.isEnd() && !this.debug) {
                this.add();
            }
        } else {
            this.allowDiskUse();
        }
        if (dBObject.containsField(ROWS_TO_PROCESS_KEY) && (n = this.append(dBObject.get(ROWS_TO_PROCESS_KEY))) != null) {
            this.containsField = n;
        }
        if (this.containsField == 0) {
            this.containsField = Integer.MAX_VALUE;
        }
    }

    private void add() {
        int n = this.commandResults.size();
        int n2 = n > 10 ? 10 : n;
        int n3 = Integer.MIN_VALUE;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            for (int i = 0; i < n2; ++i) {
                Integer n4 = secureRandom.nextInt(n);
                n3 = Math.max(n3, this.commandResults.get(n4).toString().length());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            CURSOR.error("not support SHA1PRNG random.", noSuchAlgorithmException);
        }
        this.currentTimeMillis = 0xB33333 / n3;
        if (CURSOR.isDebugEnabled()) {
            CURSOR.debug("resize the limit with first result: fetch size = " + this.currentTimeMillis + " maxLength=" + n3);
        }
    }

    private Object aggCur(Object object) {
        DBObject dBObject = (DBObject)object;
        if (dBObject.containsField(PIPELINE_KEY)) {
            BasicDBObject basicDBObject = new BasicDBObject(AGGREGATE_KEY, dBObject.get(AGGREGATE_KEY));
            ArrayList<BasicDBObject> arrayList = new ArrayList<BasicDBObject>((List)dBObject.get(PIPELINE_KEY));
            if (this.getAggQueryOject != 0) {
                arrayList.add(new BasicDBObject(AGG_SKIP_KEY, (Object)this.getAggQueryOject));
            }
            arrayList.add(new BasicDBObject(AGG_LIMIT_KEY, (Object)this.currentTimeMillis));
            this.getAggQueryOject += this.currentTimeMillis;
            basicDBObject.put(PIPELINE_KEY, arrayList);
            return basicDBObject;
        }
        return object;
    }

    public void refetch() throws MongoDbException {
        this.getCollection = false;
        if (!this.find) {
            this.runCommand(this.aggCur(this.get));
        }
    }

    private void aggregate(MongoQuery mongoQuery) throws MongoDbException {
        long l;
        block4: {
            l = 0L;
            try {
                this.builder.useDatabase(this.close);
                DBCollection dBCollection = this.builder.getMongoDatabase().getCollection(mongoQuery.getCollection());
                AggregationOptions.Builder builder = AggregationOptions.builder();
                builder.allowDiskUse(Boolean.valueOf(true));
                builder.batchSize(Integer.valueOf(0));
                builder.outputMode(AggregationOptions.OutputMode.CURSOR);
                AggregationOptions aggregationOptions = builder.build();
                if (CURSOR.isDebugEnabled()) {
                    l = System.currentTimeMillis();
                    CURSOR.debug("execute begin Mongo aggregation query @" + this.hashCode() + " : " + this.freeConnection.toString() + " AggregationOption : " + aggregationOptions);
                }
                this.aggCur = dBCollection.aggregate(this.freeConnection, aggregationOptions);
            }
            catch (CommandFailureException commandFailureException) {
                this.find = false;
                this.build = mongoQuery.getQueryOject();
                this.SEDU(this.build);
                if (!CURSOR.isDebugEnabled()) break block4;
                CURSOR.debug(" execute Mongo aggregation query error, error info is " + commandFailureException.getMessage() + " goAgg=" + this.find);
            }
        }
        if (CURSOR.isDebugEnabled()) {
            CURSOR.debug("execute end mongo aggregation query @" + this.hashCode() + "with time ms " + (System.currentTimeMillis() - l));
        }
    }

    public boolean isGoAgg() {
        return this.find;
    }

    private void runCommand(Object object) throws MongoDbException {
        long l = 0L;
        if (CURSOR.isDebugEnabled()) {
            l = System.currentTimeMillis();
            CURSOR.debug("execute begin Mongo query @" + this.hashCode() + " : " + object.toString());
        }
        if (!(object instanceof DBObject)) {
            throw new MongoDbException(7130);
        }
        DBObject dBObject = (DBObject)object;
        CommandResult commandResult = this.builder.getMongoDatabase().command(dBObject);
        if (!commandResult.ok()) {
            throw new MongoDbException(7135, new String[]{commandResult.getErrorMessage()});
        }
        Object object2 = commandResult.get(aggregate);
        if (object2 == null) {
            throw new MongoDbException(7140);
        }
        this.commandResults = (List)object2;
        if (CURSOR.isDebugEnabled()) {
            CURSOR.debug("execute end mongo query @" + this.hashCode() + "with time ms " + (System.currentTimeMillis() - l));
        }
    }

    private void allowDiskUse() throws MongoDbException {
        Integer n;
        if (!this.build.containsField(COLLECTION_NAME_KEY)) {
            throw new MongoDbException(7145);
        }
        DBObject dBObject = (DBObject)this.build.get(FIND_QUERY_KEY);
        if (dBObject == null) {
            dBObject = new BasicDBObject();
        }
        DBCollection dBCollection = this.builder.getMongoDatabase().getCollectionFromString((String)this.build.removeField(COLLECTION_NAME_KEY));
        this.batchSize(dBCollection.find(dBObject, (DBObject)this.build.get(FIND_FIELDS_KEY)));
        if (this.build.containsField(SORT_KEY)) {
            this.batchSize(this.getIterator().sort((DBObject)this.build.get(SORT_KEY)));
        }
        if (this.build.containsField(START_KEY) && (n = this.append(this.build.get(START_KEY))) != null) {
            this.batchSize(this.getIterator().skip(n.intValue()));
        }
        if (this.build.containsField(LIMIT_KEY) && (n = this.append(this.build.get(LIMIT_KEY))) != null) {
            this.batchSize(this.getIterator().limit(n.intValue()));
        }
    }

    private Integer append(Object object) {
        try {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            CURSOR.error(exception);
            return null;
        }
    }

    public DBCursor getIterator() {
        return this.batchSize;
    }

    private void batchSize(DBCursor dBCursor) {
        this.batchSize = dBCursor;
    }

    public MongoResultSet getDataset() {
        return new MongoResultSet(this);
    }

    public List getMetadata() {
        return this.error;
    }

    public void setMetadata(List list) {
        this.error = list;
    }

    public int getFetchSize() {
        return this.currentTimeMillis;
    }

    public void setFetchSize(int n) {
        this.currentTimeMillis = n;
        this.debug = true;
    }

    public boolean isEnd() {
        if (this.getCollection && !this.debug) {
            return this.commandResults.size() < 10000;
        }
        return this.commandResults.size() < this.currentTimeMillis;
    }

    public void clear() throws SQLException {
        if (this.batchSize != null) {
            this.batchSize.close();
        }
        this.build = null;
        if (this.builder != null) {
            ConnectionsBroker.freeConnection(this.clear);
            this.clear = null;
            this.builder = null;
        }
        if (this.commandResults != null) {
            this.commandResults.clear();
            this.commandResults = null;
        }
        if (this.error != null) {
            this.error.clear();
            this.error = null;
        }
        if (this.aggCur != null) {
            this.aggCur.close();
            this.aggCur = null;
        }
    }

    public void close() throws SQLException {
        this.clear();
    }
}

