/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBObject;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine8.olap.util.DataConverter;
import jet.log.JRLogger;
import org.bson.types.ObjectId;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.mongo.MongoQueryExecuter;

public class MongoResultSet
implements ResultSet {
    private MongoQueryExecuter SEDU;
    private DBObject aggCur;
    private static final JRLogger booleanValue = JRLogger.getLogger(MongoResultSet.class.getName());
    private boolean byteValue = false;
    private boolean clear = false;
    private Iterator commandResults;
    private boolean doubleValue = false;
    private Cursor floatValue;
    private List get;
    private boolean getColName;

    protected MongoResultSet() {
    }

    public MongoResultSet(MongoQueryExecuter mongoQueryExecuter) {
        booleanValue.info("New MongoDB Data set");
        this.SEDU = mongoQueryExecuter;
        this.get = mongoQueryExecuter.getMetadata();
        this.refresh(mongoQueryExecuter);
    }

    private void refresh(MongoQueryExecuter mongoQueryExecuter) {
        boolean bl = this.byteValue = mongoQueryExecuter.getIterator() != null;
        if (!this.byteValue) {
            this.doubleValue = mongoQueryExecuter.isGoAgg();
            this.floatValue = mongoQueryExecuter.aggCur;
        }
        if (!this.doubleValue) {
            this.clear = mongoQueryExecuter.commandResults != null;
            this.commandResults = mongoQueryExecuter.commandResults.iterator();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    public DbValue getFieldValue(DbColDesc dbColDesc) throws DSException {
        DbValue dbValue = DbValue.makeDbValue(dbColDesc);
        if (this.byteValue) {
            DataConverter.setValue(dbValue, this.aggCur(dbColDesc.getColName()));
        } else if (this.clear) {
            DataConverter.setValue(dbValue, this.SEDU(dbColDesc.getColName()));
        }
        return dbValue;
    }

    private Object SEDU(String string) {
        Object object = this.booleanValue(string, this.getCurrentResult());
        if (object instanceof ObjectId) {
            return ((ObjectId)object).toString();
        }
        return object;
    }

    private Object aggCur(String string) {
        return this.booleanValue(string, this.getCurrentResult());
    }

    private Object booleanValue(String string, DBObject dBObject) {
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = i == stringArray.length - 1;
            String string2 = stringArray[i];
            Object object = dBObject.get(string2);
            if (object == null) {
                return null;
            }
            if (object instanceof DBObject) {
                dBObject = (DBObject)object;
                if (!bl) continue;
                return dBObject;
            }
            if (bl) {
                return dBObject.get(string2);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl = false;
        if (this.byteValue && (bl = this.SEDU.getIterator().hasNext())) {
            this.setCurrentResult(this.SEDU.getIterator().next());
        } else if (this.doubleValue) {
            bl = this.floatValue.hasNext();
            this.setCurrentResult(null);
            if (bl) {
                this.setCurrentResult((DBObject)this.floatValue.next());
            }
        } else if (this.clear) {
            bl = this.commandResults.hasNext();
            this.setCurrentResult(null);
            if (bl) {
                this.setCurrentResult((DBObject)this.commandResults.next());
            } else if (!this.SEDU.isEnd()) {
                try {
                    this.SEDU.refetch();
                }
                catch (MongoDbException mongoDbException) {
                    throw new SQLException(mongoDbException);
                }
                this.refresh(this.SEDU);
                bl = this.commandResults.hasNext();
                if (bl) {
                    this.setCurrentResult((DBObject)this.commandResults.next());
                }
            }
        }
        return bl;
    }

    public Object unwrap(Class clazz) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.SEDU != null) {
            this.SEDU.clear();
        }
        this.SEDU = null;
        this.setCurrentResult(null);
        this.commandResults = null;
        this.get = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getColName;
    }

    @Override
    public String getString(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return null;
        }
        this.getColName = false;
        return object.toString();
    }

    protected Object getValue(String string) {
        if (string.indexOf(".") == -1) {
            return this.getCurrentResult().get(string);
        }
        String[] stringArray = string.split("\\.");
        Object object = this.getCurrentResult().get(stringArray[0]);
        int n = 1;
        do {
            if (object == null) {
                return null;
            }
            if (object instanceof BasicDBList) {
                BasicDBList basicDBList = (BasicDBList)object;
                if (basicDBList.isEmpty()) {
                    return null;
                }
                if (basicDBList.get(0) instanceof BasicDBObject) {
                    object = ((BasicDBObject)basicDBList.get(0)).get(stringArray[n]);
                    continue;
                }
                return null;
            }
            if (!(object instanceof BasicDBObject)) continue;
            object = ((BasicDBObject)object).get(stringArray[n]);
        } while (++n < stringArray.length);
        return object;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return false;
        }
        this.getColName = false;
        Boolean bl = null;
        try {
            bl = (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            bl = Boolean.valueOf(object.toString());
        }
        return bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0;
        }
        this.getColName = false;
        Byte by = 0;
        try {
            by = (Byte)object;
        }
        catch (ClassCastException classCastException) {
            try {
                by = Byte.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return by;
    }

    @Override
    public short getShort(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0;
        }
        this.getColName = false;
        Short s = 0;
        try {
            s = (Short)object;
        }
        catch (ClassCastException classCastException) {
            try {
                s = Short.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return s;
    }

    @Override
    public int getInt(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0;
        }
        this.getColName = false;
        Integer n2 = 0;
        try {
            n2 = (Integer)object;
        }
        catch (ClassCastException classCastException) {
            try {
                n2 = Integer.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return n2;
    }

    @Override
    public long getLong(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0L;
        }
        this.getColName = false;
        Long l = 0L;
        try {
            l = (Long)object;
        }
        catch (ClassCastException classCastException) {
            try {
                l = Long.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return l;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0.0f;
        }
        this.getColName = false;
        Float f = Float.valueOf(0.0f);
        try {
            f = (Float)object;
        }
        catch (ClassCastException classCastException) {
            try {
                f = Float.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return f.floatValue();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return 0.0;
        }
        this.getColName = false;
        Double d = 0.0;
        try {
            d = (Double)object;
        }
        catch (ClassCastException classCastException) {
            try {
                d = Double.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return null;
        }
        this.getColName = false;
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = (BigDecimal)object;
        }
        catch (ClassCastException classCastException) {
            try {
                bigDecimal = BigDecimal.valueOf(Double.valueOf(object.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                this.getColName = true;
            }
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return null;
        }
        this.getColName = false;
        try {
            return new Date(((java.util.Date)object).getTime());
        }
        catch (ClassCastException classCastException) {
            this.getColName = true;
            return null;
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return null;
        }
        this.getColName = false;
        try {
            return new Time(((java.util.Date)object).getTime());
        }
        catch (ClassCastException classCastException) {
            this.getColName = true;
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        String string = (String)this.get.get(n);
        Object object = this.getValue(string);
        if (object == null) {
            this.getColName = true;
            return null;
        }
        this.getColName = false;
        try {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        catch (ClassCastException classCastException) {
            this.getColName = true;
            return null;
        }
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return null;
    }

    @Override
    public String getString(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return false;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return 0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        return 0;
    }

    @Override
    public int getInt(String string) throws SQLException {
        return 0;
    }

    @Override
    public long getLong(String string) throws SQLException {
        return 0L;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return 0.0f;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return null;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return 0;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return 0;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return 0;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
    }

    @Override
    public void updateTime(int n, Time time2) throws SQLException {
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
    }

    @Override
    public void updateNull(String string) throws SQLException {
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
    }

    @Override
    public void updateTime(String string, Time time2) throws SQLException {
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return null;
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
    }

    @Override
    public String getNString(int n) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String string) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
    }

    protected DBObject getCurrentResult() {
        return this.aggCur;
    }

    protected void setCurrentResult(DBObject dBObject) {
        this.aggCur = dBObject;
    }
}

