/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.query.parser;

import toolkit.db.query.parser.Node;
import toolkit.db.query.parser.QueryParser;
import toolkit.db.query.parser.QueryParserTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected String image;
    protected QueryParser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(QueryParser queryParser, int n) {
        this(n);
        this.parser = queryParser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public int jjtIndexOf(Node node) {
        return this.jjtIndexOf(node, 0);
    }

    @Override
    public int jjtIndexOf(Node node, int n) {
        for (int i = n; i < this.children.length; ++i) {
            if (!node.equals(this.children[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void jjtRemoveChild(int n) {
        int n2;
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + 0);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + 0);
        }
        if (n >= this.children.length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.children.length);
        }
        this.children[n].jjtSetParent(null);
        if (this.children.length == 1) {
            this.children = null;
            return;
        }
        Node[] nodeArray = new Node[this.children.length - 1];
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = this.children[n2];
        }
        for (n2 = n; n2 < this.children.length - 1; ++n2) {
            nodeArray[n2] = this.children[n2 + 1];
        }
        this.children = nodeArray;
    }

    @Override
    public boolean jjtRemoveChild(Node node) {
        int n = this.jjtIndexOf(node);
        if (n == -1) {
            return false;
        }
        this.jjtRemoveChild(n);
        return true;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return QueryParserTreeConstants.jjtNodeName[this.id] + " : " + this.getImage();
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void initImage() {
    }

    public String getImage() {
        if (this.image == null) {
            this.initImage();
        }
        return this.image;
    }

    final String removeQuota(String string) {
        if (string != null && (string.charAt(0) == '\"' || string.charAt(0) == '`')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }
}

