/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import com.jinfonet.jdbc.UnsupportedException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUJdbcSupportInfo;
import toolkit.config.PoolConfig;
import toolkit.db.version2.CallTrace;
import toolkit.db.version2.DebugStatement;
import toolkit.db.version2.JdbcPool;

public class ConnectionInfo
implements Connection {
    int lock;
    long time;
    String username;
    Connection connection;
    JdbcPool pool;
    private String SEDU;
    private int append;
    private String clearWarnings;
    private String close = null;
    private static JRLogger commit = JRLogger.getLogger(ConnectionInfo.class.getName());
    private static DSLog config = DSLog.getDSLog(ConnectionInfo.class.getName());

    public Connection getRealConn() {
        Connection connection = this.connection;
        while (connection != this && connection instanceof ConnectionInfo) {
            connection = ((ConnectionInfo)connection).getRealConn();
        }
        return connection;
    }

    ConnectionInfo(JdbcPool jdbcPool, Connection connection, String string, String string2) {
        this.pool = jdbcPool;
        this.connection = connection;
        try {
            this.close = connection.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.username = string;
        this.SEDU = string2;
        ++this.lock;
        this.time = System.currentTimeMillis();
        this.append = System.identityHashCode(this);
        if (commit.isDebugEnabled()) {
            commit.debug("create connection\nshare count is " + this.lock);
        }
    }

    public String getCatalogUsedToGetConnection() {
        return this.clearWarnings;
    }

    public void setCatalogUsedToGetConnection(String string) {
        this.clearWarnings = string;
    }

    public String getUser() {
        return this.username;
    }

    public synchronized int getStartTime() {
        return this.lock > 0 ? (int)(System.currentTimeMillis() - this.time) : -1;
    }

    public synchronized int getIdleTime() {
        return this.lock == 0 ? (int)(System.currentTimeMillis() - this.time) : -1;
    }

    public synchronized int getLockNumber() {
        return this.lock;
    }

    public synchronized boolean isLock() {
        return this.lock > 0;
    }

    public JdbcPool getJdbcPool() {
        return this.pool;
    }

    synchronized void lock() throws SQLException {
        SQLException sQLException = null;
        if (commit.isDebugEnabled()) {
            commit.debug("share connection\nshare count is " + this.lock);
        }
        if (this.connValid()) {
            ++this.lock;
        } else {
            if (this.connection != null) {
                try {
                    if (!this.connection.getAutoCommit()) {
                        this.connection.commit();
                    }
                    this.connection.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            PoolConfig poolConfig = this.pool.getConfig();
            int n = poolConfig.getMaxCount();
            int n2 = poolConfig.getShare();
            int n3 = poolConfig.getAttempt();
            int n4 = poolConfig.getInterval();
            int n5 = n4 * n3;
            int n6 = n3;
            while (--n6 >= 0) {
                try {
                    this.connection = DriverManager.getConnection(poolConfig.getURL(), this.username, this.SEDU);
                    if (this.connValid()) {
                        ++this.lock;
                        sQLException = null;
                        break;
                    }
                }
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                }
                if (n4 <= 0) continue;
                try {
                    this.wait(n5);
                    n5 -= n4;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.time = System.currentTimeMillis();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized boolean connValid() {
        boolean bl = true;
        return bl;
    }

    synchronized void unlock() {
        if (this.lock > 0 && --this.lock == 0) {
            this.time = System.currentTimeMillis();
        }
        if (commit.isDebugEnabled()) {
            commit.debug("reduce share connection\nshare count is " + this.lock);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (SQLWarning sQLWarning = this.connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
        }
        this.connection.clearWarnings();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ConnectionInfo) {
            ConnectionInfo connectionInfo = (ConnectionInfo)object;
            return connectionInfo.connection.equals(this.connection) && connectionInfo.username.equals(this.username);
        }
        return false;
    }

    protected void finalize() {
        block2: {
            try {
                this.disconnect();
            }
            catch (SQLException sQLException) {
                if (!commit.isErrorEnabled()) break block2;
                commit.error("", sQLException);
            }
        }
    }

    void disconnect() throws SQLException {
        SQLException sQLException = null;
        if (this.connection != null) {
            try {
                if (!this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
                this.connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.pool = null;
            this.lock = 0;
        }
        this.connection = null;
        if (config.isDebugEnabled()) {
            config.debug("disconnect connection H:[" + this.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] ShareCount[" + this.getLockNumber() + "]", new CallTrace());
            config.debug("disconnect connection\nshare count is " + this.lock);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (commit.isDebugEnabled()) {
            return new DebugStatement(this.connection.createStatement());
        }
        return this.connection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.connection.prepareCall(string);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        if (config.isDebugEnabled()) {
            config.debug("close connection H:[" + this.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "]", new CallTrace());
        }
        this.unlock();
        if (this.connection == null) {
            return;
        }
        if (this.pool.config.getIdleExpire() == 0) {
            this.pool.disconnect(this.hashCode());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.close;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
        this.close = this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (commit.isDebugEnabled()) {
            return new DebugStatement(this.connection.createStatement(n, n2));
        }
        return this.connection.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.connection.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.connection.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("This is not a Jdbc 3.0 Compliant Connection");
    }

    void dump(Writer writer) throws IOException {
        writer.write("\t\tshare count is " + this.lock + "\r\n");
        writer.write("\t\t" + (this.lock == 0 ? "idle time is " : "last get time is ") + (System.currentTimeMillis() - this.time) + "ms\r\n");
        writer.write("\t\tconnection: " + this.connection + "\r\n");
    }

    public String getPassword() {
        return this.SEDU;
    }

    public JetUJdbcSupportInfo getSupportInfo() {
        return this.pool.getSupportInfo();
    }

    public int hashCode() {
        return this.append;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new UnsupportedException();
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        throw new UnsupportedException();
    }
}

