/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import jet.log.JRLogger;
import toolkit.db.version2.JdbcPool;
import toolkit.db.version2.PoolService;

public class JdbcDataSource
implements Runnable {
    boolean end;
    long interval = 1000L;
    PoolService service;
    Hashtable pools = new Hashtable();
    Thread thread;
    private static JRLogger SEDU = JRLogger.getLogger(JdbcDataSource.class.getName());

    JdbcDataSource(PoolService poolService) {
        this.service = poolService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(String string, String string2, String string3, String string4, String string5) throws SQLException, ClassNotFoundException {
        JdbcPool jdbcPool = null;
        JdbcDataSource jdbcDataSource = this;
        synchronized (jdbcDataSource) {
            String string6 = string2.toLowerCase();
            jdbcPool = (JdbcPool)this.pools.get(string6);
            if (jdbcPool == null) {
                if (string != null && string.length() > 0) {
                    Class.forName(string);
                }
                jdbcPool = new JdbcPool(this.service.getPoolConfig(string2));
                this.pools.put(string6, jdbcPool);
            }
            if (this.end) {
                this.release();
            }
        }
        return jdbcPool.getConnection(string3, string4, string5);
    }

    void disconnect(String string, String string2) throws SQLException {
        String string3 = string.toLowerCase();
        JdbcPool jdbcPool = (JdbcPool)this.pools.get(string3);
        if (jdbcPool != null) {
            jdbcPool.disconnect(string2);
        }
    }

    void disconnect(String string) throws SQLException {
        String string2 = string.toLowerCase();
        JdbcPool jdbcPool = (JdbcPool)this.pools.get(string2);
        if (jdbcPool != null) {
            jdbcPool.disconnect();
        }
    }

    void disconnect(int n) throws SQLException {
        SQLException sQLException = null;
        Enumeration enumeration = this.pools.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((JdbcPool)enumeration.nextElement()).disconnect(n);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public Hashtable getPools() {
        return (Hashtable)this.pools.clone();
    }

    synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    void stop() {
        this.end = true;
    }

    @Override
    public void run() {
        while (!this.end) {
            try {
                Thread.sleep(this.interval);
                this.release();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (SQLException sQLException) {
                if (!SEDU.isErrorEnabled()) continue;
                SEDU.error("", sQLException);
            }
        }
        this.end = false;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() throws SQLException {
        SQLException sQLException = null;
        Enumeration enumeration = null;
        JdbcDataSource jdbcDataSource = this;
        synchronized (jdbcDataSource) {
            enumeration = this.getPools().elements();
        }
        while (enumeration.hasMoreElements()) {
            JdbcPool jdbcPool = (JdbcPool)enumeration.nextElement();
            try {
                jdbcPool.release();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized void dispose() throws SQLException {
        Enumeration enumeration = this.pools.elements();
        SQLException sQLException = null;
        while (enumeration.hasMoreElements()) {
            try {
                ((JdbcPool)enumeration.nextElement()).dispose();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this.end = true;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void dump(Writer writer) throws IOException {
        Enumeration enumeration = this.pools.elements();
        while (enumeration.hasMoreElements()) {
            ((JdbcPool)enumeration.nextElement()).dump(writer);
        }
    }
}

