/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import com.jinfonet.jdbc.obj.ObjectConnection;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.dataengine.util.DSLog;
import jet.log.JRLogger;
import jet.universe.JetUJdbcSupportInfo;
import toolkit.config.PoolConfig;
import toolkit.db.version2.CallTrace;
import toolkit.db.version2.ConnectionInfo;

public class JdbcPool {
    int length;
    ConnectionInfo[] connections;
    PoolConfig config;
    private JetUJdbcSupportInfo SEDU = null;
    private static JRLogger add = JRLogger.getLogger(JdbcPool.class.getName());
    private static DSLog append = DSLog.getDSLog(JdbcPool.class.getName());

    JdbcPool(PoolConfig poolConfig) {
        this.config = poolConfig;
        int n = poolConfig.getMaxCount();
        this.connections = new ConnectionInfo[n <= 0 ? 10 : n];
    }

    public synchronized boolean checkValidity(Connection connection) {
        if (append.isDebugEnabled()) {
            append.debug("Validity connection H:[" + connection.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "]", new CallTrace());
        }
        boolean bl = true;
        ConnectionInfo connectionInfo = null;
        try {
            connectionInfo = (ConnectionInfo)connection;
            DatabaseMetaData databaseMetaData = connectionInfo.getMetaData();
            if (databaseMetaData.getDatabaseProductName().startsWith("ACCESS")) {
                return true;
            }
            ResultSet resultSet = connection.getMetaData().getSchemas();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            block11: {
                if (add.isErrorEnabled()) {
                    add.error("check connection validity: invalid");
                }
                try {
                    this.remove(connectionInfo);
                    connectionInfo.disconnect();
                }
                catch (SQLException sQLException2) {
                    if (!add.isErrorEnabled()) break block11;
                    add.error("close connection failed");
                }
            }
            bl = false;
        }
        catch (Exception exception) {
            block12: {
                try {
                    this.remove(connectionInfo);
                    connectionInfo.disconnect();
                }
                catch (SQLException sQLException) {
                    if (!add.isErrorEnabled()) break block12;
                    add.error("close connection failed");
                }
            }
            if (add.isErrorEnabled()) {
                add.error("check connection validity: invalid");
            }
            bl = false;
        }
        return bl;
    }

    public synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        if (string == null) {
            string = "";
        }
        int n = this.config.getMaxCount();
        int n2 = this.config.getIdleExpire();
        int n3 = this.config.getShare();
        int n4 = this.config.getAttempt();
        int n5 = this.config.getInterval();
        int n6 = n5 * n4;
        if (append.isDebugEnabled()) {
            append.debug("Befor get connection, get pool config information. idleTime=" + n2 + " share=" + n3 + " count=" + n);
        }
        int n7 = n4;
        while (--n7 >= 0) {
            block36: {
                Object object;
                ConnectionInfo connectionInfo;
                int n8 = this.length;
                while (--n8 >= 0) {
                    int n9;
                    block35: {
                        connectionInfo = this.connections[n8];
                        object = connectionInfo.getCatalog();
                        String string4 = connectionInfo.getCatalogUsedToGetConnection();
                        if (append.isDebugEnabled()) {
                            if (!connectionInfo.username.equals(string)) {
                                append.debug("User name does not satisfy. info.username=" + connectionInfo.username + "!!!!" + string + "!!!");
                            }
                            if (!(connectionInfo.getPassword() != null ? connectionInfo.getPassword().equals(string2) : string2 == null)) {
                                append.debug("Password does not satisfy. ");
                            }
                            if (n3 != 0 && (connectionInfo.getIdleTime() >= n2 || connectionInfo.getLockNumber() >= n3)) {
                                append.debug("Reach idle expire time or max share name. info.getIdleTime()=" + connectionInfo.getIdleTime() + " info.getLockNumber()=" + connectionInfo.getLockNumber());
                            }
                            if (!(string3 != null && object != null && ((String)object).length() > 0 && string3.equals(object) || string3 == null)) {
                                append.debug("Catalog does not satisfy. catalog=" + string3 + "!!!" + (String)object + "!!!");
                            }
                        }
                        if (!connectionInfo.username.equals(string) || !(connectionInfo.getPassword() == null ? string2 == null : connectionInfo.getPassword().equals(string2)) || n3 != 0 && (connectionInfo.getIdleTime() >= n2 || connectionInfo.getLockNumber() >= n3) || !(connectionInfo.getLockNumber() == 0 || string3 != null && object != null && ((String)object).length() > 0 && string3.equals(object) || string3 != null && string3.equals(string4)) && string3 != null) continue;
                        if (append.isDebugEnabled()) {
                            append.debug("Befor get connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            for (n9 = 0; n9 < this.connections.length; ++n9) {
                                if (this.connections[n9] == null) continue;
                                append.debug("\tJDBC POOL [" + n9 + "] connection H:[" + this.connections[n9].hashCode() + "] ShareCount:[" + this.connections[n9].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            }
                        }
                        if (connectionInfo.getLockNumber() == 0 && string3 != null) {
                            try {
                                connectionInfo.setCatalogUsedToGetConnection(string3);
                                connectionInfo.getRealConn().setCatalog(string3);
                            }
                            catch (SQLException sQLException) {
                                if (!append.isDebugEnabled()) break block35;
                                append.debug("Warning : Fail to set Catalog " + string3 + ". " + sQLException.getClass().getName() + " " + sQLException.getMessage());
                            }
                        }
                    }
                    connectionInfo.lock();
                    if (append.isDebugEnabled()) {
                        append.debug("End get connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] ShareCount:[" + connectionInfo.getLockNumber() + "] Pool H:[" + this.hashCode() + "]", new CallTrace());
                        for (n9 = 0; n9 < this.connections.length; ++n9) {
                            if (this.connections[n9] == null) continue;
                            append.debug("\tJDBC POOL [" + n9 + "] connection H:[" + this.connections[n9].hashCode() + "] ShareCount:[" + this.connections[n9].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                        }
                    }
                    return connectionInfo;
                }
                if (n != 0 && this.length == n) {
                    n8 = this.length;
                    while (--n8 >= 0) {
                        connectionInfo = this.connections[n8];
                        if (connectionInfo.isLock() || connectionInfo.username.equals(string)) continue;
                        connectionInfo.disconnect();
                        this.remove(connectionInfo);
                    }
                }
                if (n == 0 || n == 0 || this.length < n) {
                    try {
                        Connection connection = DriverManager.getConnection(this.config.getURL(), string, string2);
                        if (connection instanceof ObjectConnection) {
                            return connection;
                        }
                        connectionInfo = new ConnectionInfo(this, connection, string, string2);
                        if (this.SEDU == null && connection != null) {
                            if (add.isDebugEnabled()) {
                                add.debug("Fetch Support info from Connection url:[" + this.config.getURL() + "]");
                            }
                            JetUJdbcSupportInfo jetUJdbcSupportInfo = new JetUJdbcSupportInfo();
                            jetUJdbcSupportInfo.fetchJDBCSupportInfo(connection);
                            this.SEDU = jetUJdbcSupportInfo;
                        }
                        if (string3 != null) {
                            try {
                                connectionInfo.setCatalogUsedToGetConnection(string3);
                                connection.setCatalog(string3);
                            }
                            catch (SQLException sQLException) {
                                DSLog.getDSLog(this.getClass().getName()).debug(sQLException.getMessage());
                            }
                        }
                        if (append.isDebugEnabled()) {
                            append.debug("Befor create connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            for (int i = 0; i < this.connections.length; ++i) {
                                if (this.connections[i] == null) continue;
                                append.debug("\tBefor create connection JDBC POOL [" + i + "] connection H:[" + this.connections[i].hashCode() + "] ShareCount:[" + this.connections[i].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            }
                        }
                        this.add(connectionInfo);
                        if (append.isDebugEnabled()) {
                            append.debug("End create connection H:[" + connectionInfo.hashCode() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]", new CallTrace());
                            for (int i = 0; i < this.connections.length; ++i) {
                                if (this.connections[i] == null) continue;
                                append.debug("\tEnd create connection JDBC POOL [" + i + "] connection H:[" + this.connections[i].hashCode() + "] ShareCount:[" + this.connections[i].getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "] Pool H:[" + this.hashCode() + "]");
                            }
                            append.debug("Get create connection H:[" + connectionInfo.hashCode() + "] ShareCount:[" + connectionInfo.getLockNumber() + "] T:[" + Thread.currentThread().hashCode() + "]");
                        }
                        return connectionInfo;
                    }
                    catch (SQLException sQLException) {
                        if (n7 == 0 || this.length == 0) {
                            throw sQLException;
                        }
                    }
                    catch (Throwable throwable) {
                        if (n7 != 0 && this.length != 0) break block36;
                        object = new SQLException(throwable.getMessage());
                        ((Throwable)object).setStackTrace(throwable.getStackTrace());
                        throw object;
                    }
                }
            }
            if (n5 <= 0) continue;
            try {
                this.wait(n6);
                n6 -= n5;
            }
            catch (InterruptedException interruptedException) {
                DSLog.getDSLog(this.getClass().getName()).debug(interruptedException.getMessage());
            }
        }
        this.notifyAll();
        throw new SQLException("JReport connection pool: Can not establish more than  " + this.length + " connections with URL " + this.config.getURL());
    }

    synchronized void disconnect(String string) throws SQLException {
        SQLException sQLException = null;
        if (string == null) {
            string = "";
        }
        int n = this.length;
        while (--n >= 0) {
            ConnectionInfo connectionInfo = this.connections[n];
            if (!connectionInfo.username.equals(string)) continue;
            try {
                connectionInfo.disconnect();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (n < this.length - 1) {
                System.arraycopy(this.connections, n + 1, this.connections, n, this.length - n - 1);
            }
            --this.length;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized void disconnect() throws SQLException {
        SQLException sQLException = null;
        int n = this.length;
        while (--n >= 0) {
            try {
                this.connections[n].disconnect();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.length = 0;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    synchronized void disconnect(int n) throws SQLException {
        SQLException sQLException = null;
        int n2 = this.length;
        while (--n2 >= 0) {
            ConnectionInfo connectionInfo = this.connections[n2];
            if (connectionInfo.hashCode() != n) continue;
            try {
                connectionInfo.disconnect();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            if (n2 < this.length - 1) {
                System.arraycopy(this.connections, n2 + 1, this.connections, n2, this.length - n2 - 1);
            }
            --this.length;
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public ConnectionInfo[] getConnectionInfos() {
        ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.length];
        if (this.connections != null) {
            System.arraycopy(this.connections, 0, connectionInfoArray, 0, this.length);
        }
        return connectionInfoArray;
    }

    public PoolConfig getConfig() {
        return this.config;
    }

    void add(ConnectionInfo connectionInfo) {
        if (this.length == this.connections.length) {
            ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.length + this.length];
            System.arraycopy(this.connections, 0, connectionInfoArray, 0, this.length);
            this.connections = connectionInfoArray;
        }
        this.connections[this.length++] = connectionInfo;
    }

    boolean remove(ConnectionInfo connectionInfo) {
        return this.remove(this.indexOf(connectionInfo));
    }

    boolean remove(int n) {
        if (n >= 0 && n < this.length) {
            if (n < this.length - 1) {
                System.arraycopy(this.connections, n + 1, this.connections, n, this.length - n - 1);
            }
            --this.length;
            if (this.config.getMaxCount() == 0 && this.connections.length > 10 && this.length + this.length < this.connections.length) {
                ConnectionInfo[] connectionInfoArray = new ConnectionInfo[this.length < 10 ? 11 : this.length + 1];
                System.arraycopy(this.connections, 0, connectionInfoArray, 0, this.length);
                this.connections = connectionInfoArray;
            }
            return true;
        }
        return false;
    }

    int indexOf(ConnectionInfo connectionInfo) {
        int n = this.length;
        while (--n >= 0) {
            if (this.connections[n] != connectionInfo) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws SQLException {
        boolean bl = false;
        int n = this.config.getIdleExpire();
        int n2 = this.config.getExpire();
        SQLException sQLException = null;
        int n3 = this.length;
        while (--n3 >= 0) {
            ConnectionInfo connectionInfo;
            ConnectionInfo connectionInfo2 = this.connections[n3];
            if (connectionInfo2.getIdleTime() >= n) {
                if (!this.remove(n3)) continue;
                bl = true;
                connectionInfo = connectionInfo2;
                synchronized (connectionInfo) {
                    if (connectionInfo2.getLockNumber() > 0) {
                        if (add.isDebugEnabled()) {
                            add.debug("", new Exception("release Connection [" + connectionInfo2.hashCode() + "]  lock[" + connectionInfo2.getLockNumber() + "] continue"));
                        }
                        continue;
                    }
                    try {
                        connectionInfo2.disconnect();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                    }
                    continue;
                }
            }
            if (n2 == 0 || connectionInfo2.getStartTime() < n2 || !this.remove(n3)) continue;
            bl = true;
            connectionInfo = connectionInfo2;
            synchronized (connectionInfo) {
                if (connectionInfo2.getLockNumber() > 0) {
                    if (add.isDebugEnabled()) {
                        add.debug("", new Exception("release Connection [" + connectionInfo2.hashCode() + "]  lock[" + connectionInfo2.getLockNumber() + "] continue"));
                    }
                    continue;
                }
                try {
                    connectionInfo2.disconnect();
                }
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                }
            }
        }
        if (bl) {
            this.notifyAll();
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public synchronized void dispose() throws SQLException {
        int n = this.config.getMaxCount();
        SQLException sQLException = null;
        int n2 = this.length;
        while (--n2 >= 0) {
            try {
                this.connections[n2].disconnect();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this.connections = new ConnectionInfo[n <= 0 ? 10 : n];
        this.length = 0;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void dump(Writer writer) throws IOException {
        writer.write("\tURL: " + this.config.getURL() + "\r\n");
        int n = this.length;
        while (--n >= 0) {
            this.connections[n].dump(writer);
        }
        writer.write("\tend URL: " + this.config.getURL() + "\r\n");
    }

    JetUJdbcSupportInfo getSupportInfo() {
        return this.SEDU;
    }
}

