/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.version2;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import jet.ReportEnv;
import jet.log.JRLogger;
import toolkit.config.ConnectionPoolConfig;
import toolkit.config.PoolConfig;
import toolkit.db.version2.BeaDataSource;
import toolkit.db.version2.JdbcDataSource;

public class PoolService {
    ConnectionPoolConfig configs;
    JdbcDataSource jdbcDataSource;
    BeaDataSource beaDataSource;
    public static final String BEAURLPREFIX = "jdbc:weblogic:jinfonet:";
    public static final String BEAPOOLDRIVER = "weblogic.jinfonet.pool.Driver";
    private static JRLogger SEDU = JRLogger.getLogger(PoolService.class.getName());

    public PoolService() {
        String string = ReportEnv.binPath + "ConnectionPoolConfig.properties";
        this.configs = new ConnectionPoolConfig();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            this.configs.createConfig(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jdbcDataSource = new JdbcDataSource(this);
        this.jdbcDataSource.start();
    }

    public Connection getConnection(String string, String string2, String string3, String string4, String string5) throws SQLException, ClassNotFoundException {
        if (SEDU.isDebugEnabled()) {
            SEDU.debug("get connection\ndriver name: " + string + ", url: " + string2 + ", use name: " + string3);
        }
        if (this.SEDU(string)) {
            if (this.beaDataSource == null) {
                try {
                    this.beaDataSource = new BeaDataSource();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (SEDU.isErrorEnabled()) {
                        SEDU.error("Connection Pool message\n", noClassDefFoundError);
                    }
                    throw new SQLException("can't get connection: please add weblogic.jar to classpath");
                }
            }
            return this.beaDataSource.getConnection(string2, string3, string4);
        }
        return this.jdbcDataSource.getConnection(string, string2, string3, string4, string5);
    }

    public void disconnect(String string, String string2) throws SQLException {
        this.jdbcDataSource.disconnect(string, string2);
    }

    public void disconnect(String string) throws SQLException {
        this.jdbcDataSource.disconnect(string);
    }

    public void disconnect(int n) throws SQLException {
        this.jdbcDataSource.disconnect(n);
    }

    public ConnectionPoolConfig getConnectionPoolConfig() {
        return this.configs;
    }

    public PoolConfig getPoolConfig(String string) {
        return this.configs.getConfig(string);
    }

    public JdbcDataSource getJdbcDataSource() {
        return this.jdbcDataSource;
    }

    public BeaDataSource getBeaDataSource() {
        return this.beaDataSource;
    }

    public void dump(Writer writer) throws IOException {
        writer.write("dump connection pool:\r\n");
        this.jdbcDataSource.dump(writer);
        writer.write("end dump\r\n");
    }

    private boolean SEDU(String string) {
        return string == null ? false : string.equals(BEAPOOLDRIVER);
    }

    public void dispose() {
        try {
            this.jdbcDataSource.dispose();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void release() {
        try {
            this.jdbcDataSource.release();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void destroy() {
        this.dispose();
        this.configs.dispose();
    }
}

