/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;

public class RandomAccessStream {
    public static final byte FALSE = 0;
    public static final byte TRUE = 1;
    public static final int BYTE = 1;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 8;
    public static final int DATE = 8;
    public static final int TIME = 8;
    public static final int TIMESTAMP = 12;
    static final Hashtable files = new Hashtable();
    byte[] buffer;
    int pointer;

    public static int getLength(byte[] byArray) {
        return byArray == null ? 4 : 4 + byArray.length;
    }

    public static int getLength(char[] cArray) {
        return cArray == null ? 4 : 4 + cArray.length * 2;
    }

    public static int getLength(String string) {
        return string == null ? 4 : 4 + string.length() * 2;
    }

    public static int getLength(String[] stringArray) {
        int n = 4;
        if (stringArray != null) {
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                n += RandomAccessStream.getLength(stringArray[n2]);
            }
        }
        return n;
    }

    public static int getLength(String[][] stringArray) {
        int n = 4;
        if (stringArray != null) {
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                n += RandomAccessStream.getLength(stringArray[n2]);
            }
        }
        return n;
    }

    public static int getLength(boolean[] blArray) {
        return blArray == null ? 4 : 4 + blArray.length;
    }

    public static int getLength(int[] nArray) {
        return nArray == null ? 4 : 4 + nArray.length * 4;
    }

    public static int getLength(float[] fArray2) {
        return fArray2 == null ? 4 : 4 + fArray2.length * 4;
    }

    public static int getLength(double[] dArray) {
        return dArray == null ? 4 : 4 + dArray.length * 8;
    }

    public static synchronized RandomAccessFile createTempFile(String string, String string2, String string3, String string4) throws IOException {
        RandomAccessFile randomAccessFile;
        File file = new File(string);
        if (file.isDirectory()) {
            if (string2 == null) {
                string2 = "";
            }
            string3 = string3 == null ? "" : "." + string3;
            String string5 = string2 + string3;
            file = new File(string, string5);
            while (file.exists()) {
                string5 = string2 + System.currentTimeMillis() + string3;
                file = new File(string, string5);
            }
            randomAccessFile = new RandomAccessFile(file, string4);
            files.put(randomAccessFile, file.getPath());
        } else {
            randomAccessFile = null;
        }
        return randomAccessFile;
    }

    public static synchronized boolean releaseTempFile(RandomAccessFile randomAccessFile) throws IOException {
        String string = (String)files.get(randomAccessFile);
        if (string != null) {
            randomAccessFile.close();
            new File(string).delete();
            return true;
        }
        return false;
    }

    public static synchronized void releaseTempFiles() {
        Enumeration enumeration = files.elements();
        while (enumeration.hasMoreElements()) {
            new File((String)enumeration.nextElement()).delete();
        }
    }

    public static synchronized boolean isTempFile(RandomAccessFile randomAccessFile) {
        return files.get(randomAccessFile) != null;
    }

    public RandomAccessStream() {
    }

    public RandomAccessStream(int n) {
        this.open(n);
    }

    public void open(int n) {
        this.buffer = new byte[n];
        this.pointer = 0;
    }

    public byte[] close() {
        byte[] byArray = this.buffer;
        this.buffer = null;
        this.pointer = 0;
        return byArray;
    }

    public int read(int n, RandomAccessFile randomAccessFile) throws IOException {
        this.update(n);
        return randomAccessFile.read(this.buffer, this.pointer, n);
    }

    public int write(int n, RandomAccessFile randomAccessFile) throws IOException {
        if (this.buffer != null && this.pointer > 0) {
            if (n > this.pointer) {
                n = this.pointer;
            }
            randomAccessFile.write(this.buffer, 0, n);
            return n;
        }
        return 0;
    }

    public int read(int n, InputStream inputStream) throws IOException {
        this.update(n);
        return inputStream.read(this.buffer, this.pointer, n);
    }

    public int write(int n, OutputStream outputStream) throws IOException {
        if (this.buffer != null && this.pointer > 0) {
            if (n > this.pointer) {
                n = this.pointer;
            }
            outputStream.write(this.buffer, 0, n);
            return n;
        }
        return 0;
    }

    public int read(int n, DataInput dataInput) throws IOException {
        this.update(n);
        dataInput.readFully(this.buffer, this.pointer, n);
        return n;
    }

    public int write(int n, DataOutput dataOutput) throws IOException {
        if (this.buffer != null && this.pointer > 0) {
            if (n > this.pointer) {
                n = this.pointer;
            }
            dataOutput.write(this.buffer, 0, n);
            return n;
        }
        return 0;
    }

    public final int getLength() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final int seek(int n) {
        this.pointer = n < 0 || this.buffer == null ? 0 : (n > this.buffer.length ? this.buffer.length : n);
        return this.pointer;
    }

    public final int skip(int n) {
        return this.seek(this.pointer + n) - this.pointer;
    }

    public final byte readByte() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length) {
            throw new IOException("End of stream");
        }
        return this.buffer[this.pointer++];
    }

    public final boolean readBoolean() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length) {
            throw new IOException("End of stream");
        }
        return this.buffer[this.pointer++] == 1;
    }

    public final short readShort() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 1) {
            throw new IOException("End of stream");
        }
        return (short)((((short)this.buffer[this.pointer++] & 0xFF) << 8) + ((short)this.buffer[this.pointer++] & 0xFF));
    }

    public final int readInt() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 3) {
            throw new IOException("End of stream");
        }
        return ((this.buffer[this.pointer++] & 0xFF) << 24) + ((this.buffer[this.pointer++] & 0xFF) << 16) + ((this.buffer[this.pointer++] & 0xFF) << 8) + (this.buffer[this.pointer++] & 0xFF);
    }

    public final long readLong() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 7) {
            throw new IOException("End of stream");
        }
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 3) {
            throw new IOException("End of stream");
        }
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 7) {
            throw new IOException("End of stream");
        }
        return Double.longBitsToDouble(this.readLong());
    }

    public final byte[] readBytes() throws IOException {
        byte[] byArray;
        int n = this.readInt();
        if (n < 0) {
            byArray = null;
        } else {
            if (this.buffer.length - this.pointer < n) {
                throw new IOException("End of stream");
            }
            byArray = new byte[n];
            System.arraycopy(this.buffer, this.pointer, byArray, 0, n);
            this.pointer += n;
        }
        return byArray;
    }

    public final byte[] readBytes(int n) throws IOException {
        int n2;
        byte[] byArray = this.readBytes();
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (n2 < n) {
            this.pointer += n - n2;
        }
        return byArray;
    }

    public final char readChar() throws IOException {
        if (this.buffer == null || this.pointer >= this.buffer.length - 1) {
            throw new IOException("End of stream");
        }
        return (char)((((short)this.buffer[this.pointer++] & 0xFF) << 8) + ((short)this.buffer[this.pointer++] & 0xFF));
    }

    public final char[] readChars() throws IOException {
        char[] cArray;
        byte[] byArray = this.readBytes();
        if (byArray == null) {
            cArray = null;
        } else {
            if (byArray.length % 2 != 0) {
                throw new IOException("Can not read a string");
            }
            cArray = new char[byArray.length / 2];
            for (int i = 0; i < cArray.length; ++i) {
                int n = i + i;
                cArray[i] = (char)((((short)byArray[n] & 0xFF) << 8) + ((short)byArray[n + 1] & 0xFF));
            }
        }
        return cArray;
    }

    public final char[] readChars(int n) throws IOException {
        int n2;
        char[] cArray = this.readChars();
        int n3 = n2 = cArray == null ? 0 : cArray.length;
        if (n2 < n) {
            this.pointer += (n - n2) * 2;
        }
        return cArray;
    }

    public final String readString() throws IOException {
        char[] cArray = this.readChars();
        return cArray == null ? null : new String(cArray);
    }

    public final Date readDate() throws IOException {
        long l = this.readLong();
        return l == Long.MIN_VALUE ? null : new Date(l);
    }

    public final Time readTime() throws IOException {
        long l = this.readLong();
        return l == Long.MIN_VALUE ? null : new Time(l);
    }

    public final Timestamp readTimestamp() throws IOException {
        Timestamp timestamp;
        long l = this.readLong();
        int n = this.readInt();
        if (l == Long.MIN_VALUE && n == Integer.MIN_VALUE) {
            timestamp = null;
        } else {
            timestamp = new Timestamp(l);
            timestamp.setNanos(n);
        }
        return timestamp;
    }

    public final BigDecimal readBigDecimal(int n, int n2, int n3) throws IOException {
        byte[] byArray = this.readBytes(n);
        return byArray == null ? null : new BigDecimal(new String(byArray)).setScale(n2, n3);
    }

    public final boolean[] readBooleans() throws IOException {
        boolean[] blArray;
        int n = this.readInt();
        if (n < 0) {
            blArray = null;
        } else {
            blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = this.readBoolean();
            }
        }
        return blArray;
    }

    public final int[] readInts() throws IOException {
        int[] nArray;
        int n = this.readInt();
        if (n < 0) {
            nArray = null;
        } else {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.readInt();
            }
        }
        return nArray;
    }

    public final float[] readFloats() throws IOException {
        float[] fArray2;
        int n = this.readInt();
        if (n < 0) {
            fArray2 = null;
        } else {
            fArray2 = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray2[i] = this.readFloat();
            }
        }
        return fArray2;
    }

    public final double[] readDoubles() throws IOException {
        double[] dArray;
        int n = this.readInt();
        if (n < 0) {
            dArray = null;
        } else {
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.readDouble();
            }
        }
        return dArray;
    }

    public final String[] readStrings() throws IOException {
        String[] stringArray;
        int n = this.readInt();
        if (n < 0) {
            stringArray = null;
        } else {
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readString();
            }
        }
        return stringArray;
    }

    public final void writeByte(byte by) {
        this.update(1);
        this.buffer[this.pointer++] = by;
    }

    public final void writeBoolean(boolean bl) {
        this.update(1);
        this.buffer[this.pointer++] = bl ? (byte)1 : 0;
    }

    public final void writeShort(short s) {
        this.update(2);
        this.buffer[this.pointer++] = (byte)(s >>> 8 & 0xFF);
        this.buffer[this.pointer++] = (byte)(s >>> 0 & 0xFF);
    }

    public final void writeInt(int n) {
        this.update(4);
        this.buffer[this.pointer++] = (byte)(n >>> 24 & 0xFF);
        this.buffer[this.pointer++] = (byte)(n >>> 16 & 0xFF);
        this.buffer[this.pointer++] = (byte)(n >>> 8 & 0xFF);
        this.buffer[this.pointer++] = (byte)(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) {
        this.update(8);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 56) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 48) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 40) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 32) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 24) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 16) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 8) & 0xFF);
        this.buffer[this.pointer++] = (byte)((int)(l >>> 0) & 0xFF);
    }

    public final void writeFloat(float f) {
        this.update(4);
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) {
        this.update(8);
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeByteArray(byte[] byArray) {
        if (byArray != null) {
            this.update(byArray.length);
            System.arraycopy(byArray, 0, this.buffer, this.pointer, byArray.length);
            this.pointer += byArray.length;
        }
    }

    public final byte[] readByteArray(int n) throws IOException {
        if (this.buffer.length - this.pointer < n) {
            throw new IOException("End of stream");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, this.pointer, byArray, 0, n);
        this.pointer += n;
        return byArray;
    }

    public final void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, byArray == null ? 0 : byArray.length);
    }

    public final void writeBytes(byte[] byArray, int n) {
        this.update(n + 4);
        if (byArray == null) {
            this.writeInt(-1);
        } else {
            int n2 = byArray.length < n ? byArray.length : n;
            this.writeInt(n2);
            System.arraycopy(byArray, 0, this.buffer, this.pointer, n2);
        }
        this.pointer += n;
    }

    public final void writeChar(char c) {
        this.update(2);
        this.buffer[this.pointer++] = (byte)(c >>> 8 & 0xFF);
        this.buffer[this.pointer++] = (byte)(c >>> 0 & 0xFF);
    }

    public final void writeChars(char[] cArray) {
        this.writeChars(cArray, cArray == null ? 0 : cArray.length);
    }

    public final void writeChars(char[] cArray, int n) {
        byte[] byArray;
        if (cArray == null) {
            byArray = null;
        } else {
            int n2 = cArray.length < n ? cArray.length : n;
            byArray = new byte[n2 + n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = i + i;
                byArray[n3] = (byte)(cArray[i] >>> 8 & 0xFF);
                byArray[n3 + 1] = (byte)(cArray[i] >>> 0 & 0xFF);
            }
        }
        this.writeBytes(byArray, n + n);
    }

    public final void writeString(String string) {
        this.writeString(string, string == null ? 0 : string.length());
    }

    public final void writeString(String string, int n) {
        char[] cArray = string == null ? null : string.toCharArray();
        this.writeChars(cArray, n);
    }

    public final void writeDate(Date date) {
        long l = date == null ? Long.MIN_VALUE : date.getTime();
        this.writeLong(l);
    }

    public final void writeTime(Time time2) throws IOException {
        long l = time2 == null ? Long.MIN_VALUE : time2.getTime();
        this.writeLong(l);
    }

    public final void writeTimestamp(Timestamp timestamp) {
        int n;
        long l;
        if (timestamp == null) {
            l = Long.MIN_VALUE;
            n = Integer.MIN_VALUE;
        } else {
            l = timestamp.getTime();
            n = timestamp.getNanos();
        }
        this.writeLong(l);
        this.writeInt(n);
    }

    public final void writeBigDecimal(BigDecimal bigDecimal, int n) {
        this.writeBytes(bigDecimal == null ? null : bigDecimal.toString().getBytes(), n);
    }

    public final void writeBooleans(boolean[] blArray) {
        int n = blArray == null ? -1 : blArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeBoolean(blArray[i]);
        }
    }

    public final void writeInts(int[] nArray) {
        int n = nArray == null ? -1 : nArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeInt(nArray[i]);
        }
    }

    public final void writeFloats(float[] fArray2) {
        int n = fArray2 == null ? -1 : fArray2.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeFloat(fArray2[i]);
        }
    }

    public final void writeDoubles(double[] dArray) {
        int n = dArray == null ? -1 : dArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeDouble(dArray[i]);
        }
    }

    public final void writeStrings(String[] stringArray) {
        int n = stringArray == null ? -1 : stringArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeString(stringArray[i]);
        }
    }

    public final void writeStringss(String[][] stringArray) {
        int n = stringArray == null ? -1 : stringArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeStrings(stringArray[i]);
        }
    }

    public final String[][] readStringss() throws IOException {
        String[][] stringArray;
        int n = this.readInt();
        if (n < 0) {
            stringArray = null;
        } else {
            stringArray = new String[n][];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readStrings();
            }
        }
        return stringArray;
    }

    void update(int n) {
        n += this.pointer;
        if (this.buffer == null) {
            this.buffer = new byte[n];
        } else if (this.buffer.length < n) {
            byte[] byArray = new byte[n];
            if (this.pointer != 0) {
                System.arraycopy(this.buffer, 0, byArray, 0, this.pointer);
            }
            this.buffer = byArray;
        }
    }
}

