/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

public class RenderToolkit {
    public static final short NONE_STYLE = 0;
    public static final short LINE_SOLID = 1;
    public static final short LINE_DASHED = 2;
    public static final short LINE_DOTTED = 3;
    public static final short LINE_DASHDOT = 4;
    public static final short LINE_DOUBLE = 5;
    public static final short PATTERN_PERCENT50 = 1;
    public static final short PATTERN_HORIZONTAL = 2;
    public static final short PATTERN_VERTICAL = 3;
    public static final short PATTERN_HATCH = 4;
    public static final short PATTERN_SLASH = 5;
    private static final int F = 1;
    private static final int KEY_ANTIALIASING = 2;
    private static final int SEDU = 3;
    private static final int VALUE_ANTIALIAS_ON = new Color(0, 128, 255).getRGB();

    public static void drawShadow(Graphics graphics, Dimension dimension, int n, int n2) {
        graphics.setColor(new Color(n));
        graphics.fillRect(n2, dimension.height, dimension.width - 1, n2);
        graphics.fillRect(dimension.width, n2, n2, dimension.height - 1);
    }

    public static void setBackground(JComponent jComponent, int n) {
        Color color = RenderToolkit.determineColor(n);
        jComponent.setBackground(color);
        jComponent.setOpaque(color != null);
    }

    public static Color determineColor(int n) {
        Color color = null;
        if ((n & 0xFF000000) != -16777216) {
            color = new Color(n);
        }
        return color;
    }

    public static void drawGrid(Graphics graphics, int n, Dimension dimension) {
        if (dimension.width > 0 && dimension.height > 0) {
            int n2;
            int[] nArray = new int[dimension.width * dimension.height];
            for (n2 = n - 1; n2 < dimension.width; n2 += n) {
                nArray[n2] = graphics.getColor().getRGB();
            }
            for (n2 = n - 1; n2 < dimension.height; n2 += n) {
                System.arraycopy(nArray, 0, nArray, n2 * dimension.width, dimension.width);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(dimension.width, dimension.height, nArray, 0, dimension.width));
            graphics.drawImage(image, 0, 0, dimension.width, dimension.height, null);
        }
    }

    public static void drawLine(Graphics graphics, float f, float f2, float f3, float f4, Color color, float f5, int n) {
        if (color != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(color);
            graphics2D.setStroke(RenderToolkit.getStroke(n, f5));
            graphics2D.draw(new Line2D.Float(f, f2, f3, f4));
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setStroke(stroke);
        }
    }

    public static void drawBox(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Color color3 = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f + f6, f2 + f6, f3 - f6 * 2.0f, f4 - f6 * 2.0f);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(color2);
            graphics2D.setStroke(RenderToolkit.getStroke(n, f5));
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setColor(color3);
    }

    public static void drawPattern(Graphics graphics, Rectangle rectangle, Color color, int n) {
        if (color != null) {
            graphics.setColor(color);
            switch (n) {
                case 1: {
                    RenderToolkit.F(graphics, rectangle, 2);
                    break;
                }
                case 5: {
                    RenderToolkit.F(graphics, rectangle, 6);
                    break;
                }
                case 2: {
                    RenderToolkit.KEY_ANTIALIASING(graphics, rectangle, 6, 1);
                    break;
                }
                case 3: {
                    RenderToolkit.KEY_ANTIALIASING(graphics, rectangle, 6, 2);
                    break;
                }
                case 4: {
                    RenderToolkit.KEY_ANTIALIASING(graphics, rectangle, 6, 3);
                }
            }
        }
    }

    private static void F(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        int n3;
        int n4 = n3 = rectangle.x;
        int n5 = n2 = rectangle.y;
        int n6 = rectangle.width + n3;
        int n7 = rectangle.height + n2;
        graphics.drawLine(n3, n2, n3, n2);
        if (rectangle.width > rectangle.height) {
            while (n2 + n < n7) {
                graphics.drawLine(n3 + n, n5, n4, n2 + n);
                n3 += n;
                n2 += n;
            }
            n4 = n2 + n - n7 + n4;
            while (n3 + n < n6) {
                graphics.drawLine(n3 + n, n5, n4, n7);
                n3 += n;
                n4 += n;
            }
            for (n5 = n3 + n - n6 + n5; n5 <= n7; n5 += n) {
                graphics.drawLine(n6, n5, n4, n7);
                n4 += n;
            }
        } else {
            while (n3 + n < n6) {
                graphics.drawLine(n3 + n, n5, n4, n2 + n);
                n3 += n;
                n2 += n;
            }
            n5 = n3 + n - n6 + n5;
            while (n2 + n < n7) {
                graphics.drawLine(n6, n5, n4, n2 + n);
                n2 += n;
                n5 += n;
            }
            n4 = n2 + n - n7 + n4;
            while (n4 <= n6) {
                graphics.drawLine(n6, n5, n4, n7);
                n4 += n;
                n5 += n;
            }
        }
    }

    private static void KEY_ANTIALIASING(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3;
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        if ((n2 & 1) != 0) {
            for (n3 = n6 + n - 1; n3 < n7 + 1; n3 += n) {
                graphics.drawLine(n4, n3, n5, n3);
            }
        }
        if ((n2 & 2) != 0) {
            for (n3 = n4 + n - 1; n3 < n5 + 1; n3 += n) {
                graphics.drawLine(n3, n6, n3, n7);
            }
        }
    }

    public static void drawOval(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        Ellipse2D.Float float_ = new Ellipse2D.Float(f + f6, f2 + f6, f3 - f6 * 2.0f, f4 - f6 * 2.0f);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(color2);
            graphics2D.setStroke(RenderToolkit.getStroke(n, f5));
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public static void drawArc(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n, float f6, float f7) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f8 = f5 / 2.0f;
        Arc2D.Float float_ = new Arc2D.Float(f + f8, f2 + f8, f3 - f8 * 2.0f, f4 - f8 * 2.0f, f6, f7, 0);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(color2);
            graphics2D.setStroke(RenderToolkit.getStroke(n, f5));
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public static void drawRoundBox(Graphics graphics, float f, float f2, float f3, float f4, Color color, Color color2, float f5, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f6 = f5 / 2.0f;
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f + f6, f2 + f6, f3 - f6 * 2.0f, f4 - f6 * 2.0f, n2, n2);
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fill(float_);
        }
        if (n != 0 && color2 != null && !color2.equals(color)) {
            float_.width -= 1.0f;
            float_.height -= 1.0f;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(color2);
            graphics2D.setStroke(RenderToolkit.getStroke(n, f5));
            graphics2D.draw(float_);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public static BasicStroke getStroke(int n, float f) {
        BasicStroke basicStroke = null;
        switch (n) {
            case 1: {
                basicStroke = new BasicStroke(f, 0, 0);
                break;
            }
            case 2: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
                break;
            }
            case 3: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{f, 6.0f}, 0.0f);
                break;
            }
            case 4: {
                basicStroke = new BasicStroke(f, 0, 0, 10.0f, new float[]{10.0f, 5.0f, f, 5.0f}, 0.0f);
                break;
            }
            case 5: {
                basicStroke = new BasicStroke(f * 2.0f, 0, 0);
            }
        }
        return basicStroke;
    }
}

