// Copyright (c) 2001, Jinfonet Software, Inc.  All Rights Reserved.

var same;
var node;

function enableNode(id, enable)
{
	var el = eval('document.all.' + id), tn, child, children;

	if ( el != null )
	{
		tn = null;

		if ( el.length == null )
		{
			if ( el.className == "treenode" )
			{
				tn = el;
			}
		}
		else
		{
			for ( var i = el.length; --i >= 0; )
			{
				child = el[i];

				if ( child.className == "treenode" )
				{
					tn = child;
					break;
				}
			}
		}
		if ( tn != null )
		{
			children = tn.children;

			for ( var i = children.length; --i >= 0; )
			{
				child = children[i];

				if ( child.className == "nodelbl" )
				{
					child.style.filter = enable ? "none" : "DropShadow(Color=buttonhighlight, OffX=1, OffY=1)";
				}
				else if ( child.className == "pantograph" || child.className == "nodeicon" )
				{
					child.style.filter = enable ? "none" : "Gray() DropShadow(Color=buttonhighlight, OffX=1, OffY=1)";
				}
			}
		}
	}
}

function nodeState()
{
	var srcEl = window.event.srcElement;

	if ( srcEl.style.filter == "none" )
	{
		if ( srcEl.src.lastIndexOf("collapsed_nt.gif") != -1 )
		{
			expendNode(srcEl.parentElement);
		}
		else if ( srcEl.src.lastIndexOf("expanded_nt.gif") != -1 )
		{
			collapseNode(srcEl.parentElement);
		}
	}

	return false;
}

function nodeDown()
{
	if ( !disable && event.button == 1 )
	{
		var srcEl = window.event.srcElement, tn = srcEl.parentElement;

		same = tn == node;

		if ( !same )
		{
			makeNodeSelect(tn, false);
		}
	}

	return false;
}

function nodeDblClick()
{
	if ( !disable )
	{
		var srcEl = window.event.srcElement;

		if ( srcEl.style.filter == "none" )
		{
			var parent, child, children;

			parent = srcEl.parentElement;
			children = parent.children;
			child = children[children.length - 1];

			if ( child.className == "treesheet" )
			{
				if ( child.style.visibility == "inherit" )
				{
					collapseNode(parent);
				}
				else if ( child.style.visibility == "hidden" )
				{
					expendNode(parent);
				}
				makeNodeSelect(parent, false);
			}
		}
	}

	return false;
}

function nodeExec(exp, top, target)
{
	if ( !disable && same )
	{
		exec(exp, top, target);
	}
}

function nodeDblExec(exp, top, target)
{
	if ( !disable )
	{
		var srcEl = window.event.srcElement;

		if ( srcEl.style.filter == "none" )
		{
			exec(exp, top, target);
		}
	}
}

function makeNodeSelect(nodeEl, scroll)
{
	var children = nodeEl.children, child;

	for ( var i = children.length; --i >= 0; )
	{
		child = children[i];

		if ( child.className == "nodelbl" && child.style.filter == "none" )
		{
			if ( node != null )
			{
				makeNodeUnselect(node);
			}
			makeSelect(child);
			node = nodeEl;

			if ( scroll )
			{
				visibleNode(nodeEl);
			}

			break;
		}
	}
}

function visibleNode(nodeEl)
{
	var x, y, width, height, sx, sy;
	var parent;

	x = parseInt(nodeEl.style.left);
	y = parseInt(nodeEl.style.top);
	width = parseInt(nodeEl.style.width);
	height = parseInt(nodeEl.style.height);
	parent = nodeEl.parentElement;

	while ( parent != document.body )
	{
		x += parseInt(parent.style.left);
		y += parseInt(parent.style.top);
		parent = parent.parentElement;
	}

	width += x;
	height += y;

	sx = document.body.scrollLeft;
	sy = document.body.scrollTop;

/*	if ( width > cw )
	{
		sx = cw - width;
		if ( sx < 0 )
		{
			sx = 0;
		}
	}
	if ( height > ch )
	{
		sy = ch -height;
		if ( sy < 0 )
		{
			sy = 0;
		}
	}*/
	if ( x < 0 )
	{
		sx = 0;
	}
	if ( y < 0 )
	{
		sy = 0;
	}
	if ( y > 64 )
	{
		sy = y;
	}
	window.scroll(sx, sy);
}

function makeNodeUnselect(nodeEl)
{
	var children = nodeEl.children, child;

	for ( var i = children.length; --i >= 0; )
	{
		child = children[i];

		if ( child.className == "nodelbl" && child.style.filter == "none" )
		{
			makeUnselect(child);
			break;
		}
	}
}

function expendNode(nodeEl)
{
	var children = nodeEl.children, child;

	child = children[0];

	if ( child.className == "pantograph" )
	{
		child.src = "expanded_nt.gif";
	}

	child = children[children.length - 1];

	if ( child.className == "treesheet" )
	{
		child.style.visibility = "inherit";
		updateTreeSize(nodeEl, parseInt(child.style.height));
	}
}

function collapseNode(nodeEl)
{
	var children = nodeEl.children, child;

	child = children[0];

	if ( child.className == "pantograph" )
	{
		child.src = "collapsed_nt.gif";
	}

	child = children[children.length - 1];

	if ( child.className == "treesheet" )
	{
		child.style.visibility = "hidden";
		updateTreeSize(nodeEl, -parseInt(child.style.height));
	}
}

function updateTreeSize(nodeEl, dh)
{
	var parent, children, child;

	do
	{
		nodeEl.style.height = parseInt(nodeEl.style.height) + dh;
		parent = nodeEl.parentElement;
		children = parent.children;

		for ( var i = children.length; --i >= 0; )
		{
			child = children[i];

			if ( child != nodeEl )
			{
				child.style.top = parseInt(child.style.top) + dh;
			}
			else
			{
				break;
			}
		}
		nodeEl = parent;

	} while ( parent.className != "tree" );

	nodeEl.style.height = parseInt(nodeEl.style.height) + dh;
}

function initTree()
{
	var activated = eval('document.all.activated');

	if ( activated != null )
	{
		makeNodeSelect(activated.parentElement, true);
	}
}

function setActivated(id)
{
	var src = eval('document.all.' + id);

	if ( src != null && src != node )
	{
		makeNodeSelect(src, true);
	}
}

document.write("<style>");
document.write(".tree {position: absolute;}");
document.write(".treenode {position: absolute; left: 0px;}");
document.write(".treesheet {position: absolute;}");
document.write(".nodelbl {position: absolute; cursor: default;}");
document.write(".nodeicon {position: absolute;}");
document.write(".pantograph {position: absolute;}");
document.write("</style>");
