/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.entity;

import com.ericsson.cms.categorymgmt.entity.CatCategoryMetadata;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="CAT_CATEGORY")
public class CatCategory
implements Serializable,
Comparable<CatCategory> {
    private static final long serialVersionUID = 1L;
    public static final String PATH_DELIMITER = "/";
    @Id
    @SequenceGenerator(name="CAT_CATEGORY_ID_GENERATOR", sequenceName="CAT_CATEGORY_SEQ")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CAT_CATEGORY_ID_GENERATOR")
    @Column(unique=true, nullable=false, precision=22)
    private Long id;
    @Column(name="ASSOCIATED_CATEGORY_PACKAGE")
    private Long associatedCategoryPackage;
    @Column(nullable=false, length=1024)
    @OrderBy(value="NAME ASC")
    private String name;
    @Column(nullable=false, name="PARENT_CATEGORY_ID", updatable=false, insertable=false)
    private Long parentId;
    @ManyToOne
    @JoinColumn(name="PARENT_CATEGORY_ID")
    private CatCategory parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    @OrderBy(value="name")
    private Set<CatCategory> children = new HashSet<CatCategory>();
    @OneToMany(mappedBy="catCategory", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<CatCategoryMetadata> catCategoryMetadata;
    @Column(name="INTERNAL_VERSION")
    private Long internalVersion;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getAssociatedCategoryPackage() {
        return this.associatedCategoryPackage;
    }

    public void setAssociatedCategoryPackage(Long associatedCategoryPackage) {
        this.associatedCategoryPackage = associatedCategoryPackage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatCategory getParent() {
        return this.parent;
    }

    public void setParent(CatCategory catCategory) {
        this.parent = catCategory;
    }

    public Set<CatCategory> getChildren() {
        return this.children;
    }

    public void setChildren(Set<CatCategory> children) {
        this.children = children;
    }

    public Set<CatCategoryMetadata> getCatCategoryMetadata() {
        return this.catCategoryMetadata;
    }

    public void setCatCategoryMetadata(Set<CatCategoryMetadata> catCategoryMetadata) {
        this.catCategoryMetadata = catCategoryMetadata;
    }

    public Long getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(Long internalVersion) {
        this.internalVersion = internalVersion;
    }

    @Transient
    public String getPath() {
        String path = this.getName();
        for (CatCategory catParent = this.getParent(); catParent != null && catParent.getId() != null && catParent.getId() != 0L; catParent = catParent.getParent()) {
            path = catParent.getName() + PATH_DELIMITER + path;
        }
        return path;
    }

    @Transient
    public String toString() {
        return this.parentId + ":" + this.id + ":" + this.name + ":" + this.associatedCategoryPackage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatCategory other = (CatCategory)obj;
        if (this.parent == null && other.getParent() != null) {
            return false;
        }
        if (this.parent != null && other.getParent() == null) {
            return false;
        }
        if (this.parent != other.getParent()) {
            return false;
        }
        if (this.name == null && other.getName() != null) {
            return false;
        }
        if (this.name != null && other.getName() == null) {
            return false;
        }
        return this.name == null || this.name.equals(other.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.id != null && this.id == 0L) {
            return result;
        }
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    @Override
    public int compareTo(CatCategory other) {
        if (this.equals(other)) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        if (this.getParent() == null && other.getParent() != null) {
            return -1;
        }
        if (this.getParent() != null && this.getParent().compareTo(other.getParent()) != 0) {
            return this.getParent().compareTo(other.getParent());
        }
        if (this.getName() == null && other.getName() != null) {
            return -1;
        }
        if (this.getName() != null && this.getName().compareTo(other.getName()) != 0) {
            return this.getName().compareTo(other.getName());
        }
        return 0;
    }
}

