/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.entity;

import com.ericsson.cms.categorymgmt.entity.CatCategory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CAT_CATEGORY_METADATA")
public class CatCategoryMetadata
implements Serializable,
Comparable<CatCategoryMetadata> {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="CAT_CATEGORY_METADATA_ID_GENERATOR", sequenceName="CAT_CATEGORY_METADATA_SEQ")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CAT_CATEGORY_METADATA_ID_GENERATOR")
    @Column(unique=true, nullable=false, precision=22)
    private long id;
    @Column(name="DATE_VALUE")
    private Date dateValue;
    @Column(name="FIELD_ID", nullable=false)
    private Long fieldId;
    @Column(name="IMAGE_VALUE")
    private byte[] imageValue;
    @Column(name="NUMBER_VALUE", precision=22)
    private BigDecimal numberValue;
    @Column(name="OCC_NUM", precision=22)
    private Long occNum;
    @Column(name="STRING_VALUE", length=1024)
    private String stringValue;
    @ManyToOne
    @JoinColumn(name="CATEGORY_ID", nullable=false)
    private CatCategory catCategory;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public byte[] getImageValue() {
        return this.imageValue;
    }

    public void setImageValue(byte[] imageValue) {
        this.imageValue = imageValue == null ? null : Arrays.copyOf(imageValue, imageValue.length);
    }

    public BigDecimal getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(BigDecimal numberValue) {
        this.numberValue = numberValue;
    }

    public Long getOccNum() {
        return this.occNum == null ? Long.valueOf(1L) : this.occNum;
    }

    public void setOccNum(Long occNum) {
        this.occNum = occNum;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public CatCategory getCatCategory() {
        return this.catCategory;
    }

    public void setCatCategory(CatCategory catCategory) {
        this.catCategory = catCategory;
    }

    public void setFieldId(Long fieldId) {
        this.fieldId = fieldId;
    }

    public Long getFieldId() {
        return this.fieldId;
    }

    public String toString() {
        return this.catCategory.getId() + ":" + this.id + ":" + this.fieldId + ":" + this.occNum + ":" + this.stringValue + ":" + this.numberValue + ":" + this.dateValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatCategoryMetadata other = (CatCategoryMetadata)obj;
        if (this.getCatCategory() == null && other.getCatCategory() != null) {
            return false;
        }
        if (this.getCatCategory() != null && other.getCatCategory() == null) {
            return false;
        }
        if (this.getCatCategory() != null && !this.getCatCategory().equals(other.getCatCategory())) {
            return false;
        }
        if (this.getFieldId() == null && other.getFieldId() != null) {
            return false;
        }
        if (this.getFieldId() != null && other.getFieldId() == null) {
            return false;
        }
        if (this.getFieldId() != null && !this.getFieldId().equals(other.getFieldId())) {
            return false;
        }
        if (this.getOccNum() == null && other.getOccNum() != null) {
            return false;
        }
        if (this.getOccNum() != null && other.getOccNum() == null) {
            return false;
        }
        return this.getOccNum() == null || this.getOccNum().equals(other.getOccNum());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catCategory == null ? 0 : this.catCategory.hashCode());
        result = 31 * result + (this.fieldId == null ? 0 : this.fieldId.hashCode());
        result = 31 * result + (this.occNum == null ? 0 : this.occNum.hashCode());
        return result;
    }

    @Override
    public int compareTo(CatCategoryMetadata other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.getCatCategory() != null && this.getCatCategory().compareTo(other.getCatCategory()) != 0) {
            return this.getCatCategory().compareTo(other.getCatCategory());
        }
        if (this.getFieldId() != null && this.getFieldId().compareTo(other.getFieldId()) != 0) {
            return this.getFieldId().compareTo(other.getFieldId());
        }
        if (this.getOccNum() != null && this.getOccNum().compareTo(other.getOccNum()) != 0) {
            return this.getOccNum().compareTo(other.getOccNum());
        }
        return 0;
    }

    public boolean hasValue() {
        boolean hasValue = false;
        hasValue = this.stringValue != null || this.numberValue != null || this.dateValue != null || this.imageValue != null;
        return hasValue;
    }
}

