/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.client;

import com.ericsson.cms.categorymgmt.client.CategoryHeaderPanel;
import com.ericsson.cms.categorymgmt.client.CategoryTreePanel;
import com.ericsson.cms.categorymgmt.client.CategoryViewPanel;
import com.ericsson.cms.categorymgmt.client.UIMetadataNodeParser;
import com.ericsson.cms.categorymgmt.client.exception.UICategoryManagerException;
import com.ericsson.cms.categorymgmt.client.i18n.CategoryConstants;
import com.ericsson.cms.categorymgmt.client.model.CategoryDateFormat;
import com.ericsson.cms.categorymgmt.client.model.UICategoryFieldSchema;
import com.ericsson.cms.categorymgmt.client.model.UICategoryFieldSchemaDefault;
import com.ericsson.cms.categorymgmt.client.model.UICategoryHyperlink;
import com.ericsson.cms.categorymgmt.client.model.UICategoryNode;
import com.ericsson.cms.categorymgmt.client.model.UIMetadataContent;
import com.ericsson.cms.categorymgmt.client.model.UIMetadataNode;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryFieldSchemaManagerService;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryFieldSchemaManagerServiceAsync;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryManagerService;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryManagerServiceAsync;
import com.ericsson.cms.categorymgmt.client.validation.CategoryValidationView;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryGeneralMessage;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryMessage;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryValidationException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateTimeInputWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryDetailPanel
extends Composite
implements IsSerializable {
    private static final String PATH_SEPARATOR = "/";
    private final NeptuneSecurity security;
    private final FlowPanel detailPanel;
    private final CategoryTreePanel treePanel;
    private final CategoryViewPanel parentPanel;
    private final CategoryHeaderPanel headerPanel;
    private final CategoryValidationView validationView;
    private ScrollContainer scrollContainer;
    private final FlowPanel buttonPanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final ICategoryFieldSchemaManagerServiceAsync metadataService = (ICategoryFieldSchemaManagerServiceAsync)GWT.create(ICategoryFieldSchemaManagerService.class);
    private final ICategoryManagerServiceAsync categoryManagerService = (ICategoryManagerServiceAsync)GWT.create(ICategoryManagerService.class);
    private final CategoryConstants constants = (CategoryConstants)GWT.create(CategoryConstants.class);
    private Map<Object, Widget> valueMap = null;
    private UICategoryNode m_categoryNode = null;
    private boolean newCategory = false;
    private final List<UIMetadataNode> invalidNodes = new ArrayList<UIMetadataNode>();
    private final ArgClickHandler argClickHandler = new ArgClickHandler();
    public static final int CATEGORY_NAME_MAX_LENGTH = 1024;
    public static final int TEXTBOX_DEFAULT_MAX_LENGTH = 1024;

    public CategoryDetailPanel(CategoryViewPanel parentPanel, CategoryTreePanel treePanel, CategoryHeaderPanel headerPanel, CategoryValidationView validationView, FlowPanel buttonPanel) {
        this.parentPanel = parentPanel;
        this.treePanel = treePanel;
        this.headerPanel = headerPanel;
        this.validationView = validationView;
        this.buttonPanel = buttonPanel;
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.detailPanel = new FlowPanel();
        this.detailPanel.addStyleName("zero-padding");
        this.detailPanel.setWidth("100%");
        this.initWidget((Widget)this.detailPanel);
    }

    private VerticalContainer showHyperlinks(List<UICategoryHyperlink> links, String categoryName, boolean newCategory) {
        VerticalContainer result = new VerticalContainer();
        HorizontalPanel hLinkPanel = new HorizontalPanel();
        for (UICategoryHyperlink link : links) {
            String categoryParent = " " + link.getName();
            String token = "CategoryManager.View.id=" + link.getId();
            hLinkPanel.add((Widget)new Hyperlink(categoryParent, token));
            hLinkPanel.add((Widget)new LabelWidget(" >  "));
        }
        if (categoryName != null) {
            hLinkPanel.add((Widget)new LabelWidget(categoryName));
        } else {
            hLinkPanel.add((Widget)new LabelWidget(this.constants.newCategoryTempName()));
        }
        result.add((Widget)hLinkPanel);
        return result;
    }

    private VerticalContainer showMetadataNode(UIMetadataNode metadata) {
        VerticalContainer result = new VerticalContainer();
        if (metadata == null) {
            return result;
        }
        UICategoryFieldSchema uiSchema = metadata.getSchema();
        UIMetadataContent uiMetadataContent = metadata.getContent();
        if (uiSchema != null && uiMetadataContent != null) {
            String dataType = uiSchema.getDataType();
            if ("Set".equals(dataType)) {
                result.add(this.display(uiSchema, metadata));
            } else {
                Widget displayWidget = null;
                if ("String".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("String Choice".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("Integer".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getLong());
                } else if ("Number Choice".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getLong());
                } else if ("DateTimeZone".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getDate());
                } else if ("Boolean".equals(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("Decimal".endsWith(dataType)) {
                    displayWidget = this.display(uiSchema, uiMetadataContent.getDouble());
                }
                if (displayWidget != null) {
                    this.valueMap.put(metadata, displayWidget);
                    result.add(displayWidget);
                }
            }
        }
        return result;
    }

    private Widget display(UIMetadataNode value) {
        Widget result = null;
        if (value == null) {
            return result;
        }
        UICategoryFieldSchema uiSchema = value.getSchema();
        UIMetadataContent uiMetadataContent = value.getContent();
        if (uiSchema != null && uiMetadataContent != null) {
            String dataType = uiSchema.getDataType();
            if ("Set".equals(dataType)) {
                result = this.display(uiSchema, value);
            } else {
                Widget resultWidget = null;
                if ("String".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("String Choice".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("Integer".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getLong());
                } else if ("Number Choice".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getLong());
                } else if ("DateTimeZone".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getDate());
                } else if ("Image".equals(dataType)) {
                    resultWidget = this.display(uiSchema, "ImageValue");
                } else if ("Boolean".equals(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getString());
                } else if ("Decimal".endsWith(dataType)) {
                    resultWidget = this.display(uiSchema, uiMetadataContent.getDouble());
                }
                this.valueMap.put(value, resultWidget);
                HorizontalPanel valuePanel = new HorizontalPanel();
                valuePanel.add(resultWidget);
                if (this.security.isUserInRole("CategoryManager_Modify")) {
                    valuePanel.add((Widget)this.showAddRemoveButtons(value));
                }
                result = valuePanel;
            }
        }
        return result;
    }

    private Widget display(UICategoryFieldSchema uiSchema, Double value) {
        String displayType;
        TextBox result = null;
        String strValue = null;
        if (value != null) {
            strValue = value.toString();
        }
        if ("Text".equals(displayType = uiSchema.getDisplayType())) {
            TextBox textBox = new TextBox();
            textBox.setText(strValue);
            result = textBox;
        } else if ("TextArea".equals(displayType)) {
            TextArea textArea = new TextArea();
            textArea.setText(strValue);
            result = textArea;
        }
        return result;
    }

    private Widget display(UICategoryFieldSchema uiSchema, Long value) {
        List<UICategoryFieldSchemaDefault> defaults;
        TextBox result = null;
        String displayType = uiSchema.getDisplayType();
        if ("Text".equals(displayType)) {
            TextBox textBox = new TextBox();
            if (value != null) {
                textBox.setText(value.toString());
            }
            result = textBox;
        } else if ("TextArea".equals(displayType)) {
            TextArea textArea = new TextArea();
            if (value != null) {
                textArea.setText(value.toString());
            }
            result = textArea;
        } else if ("ComboBox".equals(displayType) && (defaults = uiSchema.getDefaults()) != null) {
            ListBox nameBox = new ListBox();
            nameBox.setSize("250px", "20px");
            nameBox.addItem("Select...");
            int i = 0;
            for (UICategoryFieldSchemaDefault schemaDefault : defaults) {
                ++i;
                String defaultValue = schemaDefault.getKeyValue();
                String numberValue = String.valueOf(schemaDefault.getNumberValue());
                if (defaultValue == null || numberValue == null) continue;
                nameBox.addItem(numberValue);
                if (value == null || !value.equals(schemaDefault.getNumberValue().longValueExact())) continue;
                nameBox.setSelectedIndex(i);
            }
            result = nameBox;
        }
        return result;
    }

    private Widget display(UICategoryFieldSchema uiSchema, String value) {
        String displayType;
        TextArea result = null;
        String string = displayType = uiSchema.getDisplayType() == null ? "Text" : uiSchema.getDisplayType();
        if ("Text".equals(displayType)) {
            TextBox textBox = new TextBox();
            textBox.setMaxLength(this.getMaxLength(uiSchema.getMaxLen()));
            if (value != null) {
                textBox.setText(value);
            }
            result = textBox;
        } else if ("TextArea".equals(displayType)) {
            TextArea textArea = new TextArea();
            if (value != null) {
                textArea.setText(value);
            }
            result = textArea;
        } else if ("ComboBox".equals(displayType)) {
            List<UICategoryFieldSchemaDefault> defaults = uiSchema.getDefaults();
            if (defaults != null) {
                ListBox nameBox = new ListBox();
                nameBox.setSize("250px", "20px");
                nameBox.addItem("Select...");
                int i = 0;
                for (UICategoryFieldSchemaDefault schemaDefault : defaults) {
                    ++i;
                    String defaultValue = schemaDefault.getStringValue();
                    if (defaultValue == null) continue;
                    nameBox.addItem(defaultValue);
                    if (!defaultValue.equals(value)) continue;
                    nameBox.setSelectedIndex(i);
                }
                result = nameBox;
            }
        } else if ("CheckBox".equals(displayType)) {
            CheckBox nameBox = new CheckBox();
            if ("T".equals(value)) {
                nameBox.setValue(Boolean.valueOf(true));
            }
            result = nameBox;
        } else if ("Hyperlink".equals(displayType)) {
            Hyperlink nameLink = new Hyperlink();
            nameLink.setHTML(value);
            result = nameLink;
        }
        return result;
    }

    private Widget display(UICategoryFieldSchema uiSchema, Date value) {
        String displayType = uiSchema.getDisplayType();
        DateTimeInputWidget result = null;
        if ("DatePicker".equals(displayType)) {
            DateTimeInputWidget dateTimeWidget;
            result = dateTimeWidget = new DateTimeInputWidget(new DatePicker(), value, (DateTimeInputWidget.Format)new CategoryDateFormat(uiSchema.getValidationRegex()));
        } else if ("Text".equals(displayType)) {
            TextBox textBox = new TextBox();
            CategoryDateFormat dateFormat = new CategoryDateFormat(uiSchema.getValidationRegex());
            if (value != null) {
                String strDate = dateFormat.format(value);
                textBox.setValue((Object)strDate);
            }
            result = textBox;
        }
        return result;
    }

    private String convertToString(UIMetadataNode node) {
        if (node.getContent() != null) {
            if ("String".equals(node.getSchema().getDataType())) {
                return node.getContent().getString();
            }
            if ("String Choice".equals(node.getSchema().getDataType())) {
                return node.getContent().getString();
            }
            if ("Integer".equals(node.getSchema().getDataType())) {
                return node.getContent().getLong().toString();
            }
            if ("Number Choice".equals(node.getSchema().getDataType())) {
                return node.getContent().getLong().toString();
            }
            if ("Decimal".equals(node.getSchema().getDataType())) {
                return node.getContent().getDouble().toString();
            }
            if ("Boolean".equals(node.getSchema().getDataType())) {
                return node.getContent().getBoolean().toString();
            }
            if ("DateTimeZone".equals(node.getSchema().getDataType())) {
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)node.getSchema().getValidationRegex());
                dtf.format(node.getContent().getDate());
            }
        }
        return null;
    }

    private Widget display(UICategoryFieldSchema uiSchema, UIMetadataNode parentNode) {
        List<UIMetadataNode> values = parentNode.getContent().getList();
        RoundedDisclosureContainer result = null;
        if ("Section".equals(uiSchema.getDisplayType())) {
            RoundedDisclosureContainer disPanel = new RoundedDisclosureContainer(uiSchema.getName());
            disPanel.setOpen(true);
            if ("Standard Fields".equals(uiSchema.getName()) || "Custom Fields".equals(uiSchema.getName())) {
                disPanel.setWidth("600px");
            }
            FormContainer fPanel = new FormContainer(HorizontalContainer.ALIGN_LEFT);
            for (UIMetadataNode value : values) {
                LabelWidget name = new LabelWidget(value.getSchema().getName());
                long minOcc = value.getSchema().getMinOcc();
                boolean req = value.getSchema().isRequiredCreate();
                if (minOcc > 0L || req) {
                    fPanel.addRow(name, this.display(value), true);
                    continue;
                }
                fPanel.addRow(name, this.display(value));
            }
            disPanel.add((Widget)fPanel);
            result = disPanel;
        } else if ("Table".equals(uiSchema.getDisplayType())) {
            HashSet<String> colvals = new HashSet<String>();
            HashSet<Long> rowvals = new HashSet<Long>();
            ArrayList<UIMetadataNode> leftMostNodes = new ArrayList<UIMetadataNode>();
            for (UIMetadataNode value : values) {
                colvals.add(value.getSchema().getName());
                rowvals.add(value.getOccNum());
            }
            int colct = colvals.size();
            int rowct = rowvals.size();
            Grid nameBox = new Grid(rowct + 1, colct);
            int c = 0;
            int r = 0;
            for (UIMetadataNode column : values) {
                nameBox.setText(0, c, column.getSchema().getName());
                nameBox.getCellFormatter().setStyleName(0, c, "category-table-row-header");
                nameBox.getCellFormatter().addStyleName(0, c, "category-table-header-text");
                nameBox.getCellFormatter().setWidth(0, c, "100px");
                TextBox textBox = new TextBox();
                textBox.setText(this.convertToString(column));
                textBox.setMaxLength(this.getMaxLength(column.getSchema().getMaxLen()));
                nameBox.setWidget(++r, c, (Widget)textBox);
                nameBox.getCellFormatter().setWidth(r, c, "100px");
                this.valueMap.put(column, (Widget)textBox);
                if (c == 0) {
                    leftMostNodes.add(column);
                }
                if (r != rowct) continue;
                r = 0;
                ++c;
            }
            nameBox.setBorderWidth(1);
            nameBox.setCellPadding(10);
            result = nameBox;
            this.showAddRemoveButtons(parentNode, leftMostNodes, nameBox);
        }
        return result;
    }

    public void showCategory(final UICategoryNode categoryNode, boolean createCategory) {
        this.headerPanel.updateCategoryHeaderView(categoryNode);
        this.valueMap = new HashMap<Object, Widget>();
        this.m_categoryNode = categoryNode;
        this.newCategory = createCategory;
        this.parentPanel.initFeedback();
        this.parentPanel.showFeedback();
        this.validationView.clearMessages();
        if (categoryNode == null) {
            this.detailPanel.clear();
            this.detailPanel.add((Widget)new LabelWidget(this.constants.defaultCategoryDoesNotExistMessage()));
            return;
        }
        if (categoryNode != null && !createCategory && categoryNode.getName().equals("Categories")) {
            this.detailPanel.clear();
            this.detailPanel.add((Widget)new LabelWidget(this.constants.defaultDetailPanelMessage()));
        } else {
            try {
                this.detailPanel.clear();
                FlowPanel detailMainPanel = new FlowPanel();
                this.detailPanel.add((Widget)detailMainPanel);
                if (categoryNode != null) {
                    List<UICategoryHyperlink> links = categoryNode.getHyperlinks();
                    List<UIMetadataNode> metadata = categoryNode.getMetadata();
                    String categoryName = categoryNode.getName();
                    if (links != null) {
                        detailMainPanel.add((Widget)this.showHyperlinks(links, categoryName, this.newCategory));
                    }
                    final FormContainer categoryPanel = new FormContainer(HorizontalContainer.ALIGN_LEFT);
                    LabelWidget nameLabel = new LabelWidget(this.constants.categoryNameLabel());
                    TextBox nameBox = new TextBox();
                    nameBox.setText(categoryNode.getName());
                    nameBox.setReadOnly(true);
                    nameBox.setMaxLength(1024);
                    nameBox.setWidth("450px");
                    LabelWidget internalVersionLabel = new LabelWidget(this.constants.internalVersionLabel());
                    TextBox versionBox = new TextBox();
                    versionBox.setText(String.valueOf(categoryNode.getInternalVersion()));
                    versionBox.setReadOnly(true);
                    if (this.newCategory) {
                        nameBox.setReadOnly(false);
                        versionBox.setText("1");
                    }
                    this.valueMap.put("NewName", (Widget)nameBox);
                    this.valueMap.put("InternalVersion", (Widget)versionBox);
                    categoryPanel.addRow(nameLabel, (Widget)nameBox, true);
                    categoryPanel.addRow(internalVersionLabel, (Widget)versionBox, false);
                    final LabelWidget associatedCatLabel = new LabelWidget(this.constants.categoryTitleLable());
                    if (categoryNode.getAssociateCatPackageId() != null) {
                        this.categoryManagerService.isAssociatedTitleStillExists(categoryNode.getAssociateCatPackageId(), new AsyncCallback<Boolean>(){

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    String associateId = categoryNode.getAssociateCatPackageId().toString();
                                    HashMap<String, String> anchorTokens = new HashMap<String, String>();
                                    anchorTokens.put("Id", associateId);
                                    anchorTokens.put("returnAnchor", History.getToken());
                                    String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens);
                                    Hyperlink associatedCatLink = new Hyperlink(categoryNode.getAssociateCatPackageId().toString(), token);
                                    categoryPanel.addRow(associatedCatLabel, (Widget)associatedCatLink, false);
                                } else {
                                    categoryPanel.addRow(associatedCatLabel, (Widget)new LabelWidget("-"), false);
                                }
                            }

                            public void onFailure(Throwable caught) {
                                Window.alert((String)caught.toString());
                                CategoryDetailPanel.this.busyIndicator.hide();
                            }
                        });
                    } else {
                        categoryPanel.addRow(associatedCatLabel, (Widget)new LabelWidget("-"), false);
                    }
                    detailMainPanel.add((Widget)categoryPanel);
                    FlowPanel vPanel = new FlowPanel();
                    this.scrollContainer = new ScrollContainer((Widget)vPanel);
                    int height = Window.getClientHeight() - 405;
                    if (metadata != null) {
                        this.scrollContainer.setWidth("620px");
                        this.scrollContainer.setHeight(height + "px");
                        for (UIMetadataNode m : metadata) {
                            vPanel.add((Widget)this.showMetadataNode(m));
                        }
                    }
                    detailMainPanel.add((Widget)vPanel);
                }
                this.buttonPanel.clear();
                this.buttonPanel.setStyleName("cms_button_container");
                if (this.newCategory && this.security.isUserInRole("CategoryManager_Create") || this.security.isUserInRole("CategoryManager_Modify")) {
                    this.buttonPanel.add((Widget)this.createSaveButton());
                }
                if (this.security.isUserInRole("CategoryManager_Create") && categoryNode.getAssociateCatPackageId() == null && !this.newCategory) {
                    this.buttonPanel.add((Widget)this.createCreateCategoryPackageButton());
                }
                if (this.security.isUserInRole("CategoryManager_TargetCategoryTitle") && categoryNode.getAssociateCatPackageId() != null) {
                    this.buttonPanel.add((Widget)this.targetButton(categoryNode.getAssociateCatPackageId()));
                }
                if (this.security.isUserInRole("CategoryManager_Delete") && this.treePanel.getSelectedItem() != null && this.treePanel.getSelectedItem().getChildCount() == 0 && this.treePanel.getSelectedItem().getUserObject() != null) {
                    this.buttonPanel.add((Widget)this.deleteButton(categoryNode));
                }
                if (this.parentPanel != null) {
                    this.parentPanel.layout();
                }
            }
            catch (Exception e) {
                Window.alert((String)e.getMessage());
                System.err.println(e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    public Button createCreateCategoryPackageButton() {
        HorizontalPanel horizonButtonPanel = new HorizontalPanel();
        Button createCategoryPackageButton = new Button(this.constants.createCategoryPackageButton());
        createCategoryPackageButton.removeStyleName("gwt-Button");
        createCategoryPackageButton.addStyleName("ebBtn");
        createCategoryPackageButton.addStyleName("ebBtn_color_green");
        createCategoryPackageButton.addStyleName("create_button_icon");
        createCategoryPackageButton.addStyleName("float-left");
        createCategoryPackageButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CategoryDetailPanel.this.clearMessages();
                HashMap<String, String> anchorTokens = new HashMap<String, String>();
                anchorTokens.put("type", "category");
                anchorTokens.put("returnAnchor", History.getToken());
                String token = "Content.Create." + new AnchorTokenizer().buildAnchor(anchorTokens);
                History.newItem((String)token);
            }
        });
        horizonButtonPanel.add((Widget)createCategoryPackageButton);
        return createCategoryPackageButton;
    }

    public Button targetButton(Long id) {
        HorizontalPanel horizonButtonPanel = new HorizontalPanel();
        final String catId = id.toString();
        Button targetButton = new Button(this.constants.targetButton());
        targetButton.removeStyleName("gwt-Button");
        targetButton.addStyleName("ebBtn");
        targetButton.addStyleName("ebBtn_color_green");
        targetButton.addStyleName("float-left");
        targetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CategoryDetailPanel.this.clearMessages();
                HashMap<String, String> anchorTokens = new HashMap<String, String>();
                anchorTokens.put("Id", catId);
                anchorTokens.put("returnAnchor", History.getToken());
                String token = "Content.Search." + new AnchorTokenizer().buildAnchor(anchorTokens) + "&Tab=Sites";
                History.newItem((String)token);
            }
        });
        horizonButtonPanel.add((Widget)targetButton);
        return targetButton;
    }

    public Button deleteButton(UICategoryNode categoryNode) {
        HorizontalPanel horizonButtonPanel = new HorizontalPanel();
        final String catName = categoryNode.getName();
        Button delButton = new Button(this.constants.deleteButton());
        delButton.removeStyleName("gwt-Button");
        delButton.addStyleName("ebBtn");
        delButton.addStyleName("delete_button_icon");
        delButton.addStyleName("float-left");
        delButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!Window.confirm((String)CategoryDetailPanel.this.constants.deleteCategoryConfirmMessage(catName))) {
                    return;
                }
                CategoryDetailPanel.this.clearMessages();
                CategoryDetailPanel.this.treePanel.deleteCategory();
                CategoryDetailPanel.this.parentPanel.layout();
            }
        });
        horizonButtonPanel.add((Widget)delButton);
        return delButton;
    }

    public Button createSaveButton() {
        HorizontalPanel horizonButtonPanel = new HorizontalPanel();
        Button saveButton = new Button(this.constants.saveButton());
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        saveButton.addStyleName("float-left");
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String intVersion;
                TextBox txtInternalVersion;
                CategoryDetailPanel.this.validationView.clearMessages();
                CategoryDetailPanel.this.clearMessages();
                if (CategoryDetailPanel.this.newCategory) {
                    TextBox txtName = (TextBox)CategoryDetailPanel.this.valueMap.get("NewName");
                    String categoryName = txtName == null ? null : (txtName.getValue() == null ? null : (txtName.getValue().trim().length() == 0 ? null : txtName.getValue().trim()));
                    txtName.removeStyleName("field-ValidationError");
                    if (categoryName != null) {
                        if (categoryName.contains(CategoryDetailPanel.PATH_SEPARATOR)) {
                            txtName.addStyleName("field-ValidationError");
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.categoryName(), CategoryDetailPanel.this.constants.invalidCategoryNameMessage()));
                        } else if (CategoryDetailPanel.this.m_categoryNode.getSiblings() != null && CategoryDetailPanel.this.m_categoryNode.getSiblings().contains(categoryName)) {
                            txtName.addStyleName("field-ValidationError");
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.categoryName(), CategoryDetailPanel.this.constants.duplicateNameValidationMessage()));
                        } else {
                            CategoryDetailPanel.this.m_categoryNode.setName(categoryName);
                        }
                    } else {
                        txtName.addStyleName("field-ValidationError");
                        CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.categoryName(), CategoryDetailPanel.this.constants.emptyNameValidationMessage()));
                    }
                }
                String string = (txtInternalVersion = (TextBox)CategoryDetailPanel.this.valueMap.get("InternalVersion")) == null ? null : (txtInternalVersion.getValue() == null ? null : (intVersion = txtInternalVersion.getValue().trim().length() == 0 ? null : txtInternalVersion.getValue().trim()));
                if (intVersion != null) {
                    try {
                        CategoryDetailPanel.this.m_categoryNode.setInternalVersion(Long.valueOf(txtInternalVersion.getValue()));
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    if (CategoryDetailPanel.this.valueMap != null && CategoryDetailPanel.this.m_categoryNode != null) {
                        Integer providerVersion;
                        for (UIMetadataNode curMetadataNode : CategoryDetailPanel.this.m_categoryNode.getMetadata()) {
                            try {
                                CategoryDetailPanel.this.handleMetadataNode(curMetadataNode);
                            }
                            catch (UICategoryValidationException ucve) {
                                CategoryDetailPanel.this.validationView.addValidationMessage(ucve);
                            }
                        }
                        UIMetadataNodeParser parser = new UIMetadataNodeParser(CategoryDetailPanel.this.m_categoryNode.getMetadata());
                        long startDate = parser.geLongDateValue("Start Date");
                        long endDate = parser.geLongDateValue("End Date");
                        if (endDate < startDate) {
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.endDate(), CategoryDetailPanel.this.constants.invalidEndDateMessage()));
                        }
                        if (endDate > 0L && startDate <= 0L) {
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.startDate(), CategoryDetailPanel.this.constants.invalidStartDateMessage()));
                        }
                        if ((providerVersion = parser.getIntValue("Provider Version")) != null && providerVersion < 1) {
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryValidationException(CategoryDetailPanel.this.constants.providerVersion(), CategoryDetailPanel.this.constants.invalidProviderVersionMessage()));
                        }
                    }
                    try {
                        CategoryDetailPanel.this.validateCategoryUnique(CategoryDetailPanel.this.m_categoryNode);
                    }
                    catch (UICategoryValidationException ucve) {
                        for (UICategoryValidationException curExc : ucve.getChildren()) {
                            CategoryDetailPanel.this.validationView.addValidationMessage(curExc);
                        }
                    }
                    CategoryDetailPanel.this.invalidNodes.clear();
                }
                catch (UICategoryManagerException ucme) {
                    CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryGeneralMessage(UICategoryMessage.MessageLevel.ERROR, ucme.getMessage()));
                }
                catch (Exception e) {
                    CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryGeneralMessage(UICategoryMessage.MessageLevel.ERROR, CategoryDetailPanel.this.constants.unanticipatedException() + e.getMessage()));
                }
                if (CategoryDetailPanel.this.validationView.hasErrors()) {
                    CategoryDetailPanel.this.validationView.refresh();
                    return;
                }
                CategoryDetailPanel.this.metadataService.saveCategory(CategoryDetailPanel.this.m_categoryNode, CategoryDetailPanel.this.newCategory, (AsyncCallback<Long>)new NeptuneAsyncCallback<Long>(){

                    public void onNeptuneFailure(Throwable caught) {
                        if (caught instanceof UICategoryValidationException) {
                            UICategoryValidationException ucve = (UICategoryValidationException)caught;
                            CategoryDetailPanel.this.addValidationMessages(ucve);
                        } else {
                            CategoryDetailPanel.this.validationView.addValidationMessage(new UICategoryGeneralMessage(UICategoryMessage.MessageLevel.ERROR, CategoryDetailPanel.this.constants.unableToSaveCategory() + caught.getMessage()));
                        }
                        CategoryDetailPanel.this.validationView.refresh();
                    }

                    public void onNeptuneSuccess(Long result) {
                        CategoryDetailPanel.this.parentPanel.setFeedbackMessage(CategoryDetailPanel.this.constants.saveCategorySuccessMessage(CategoryDetailPanel.this.m_categoryNode.getName()));
                        History.getToken().replace("CategoryManager.View.id=99999", "CategoryManager.View.id=" + CategoryDetailPanel.this.m_categoryNode.getId());
                        if (CategoryDetailPanel.this.newCategory) {
                            CategoryDetailPanel.this.m_categoryNode.setId(result);
                        }
                        if (CategoryDetailPanel.this.m_categoryNode.getId() != null) {
                            CategoryDetailPanel.this.treePanel.reload(CategoryDetailPanel.this.m_categoryNode.getId(), CategoryDetailPanel.this.m_categoryNode.getParentId());
                            if (!CategoryDetailPanel.this.newCategory) {
                                History.fireCurrentHistoryState();
                            }
                        }
                    }
                });
                CategoryDetailPanel.this.parentPanel.layout();
            }
        });
        horizonButtonPanel.add((Widget)saveButton);
        return saveButton;
    }

    private void handleMetadataNode(UIMetadataNode parentNode) throws UICategoryValidationException, UICategoryManagerException {
        UICategoryFieldSchema curFieldSchema = parentNode.getSchema();
        UIMetadataContent curContent = parentNode.getContent();
        if ("Set".equals(curFieldSchema.getDataType())) {
            ArrayList<UIMetadataNode> childMetadataNodes = new ArrayList<UIMetadataNode>(curContent.getList());
            for (UIMetadataNode curMetadataNode : childMetadataNodes) {
                try {
                    this.handleMetadataNode(curMetadataNode);
                }
                catch (UICategoryValidationException ucve) {
                    this.validationView.addValidationMessage(ucve);
                }
            }
        } else if ("Text".equals(curFieldSchema.getDisplayType())) {
            this.handleTextNode(parentNode, curFieldSchema, curContent);
        } else if ("DatePicker".equals(curFieldSchema.getDisplayType())) {
            this.handleDatePickerNode(parentNode, curFieldSchema, curContent);
        } else if ("ComboBox".equals(curFieldSchema.getDisplayType())) {
            this.handleComboxNode(parentNode, curFieldSchema, curContent);
        } else if ("CheckBox".equals(curFieldSchema.getDisplayType())) {
            CheckBox checkWidget = (CheckBox)this.valueMap.get(parentNode);
            curContent.setBoolean(checkWidget.getValue());
        } else if ("TextArea".equals(curFieldSchema.getDisplayType())) {
            this.handleTextAreaNode(parentNode, curFieldSchema, curContent);
        } else {
            throw new UICategoryManagerException(this.constants.unknownDisplayType() + curFieldSchema.getDisplayType());
        }
    }

    private void handleTextAreaNode(UIMetadataNode parentNode, UICategoryFieldSchema curFieldSchema, UIMetadataContent curContent) {
        String strValue;
        TextArea textWidget = (TextArea)this.valueMap.get(parentNode);
        textWidget.removeStyleName("field-ValidationError");
        String string = textWidget.getValue() == null ? null : (strValue = textWidget.getValue().trim().length() == 0 ? null : textWidget.getValue().trim());
        if ((curFieldSchema.getMinOcc() > 0L || curFieldSchema.isRequiredCreate()) && strValue == null) {
            textWidget.addStyleName("field-ValidationError");
            this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.requiredFieldMissingMessage()));
        }
        if (strValue != null) {
            RegExp pattern;
            boolean validated;
            String strPattern = curFieldSchema.getValidationRegex();
            if (strPattern != null && !(validated = (pattern = RegExp.compile((String)strPattern)).test(strValue))) {
                this.invalidNodes.add(parentNode);
                textWidget.addStyleName("field-ValidationError");
                this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidFormatMessage("text", strPattern)));
            }
            curContent.setString(strValue);
        } else {
            curContent.setString(null);
        }
    }

    private void handleComboxNode(UIMetadataNode parentNode, UICategoryFieldSchema curFieldSchema, UIMetadataContent curContent) {
        ListBox comboWidget = (ListBox)this.valueMap.get(parentNode);
        comboWidget.removeStyleName("field-ValidationError");
        Integer selectedIndex = comboWidget.getSelectedIndex();
        if (curFieldSchema.isRequiredCreate() && selectedIndex <= 0) {
            comboWidget.addStyleName("field-ValidationError");
            this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.requiredFieldMissingMessage()));
        }
        if (selectedIndex > 0) {
            if ("Number Choice".equals(curFieldSchema.getDataType())) {
                curContent.setNumber(Integer.parseInt(comboWidget.getValue(selectedIndex.intValue())));
            } else if ("String Choice".equals(curFieldSchema.getDataType())) {
                curContent.setString(comboWidget.getValue(comboWidget.getSelectedIndex()));
            }
        } else {
            curContent.setNumber((BigDecimal)null);
            curContent.setString(null);
        }
    }

    private void handleDatePickerNode(UIMetadataNode parentNode, UICategoryFieldSchema curFieldSchema, UIMetadataContent curContent) throws UICategoryValidationException {
        Date validDate;
        DateTimeInputWidget widget = (DateTimeInputWidget)this.valueMap.get(parentNode);
        widget.getTextBox().removeStyleName("field-ValidationError");
        String strDate = widget.getTextBox().getValue() == null ? null : (widget.getTextBox().getValue().trim().length() == 0 ? null : widget.getTextBox().getValue());
        Date dateValue = widget.getValue();
        if (curFieldSchema.isRequiredCreate() && dateValue == null) {
            widget.getTextBox().addStyleName("field-ValidationError");
            this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.requiredFieldMissingMessage()));
        }
        if (strDate != null && (validDate = widget.getFormat().parse(widget, strDate, true)) == null) {
            this.invalidNodes.add(parentNode);
            widget.getTextBox().addStyleName("field-ValidationError");
            CategoryDateFormat cdf = (CategoryDateFormat)widget.getFormat();
            String pattern = cdf.getPattern();
            this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidFormatMessage("Date", pattern)));
        }
        if (curFieldSchema.isRequiredCreate() && dateValue == null) {
            widget.getTextBox().addStyleName("field-ValidationError");
            throw new UICategoryValidationException(curFieldSchema.getName(), this.constants.requiredFieldMissingMessage());
        }
        if (dateValue != null) {
            curContent.setDate(dateValue);
        } else {
            curContent.setDate(null);
        }
    }

    private void handleTextNode(UIMetadataNode parentNode, UICategoryFieldSchema curFieldSchema, UIMetadataContent curContent) {
        String strValue;
        TextBox textWidget = (TextBox)this.valueMap.get(parentNode);
        textWidget.removeStyleName("field-ValidationError");
        String string = textWidget.getValue() == null ? null : (strValue = textWidget.getValue().trim().length() == 0 ? null : textWidget.getValue().trim());
        if ((curFieldSchema.getMinOcc() > 0L || curFieldSchema.isRequiredCreate()) && strValue == null) {
            textWidget.addStyleName("field-ValidationError");
            this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.requiredFieldMissingMessage()));
        }
        if (strValue != null) {
            if ((long)strValue.length() < curFieldSchema.getMinLen()) {
                textWidget.addStyleName("field-ValidationError");
                this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.minLengthMessage(curFieldSchema.getMinLen())));
            }
            if (curFieldSchema.getMaxLen() > 0L && (long)strValue.length() > curFieldSchema.getMaxLen()) {
                textWidget.addStyleName("field-ValidationError");
                this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.maxLengthMessage(curFieldSchema.getMaxLen())));
            }
            if ("String".equals(curFieldSchema.getDataType())) {
                RegExp pattern;
                boolean validated;
                String strPattern = curFieldSchema.getValidationRegex();
                if (strPattern != null && !(validated = (pattern = RegExp.compile((String)strPattern)).test(strValue))) {
                    this.invalidNodes.add(parentNode);
                    textWidget.addStyleName("field-ValidationError");
                    this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidFormatMessage("text", strPattern)));
                }
                curContent.setString(strValue);
            } else if ("Integer".equals(curFieldSchema.getDataType())) {
                try {
                    curContent.setNumber(Integer.parseInt(strValue));
                }
                catch (NumberFormatException nfe) {
                    this.invalidNodes.add(parentNode);
                    textWidget.addStyleName("field-ValidationError");
                    this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidValueMessage("integer")));
                }
            } else if ("Decimal".equals(curFieldSchema.getDataType())) {
                try {
                    curContent.setNumber(Double.parseDouble(strValue));
                }
                catch (NumberFormatException nfe) {
                    textWidget.addStyleName("field-ValidationError");
                    this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidValueMessage("decimal")));
                }
            } else if ("DateTimeZone".equals(curFieldSchema.getDataType())) {
                String strPattern = curFieldSchema.getValidationRegex();
                CategoryDateFormat cdf = new CategoryDateFormat(strPattern);
                try {
                    Date dateValue = cdf.parseStrict(strValue);
                    if (dateValue != null) {
                        curContent.setDate(dateValue);
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.invalidNodes.add(parentNode);
                    textWidget.addStyleName("field-ValidationError");
                    this.validationView.addValidationMessage(new UICategoryValidationException(curFieldSchema.getName(), this.constants.invalidFormatMessage("Date", strPattern)));
                }
            }
        } else {
            curContent.setDate(null);
            curContent.setString(null);
            curContent.setNumber((BigDecimal)null);
        }
    }

    private int nodeCount(List<UIMetadataNode> nodeList, String name) {
        int count = 0;
        for (UIMetadataNode curNode : nodeList) {
            UIMetadataContent content = curNode.getContent();
            UICategoryFieldSchema fieldSchema = curNode.getSchema();
            if (content.getList() != null) {
                count += this.nodeCount(content.getList(), name);
            }
            if (!name.equals(fieldSchema.getName())) continue;
            ++count;
        }
        return count;
    }

    private void updateAddRemoveButtons(List<UIMetadataNode> nodeList, String fieldName) {
        for (UIMetadataNode curNode : nodeList) {
            UIMetadataContent content = curNode.getContent();
            UICategoryFieldSchema fieldSchema = curNode.getSchema();
            if (content.getList() != null) {
                this.updateAddRemoveButtons(content.getList(), fieldName);
            }
            if (!fieldName.equals(fieldSchema.getName())) continue;
            Widget entryWidget = this.valueMap.get(curNode);
            HorizontalPanel horizPanel = (HorizontalPanel)entryWidget.getParent();
            horizPanel.remove(horizPanel.getWidgetCount() - 1);
            horizPanel.add((Widget)this.showAddRemoveButtons(curNode));
        }
    }

    private List<UIMetadataNode> getNodesByFieldName(List<UIMetadataNode> metadataList, String fieldName) {
        ArrayList<UIMetadataNode> fieldNodes = new ArrayList<UIMetadataNode>();
        for (UIMetadataNode curNode : metadataList) {
            UIMetadataContent content = curNode.getContent();
            UICategoryFieldSchema fieldSchema = curNode.getSchema();
            if (content.getList() != null) {
                this.updateAddRemoveButtons(content.getList(), fieldName);
            }
            if (!fieldName.equals(fieldSchema.getName())) continue;
            fieldNodes.add(curNode);
        }
        return fieldNodes;
    }

    public void anchorChanged(String anchor) {
        if (this.isBlank(anchor)) {
            this.detailPanel.clear();
            this.headerPanel.refreshHeading();
            this.parentPanel.hideFeedback();
            this.treePanel.reload(new Long(0L), new Long(0L));
        } else {
            AnchorTokenizer at = new AnchorTokenizer();
            Map paramMap = at.parseAnchor(anchor);
            Long id = Long.parseLong((String)paramMap.get("id"));
            if (id != null && id >= 0L) {
                this.selectCategory(id);
            }
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    private Panel showAddRemoveButtons(UIMetadataNode metadataNode) {
        HorizontalPanel horizonButtonPanel = new HorizontalPanel();
        UIMetadataContent metadataContent = metadataNode.getContent();
        UICategoryFieldSchema metadataSchema = metadataNode.getSchema();
        List<UIMetadataNode> categoryMetadataList = this.m_categoryNode.getMetadata();
        int nodeCount = -1;
        nodeCount = "Table".equals(metadataSchema.getDisplayType()) ? this.nodeCount(categoryMetadataList, metadataContent.getList().get(0).getSchema().getName()) : this.nodeCount(categoryMetadataList, metadataSchema.getName());
        if (nodeCount > 1 && metadataSchema.getMaxOcc() != 1L) {
            ArgButton deleteButton = new ArgButton("-", 2, metadataNode);
            deleteButton.addClickHandler(this.argClickHandler);
            deleteButton.removeStyleName("gwt-Button");
            deleteButton.addStyleName("ebBtn");
            deleteButton.addStyleName("minus_button_icon");
            deleteButton.setTitle(this.constants.datalossButtonTitle());
            horizonButtonPanel.add((Widget)deleteButton);
        }
        if (metadataNode.getOccNum() != null && metadataNode.getOccNum() == (long)nodeCount && (metadataNode.getOccNum() < metadataSchema.getMaxOcc() || metadataSchema.getMaxOcc() == 0L)) {
            ArgButton addButton = new ArgButton("+", 1, metadataNode);
            addButton.removeStyleName("gwt-Button");
            addButton.addStyleName("ebBtn");
            addButton.addStyleName("plus_button_icon");
            addButton.addClickHandler(this.argClickHandler);
            addButton.setTitle(this.constants.commitButtonTitle());
            horizonButtonPanel.add((Widget)addButton);
        }
        return horizonButtonPanel;
    }

    public void showAddRemoveButtons(UIMetadataNode parentNode, List<UIMetadataNode> metadataList, Grid grid) {
        if (metadataList != null) {
            UIMetadataNode masterNode = metadataList.get(0);
            UICategoryFieldSchema fieldSchema = masterNode.getSchema();
            UICategoryFieldSchema parentSchema = parentNode.getSchema();
            if (fieldSchema != null) {
                int i = 1;
                if (fieldSchema.getMaxOcc() != 1L && metadataList.size() > 1) {
                    grid.resizeColumns(grid.getColumnCount() + 1);
                    grid.setText(0, grid.getColumnCount() - 1, "-");
                    grid.getCellFormatter().setStyleName(0, grid.getColumnCount() - 1, "category-table-row-header");
                    grid.getCellFormatter().addStyleName(0, grid.getColumnCount() - 1, "category-table-header-text");
                    for (UIMetadataNode curMetadataNode : metadataList) {
                        curMetadataNode.getSchema().setParent(parentSchema);
                        ArgButton removeButton = new ArgButton("-", 2, curMetadataNode, parentNode);
                        removeButton.addClickHandler(this.argClickHandler);
                        removeButton.removeStyleName("gwt-Button");
                        removeButton.addStyleName("ebBtn");
                        removeButton.addStyleName("minus_button_icon");
                        removeButton.setTitle(this.constants.datalossButtonTitle());
                        grid.setWidget(i, grid.getColumnCount() - 1, (Widget)removeButton);
                        ++i;
                    }
                }
                if (fieldSchema.getMaxOcc() == 0L || fieldSchema.getMaxOcc() > (long)metadataList.size()) {
                    grid.resizeColumns(grid.getColumnCount() + 1);
                    grid.setText(0, grid.getColumnCount() - 1, "+");
                    grid.getCellFormatter().setStyleName(0, grid.getColumnCount() - 1, "category-table-row-header");
                    grid.getCellFormatter().addStyleName(0, grid.getColumnCount() - 1, "category-table-header-text");
                    ArgButton addButton = new ArgButton("+", 1, parentNode);
                    addButton.addClickHandler(this.argClickHandler);
                    addButton.removeStyleName("gwt-Button");
                    addButton.addStyleName("ebBtn");
                    addButton.addStyleName("plus_button_icon");
                    addButton.setTitle(this.constants.commitButtonTitle());
                    grid.setWidget(grid.getRowCount() - 1, grid.getColumnCount() - 1, (Widget)addButton);
                }
            }
        }
    }

    protected void removeNodeFromParent(UIMetadataNode metadataNode, boolean updateOccNum) {
        List<UIMetadataNode> parentList = metadataNode.getParentList();
        if (parentList != null) {
            parentList.remove(metadataNode);
        }
        if (updateOccNum) {
            this.updateOccNums(metadataNode.getSchema().getName(), parentList);
        }
    }

    protected void updateOccNums(String fieldSchemaName, List<UIMetadataNode> metadataList) {
        long curOccNum = 1L;
        for (UIMetadataNode curMetadataNode : metadataList) {
            if (!fieldSchemaName.equals(curMetadataNode.getSchema().getName())) continue;
            curMetadataNode.setOccNum(curOccNum);
            ++curOccNum;
        }
    }

    private void addValidationMessages(UICategoryValidationException ve) {
        this.validationView.addValidationMessage(ve);
        if (ve.getChildren() != null) {
            for (UICategoryValidationException child : ve.getChildren()) {
                this.addValidationMessages(child);
            }
        }
    }

    private Set<String> validateUnique(List<UIMetadataNode> metadataList) {
        HashSet<String> duplicateOccs = new HashSet<String>();
        for (UIMetadataNode metadataNode : metadataList) {
            Widget duplicateWidget;
            if ("Set".equals(metadataNode.getSchema().getDataType())) {
                duplicateOccs.addAll(this.validateUnique(metadataNode.getContent().getList()));
                continue;
            }
            if (this.invalidNodes.contains(metadataNode)) continue;
            UIMetadataContent umc = metadataNode.getContent();
            String strNode = metadataNode.getSchema().getName() + ":" + umc.getString() + ":" + umc.getNumber() + ":" + umc.getBoolean() + ":" + umc.getImage() + ":" + umc.getDate();
            if (!this.findDuplicateValues(metadataNode, metadataList)) continue;
            Widget mappedWidget = this.valueMap.get(metadataNode);
            if ("DatePicker".equals(metadataNode.getSchema().getDisplayType())) {
                DateTimeInputWidget dtiw = (DateTimeInputWidget)mappedWidget;
                duplicateWidget = dtiw.getTextBox();
            } else {
                duplicateWidget = mappedWidget;
            }
            if (duplicateWidget != null) {
                duplicateWidget.addStyleName("field-ValidationError");
            }
            duplicateOccs.add(metadataNode.getSchema().getId() + "]" + metadataNode.getSchema().getName());
        }
        return duplicateOccs;
    }

    private boolean findDuplicateValues(UIMetadataNode metadataNode, List<UIMetadataNode> metadataList) {
        boolean foundDuplicate = false;
        UIMetadataContent umc = metadataNode.getContent();
        if (umc.hasValue()) {
            String metadataStr = metadataNode.getSchema().getName() + ":" + umc.getString() + ":" + umc.getNumber() + ":" + umc.getBoolean() + ":" + umc.getImage() + ":" + umc.getDate();
            for (UIMetadataNode curMetadataNode : metadataList) {
                String strNode;
                if (metadataNode == curMetadataNode) continue;
                if ("Set".equals(curMetadataNode.getSchema().getDataType())) {
                    foundDuplicate = foundDuplicate || this.findDuplicateValues(metadataNode, curMetadataNode.getContent().getList());
                    continue;
                }
                UIMetadataContent curUmc = curMetadataNode.getContent();
                if (!curUmc.hasValue() || !metadataStr.equals(strNode = curMetadataNode.getSchema().getName() + ":" + curUmc.getString() + ":" + curUmc.getNumber() + ":" + curUmc.getBoolean() + ":" + curUmc.getImage() + ":" + curUmc.getDate())) continue;
                foundDuplicate = true;
                break;
            }
        }
        return foundDuplicate;
    }

    private void validateCategoryUnique(UICategoryNode categoryNode) throws UICategoryValidationException {
        Set<String> duplicates = this.validateUnique(categoryNode.getMetadata());
        UICategoryValidationException ucve = new UICategoryValidationException();
        ArrayList<UICategoryValidationException> validationList = new ArrayList<UICategoryValidationException>();
        for (String duplicateField : duplicates) {
            String duplicateName = duplicateField.substring(duplicateField.indexOf("]") + 1);
            validationList.add(new UICategoryValidationException(duplicateName, this.constants.uniqueMessage()));
        }
        if (validationList.size() > 0) {
            ucve.setChildren(validationList);
            throw ucve;
        }
    }

    private void clearMessages() {
        this.validationView.setVisible(false);
        this.parentPanel.hideFeedback();
    }

    protected void selectCategory(long id) {
        this.busyIndicator.center();
        this.metadataService.getUICategoryNode(id, (AsyncCallback<UICategoryNode>)new NeptuneAsyncCallback<UICategoryNode>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.toString());
                StringBuffer strBuff = new StringBuffer();
                StackTraceElement[] stackTrace = caught.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    strBuff.append(stackTrace[i].toString());
                }
                CategoryDetailPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UICategoryNode result) {
                if (result != null) {
                    CategoryDetailPanel.this.treePanel.select(result.getId(), result.getParentId());
                    CategoryDetailPanel.this.showCategory(result, false);
                }
                CategoryDetailPanel.this.busyIndicator.hide();
            }
        });
    }

    private int getMaxLength(long len) {
        if (len <= 0L) {
            return 1024;
        }
        return (int)len;
    }

    private void removeButtonColumns(Grid grid) {
        int colsToPare = 0;
        for (int i = 0; i < grid.getCellCount(0); ++i) {
            if (!"+".equals(grid.getText(0, i)) && !"-".equals(grid.getText(0, i))) continue;
            ++colsToPare;
        }
        grid.resizeColumns(grid.getColumnCount() - colsToPare);
    }

    private int findWidgetRow(FlexTable table, Widget widget) {
        int row = -1;
        for (int i = 0; i < table.getRowCount(); ++i) {
            HorizontalPanel horizPanel;
            Widget valueWidget = table.getWidget(i, 1);
            if (!(valueWidget instanceof HorizontalPanel) || (horizPanel = (HorizontalPanel)table.getWidget(i, 1)).getWidget(0) == null || !horizPanel.getWidget(0).equals(widget)) continue;
            row = i;
            break;
        }
        return row;
    }

    private static final class FieldLabel
    extends Composite {
        private static final String STYLE_REQUIRED = "nwt-FormContainer-required";
        private final HorizontalPanel panel = new HorizontalPanel();
        private final Label requiredLabel = new LabelWidget();
        private boolean required = false;

        public FieldLabel(Label label, boolean required) {
            this.requiredLabel.setStyleName(STYLE_REQUIRED);
            this.panel.add((Widget)this.requiredLabel);
            this.panel.add((Widget)label);
            this.initWidget((Widget)this.panel);
            this.setRequired(required);
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
            String text = this.required ? "*" : "";
            this.requiredLabel.setText(text);
            String width = this.required ? "10" : "";
            this.panel.setCellWidth((Widget)this.requiredLabel, width);
        }
    }

    class ArgClickHandler
    implements ClickHandler {
        ArgClickHandler() {
        }

        public void onClick(ClickEvent event) {
            ArgButton argButton = (ArgButton)((Object)event.getSource());
            int buttonFunction = argButton.getFunction();
            UIMetadataNode metadataNode = argButton.getMetadataNode();
            if (metadataNode != null) {
                switch (buttonFunction) {
                    case 1: {
                        NewInstanceEntryBox entryBox = new NewInstanceEntryBox(metadataNode);
                        entryBox.handleSaveEvent();
                        break;
                    }
                    case 2: {
                        UICategoryFieldSchema fieldSchema = metadataNode.getSchema();
                        if (fieldSchema != null && fieldSchema.getParent() != null && fieldSchema.getParent().getDisplayType() != null && "Table".equals(fieldSchema.getParent().getDisplayType())) {
                            ArrayList<UIMetadataNode> parentList = new ArrayList<UIMetadataNode>(metadataNode.getParentList());
                            if (parentList == null) break;
                            HashSet<Long> rowvals = new HashSet<Long>();
                            for (UIMetadataNode value : parentList) {
                                rowvals.add(value.getOccNum());
                            }
                            int rowct = rowvals.size();
                            int r = 0;
                            int rowToRemove = -1;
                            for (UIMetadataNode curMetadataNode : parentList) {
                                if (curMetadataNode.getOccNum() != null && curMetadataNode.getOccNum() == metadataNode.getOccNum()) {
                                    CategoryDetailPanel.this.removeNodeFromParent(curMetadataNode, false);
                                    if (rowToRemove < 0) {
                                        rowToRemove = r + 1;
                                    }
                                }
                                if (++r != rowct) continue;
                                r = 0;
                            }
                            UIMetadataNode refNode = (UIMetadataNode)parentList.get(0);
                            Widget entryWidget = (Widget)CategoryDetailPanel.this.valueMap.get(refNode);
                            Widget gridWidget = entryWidget.getParent();
                            Grid grid = (Grid)gridWidget;
                            grid.removeRow(rowToRemove);
                            CategoryDetailPanel.this.removeButtonColumns(grid);
                            UIMetadataNode parentNode = argButton.getParentNode();
                            if (parentNode == null) break;
                            CategoryDetailPanel.this.showAddRemoveButtons(parentNode, CategoryDetailPanel.this.getNodesByFieldName(refNode.getParentList(), "Locale"), grid);
                            break;
                        }
                        CategoryDetailPanel.this.removeNodeFromParent(metadataNode, true);
                        Widget entryWidget = (Widget)CategoryDetailPanel.this.valueMap.get(metadataNode);
                        Widget horizWidget = entryWidget.getParent();
                        Widget fcWidget = horizWidget.getParent();
                        FlexTable flexTable = (FlexTable)fcWidget;
                        int rowToRemove = CategoryDetailPanel.this.findWidgetRow(flexTable, entryWidget);
                        flexTable.removeRow(rowToRemove);
                        CategoryDetailPanel.this.updateAddRemoveButtons(metadataNode.getParentList(), metadataNode.getSchema().getName());
                    }
                }
            }
        }
    }

    class ArgButton
    extends Button {
        public static final int ADD_INSTANCE = 1;
        public static final int DELETE_INSTANCE = 2;
        private int function;
        private UIMetadataNode metadataNode;
        private UIMetadataNode parentNode;

        public ArgButton(String label, int function, UIMetadataNode metadataNode) {
            super(label);
            this.function = -1;
            this.metadataNode = null;
            this.parentNode = null;
            this.function = function;
            this.metadataNode = metadataNode;
        }

        public ArgButton(String label, int function, UIMetadataNode metadataNode, UIMetadataNode parentNode) {
            super(label);
            this.function = -1;
            this.metadataNode = null;
            this.parentNode = null;
            this.function = function;
            this.metadataNode = metadataNode;
            this.parentNode = parentNode;
        }

        public int getFunction() {
            return this.function;
        }

        public UIMetadataNode getMetadataNode() {
            return this.metadataNode;
        }

        public UIMetadataNode getParentNode() {
            return this.parentNode;
        }
    }

    class NewInstanceEntryBox {
        private UIMetadataNode metadataNode = null;

        public NewInstanceEntryBox(UIMetadataNode metadataNode) {
            this.metadataNode = metadataNode;
        }

        public void handleSaveEvent() {
            UIMetadataNode newNode = new UIMetadataNode();
            newNode.setSchema(this.metadataNode.getSchema());
            UIMetadataContent newContent = new UIMetadataContent();
            String displayType = this.metadataNode.getSchema().getDisplayType();
            try {
                if ("Table".equals(displayType)) {
                    List<UICategoryFieldSchema> childrenSchema = this.metadataNode.getSchema().getChildren();
                    Long prevOccNum = 0L;
                    List<UIMetadataNode> parentList = this.metadataNode.getContent().getList();
                    if (parentList.size() > 0) {
                        prevOccNum = parentList.get(parentList.size() - 1).getOccNum();
                    }
                    UIMetadataNode firstChild = this.metadataNode.getContent().getList().get(0);
                    Widget entryWidget = (Widget)CategoryDetailPanel.this.valueMap.get(firstChild);
                    Widget parentWidget = entryWidget.getParent();
                    Grid flexTable = (Grid)parentWidget;
                    int row = flexTable.getRowCount();
                    flexTable.insertRow(row);
                    for (int i = 0; i < 2; ++i) {
                        UICategoryFieldSchema curSchema = childrenSchema.get(i);
                        UIMetadataNode curMetadataNode = new UIMetadataNode();
                        curMetadataNode.setSchema(curSchema);
                        UIMetadataContent curContent = new UIMetadataContent();
                        TextBox curTextBox = new TextBox();
                        curContent.setString(curTextBox.getValue());
                        curMetadataNode.setOccNum(prevOccNum + 1L);
                        curMetadataNode.setContent(curContent);
                        int curIndex = 0;
                        boolean foundLikeName = false;
                        for (UIMetadataNode searchNode : parentList) {
                            if (!foundLikeName && searchNode.getSchema().getName().equals(curSchema.getName())) {
                                foundLikeName = true;
                            } else if (foundLikeName && !searchNode.getSchema().getName().equals(curSchema.getName())) break;
                            ++curIndex;
                        }
                        if (curIndex < parentList.size()) {
                            parentList.add(curIndex, curMetadataNode);
                        } else {
                            parentList.add(curMetadataNode);
                        }
                        curMetadataNode.setParentList(parentList);
                        TextBox valueWidget = new TextBox();
                        valueWidget.setValue((Object)curMetadataNode.getContent().getString());
                        flexTable.setWidget(row, i, (Widget)valueWidget);
                        CategoryDetailPanel.this.valueMap.put(curMetadataNode, valueWidget);
                    }
                    CategoryDetailPanel.this.removeButtonColumns(flexTable);
                    CategoryDetailPanel.this.showAddRemoveButtons(this.metadataNode, CategoryDetailPanel.this.getNodesByFieldName(parentList, "Locale"), flexTable);
                } else {
                    TextBox childrenSchema;
                    if ("Text".equals(displayType)) {
                        childrenSchema = new TextBox();
                    } else if ("TextArea".equals(displayType)) {
                        childrenSchema = new TextArea();
                    } else if ("ComboBox".equals(displayType)) {
                        childrenSchema = new ListBox();
                    } else if ("CheckBox".equals(displayType)) {
                        childrenSchema = new CheckBox();
                    } else if ("DatePicker".equals(displayType)) {
                        childrenSchema = new DateTimeInputWidget(new DatePicker(), null, (DateTimeInputWidget.Format)new CategoryDateFormat(this.metadataNode.getSchema().getValidationRegex()));
                    }
                    newNode.setContent(newContent);
                    newNode.setOccNum(this.metadataNode.getOccNum() + 1L);
                    for (int i = 0; i < this.metadataNode.getParentList().size(); ++i) {
                        if (!this.metadataNode.equals(this.metadataNode.getParentList().get(i))) continue;
                        this.metadataNode.getParentList().add(i + 1, newNode);
                    }
                    newNode.setParentList(this.metadataNode.getParentList());
                    Widget entryWidget = (Widget)CategoryDetailPanel.this.valueMap.get(this.metadataNode);
                    Widget horizWidget = entryWidget.getParent();
                    Widget fcWidget = horizWidget.getParent();
                    FlexTable flexTable = (FlexTable)fcWidget;
                    int row = CategoryDetailPanel.this.findWidgetRow(flexTable, (Widget)CategoryDetailPanel.this.valueMap.get(this.metadataNode)) + 1;
                    flexTable.insertRow(row);
                    LabelWidget label = new LabelWidget(newNode.getSchema().getName());
                    boolean required = this.metadataNode.getSchema().isRequiredCreate() || this.metadataNode.getSchema().getMinOcc() > 0L;
                    FieldLabel fieldLabel = new FieldLabel((Label)label, required);
                    label.setStyleName("nwt-FormContainer-label");
                    Widget valueWidget = CategoryDetailPanel.this.display(newNode);
                    valueWidget.setStyleName("nwt-FormContainer-value");
                    flexTable.setWidget(row, 0, (Widget)fieldLabel);
                    flexTable.setWidget(row, 1, valueWidget);
                    flexTable.getCellFormatter().addStyleName(row, 0, "nwt-FormContainer-label-cell");
                    flexTable.getCellFormatter().addStyleName(row, 1, "nwt-FormContainer-value-cell");
                    HorizontalPanel valuePanel = (HorizontalPanel)valueWidget;
                    Widget valueMapWidget = valuePanel.getWidget(0);
                    CategoryDetailPanel.this.valueMap.put(newNode, valueMapWidget);
                    CategoryDetailPanel.this.updateAddRemoveButtons(this.metadataNode.getParentList(), newNode.getSchema().getName());
                }
            }
            catch (NumberFormatException nfe) {
                Window.alert((String)"Invalid number format");
            }
            catch (IllegalArgumentException iae) {
                Window.alert((String)"Invalid date format");
            }
            catch (Exception e) {
                Window.alert((String)e.getMessage());
            }
        }
    }

    class DisclosurePanelHeader
    extends HorizontalPanel {
        public DisclosurePanelHeader(AbsolutePanel myPanel) {
            this.add((Widget)myPanel);
        }
    }
}

