/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.client;

import com.ericsson.cms.categorymgmt.client.CategoryDetailPanel;
import com.ericsson.cms.categorymgmt.client.TreeResource;
import com.ericsson.cms.categorymgmt.client.i18n.CategoryConstants;
import com.ericsson.cms.categorymgmt.client.model.UICategoryNode;
import com.ericsson.cms.categorymgmt.client.model.UICategoryTreeNode;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryFieldSchemaManagerService;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryFieldSchemaManagerServiceAsync;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryManagerService;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.MenuBarWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CategoryTreePanel
extends TreeWidget
implements IsSerializable {
    private NeptuneSecurity security;
    private TreeItem categoryRoot;
    private CategoryDetailPanel detailView;
    private boolean loaded;
    private final Set<UICategoryTreeNode> openedCategoryNodes = new HashSet<UICategoryTreeNode>();
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final PopupContainer contextMenuContainer = new PopupContainer(true);
    private final ICategoryManagerServiceAsync service = (ICategoryManagerServiceAsync)GWT.create(ICategoryManagerService.class);
    private final ICategoryFieldSchemaManagerServiceAsync metadataService = (ICategoryFieldSchemaManagerServiceAsync)GWT.create(ICategoryFieldSchemaManagerService.class);
    private final CategoryConstants constants = (CategoryConstants)GWT.create(CategoryConstants.class);

    public CategoryTreePanel(NeptuneSecurity security, TreeResource image) {
        super((Tree.Resources)image);
        this.security = security;
        this.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                UICategoryTreeNode nodeData = (UICategoryTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                CategoryTreePanel.this.openedCategoryNodes.add(nodeData);
                TreeItem openedItem = (TreeItem)event.getTarget();
                openedItem.setWidget(CategoryTreeItem.getWidget(nodeData));
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<TreeItem>(){

            public void onClose(CloseEvent<TreeItem> event) {
                UICategoryTreeNode nodeData = (UICategoryTreeNode)((TreeItem)event.getTarget()).getUserObject();
                if (nodeData == null) {
                    return;
                }
                CategoryTreePanel.this.openedCategoryNodes.remove(nodeData);
                TreeItem closedItem = (TreeItem)event.getTarget();
                closedItem.setWidget(CategoryTreeItem.getWidget(nodeData));
            }
        });
        this.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem selectedItem = (TreeItem)event.getSelectedItem();
                UICategoryTreeNode nodeData = (UICategoryTreeNode)selectedItem.getUserObject();
                Long id = 0L;
                if (nodeData != null) {
                    id = nodeData.getId();
                }
                History.newItem((String)CategoryTreePanel.this.buildAnchor(id));
            }
        });
        this.setupContextMenu();
        this.categoryRoot = new CategoryTreeItem(this.constants.labelCategoryTreeRoot());
        this.addItem(this.categoryRoot);
    }

    public void setDetailView(CategoryDetailPanel detailView) {
        this.detailView = detailView;
    }

    private void setupContextMenu() {
        this.addDomHandler((EventHandler)new ContextMenuHandler(){

            public void onContextMenu(ContextMenuEvent event) {
                CategoryTreePanel.this.showContextMenu();
                event.preventDefault();
                event.stopPropagation();
            }
        }, ContextMenuEvent.getType());
    }

    private void showContextMenu() {
        TreeItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        MenuBarWidget menu = new MenuBarWidget(true);
        this.contextMenuContainer.setWidget((Widget)menu);
        boolean hasMenuItems = false;
        if (this.security.isUserInRole("CategoryManager_Create")) {
            hasMenuItems = true;
            menu.addItem(this.constants.contextMenuCreateCategory(), (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    CategoryTreePanel.this.busyIndicator.show();
                    TreeItem selectedItem = CategoryTreePanel.this.getSelectedItem();
                    UICategoryTreeNode treeNode = (UICategoryTreeNode)selectedItem.getUserObject();
                    long parentId = 0L;
                    if (treeNode != null) {
                        parentId = treeNode.getId();
                    }
                    CategoryTreePanel.this.hideContextMenu();
                    CategoryTreePanel.this.metadataService.getDefaultUICategory(parentId, (AsyncCallback<UICategoryNode>)new NeptuneAsyncCallback<UICategoryNode>(){

                        public void onNeptuneFailure(Throwable caught) {
                            CategoryTreePanel.this.busyIndicator.hide();
                            Window.alert((String)("Unable to load Field Schema: " + caught.getMessage()));
                        }

                        public void onNeptuneSuccess(UICategoryNode result) {
                            CategoryTreePanel.this.loaded = true;
                            CategoryTreePanel.this.detailView.showCategory(result, true);
                            long tempId = Long.valueOf("99999");
                            History.newItem((String)CategoryTreePanel.this.buildAnchor(tempId));
                            CategoryTreePanel.this.busyIndicator.hide();
                        }
                    });
                }
            });
        }
        if (this.security.isUserInRole("CategoryManager_Delete") && this.getSelectedItem().getChildCount() == 0 && this.getSelectedItem().getUserObject() != null) {
            hasMenuItems = true;
            menu.addItem(this.constants.contextMenuDeleteCategory(), (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    if (!Window.confirm((String)CategoryTreePanel.this.constants.deleteCategoryConfirmMessage(CategoryTreePanel.this.getSelectedItem().getText()))) {
                        return;
                    }
                    CategoryTreePanel.this.deleteCategory();
                }
            });
        }
        if (hasMenuItems) {
            Widget relativeWidget = selectedItem != null ? selectedItem.getWidget() : this.getItem(0).getWidget();
            this.contextMenuContainer.setPopupPosition(relativeWidget.getAbsoluteLeft(), relativeWidget.getAbsoluteTop() + relativeWidget.getOffsetHeight());
            this.contextMenuContainer.show();
        }
    }

    public void deleteCategory() {
        TreeItem selectedItem = this.getSelectedItem();
        UICategoryTreeNode treeNode = (UICategoryTreeNode)selectedItem.getUserObject();
        long id = 0L;
        long tempId = 0L;
        if (treeNode.getParent() != null) {
            tempId = treeNode.getParent().getId();
        }
        final long parentId = tempId;
        if (treeNode != null) {
            id = treeNode.getId();
        }
        this.hideContextMenu();
        this.service.deleteCategory(id, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                CategoryTreePanel.this.busyIndicator.hide();
                Window.alert((String)caught.getMessage());
            }

            public void onNeptuneSuccess(Boolean result) {
                Window.alert((String)CategoryTreePanel.this.constants.deleteCategorySuccessMessage());
                CategoryTreePanel.this.metadataService.getUICategoryNode(parentId, (AsyncCallback<UICategoryNode>)new NeptuneAsyncCallback<UICategoryNode>(){

                    public void onNeptuneFailure(Throwable caught) {
                        CategoryTreePanel.this.busyIndicator.hide();
                        Window.alert((String)caught.toString());
                        StringBuffer strBuff = new StringBuffer();
                        StackTraceElement[] stackTrace = caught.getStackTrace();
                        for (int i = 0; i < stackTrace.length; ++i) {
                            strBuff.append(stackTrace[i].toString());
                        }
                    }

                    public void onNeptuneSuccess(UICategoryNode result) {
                        CategoryTreePanel.this.loaded = false;
                        long id = result.getId();
                        History.newItem((String)CategoryTreePanel.this.buildAnchor(id));
                        CategoryTreePanel.this.select(parentId, result.getParentId());
                        CategoryTreePanel.this.busyIndicator.hide();
                    }
                });
            }
        });
    }

    private void hideContextMenu() {
        this.contextMenuContainer.hide();
    }

    public void reload(final Long categoryIdToSelect, final Long parentCategoryIdToSelect) {
        this.busyIndicator.center();
        this.service.getCategoryTree((AsyncCallback<List<UICategoryTreeNode>>)new NeptuneAsyncCallback<List<UICategoryTreeNode>>(){

            public void onNeptuneFailure(Throwable caught) {
                CategoryTreePanel.this.busyIndicator.hide();
                Window.alert((String)"Unable to load Category Tree");
            }

            public void onNeptuneSuccess(List<UICategoryTreeNode> result) {
                CategoryTreePanel.this.loaded = true;
                CategoryTreePanel.this.renderTree(result);
                if (categoryIdToSelect != 0L) {
                    CategoryTreePanel.this.selectTreeItem(categoryIdToSelect, parentCategoryIdToSelect);
                } else {
                    CategoryTreePanel.this.selectDefaultCategory();
                }
                CategoryTreePanel.this.busyIndicator.hide();
            }
        });
    }

    public void select(Long categoryIdToSelect, Long parentCategoryIdToSelect) {
        if (!this.loaded) {
            this.reload(categoryIdToSelect, parentCategoryIdToSelect);
        } else if (categoryIdToSelect == 0L) {
            this.clearSelection();
        } else {
            this.selectTreeItem(categoryIdToSelect, parentCategoryIdToSelect);
        }
    }

    private void renderTree(List<UICategoryTreeNode> treeData) {
        this.categoryRoot.removeItems();
        this.addToTreeItem(this.categoryRoot, treeData);
        this.categoryRoot.setState(true);
        Iterator<UICategoryTreeNode> openedCategoryNodeIter = this.openedCategoryNodes.iterator();
        while (openedCategoryNodeIter.hasNext()) {
            UICategoryTreeNode openedSiteNode = openedCategoryNodeIter.next();
            boolean foundAndHasChildren = false;
            Iterator treeItemIterator = this.treeItemIterator();
            while (treeItemIterator.hasNext()) {
                TreeItem treeItem = (TreeItem)treeItemIterator.next();
                if (!openedSiteNode.equals(treeItem.getUserObject())) continue;
                if (treeItem.getChildCount() <= 0) break;
                treeItem.setState(true, false);
                foundAndHasChildren = true;
                break;
            }
            if (foundAndHasChildren) continue;
            openedCategoryNodeIter.remove();
        }
    }

    private void addToTreeItem(TreeItem parentTreeItem, List<UICategoryTreeNode> treeData) {
        for (UICategoryTreeNode nodeData : treeData) {
            CategoryTreeItem treeItem = new CategoryTreeItem(nodeData);
            parentTreeItem.addItem((TreeItem)treeItem);
            if (!nodeData.hasChildren()) continue;
            this.addToTreeItem(treeItem, nodeData.getChildren());
        }
    }

    private void selectTreeItem(long id, Long parentCategoryId) {
        CategoryTreeItem item = null;
        if (parentCategoryId != 0L) {
            CategoryTreeItem parentItem = this.findFirstTreeItemById(parentCategoryId, this.categoryRoot);
            if (parentItem != null) {
                item = this.findFirstTreeItemById(id, parentItem);
            }
        } else {
            item = this.findFirstTreeItemById(id, this.categoryRoot);
        }
        if (item != null) {
            item.getTree().setSelectedItem((TreeItem)item, true);
            item.getTree().ensureSelectedItemVisible();
        }
    }

    private void clearSelection() {
        this.clearSelection(this.categoryRoot);
    }

    private boolean clearSelection(TreeItem item) {
        if (item == null) {
            return false;
        }
        if (item.isSelected()) {
            item.setSelected(false);
            return true;
        }
        if (item.getChildCount() > 0) {
            for (int i = 0; i < item.getChildCount(); ++i) {
                boolean cleared = this.clearSelection(item.getChild(i));
                if (!cleared) continue;
                return true;
            }
        }
        return false;
    }

    private CategoryTreeItem findFirstTreeItemById(long id, TreeItem root) {
        if (root == null) {
            return null;
        }
        UICategoryTreeNode uiNode = (UICategoryTreeNode)root.getUserObject();
        if (root instanceof CategoryTreeItem && uiNode != null && id == uiNode.getId()) {
            return (CategoryTreeItem)root;
        }
        if (root.getChildCount() > 0) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                CategoryTreeItem item = this.findFirstTreeItemById(id, root.getChild(i));
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    private String buildAnchor(long id) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", String.valueOf(id));
        AnchorTokenizer at = new AnchorTokenizer();
        String paramAnchor = at.buildAnchor(paramMap);
        return "CategoryManager.View." + paramAnchor;
    }

    public void selectDefaultCategory() {
        if (this.categoryRoot.getChildCount() > 0) {
            TreeItem child = this.categoryRoot.getChild(0);
            UICategoryTreeNode treeNode = (UICategoryTreeNode)child.getUserObject();
            long id = treeNode.getId();
            this.selectTreeItem(id, 0L);
            this.metadataService.getUICategoryNode(id, (AsyncCallback<UICategoryNode>)new NeptuneAsyncCallback<UICategoryNode>(){

                public void onNeptuneFailure(Throwable caught) {
                    CategoryTreePanel.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(UICategoryNode result) {
                    CategoryTreePanel.this.loaded = true;
                    CategoryTreePanel.this.detailView.showCategory(result, false);
                    CategoryTreePanel.this.busyIndicator.hide();
                }
            });
        }
    }

    private static class CategoryTreeItem
    extends TreeItem {
        private static final String STYLE_TREEITEM = "category-treeItem";
        private static final String STYLE_TREEITEM_SELECTED = "category-treeItem-selected";

        public CategoryTreeItem(String text) {
            super((Widget)new LabelWidget(text));
        }

        public CategoryTreeItem(UICategoryTreeNode nodeData) {
            super(CategoryTreeItem.getWidget(nodeData));
            this.setUserObject(nodeData);
        }

        private static Widget getWidget(UICategoryTreeNode nodeData) {
            HorizontalContainer container = new HorizontalContainer();
            LabelWidget label = new LabelWidget(nodeData.getName());
            container.setSpacing(2);
            container.addStyleName(STYLE_TREEITEM);
            container.add((Widget)label);
            return container;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            if (selected) {
                this.getWidget().addStyleName(STYLE_TREEITEM_SELECTED);
            } else {
                this.getWidget().removeStyleName(STYLE_TREEITEM_SELECTED);
            }
        }
    }
}

