/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.client;

import com.ericsson.cms.categorymgmt.client.CategoryDetailPanel;
import com.ericsson.cms.categorymgmt.client.CategoryHeaderPanel;
import com.ericsson.cms.categorymgmt.client.CategoryTreePanel;
import com.ericsson.cms.categorymgmt.client.TreeResource;
import com.ericsson.cms.categorymgmt.client.validation.CategoryValidationView;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.Iterator;

public class CategoryViewPanel
extends Composite
implements WidgetMenuItem.AnchorChangeListener {
    ResizeableDockLayoutPanel rootPanel;
    private TabPanel tabPanel;
    private final CategoryTreePanel treePanel;
    private final CategoryDetailPanel detailPanel;
    private final CategoryHeaderPanel headerPanel;
    private final FlowPanel buttonPanel;
    private final CategoryValidationView validationView;
    private LabelWidget feedbackLabel;
    private PopupContainer feedbackContainer;
    private VerticalPanel panel = new VerticalPanel();
    private String feedbackMessage;
    private static final String DOWN_ICON = "cms_categorymgmt_ui/images/child-collapseAll-normalState.png";
    private static final String UP_ICON = "cms_categorymgmt_ui/images/child-expandAll-normalState.png";

    public CategoryViewPanel(NeptuneSecurity security) {
        this.rootPanel = new ResizeableDockLayoutPanel(Style.Unit.PX);
        this.headerPanel = new CategoryHeaderPanel();
        this.validationView = new CategoryValidationView(this);
        this.buttonPanel = new FlowPanel();
        TreeResource image = new TreeResource();
        this.treePanel = new CategoryTreePanel(security, image);
        LabelWidget textLabelExpand = new LabelWidget("Expand All");
        textLabelExpand.setStyleName("settings-view-expand-collapse-style");
        textLabelExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CategoryViewPanel.this.treePanel.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        LabelWidget textLabelCollapse = new LabelWidget("Collapse All");
        textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
        textLabelCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CategoryViewPanel.this.treePanel.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgCollapse = new ImageWidget(DOWN_ICON);
        dropDownImgCollapse.setStyleName("drop-arrow-asset-collapse-all");
        dropDownImgCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CategoryViewPanel.this.treePanel.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgExpand = new ImageWidget(UP_ICON);
        dropDownImgExpand.setStyleName("drop-arrow-expand-all");
        dropDownImgExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = CategoryViewPanel.this.treePanel.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.add((Widget)dropDownImgExpand);
        horizontalPanel.add((Widget)textLabelExpand);
        horizontalPanel.add((Widget)dropDownImgCollapse);
        horizontalPanel.add((Widget)textLabelCollapse);
        this.panel.add((Widget)horizontalPanel);
        this.panel.add((Widget)this.treePanel);
        this.detailPanel = new CategoryDetailPanel(this, this.treePanel, this.headerPanel, this.validationView, this.buttonPanel);
        this.buttonPanel.addStyleName("cms_button_container");
        Window.addResizeHandler((ResizeHandler)this.rootPanel);
        this.treePanel.setDetailView(this.detailPanel);
        this.headerPanel.setDetailView(this.detailPanel);
        this.rootPanel.addStyleName("category-root-panel");
        this.layout();
        this.initWidget((Widget)this.rootPanel);
    }

    public void anchorChanged(String anchor) {
        this.validationView.clearMessages();
        this.detailPanel.anchorChanged(anchor);
    }

    protected String getFeedbackMessage() {
        return this.feedbackMessage;
    }

    protected void setFeedbackMessage(String message) {
        this.feedbackMessage = message;
    }

    public void layout() {
        SplitLayoutPanel metadata = new SplitLayoutPanel(4);
        HTMLWidget br = new HTMLWidget("<BR>");
        FlowPanel northPanel = new FlowPanel();
        ScrollPanel treeScroll = new ScrollPanel();
        FlowPanel treeBox = new FlowPanel();
        ScrollPanel dataScroll = new ScrollPanel();
        this.rootPanel.clear();
        long height = Window.getClientHeight() < 400 ? 400L : (long)(Window.getClientHeight() - 125);
        long width = Window.getClientWidth() < 900 ? 900L : (long)(Window.getClientWidth() - 50);
        this.rootPanel.setSize(width + "px", height + "px");
        northPanel.add((Widget)br);
        northPanel.add((Widget)this.headerPanel);
        northPanel.add((Widget)br);
        treeBox.add((Widget)this.panel);
        treeScroll.add((Widget)treeBox);
        dataScroll.add((Widget)this.detailPanel);
        dataScroll.addStyleName("category-metadata-area");
        if (this.validationView.hasErrors()) {
            ScrollPanel validationScroll = new ScrollPanel();
            validationScroll.add((Widget)this.validationView);
            validationScroll.setHeight("100px");
            validationScroll.setWidth("100%");
            metadata.addNorth((Widget)validationScroll, 100.0);
        }
        metadata.addWest((Widget)treeScroll, 275.0);
        metadata.add((Widget)dataScroll);
        metadata.setSize(width - 25L + "px", height - 123L + "px");
        metadata.addStyleName("default-margin");
        treeBox.addStyleName("category-tree-panel");
        treeScroll.addStyleName("category-tree-panel");
        treeScroll.addStyleName("basic-border");
        this.tabPanel = new TabPanel();
        this.tabPanel.add((Widget)metadata, "Metadata");
        this.tabPanel.selectTab(0);
        this.tabPanel.getTabBar().setVisible(false);
        this.tabPanel.getDeckPanel().setStyleName("category-main-panel");
        this.tabPanel.getDeckPanel().addStyleName("null-border");
        this.buttonPanel.setStyleName("cms_button_container");
        this.buttonPanel.addStyleName("float-left");
        this.rootPanel.addNorth((Widget)northPanel, 65.0);
        this.rootPanel.addSouth((Widget)this.buttonPanel, 35.0);
        this.rootPanel.add((Widget)this.tabPanel);
    }

    public void initFeedback() {
        this.feedbackLabel = new LabelWidget("");
        this.feedbackLabel.addStyleName("category-FeedbackLabel");
        this.feedbackContainer = new PopupContainer(true);
        this.feedbackContainer.addStyleName("category-FeedbackPopup");
        this.feedbackContainer.add((Widget)this.feedbackLabel);
        this.feedbackContainer.addAutoHidePartner((Element)this.getElement());
    }

    public void showFeedback() {
        this.feedbackContainer.hide();
        String message = this.getFeedbackMessage();
        if (message != null && !message.isEmpty()) {
            this.feedbackLabel.setText(message);
            this.feedbackContainer.setPopupPositionAndShow((PopupPanel.PositionCallback)new FeedbackPositionCallback());
        }
        this.setFeedbackMessage("");
    }

    public void hideFeedback() {
        if (this.feedbackContainer != null) {
            this.feedbackContainer.hide();
        }
    }

    protected void onUnload() {
        if (this.feedbackContainer != null) {
            this.feedbackContainer.hide();
        }
        super.onUnload();
    }

    public class FeedbackPositionCallback
    implements PopupPanel.PositionCallback {
        public void setPosition(int offsetWidth, int offsetHeight) {
            int top = CategoryViewPanel.this.rootPanel.getAbsoluteTop() + offsetHeight + 40;
            int left = CategoryViewPanel.this.detailPanel.getAbsoluteLeft() + 600 + offsetWidth;
            left = Window.getClientWidth() - CategoryViewPanel.this.feedbackContainer.getOffsetWidth() - 22;
            if (CategoryViewPanel.this.feedbackContainer != null) {
                CategoryViewPanel.this.feedbackContainer.setPopupPosition(left, top);
            }
        }
    }

    private class ResizeableDockLayoutPanel
    extends DockLayoutPanel
    implements ResizeHandler {
        public ResizeableDockLayoutPanel(Style.Unit unit) {
            super(unit);
        }

        public void onResize(ResizeEvent event) {
            CategoryViewPanel.this.layout();
        }
    }
}

