/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.client.validation;

import com.ericsson.cms.categorymgmt.client.CategoryViewPanel;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryMessage;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.List;

public class CategoryValidationView
extends Composite {
    List<UICategoryMessage> categoryMessages = new ArrayList<UICategoryMessage>();
    private final SimpleContainer mainContainer;
    private CategoryViewPanel parent;

    public CategoryValidationView() {
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName("category-ValidationView");
        this.initWidget((Widget)this.mainContainer);
        this.mainContainer.setVisible(false);
    }

    public CategoryValidationView(CategoryViewPanel parent) {
        this.parent = parent;
        this.mainContainer = new SimpleContainer();
        this.mainContainer.addStyleName("category-ValidationView");
        this.initWidget((Widget)this.mainContainer);
        this.mainContainer.setVisible(false);
    }

    public boolean hasErrors() {
        return this.categoryMessages != null && this.categoryMessages.size() > 0;
    }

    public void addValidationMessage(UICategoryMessage exception) {
        this.categoryMessages.add(exception);
    }

    public void clearMessages() {
        this.categoryMessages.clear();
        this.refresh();
    }

    public void refresh() {
        this.setVisible(false);
        FlowPanel messageContainer = new FlowPanel();
        messageContainer.addStyleName("category-root-panel");
        for (UICategoryMessage curMessage : this.categoryMessages) {
            LabelWidget messageLabel = new LabelWidget(curMessage.formatMessage());
            switch (curMessage.getLevel()) {
                case INFO: {
                    messageLabel.addStyleName("category-message-info");
                    break;
                }
                case WARNING: {
                    break;
                }
                case ERROR: {
                    messageLabel.addStyleName("category-message-error");
                }
            }
            messageContainer.add((Widget)messageLabel);
        }
        this.mainContainer.setWidget((Widget)messageContainer);
        this.setVisible(true);
        if (this.parent != null) {
            this.parent.layout();
        }
    }
}

