/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.server;

import com.ericsson.cms.categorymgmt.client.exception.UICategoryManagerException;
import com.ericsson.cms.categorymgmt.client.model.UICategoryFieldSchema;
import com.ericsson.cms.categorymgmt.client.model.UICategoryFieldSchemaDefault;
import com.ericsson.cms.categorymgmt.client.model.UICategoryHyperlink;
import com.ericsson.cms.categorymgmt.client.model.UICategoryNode;
import com.ericsson.cms.categorymgmt.client.model.UIMetadataContent;
import com.ericsson.cms.categorymgmt.client.model.UIMetadataNode;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryFieldSchemaManagerService;
import com.ericsson.cms.categorymgmt.client.validation.UICategoryValidationException;
import com.ericsson.cms.categorymgmt.entity.CatCategory;
import com.ericsson.cms.categorymgmt.entity.CatCategoryMetadata;
import com.ericsson.cms.categorymgmt.entity.CatFieldDefault;
import com.ericsson.cms.categorymgmt.entity.CatFieldSchema;
import com.ericsson.cms.categorymgmt.exception.CategoryManagerException;
import com.ericsson.cms.categorymgmt.exception.DuplicateCategoryException;
import com.ericsson.cms.categorymgmt.exception.ValidationFailedCategoryException;
import com.ericsson.cms.categorymgmt.service.ICategoryFieldSchemaManagerLocal;
import com.ericsson.cms.categorymgmt.service.ICategoryManagerLocal;
import com.ericsson.cms.categorymgmt.service.ICategoryMetadataManagerLocal;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CategoryFieldSchemaManagerServiceImpl
implements ICategoryFieldSchemaManagerService,
NeptuneRemoteService {
    private static final String DATATYPE_SET = "Set";
    private static final String BOOLEAN_TRUE = "T";
    private static final String BOOLEAN_FALSE = "F";
    private static final String DATATYPE_STRING = "String";
    private static final String DATATYPE_STRING_CHOICE = "String Choice";
    private static final String DATATYPE_INTEGER = "Integer";
    private static final String DATATYPE_INTEGER_CHOICE = "Number Choice";
    private static final String DATATYPE_DECIMAL = "Decimal";
    private static final String DATATYPE_DATETIMEZONE = "DateTimeZone";
    private static final String DATATYPE_IMAGE = "Image";
    private static final String DATATYPE_BOOLEAN = "Boolean";
    private static final Logger logger = Logger.getLogger(CategoryFieldSchemaManagerServiceImpl.class);
    private final ICategoryMetadataManagerLocal metadataManager = (ICategoryMetadataManagerLocal)InjectionUtil.injectInstance((String)"cms/CategoryMetadataManager/local", ICategoryMetadataManagerLocal.class);
    private final ICategoryFieldSchemaManagerLocal schemaManager = (ICategoryFieldSchemaManagerLocal)InjectionUtil.injectInstance((String)"cms/CategoryFieldSchemaManager/local", ICategoryFieldSchemaManagerLocal.class);
    private final ICategoryManagerLocal categoryManager = (ICategoryManagerLocal)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManagerLocal.class);

    public String getRelativePath() {
        return "service/category/categoryFieldSchemaManagerService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UICategoryFieldSchema> getCategoryFieldSchema() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"CategoryManager_View"});
        ArrayList<UICategoryFieldSchema> uiCategoryFieldSchema = new ArrayList<UICategoryFieldSchema>();
        List fieldSchema = this.schemaManager.getCategoryFieldSchema();
        if (fieldSchema != null) {
            for (CatFieldSchema fields : fieldSchema) {
                uiCategoryFieldSchema.add(this.convertToUICategoryFieldSchema(fields));
            }
        }
        return uiCategoryFieldSchema;
    }

    @Override
    public UICategoryNode getDefaultUICategory(Long parentId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"CategoryManager_Create"});
        return this.convertToUICategoryNode(this.getDefaultCategory(parentId));
    }

    private CatCategory getDefaultCategory(Long parentId) {
        CatCategory parent = null;
        parent = parentId == null ? this.categoryManager.getRootCategory() : this.categoryManager.getCategory(parentId);
        CatCategory child = this.categoryManager.getDefaultCategory();
        child.setParentId(parent.getId());
        child.setParent(parent);
        if (parent.getChildren() != null) {
            parent.getChildren().add(child);
        }
        return child;
    }

    @Override
    public UICategoryNode getUICategoryNode(Long categoryId) throws NeptuneException {
        UICategoryNode node = new UICategoryNode();
        if (categoryId != null) {
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"CategoryManager_View"});
            CatCategory category = this.getCategory(categoryId);
            node = this.convertToUICategoryNode(category);
        }
        return node;
    }

    private List<CatCategoryMetadata> toList(Set<CatCategoryMetadata> set) {
        ArrayList<CatCategoryMetadata> list = new ArrayList<CatCategoryMetadata>();
        list.addAll(set);
        logger.debug((Object)("toList(): list.size()=" + list.size() + " set.size()=" + set.size()));
        return list;
    }

    private Set<CatCategoryMetadata> toSet(List<CatCategoryMetadata> list) {
        TreeSet<CatCategoryMetadata> set = new TreeSet<CatCategoryMetadata>();
        set.addAll(list);
        logger.debug((Object)("toSet(): list.size()=" + list.size() + " set.size()=" + set.size()));
        return set;
    }

    private String toString(CatFieldSchema s) {
        StringBuffer sb = new StringBuffer();
        sb.append(" getId=" + s.getId());
        sb.append(" getName=" + s.getName());
        sb.append(" getDataType=" + s.getDataType());
        sb.append(" getDisplayType=" + s.getDisplayType());
        sb.append(" getMinOcc=" + s.getMinOcc());
        sb.append(" getMaxOcc=" + s.getMaxOcc());
        sb.append(" getIsEnabled=" + s.getIsEnabled());
        sb.append(" getIsUnique=" + s.getIsUnique());
        sb.append(" getRequiredCreate=" + s.getRequiredCreate());
        sb.append(" getRequiredExport=" + s.getRequiredExport());
        sb.append(" getValidationRegex=" + s.getValidationRegex());
        sb.append(" getMinLen=" + s.getMinLen());
        sb.append(" getMaxLen=" + s.getMaxLen());
        return sb.toString();
    }

    private UICategoryNode convertToUICategoryNode(CatCategory category) {
        if (category == null) {
            return null;
        }
        UICategoryNode node = new UICategoryNode();
        node.setId(category.getId());
        node.setName(category.getName());
        node.setHyperlinks(this.getHyperlinks(category));
        node.setParentId(category.getParentId());
        node.setInternalVersion(category.getInternalVersion());
        if (category.getParent() != null && category.getParent().getChildren() != null) {
            ArrayList<String> siblings = new ArrayList<String>();
            for (CatCategory sibling : category.getParent().getChildren()) {
                siblings.add(sibling.getName());
            }
            node.setSiblings(siblings);
        }
        if (category.getAssociatedCategoryPackage() != null) {
            node.setAssociateCatPackageId(category.getAssociatedCategoryPackage());
        }
        List schema = this.schemaManager.getCategoryFieldSchema();
        Set metadata = category.getCatCategoryMetadata();
        if (schema != null) {
            ArrayList<UIMetadataNode> uiMetadata = new ArrayList<UIMetadataNode>();
            Map<Long, List<CatCategoryMetadata>> metadataHash = this.hashFields(this.toList(metadata));
            for (CatFieldSchema s : schema) {
                List<UIMetadataNode> uiNodes = this.convertToUIMetadataNode(s, metadataHash);
                uiMetadata.addAll(uiNodes);
            }
            node.setMetadata(uiMetadata);
        }
        return node;
    }

    private UICategoryFieldSchema convertToUICategoryFieldSchema(CatFieldSchema category) {
        UICategoryFieldSchema uiNode = new UICategoryFieldSchema();
        logger.debug((Object)("->convertToUICategoryFieldSchema(" + this.toString(category) + ")"));
        uiNode.setId(category.getId());
        uiNode.setName(category.getName());
        uiNode.setDataType(category.getDataType());
        uiNode.setDisplayType(category.getDisplayType());
        uiNode.setMinOcc(this.longOf(category.getMinOcc()));
        uiNode.setMaxOcc(this.longOf(category.getMaxOcc()));
        uiNode.setEnabled(this.boolOf(category.getIsEnabled()));
        uiNode.setUnique(this.boolOf(category.getIsUnique()));
        uiNode.setRequiredCreate(this.boolOf(category.getRequiredCreate()));
        uiNode.setRequiredExport(this.boolOf(category.getRequiredExport()));
        if (DATATYPE_DATETIMEZONE.equals(category.getDataType())) {
            uiNode.setValidationRegex(this.dateFormat(category.getValidationRegex()));
        } else {
            uiNode.setValidationRegex(category.getValidationRegex());
        }
        uiNode.setMinLen(this.longOf(category.getMinLen()));
        uiNode.setMaxLen(this.longOf(category.getMaxLen()));
        if (category.getChildren() != null) {
            for (CatFieldSchema childCategory : category.getChildren()) {
                if (category.getId() == childCategory.getId()) continue;
                uiNode.addChild(this.convertToUICategoryFieldSchema(childCategory));
            }
        }
        if (category.getCatFieldDefaults() != null) {
            ArrayList<UICategoryFieldSchemaDefault> defaults = new ArrayList<UICategoryFieldSchemaDefault>();
            uiNode.setDefaults(defaults);
            for (CatFieldDefault fd : category.getCatFieldDefaults()) {
                defaults.add(this.convertToUICategoryFieldSchemaDefault(fd));
            }
        }
        logger.debug((Object)("<-uiNode=" + uiNode.toString()));
        return uiNode;
    }

    private UICategoryFieldSchemaDefault convertToUICategoryFieldSchemaDefault(CatFieldDefault fd) {
        UICategoryFieldSchemaDefault uiDefault = new UICategoryFieldSchemaDefault();
        uiDefault.setId(fd.getId());
        if (fd.getCatFieldSchema() != null) {
            uiDefault.setFieldId(fd.getCatFieldSchema().getId());
        }
        uiDefault.setDefault(BOOLEAN_TRUE.equals(fd.getIsDefault()));
        uiDefault.setKeyValue(fd.getKeyValue());
        uiDefault.setStringValue(fd.getStringValue());
        uiDefault.setNumberValue(fd.getNumberValue());
        uiDefault.setDateValue(this.toString(fd.getDateValue(), this.dateFormat(fd.getCatFieldSchema().getValidationRegex())));
        uiDefault.setImageValue(fd.getImageValue());
        return uiDefault;
    }

    private List<UIMetadataNode> convertToUIMetadataNode(CatFieldSchema schemaNode, Map<Long, List<CatCategoryMetadata>> metadata) {
        logger.debug((Object)("convertToUIMetadataNode(" + schemaNode + ", " + metadata + ")"));
        ArrayList<UIMetadataNode> result = new ArrayList<UIMetadataNode>();
        if (schemaNode != null && BOOLEAN_TRUE.equals(schemaNode.getIsEnabled())) {
            UICategoryFieldSchema uiSchema = this.convertToUICategoryFieldSchema(schemaNode);
            String type = schemaNode.getDataType();
            Long fieldId = schemaNode.getId();
            if (DATATYPE_SET.equals(type)) {
                UIMetadataNode node = new UIMetadataNode();
                node.setSchema(uiSchema);
                ArrayList<UIMetadataNode> content = new ArrayList<UIMetadataNode>();
                Set children = schemaNode.getChildren();
                if (children != null) {
                    for (CatFieldSchema s : children) {
                        List<UIMetadataNode> list = this.convertToUIMetadataNode(s, metadata);
                        if (list == null) continue;
                        content.addAll(list);
                    }
                }
                node.setContent(new UIMetadataContent());
                for (UIMetadataNode curNode : content) {
                    curNode.setParentList(content);
                }
                node.getContent().setList(content);
                result.add(node);
            } else {
                long maxOcc;
                long minOcc = schemaNode.getMinOcc() == null ? 0L : schemaNode.getMinOcc();
                long l = maxOcc = schemaNode.getMaxOcc() == null ? 0L : schemaNode.getMaxOcc();
                int avail = metadata == null ? 0 : (metadata.get(fieldId) == null ? 0 : metadata.get(fieldId).size());
                ArrayList<CatCategoryMetadata> values = null;
                if (avail > 0) {
                    values = new ArrayList<CatCategoryMetadata>();
                    for (CatCategoryMetadata md : metadata.get(fieldId)) {
                        if (!md.hasValue()) continue;
                        values.add(md);
                    }
                    Collections.sort(values);
                    avail = values.size();
                }
                CatCategoryMetadata item = null;
                int i = 0;
                while (maxOcc == 0L || (long)i < maxOcc) {
                    item = null;
                    try {
                        item = (CatCategoryMetadata)values.get(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (item == null && i != 0 && (minOcc <= 0L || (long)i >= minOcc)) break;
                    UIMetadataNode node = this.uiMetadataNode(uiSchema);
                    node.setOccNum((long)i + 1L);
                    if (item != null) {
                        node.setId(item.getId());
                        node.setOccNum((long)i + 1L);
                        if (DATATYPE_STRING.equals(type) || DATATYPE_STRING_CHOICE.equals(type)) {
                            node.getContent().setString(item.getStringValue());
                        } else if (DATATYPE_INTEGER.equals(type) || DATATYPE_INTEGER_CHOICE.equals(type)) {
                            BigDecimal numberValue = item.getNumberValue();
                            if (numberValue != null) {
                                node.getContent().setNumber(item.getNumberValue().longValueExact());
                            }
                        } else if (DATATYPE_DATETIMEZONE.equals(type)) {
                            node.getContent().setDate(item.getDateValue());
                        } else if (DATATYPE_BOOLEAN.equals(type)) {
                            node.getContent().setBoolean(item.getStringValue());
                        } else if (DATATYPE_DECIMAL.equals(type)) {
                            node.getContent().setNumber(item.getNumberValue());
                        } else if (DATATYPE_IMAGE.equals(type)) {
                            node.getContent().setImage(item.getImageValue());
                        }
                    }
                    result.add(node);
                    ++i;
                }
            }
        }
        logger.debug(result);
        return result;
    }

    private String toString(Date value, String format) {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (value != null) {
            if (format != null) {
                sdf.applyPattern(format);
            } else {
                sdf.applyPattern("yyyy-MM-dd");
            }
            result = sdf.format(value);
        }
        return result;
    }

    private Map<Long, List<CatCategoryMetadata>> hashFields(List<CatCategoryMetadata> metadata) {
        HashMap<Long, ArrayList<CatCategoryMetadata>> result = null;
        if (metadata != null) {
            result = new HashMap<Long, ArrayList<CatCategoryMetadata>>();
            for (CatCategoryMetadata m : metadata) {
                Long fieldId = m.getFieldId();
                ArrayList<CatCategoryMetadata> field = (ArrayList<CatCategoryMetadata>)result.get(fieldId);
                if (field == null) {
                    field = new ArrayList<CatCategoryMetadata>();
                    result.put(fieldId, field);
                }
                field.add(m);
            }
        }
        return result;
    }

    private long longOf(Long l) {
        return l == null ? 0L : l;
    }

    private boolean boolOf(String s) {
        return BOOLEAN_TRUE.equals(s);
    }

    private CatCategory getCategory(Long categoryId) {
        CatCategory result = this.categoryManager.getCategory(categoryId);
        if (result != null) {
            result.setCatCategoryMetadata(this.toSet(this.metadataManager.getCategoryMetadata(categoryId)));
        }
        return result;
    }

    private List<UICategoryHyperlink> getHyperlinks(CatCategory category) {
        ArrayList<UICategoryHyperlink> hyperlinks = new ArrayList<UICategoryHyperlink>();
        for (CatCategory parent = category.getParent(); parent != null && parent.getId() != null && parent.getId() != 0L; parent = parent.getParent()) {
            UICategoryHyperlink link = new UICategoryHyperlink();
            link.setId(parent.getId());
            link.setName(parent.getName());
            hyperlinks.add(link);
        }
        Collections.reverse(hyperlinks);
        return hyperlinks;
    }

    private UIMetadataNode uiMetadataNode(UICategoryFieldSchema uiSchema) {
        UIMetadataNode node = new UIMetadataNode();
        node.setSchema(uiSchema);
        node.setContent(new UIMetadataContent());
        return node;
    }

    @Override
    public Long saveCategory(UICategoryNode categoryNode, boolean newCategory) throws UICategoryValidationException, UICategoryManagerException {
        Long id = -1L;
        CatCategory category = null;
        CatCategory parent = null;
        try {
            category = this.convertToCategory(categoryNode);
            category = this.removeEmptyFields(category);
            if (category.getParentId() != null && category.getParentId() > 0L) {
                parent = this.categoryManager.getCategory(category.getParentId());
                category.setParent(parent);
                if (newCategory && this.categoryManager.isCategoryExists(category.getPath())) {
                    throw new DuplicateCategoryException();
                }
            } else {
                if (newCategory && this.categoryManager.isCategoryExists(categoryNode.getName())) {
                    throw new DuplicateCategoryException();
                }
                parent = this.categoryManager.getRootCategory();
                category.setParent(parent);
            }
            if (newCategory) {
                this.categoryManager.createCategory(category);
            } else {
                this.categoryManager.updateCategory(category);
            }
            id = category.getId();
        }
        catch (DuplicateCategoryException dce) {
            String err = "Category already exists: '" + (parent == null ? category.getName() : category.getPath()) + "'";
            logger.error((Object)err, (Throwable)dce);
            throw new UICategoryValidationException(categoryNode.getName(), err);
        }
        catch (ValidationFailedCategoryException vfce) {
            logger.error((Object)vfce.toString(), (Throwable)vfce);
            throw this.convertToUICategoryValidationException(vfce);
        }
        catch (CategoryManagerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new UICategoryManagerException(e);
        }
        return id;
    }

    private UICategoryValidationException convertToUICategoryValidationException(ValidationFailedCategoryException vfce) {
        UICategoryValidationException result = new UICategoryValidationException(vfce.getField(), vfce.getMessage(), vfce);
        if (vfce.getChildren() != null) {
            result.setChildren(new ArrayList<UICategoryValidationException>());
            for (ValidationFailedCategoryException child : vfce.getChildren()) {
                result.getChildren().add(this.convertToUICategoryValidationException(child));
            }
        }
        return result;
    }

    private CatCategory removeEmptyFields(CatCategory category) {
        Set metadataList = category.getCatCategoryMetadata();
        for (CatCategoryMetadata curMetadata : new TreeSet(metadataList)) {
            if (curMetadata.hasValue()) continue;
            metadataList.remove(curMetadata);
        }
        return category;
    }

    private CatCategory convertToCategory(UICategoryNode categoryNode) {
        CatCategory category = new CatCategory();
        if (categoryNode.getId() != null && categoryNode.getId() > 0L) {
            category.setId(categoryNode.getId());
        }
        category.setName(categoryNode.getName());
        category.setParentId(categoryNode.getParentId());
        category.setInternalVersion(categoryNode.getInternalVersion());
        if ("Not Associated".equals(categoryNode.getAssociateCatPackageId())) {
            category.setAssociatedCategoryPackage(Long.valueOf(categoryNode.getAssociateCatPackageId()));
        }
        category.setCatCategoryMetadata(this.convertToCategoryMetadata(category, categoryNode.getMetadata()));
        return category;
    }

    private Set<CatCategoryMetadata> convertToCategoryMetadata(CatCategory category, List<UIMetadataNode> metadataList) {
        TreeSet<CatCategoryMetadata> categoryMetadataSet = new TreeSet<CatCategoryMetadata>();
        if (metadataList != null) {
            for (UIMetadataNode curMetadataNode : metadataList) {
                UICategoryFieldSchema schema = curMetadataNode.getSchema();
                UIMetadataContent content = curMetadataNode.getContent();
                String type = schema.getDataType();
                long fieldId = schema.getId();
                if (DATATYPE_SET.equals(schema.getDataType())) {
                    categoryMetadataSet.addAll(this.convertToCategoryMetadata(category, content.getList()));
                    continue;
                }
                CatCategoryMetadata categoryMetadata = null;
                if (DATATYPE_STRING.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getString());
                } else if (DATATYPE_STRING_CHOICE.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getString());
                } else if (DATATYPE_INTEGER.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getLong());
                } else if (DATATYPE_INTEGER_CHOICE.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getLong());
                } else if (DATATYPE_DECIMAL.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getDouble());
                } else if (DATATYPE_DATETIMEZONE.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getDate());
                } else if (DATATYPE_IMAGE.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getImage());
                } else if (DATATYPE_BOOLEAN.equals(type)) {
                    categoryMetadata = this.getMetadata(content.getBoolean());
                }
                if (categoryMetadata == null) continue;
                Long id = curMetadataNode.getId();
                Long occNum = curMetadataNode.getOccNum();
                categoryMetadata.setCatCategory(category);
                categoryMetadata.setFieldId(Long.valueOf(fieldId));
                if (id != null) {
                    categoryMetadata.setId(id.longValue());
                }
                if (occNum != null) {
                    categoryMetadata.setOccNum(occNum);
                }
                categoryMetadataSet.add(categoryMetadata);
            }
        }
        return categoryMetadataSet;
    }

    private CatCategoryMetadata getMetadata(Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            return this.getMetadata(BOOLEAN_TRUE);
        }
        return this.getMetadata(BOOLEAN_FALSE);
    }

    private CatCategoryMetadata getMetadata(byte[] value) {
        CatCategoryMetadata result = null;
        if (value != null) {
            result = new CatCategoryMetadata();
            result.setImageValue(value);
        }
        return result;
    }

    private CatCategoryMetadata getMetadata(Date value) {
        CatCategoryMetadata result = null;
        if (value != null) {
            result = new CatCategoryMetadata();
            result.setDateValue(value);
        }
        return result;
    }

    private CatCategoryMetadata getMetadata(Long value) {
        CatCategoryMetadata result = null;
        if (value != null) {
            result = new CatCategoryMetadata();
            result.setNumberValue(BigDecimal.valueOf(value));
        }
        return result;
    }

    private CatCategoryMetadata getMetadata(Double value) {
        CatCategoryMetadata result = null;
        if (value != null) {
            result = new CatCategoryMetadata();
            result.setNumberValue(BigDecimal.valueOf(value));
        }
        return result;
    }

    private CatCategoryMetadata getMetadata(String value) {
        CatCategoryMetadata result = null;
        if (value != null) {
            result = new CatCategoryMetadata();
            result.setStringValue(value);
        }
        return result;
    }

    private String dateFormat(String regex) {
        return regex == null ? "yyyy-MM-dd" : regex;
    }
}

