/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.categorymgmt.server;

import com.ericsson.cms.categorymgmt.client.exception.UICategoryManagerException;
import com.ericsson.cms.categorymgmt.client.model.UICategoryTreeNode;
import com.ericsson.cms.categorymgmt.client.rpc.ICategoryManagerService;
import com.ericsson.cms.categorymgmt.entity.CatCategory;
import com.ericsson.cms.categorymgmt.exception.CategoryManagerException;
import com.ericsson.cms.categorymgmt.server.util.UIPropertyReader;
import com.ericsson.cms.categorymgmt.service.ICategoryManagerLocal;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CategoryManagerServiceImpl
implements ICategoryManagerService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(CategoryManagerServiceImpl.class);
    private final ICategoryManagerLocal categoryManager = (ICategoryManagerLocal)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManagerLocal.class);
    private static final int DEFAULT_CATEGORYNAME_LENGTH = 25;
    private static final String CATEGORYTREE_CATEGORYNAME_DISPLAY_LENGTH_KEY = "CategoryTree.CategoryName.Display.Length";
    private static int categoryNameDisplayLength = 0;

    public String getRelativePath() {
        return "service/category/categoryManagerService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UICategoryTreeNode> getCategoryTree() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"CategoryManager_View"});
        ArrayList<UICategoryTreeNode> tree = new ArrayList<UICategoryTreeNode>();
        List topLevelCategories = this.categoryManager.getCategoryTree();
        categoryNameDisplayLength = this.getCategoryNameDisplayLength();
        logger.debug((Object)("CategoryName Display Length: " + categoryNameDisplayLength));
        if (topLevelCategories != null) {
            for (CatCategory category : topLevelCategories) {
                if (category.getId() == null) continue;
                tree.add(this.convertToUICategoryTreeNode(category));
            }
        }
        return tree;
    }

    private UICategoryTreeNode convertToUICategoryTreeNode(CatCategory category) {
        UICategoryTreeNode uiNode = new UICategoryTreeNode();
        uiNode.setId(category.getId());
        String name = category.getName();
        if (!name.isEmpty() && name.length() > categoryNameDisplayLength) {
            name = name.substring(0, categoryNameDisplayLength) + "...";
        }
        uiNode.setName(name);
        if (category.getChildren() != null) {
            for (CatCategory childCategory : category.getChildren()) {
                uiNode.addChild(this.convertToUICategoryTreeNode(childCategory));
            }
        }
        return uiNode;
    }

    private int getCategoryNameDisplayLength() {
        UIPropertyReader reader = new UIPropertyReader();
        String lenStr = reader.getInfo().get(CATEGORYTREE_CATEGORYNAME_DISPLAY_LENGTH_KEY);
        try {
            int len = Integer.parseInt(lenStr.trim());
            if (len <= 0) {
                return 25;
            }
            return len;
        }
        catch (Exception ex) {
            return 25;
        }
    }

    @Override
    public boolean deleteCategory(Long id) throws NeptuneException, UICategoryManagerException {
        try {
            this.categoryManager.remove(id.longValue());
        }
        catch (CategoryManagerException cme) {
            throw new UICategoryManagerException(cme.getMessage());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean isAssociatedTitleStillExists(Long associatedTitleId) throws NeptuneException {
        return this.categoryManager.isAssociatedTitleStillExists(associatedTitleId);
    }
}

