package com.tandbergtv.cms.pmm.client.uiservices;

import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;

/**
 * Any messages that need to be passed on to the ui after titles are added to
 * the given schedule.
 * 
 * @author spuranik
 * 
 */
public class AddTitleResult implements IOperationResult {

	private String message;
	private long scheduleId;
	private String spec;

	AddTitleResult(String message, long scheduleId, String spec) {
		this.message = message;
		this.scheduleId = scheduleId;
		this.spec = spec;
	}

	public String getMessage() {
		return message;
	}

	/**
	 * @return the scheduleId
	 */
	public long getScheduleId() {
		return scheduleId;
	}

	/**
	 * @return the spec
	 */
	public String getSpec() {
		return spec;
	}	
}
