package com.tandbergtv.cms.pmm.client.uiservices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.pmm.client.IScheduleService;
import com.tandbergtv.cms.pmm.client.IScheduleServiceAsync;
import com.tandbergtv.cms.pmm.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

public class AddTitlesToSchedule implements ITitleService {

	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private final BusyIndicator busyIndicator = new BusyIndicator();
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}
	
	public void execute(final List<Long> titleIds, String serviceParameter, IActionInput input,
			final AsyncCallback<IOperationResult> callback) {
		final TitleActionInput actionInput = (TitleActionInput) input;
		// schedule is required for this operation
		if (actionInput.getScheduleId() == 0) {
			callback.onFailure(new RuntimeException(displayConstants.scheduleRequiredFailure()));
			return;
		}

		// add the selected title to the given schedule in the backend.
		IScheduleServiceAsync service = GWT.create(IScheduleService.class);
		busyIndicator.show();
		service.addTitlesToSchedule(actionInput.getScheduleId(), titleIds,
				new NeptuneAsyncCallback<Void>() {
					public void onNeptuneFailure(Throwable caught) {
						if(caught instanceof TitleScheduleValidation) {
							setScheduleValidationErrorMessage(caught);
						} else if(caught instanceof ScheduleException) {
							setScheduleErrorMessage(caught);
						}
						busyIndicator.hide();
						callback.onFailure(caught);
					}

					public void onNeptuneSuccess(Void result) {
						busyIndicator.hide();
						callback.onSuccess(new AddTitleResult(
								prepareSuccessMessage(), actionInput.getScheduleId(), 
								actionInput.getSpec()));
					}

					private String prepareSuccessMessage() {
						StringBuilder sb = new StringBuilder();
						for (Long id : titleIds) {
							if (sb.length() > 0) {
								sb.append(",");
							}
							sb.append(id);
						}
						return displayConstants.addTitlesServiceSuccess0()
								+ sb.toString()
								+ displayConstants.addTitlesServiceSuccess1()
								+ actionInput.getScheduleId();
					}
				});
	}

	/**
	 * Prepares the error message if the exception is a schedule validation exception
	 * 
	 * @param caught
	 */
	private void setScheduleValidationErrorMessage(Throwable caught) {
		TitleScheduleValidation exception = (TitleScheduleValidation)caught;
		StringBuilder sb = new StringBuilder();
		for(String code : exception.getErrorCodes()) {
			if(sb.length() > 0) {
				sb.append("\n");
			}
			sb.append(displayConstants.getString(code));
		}
		exception.setMessage(displayConstants.addTitlesServiceScheduleFailure() + sb.toString());
	}
	
	/**
	 * Sets the error message for a schedule related exception.
	 * 
	 * @param caught
	 */
	private void setScheduleErrorMessage(Throwable caught) {
		ScheduleException exception = (ScheduleException)caught;
		try{
			exception.setMessage(displayConstants.addTitlesServiceScheduleFailure()
				+ displayConstants.getString(exception.getErrorCode()));
		}
		catch(MissingResourceException ex){
			exception.setMessage(exception.getMessage());
		}
	}
		
	public String getDescription() {
		return displayConstants.addTitlesServiceDescription();
	}

	public String getName() {
		return displayConstants.addTitlesServiceName();
	}

	public void gotoResultPage(IOperationResult result, IView sourceView) {
		// ?scheduleId= is an understanding between the content management and trafficking component
		History.newItem("PMM.Schedule?scheduleId="
				+ ((AddTitleResult) result).getScheduleId() + "&spec="
				+ ((AddTitleResult) result).getSpec());
	}

	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		return inputData.getScheduleId() == 0 ? false : true;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
