/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponentConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassLazyView;
import com.tandbergtv.cms.portal.content.client.customfield.view.CustomFieldLazyView;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.lookupkey.view.LookupKeysListPanel;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortlet;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ActivityPortletConfig;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsageMonitor;
import com.tandbergtv.cms.portal.content.client.portlet.cmsusage.CMSUsageMonitorConfig;
import com.tandbergtv.cms.portal.content.client.portlet.modified.LastModifiedPortlet;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.title.AddTitlesToOffer;
import com.tandbergtv.cms.portal.content.client.services.title.BulkEditService;
import com.tandbergtv.cms.portal.content.client.services.title.DeleteService;
import com.tandbergtv.cms.portal.content.client.services.title.Distribute;
import com.tandbergtv.cms.portal.content.client.services.title.RunNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.services.title.RunSiteTemplate;
import com.tandbergtv.cms.portal.content.client.services.title.RunTemplate;
import com.tandbergtv.cms.portal.content.client.services.title.SatellitePitchBottom;
import com.tandbergtv.cms.portal.content.client.services.title.SatellitePitchTop;
import com.tandbergtv.cms.portal.content.client.services.title.TargetSites;
import com.tandbergtv.cms.portal.content.client.services.title.TerrestrialPitchBottom;
import com.tandbergtv.cms.portal.content.client.services.title.TerrestrialPitchTop;
import com.tandbergtv.cms.portal.content.client.services.title.TitleSearchResultsExportService;
import com.tandbergtv.cms.portal.content.client.services.titleprogress.TitleProgressService;
import com.tandbergtv.cms.portal.content.client.tab.create.ContentCreateLazyView;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchWidgetFactory;
import com.tandbergtv.cms.portal.content.client.title.model.UITitleMetadataPluginsSyncedResult;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ContentComponent
extends ComponentBase {
    public static final String COMPONENT_NAME = "Content Management";
    private static final String VIDEO_PREVIEW_LIC_KEY = "VideoPreviewLicense";
    private static final String CATEGORY_MANAGER_LIC_KEY = "CategoryManagerLicense";
    private static final String METADATA_ENHANCEMENT_LIC_KEY = "MetadataEnhancementLicense";
    private String spec = "";
    private Integer titleHistoryRefreshRate = null;
    private Integer titleSitesRefreshRate = null;
    private Boolean sitesFeatureActive = null;
    private List<String> imageAssetTypes = new ArrayList<String>();
    private List<String> videoAssetTypes = new ArrayList<String>();
    private boolean licensedForVideoPreview;
    private boolean licensedForCategoryManagement;
    private boolean licensedForMetadataEnhancement;
    private IPitchScheduleServiceAsync pitchService;
    private ITitleViewServiceAsync titleService;
    private final ContentComponentConstants constants = (ContentComponentConstants)GWT.create(ContentComponentConstants.class);
    private final ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);
    private Boolean hasMPWithTracking = false;
    private Boolean providerIdCaseSensitive = true;

    public ContentComponent() {
        this.pitchService = (IPitchScheduleServiceAsync)GWT.create(IPitchScheduleService.class);
        this.titleService = (ITitleViewServiceAsync)GWT.create(ITitleViewService.class);
    }

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.setPitchScheduleOptions();
        this.spec = info.get("ContentComponent.Specification");
        this.titleHistoryRefreshRate = this.getIntegerValue("ContentComponent.TitleView.HistoryRefreshRate");
        this.titleSitesRefreshRate = this.getIntegerValue("ContentComponent.TitleView.SitesRefreshRate");
        this.sitesFeatureActive = this.getBooleanValue("ContentComponent.SitesFeatureActive");
        try {
            String strImageAssetTypes = info.get("ContentComponent.imageAssetTypes");
            String[] imageAssetTypesArray = strImageAssetTypes.split(",");
            this.imageAssetTypes = Arrays.asList(imageAssetTypesArray);
            String strVideoAssetTypes = info.get("ContentComponent.videoAssetTypes");
            String[] videoAssetTypesArray = strVideoAssetTypes.split(",");
            this.videoAssetTypes = Arrays.asList(videoAssetTypesArray);
        }
        catch (Exception ex) {
            GWT.log((String)"Unable to get image and video asset types", (Throwable)ex);
        }
        this.licensedForVideoPreview = this.getBooleanValue(VIDEO_PREVIEW_LIC_KEY);
        this.licensedForCategoryManagement = this.getBooleanValue(CATEGORY_MANAGER_LIC_KEY);
        this.licensedForMetadataEnhancement = this.getBooleanValue(METADATA_ENHANCEMENT_LIC_KEY);
        this.providerIdCaseSensitive = this.getBooleanValue("ContentComponent.TitleView.ProviderIdCaseSensitive");
        this.checkSpecIdentifiers();
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
            ActivityPortletConfig apConfig = new ActivityPortletConfig();
            apConfig.setRefreshRateSecs(this.getRefreshRate(this.info));
            apConfig.setRecordCount(this.getActivityPortletRecordCount(this.info));
            ActivityPortlet portlet = new ActivityPortlet(security, apConfig);
            portletFactories.add(new GenericPortletFactory(portlet, this));
            portletFactories.add(this.addLastModifiedPortlet(security, this.info, this.getRefreshRate(this.info)));
            portletFactories.add(this.addCMSUsagePortlet(security, this.info, this.getRefreshRate(this.info)));
        }
        return portletFactories;
    }

    private GenericPortletFactory addLastModifiedPortlet(NeptuneSecurity security, Map<String, String> info, int refresh) {
        LastModifiedPortlet portlet = new LastModifiedPortlet(security, info, refresh);
        return new GenericPortletFactory(portlet, this);
    }

    private GenericPortletFactory addCMSUsagePortlet(NeptuneSecurity security, Map<String, String> info, int refresh) {
        CMSUsageMonitorConfig apConfig = new CMSUsageMonitorConfig();
        apConfig.setRefreshRateSecs(this.getRefreshRate(info));
        CMSUsageMonitor portlet = new CMSUsageMonitor(security, apConfig);
        return new GenericPortletFactory(portlet, this);
    }

    private int getRefreshRate(Map<String, String> info) {
        int refreshRateSecs = 300;
        try {
            int tmp = Integer.parseInt(info.get("ContentComponent.portlets.refreshRate"));
            if (tmp > 60) {
                refreshRateSecs = tmp;
            }
        }
        catch (Exception exception) {}
        return refreshRateSecs;
    }

    private int getActivityPortletRecordCount(Map<String, String> info) {
        int recordCount = 10;
        try {
            int tmp = Integer.parseInt(info.get("ContentComponent.portlets.activityPortlet.recordCount"));
            recordCount = tmp < 1 ? 10 : (tmp > 20 ? 20 : tmp);
        }
        catch (Exception exception) {
            recordCount = 10;
        }
        return recordCount;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
            return this.getTitleServices();
        }
        if (clazz.getName().equalsIgnoreCase(ITitleProgressService.class.getName())) {
            ArrayList<TitleProgressService> tpServices = new ArrayList<TitleProgressService>();
            tpServices.add(new TitleProgressService());
            return tpServices;
        }
        return null;
    }

    private List<ITitleService> getTitleServices() {
        ArrayList<ITitleService> assetServices = new ArrayList<ITitleService>();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Delete"})) {
            assetServices.add(new DeleteService());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"})) {
            assetServices.add(new RunTemplate());
            assetServices.add(new RunSiteTemplate());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Distribute"})) {
            assetServices.add(new Distribute());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View", "AssetManagement_Modify"})) {
            assetServices.add(new BulkEditService());
        }
        if (this.isSitesFeatureActive() && ClientAuthorizationManager.isAuthorized((String[])new String[]{"Sites_Target"})) {
            assetServices.add(new TargetSites());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View", "AssetManagement_Modify"})) {
            assetServices.add(new RunNormalizationRuleService());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
            assetServices.add(new TitleSearchResultsExportService());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"}) && this.hasMPWithTracking.booleanValue()) {
            assetServices.add(new SatellitePitchTop());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"}) && this.hasMPWithTracking.booleanValue()) {
            assetServices.add(new SatellitePitchBottom());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"}) && this.hasMPWithTracking.booleanValue()) {
            assetServices.add(new TerrestrialPitchTop());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"}) && this.hasMPWithTracking.booleanValue()) {
            assetServices.add(new TerrestrialPitchBottom());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_Modify"})) {
            assetServices.add(new AddTitlesToOffer());
        }
        return assetServices;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList childMenuItems = new ArrayList();
        String displayName = this.constants.menuItemContent();
        GroupMenuItem rootMenuItem = new GroupMenuItem("Content", displayName, childMenuItems);
        this.buildTitleMenuItems(rootMenuItem);
        this.buildContentClassMenuItems(rootMenuItem);
        this.buildLookupKeyMenuItem(rootMenuItem);
        this.buildMetadataConfigMenuItems(rootMenuItem);
        tabs.add((MenuItemBase)rootMenuItem);
        return tabs;
    }

    private void buildTitleMenuItems(GroupMenuItem parentMenuItem) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
            parentMenuItem.getSubPanels().add(this.createSearchMenuItem("Search", this.constants.menuItemContentSearch(), UiCriteriaMode.EPISODE));
            parentMenuItem.getSubPanels().add(this.createSearchMenuItem("SeriesSearch", this.constants.menuItemContentSeriesSearch(), UiCriteriaMode.SERIES));
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View", "AssetManagement_Create"})) {
            LazyViewWidgetFactory factory = new LazyViewWidgetFactory((LazyView)new ContentCreateLazyView());
            WidgetMenuItem.AnchorChangeListener listener = factory.getAnchorChangeListener();
            String displayName = this.constants.menuItemContentCreate();
            WidgetMenuItem menuItem = new WidgetMenuItem("Create", displayName, (WidgetFactory)factory, listener);
            factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
            parentMenuItem.getSubPanels().add(menuItem);
        }
    }

    private WidgetMenuItem createSearchMenuItem(String searchName, String displayName, UiCriteriaMode criteriaMode) {
        TitleSearchWidgetFactory factory = new TitleSearchWidgetFactory(criteriaMode);
        WidgetMenuItem.AnchorChangeListener listener = factory.getAnchorChangeListener();
        WidgetMenuItem menuItem = new WidgetMenuItem(searchName, displayName, (WidgetFactory)factory, listener);
        factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
        return menuItem;
    }

    private void buildContentClassMenuItems(GroupMenuItem parentMenuItem) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View"})) {
            LazyViewWidgetFactory factory = new LazyViewWidgetFactory((LazyView)new ContentClassLazyView());
            WidgetMenuItem.AnchorChangeListener listener = factory.getAnchorChangeListener();
            String displayName = this.constants.menuItemContentClass();
            WidgetMenuItem menuItem = new WidgetMenuItem("ContentClass", displayName, (WidgetFactory)factory, listener);
            factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
            parentMenuItem.getSubPanels().add(menuItem);
        }
    }

    private void buildLookupKeyMenuItem(GroupMenuItem parentMenuItem) {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"LookupKeyManagement_View"})) {
            final LookupKeysListPanel lookupKeysListPanel = new LookupKeysListPanel();
            String displayName = this.constants.menuItemLookupKey();
            WidgetMenuItem lookupKeysListView = new WidgetMenuItem("LookupKey", displayName, new WidgetFactory(){

                public Widget getInstance() {
                    return lookupKeysListPanel;
                }

                public void release(Widget widget) {
                }
            }, lookupKeysListPanel.getAnchorChangeListener());
            lookupKeysListPanel.setReverseAnchorChangeListener(lookupKeysListView.getReverseAnchorChangeListener());
            parentMenuItem.getSubPanels().add(lookupKeysListView);
        }
    }

    private void buildMetadataConfigMenuItems(GroupMenuItem parentMenuItem) {
        ArrayList<WidgetMenuItem> configGroup = new ArrayList<WidgetMenuItem>();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_View"}) || ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_View"})) {
            String displayName = this.constants.menuItemConfiguration();
            GroupMenuItem menuItem = new GroupMenuItem("Configuration", displayName, configGroup);
            parentMenuItem.getSubPanels().add(menuItem);
            CustomFieldLazyView customFieldLazyView = new CustomFieldLazyView();
            LazyViewWidgetFactory factory = new LazyViewWidgetFactory((LazyView)customFieldLazyView);
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"CustomFieldsAdministration_View"})) {
                String customFieldName = this.constants.menuItemCustomFields();
                WidgetMenuItem customFieldViewItem = new WidgetMenuItem("CustomField", customFieldName, (WidgetFactory)factory, factory.getAnchorChangeListener());
                configGroup.add(customFieldViewItem);
            }
            final MetadataConfigLazyView metadataLazyView = new MetadataConfigLazyView();
            LazyViewWidgetFactory matadataFactory = new LazyViewWidgetFactory((LazyView)metadataLazyView);
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataConfiguration_View"})) {
                WidgetMenuItem configItem = new WidgetMenuItem("StandardFields", this.constants.menuItemStandardFields(), new WidgetFactory(){

                    public Widget getInstance() {
                        return metadataLazyView;
                    }

                    public void release(Widget widget) {
                    }
                }, matadataFactory.getAnchorChangeListener());
                configGroup.add(configItem);
            }
        }
    }

    public String getSpecificationName() {
        return this.spec;
    }

    public Integer getTitleHistoryViewRefreshRate() {
        return this.titleHistoryRefreshRate;
    }

    public Integer getTitleSitesViewRefreshRate() {
        return this.titleSitesRefreshRate;
    }

    public List<String> getImageAssetTypes() {
        return this.imageAssetTypes;
    }

    public List<String> getVideoAssetTypes() {
        return this.videoAssetTypes;
    }

    public boolean isSitesFeatureActive() {
        return this.sitesFeatureActive;
    }

    public boolean isLicensedForVideoPreview() {
        return this.licensedForVideoPreview;
    }

    public boolean isLicensedForCategoryManagement() {
        return this.licensedForCategoryManagement;
    }

    public boolean isLicensedForMetadataEnhancement() {
        return this.licensedForMetadataEnhancement;
    }

    public boolean isProviderIdCaseSensitive() {
        return this.providerIdCaseSensitive;
    }

    public void checkSpecIdentifiers() {
        this.titleService.syncAllMetadataSpecIdIndexWithPlugins((AsyncCallback<UITitleMetadataPluginsSyncedResult>)new NeptuneAsyncCallback<UITitleMetadataPluginsSyncedResult>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)ContentComponent.this.constants.failedToCreateUniqueIndex());
            }

            public void onNeptuneSuccess(UITitleMetadataPluginsSyncedResult result) {
                String titleIds;
                if (result == null) {
                    return;
                }
                if (result.isResyncRequired()) {
                    Window.alert((String)ContentComponent.this.constants.metadataIndexOutOfSyncWarning());
                }
                if ((titleIds = result.getTitleIdsWithDuplicateIdentifiers()) != null && !titleIds.isEmpty()) {
                    Window.alert((String)ContentComponent.this.messages.titleWithDuplicateAssetIds(titleIds));
                }
            }
        });
    }

    private Integer getIntegerValue(String property) {
        String value = (String)this.info.get(property);
        if (value != null) {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    private boolean getBooleanValue(String property) {
        return Boolean.parseBoolean((String)this.info.get(property));
    }

    public String getName() {
        return "CONTENT";
    }

    public String getDisplayName() {
        return this.constants.componentDisplayName();
    }

    public Boolean getHasMPWithTracking() {
        return this.hasMPWithTracking;
    }

    public void setHasMPWithTracking(Boolean hasMPWithTracking) {
        this.hasMPWithTracking = hasMPWithTracking;
    }

    private void setPitchScheduleOptions() {
        this.pitchService.hasMPWithTrackingSites((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Boolean result) {
                ContentComponent.this.setHasMPWithTracking(result);
            }
        });
    }

    private static final class GenericPortletFactory
    implements PortletFactory {
        private Portlet portlet;
        private ContentComponent contentComponent;

        public GenericPortletFactory(Portlet portlet, ContentComponent contentComponent) {
            this.portlet = portlet;
            this.contentComponent = contentComponent;
        }

        public Portlet getInstance() {
            return this.portlet;
        }

        public void release(Portlet widget) {
            this.portlet = null;
        }

        public Component getComponent() {
            return this.contentComponent;
        }
    }
}

