/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.IAssetPropertiesController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.AssetTreeItemWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class AssetPropertiesView
extends Composite {
    private static final String MSG_CONFIRM_REQUIRES_FILE = "Are you sure you want to change 'Requires a File' value?\nYou will have to reindex (resave) all existing titles before this change is reflected in 'Missing Content' search results.";
    private static final String MSG_DISABLE_ASSET = "Enabling or Disabling an asset with selected 'Requires a File' checkbox can affect 'Missing Content' search results.\nYou will have to reindex (resave) all existing titles before this change is reflected in search results.\nWould you like to continue?";
    private static final String TXT_BTN_ENABLE = "Enable this Asset";
    private static final String TXT_BTN_DISABLE = "Disable this Asset";
    private static final String TXT_LBL_ENABLED = "Enabled";
    private static final String TXT_LBL_DISABLED = "Disabled";
    private static final String ERROR_STYLE = "WidgetValidationError";
    private IAssetPropertiesController controller;
    private SimpleContainer rootContainer = new SimpleContainer();
    private TextBox txtName;
    private TextBox txtMin;
    private TextBox txtMax;
    private TextBox txtBatchMin;
    private TextBox txtBatchMax;
    private CheckBox cbRequiresFile;
    private CheckBox cbHideFileView;
    private Button btnDisable;
    private TextBox txtStatus;
    UIContentClass contentClass;
    private UIContentClassAsset currentAsset;
    private TreeItem currentTreeItem;

    public AssetPropertiesView(UIContentClass contentClass) {
        this.initWidget((Widget)this.rootContainer);
        this.contentClass = contentClass;
        FlexTable table = new FlexTable();
        table.addStyleName("FormPanel");
        table.addStyleName("FormFieldTable");
        int row = 0;
        this.txtName = new TextBox();
        this.txtName.setEnabled(false);
        table.setWidget(row, 0, (Widget)new Label("Asset Name"));
        table.setWidget(row, 1, (Widget)this.txtName);
        ++row;
        this.txtMin = new TextBox();
        this.txtMin.setMaxLength(10);
        this.txtMin.setTitle("Enter an integer value greater than or equal to 0.");
        this.txtMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (AssetPropertiesView.this.currentAsset != null) {
                    String val = AssetPropertiesView.this.txtMin.getValue().trim();
                    try {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.min = Integer.parseInt(val);
                        if (((AssetPropertiesView)AssetPropertiesView.this).currentAsset.min < 0) {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMin = val;
                            AssetPropertiesView.this.txtMin.addStyleName(AssetPropertiesView.ERROR_STYLE);
                        } else {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMin = null;
                            AssetPropertiesView.this.txtMin.removeStyleName(AssetPropertiesView.ERROR_STYLE);
                        }
                    }
                    catch (Exception exception) {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMin = val;
                        AssetPropertiesView.this.txtMin.addStyleName(AssetPropertiesView.ERROR_STYLE);
                    }
                }
            }
        });
        this.txtMax = new TextBox();
        this.txtMax.setMaxLength(10);
        this.txtMax.setTitle("Enter an integer value greater than or equal to 1.");
        this.txtMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (AssetPropertiesView.this.currentAsset != null) {
                    String val = AssetPropertiesView.this.txtMax.getValue().trim();
                    try {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.max = Integer.parseInt(val);
                        if (((AssetPropertiesView)AssetPropertiesView.this).currentAsset.max < 1) {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMax = val;
                            AssetPropertiesView.this.txtMax.addStyleName(AssetPropertiesView.ERROR_STYLE);
                        } else {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMax = null;
                            AssetPropertiesView.this.txtMax.removeStyleName(AssetPropertiesView.ERROR_STYLE);
                        }
                    }
                    catch (Exception exception) {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strMax = val;
                        AssetPropertiesView.this.txtMax.addStyleName(AssetPropertiesView.ERROR_STYLE);
                    }
                }
            }
        });
        table.setWidget(row, 0, (Widget)new Label("Min Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtMin);
        table.setWidget(++row, 0, (Widget)new Label("Max Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtMax);
        ++row;
        this.txtBatchMin = new TextBox();
        this.txtBatchMin.setMaxLength(10);
        this.txtBatchMin.setTitle("Enter an integer value greater than or equal to 0.");
        this.txtBatchMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (AssetPropertiesView.this.currentAsset != null) {
                    String val = AssetPropertiesView.this.txtBatchMin.getValue().trim();
                    try {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.batchMin = Integer.parseInt(val);
                        if (((AssetPropertiesView)AssetPropertiesView.this).currentAsset.batchMin < 0) {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMin = val;
                            AssetPropertiesView.this.txtBatchMin.addStyleName(AssetPropertiesView.ERROR_STYLE);
                        } else {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMin = null;
                            AssetPropertiesView.this.txtBatchMin.removeStyleName(AssetPropertiesView.ERROR_STYLE);
                        }
                    }
                    catch (Exception exception) {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMin = val;
                        AssetPropertiesView.this.txtBatchMin.addStyleName(AssetPropertiesView.ERROR_STYLE);
                    }
                }
            }
        });
        this.txtBatchMax = new TextBox();
        this.txtBatchMax.setMaxLength(10);
        this.txtBatchMax.setTitle("Enter an integer value greater than or equal to 0.");
        this.txtBatchMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (AssetPropertiesView.this.currentAsset != null) {
                    String val = AssetPropertiesView.this.txtBatchMax.getValue().trim();
                    try {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.batchMax = Integer.parseInt(val);
                        if (((AssetPropertiesView)AssetPropertiesView.this).currentAsset.batchMax < 0) {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMax = val;
                            AssetPropertiesView.this.txtBatchMax.addStyleName(AssetPropertiesView.ERROR_STYLE);
                        } else {
                            ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMax = null;
                            AssetPropertiesView.this.txtBatchMax.removeStyleName(AssetPropertiesView.ERROR_STYLE);
                        }
                    }
                    catch (Exception exception) {
                        ((AssetPropertiesView)AssetPropertiesView.this).currentAsset.strBatchMax = val;
                        AssetPropertiesView.this.txtBatchMax.addStyleName(AssetPropertiesView.ERROR_STYLE);
                    }
                }
            }
        });
        table.setWidget(row, 0, (Widget)new Label("Min Batch Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtBatchMin);
        table.setWidget(++row, 0, (Widget)new Label("Max Batch Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtBatchMax);
        this.cbRequiresFile = new CheckBox();
        this.cbRequiresFile.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (Window.confirm((String)AssetPropertiesView.MSG_CONFIRM_REQUIRES_FILE)) {
                    if (AssetPropertiesView.this.currentAsset != null) {
                        AssetPropertiesView.this.currentAsset.setRequiresFile(AssetPropertiesView.this.cbRequiresFile.getValue());
                    }
                } else {
                    AssetPropertiesView.this.cbRequiresFile.setValue(Boolean.valueOf((Boolean)event.getValue() == false), false);
                }
            }
        });
        table.setWidget(++row, 0, (Widget)new Label("Requires a File"));
        table.setWidget(row, 1, (Widget)this.cbRequiresFile);
        this.cbHideFileView = new CheckBox();
        this.cbHideFileView.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (AssetPropertiesView.this.currentAsset != null) {
                    AssetPropertiesView.this.currentAsset.setHideFileView(AssetPropertiesView.this.cbHideFileView.getValue());
                }
            }
        });
        table.setWidget(++row, 0, (Widget)new Label("Hide File View"));
        table.setWidget(row, 1, (Widget)this.cbHideFileView);
        this.txtStatus = new TextBox();
        this.txtStatus.setEnabled(false);
        table.setWidget(++row, 0, (Widget)new Label("Status"));
        table.setWidget(row, 1, (Widget)this.txtStatus);
        ++row;
        this.btnDisable = new Button();
        this.btnDisable.removeStyleName("gwt-Button");
        this.btnDisable.addStyleName("ebBtn");
        this.btnDisable.addStyleName("disable_button_icon");
        this.btnDisable.setEnabled(true);
        this.btnDisable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AssetPropertiesView.this.onDisableEnable();
            }
        });
        table.setWidget(row, 0, (Widget)new Label(""));
        table.setWidget(row, 1, (Widget)this.btnDisable);
        ++row;
        this.rootContainer.setWidget((Widget)table);
    }

    private void onDisableEnable() {
        boolean update = true;
        if (this.currentAsset.isRequiresFile()) {
            update = Window.confirm((String)MSG_DISABLE_ASSET);
        }
        if (this.currentAsset.isDisabled()) {
            if (update) {
                this.currentAsset.setDisabled(false);
                this.enableView();
            }
        } else if (update) {
            this.currentAsset.setDisabled(true);
            this.disableView();
        }
    }

    private void enableView() {
        if (this.contentClass.getTypeId() == 3) {
            if (!this.isValidOfferAsset(this.currentAsset)) {
                this.btnDisable.setText(TXT_BTN_ENABLE);
                this.btnDisable.addStyleName("disable_button_icon");
                this.btnDisable.removeStyleName("enable_button_icon");
                this.btnDisable.setEnabled(false);
                this.txtStatus.setValue((Object)TXT_LBL_DISABLED);
            } else {
                this.btnDisable.setText(TXT_BTN_DISABLE);
                this.btnDisable.addStyleName("disable_button_icon");
                this.btnDisable.removeStyleName("enable_button_icon");
                this.btnDisable.setEnabled(false);
                this.txtStatus.setValue((Object)TXT_LBL_ENABLED);
            }
        } else {
            this.btnDisable.setEnabled(true);
            this.btnDisable.setText(TXT_BTN_DISABLE);
            this.btnDisable.addStyleName("disable_button_icon");
            this.btnDisable.removeStyleName("enable_button_icon");
            this.btnDisable.setEnabled(!this.currentAsset.isRoot());
            this.txtStatus.setValue((Object)TXT_LBL_ENABLED);
        }
        this.txtMin.setEnabled(!this.currentAsset.isRoot());
        this.txtMax.setEnabled(!this.currentAsset.isRoot());
        this.txtBatchMin.setEnabled(this.currentAsset.canBatchEdit());
        this.txtBatchMax.setEnabled(this.currentAsset.canBatchEdit());
        this.cbRequiresFile.setEnabled(this.currentAsset.canHaveFile());
        this.cbHideFileView.setEnabled(this.currentAsset.canHaveFile());
        Widget widget = this.currentTreeItem.getWidget();
        if (widget instanceof AssetTreeItemWidget) {
            ((AssetTreeItemWidget)widget).enable();
        }
        if (this.controller != null) {
            this.controller.onEnableAsset(this.currentAsset);
        }
    }

    private boolean isValidOfferAsset(UIContentClassAsset currentAsset) {
        if (currentAsset != null && currentAsset.getPath().equalsIgnoreCase("PACKAGE")) {
            return true;
        }
        return currentAsset != null && (currentAsset.getPath().startsWith("PACKAGE/TITLE") || currentAsset.getPath().startsWith("PACKAGE/PREVIEW") || currentAsset.getPath().startsWith("PACKAGE/DISPLAY") || currentAsset.getPath().startsWith("PACKAGE/POSTER") || currentAsset.getPath().startsWith("PACKAGE/BOXCOVER")) && !currentAsset.getPath().startsWith("PACKAGE/PREVIEWSEGMENT");
    }

    private void disableView() {
        if (this.contentClass.getTypeId() == 3) {
            if (!this.isValidOfferAsset(this.currentAsset)) {
                this.btnDisable.setText(TXT_BTN_ENABLE);
                this.btnDisable.addStyleName("disable_button_icon");
                this.btnDisable.removeStyleName("enable_button_icon");
                this.btnDisable.setEnabled(false);
                this.txtStatus.setValue((Object)TXT_LBL_DISABLED);
            } else {
                this.btnDisable.setText(TXT_BTN_DISABLE);
                this.btnDisable.addStyleName("disable_button_icon");
                this.btnDisable.removeStyleName("enable_button_icon");
                this.btnDisable.setEnabled(false);
                this.txtStatus.setValue((Object)TXT_LBL_ENABLED);
            }
        } else {
            this.btnDisable.setEnabled(true);
            this.btnDisable.setText(TXT_BTN_ENABLE);
            this.btnDisable.addStyleName("enable_button_icon");
            this.btnDisable.removeStyleName("disable_button_icon");
            this.btnDisable.setEnabled(true);
            this.txtStatus.setValue((Object)TXT_LBL_DISABLED);
        }
        this.txtMin.setEnabled(false);
        this.txtMax.setEnabled(false);
        this.txtBatchMin.setEnabled(false);
        this.txtBatchMax.setEnabled(false);
        this.cbRequiresFile.setEnabled(false);
        this.cbHideFileView.setEnabled(false);
        Widget widget = this.currentTreeItem.getWidget();
        if (widget instanceof AssetTreeItemWidget) {
            ((AssetTreeItemWidget)widget).disable();
        }
        if (this.controller != null) {
            this.controller.onDisableAsset(this.currentAsset);
        }
    }

    public void refresh(UIContentClassAsset asset, TreeItem item) {
        this.currentAsset = asset;
        this.currentTreeItem = item;
        if (asset == null) {
            this.disableAll();
        } else {
            this.txtName.setValue((Object)asset.getDisplayName());
            this.txtMin.setValue((Object)asset.getMinForUI());
            if (asset.strMin != null) {
                this.txtMin.addStyleName(ERROR_STYLE);
            } else {
                this.txtMin.removeStyleName(ERROR_STYLE);
            }
            this.txtMax.setValue((Object)asset.getMaxForUI());
            if (asset.strMax != null) {
                this.txtMax.addStyleName(ERROR_STYLE);
            } else {
                this.txtMax.removeStyleName(ERROR_STYLE);
            }
            this.txtBatchMin.setValue((Object)asset.getBatchMinForUI());
            if (asset.strBatchMin != null) {
                this.txtBatchMin.addStyleName(ERROR_STYLE);
            } else {
                this.txtBatchMin.removeStyleName(ERROR_STYLE);
            }
            this.txtBatchMax.setValue((Object)asset.getBatchMaxForUI());
            if (asset.strBatchMax != null) {
                this.txtBatchMax.addStyleName(ERROR_STYLE);
            } else {
                this.txtBatchMax.removeStyleName(ERROR_STYLE);
            }
            this.cbRequiresFile.setValue(Boolean.valueOf(asset.isRequiresFile()));
            this.cbHideFileView.setValue(Boolean.valueOf(asset.isHideFileView()));
            if (asset.isDisabled()) {
                this.disableView();
            } else {
                this.enableView();
            }
        }
    }

    public void disableAll() {
        this.disableView();
        this.btnDisable.setEnabled(false);
    }

    private static int parseInt(String str) {
        if (str == null) {
            return 0;
        }
        str = str.trim();
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setController(IAssetPropertiesController controller) {
        this.controller = controller;
    }

    public UIContentClassAsset getCurrentAsset() {
        return this.currentAsset;
    }

    public UIContentClass getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(UIContentClass contentClass) {
        this.contentClass = contentClass;
    }
}

