/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassCommand;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassView;
import com.tandbergtv.cms.portal.content.client.contentclass.IContentClassController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ContentClassValidator;
import com.tandbergtv.cms.portal.content.client.contentclass.model.SaveStatus;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewService;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.Collection;
import java.util.List;

public class ContentClassController
implements IContentClassController {
    private IContentClassViewServiceAsync service = (IContentClassViewServiceAsync)GWT.create(IContentClassViewService.class);
    private ContentClassView view;

    public ContentClassController(ContentClassView view) {
        this.view = view;
    }

    @Override
    public void getContentClassList() {
        this.view.showEmptyView();
        this.view.showBusyIndicator();
        this.service.getContentClassListWithoutMetadata((AsyncCallback<List<UIContentClass>>)new NeptuneAsyncCallback<List<UIContentClass>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.List, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(List<UIContentClass> result) {
                ContentClassController.this.view.showContentClassListView(result);
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }

    @Override
    public void saveContentClass(UIContentClass contentClass) {
        this.view.showBusyIndicator();
        ContentClassValidator validator = new ContentClassValidator(0);
        validator.validate(contentClass);
        if (validator.hasErrors()) {
            this.view.onError(ContentClassCommand.Save, validator.getErrors());
            this.view.hideBusyindicator();
            return;
        }
        this.service.saveAndValidateContentClass(contentClass, (AsyncCallback<SaveStatus>)new NeptuneAsyncCallback<SaveStatus>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.Save, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(SaveStatus status) {
                if (status.errors.isEmpty()) {
                    ContentClassController.this.view.onAfterContentClassSave(status.contentClassId);
                    ContentClassController.this.view.hideBusyindicator();
                } else {
                    ContentClassController.this.view.onCCPError(status.errors);
                    ContentClassController.this.view.hideBusyindicator();
                }
            }
        });
    }

    @Override
    public void deleteContentClasses(Collection<Long> ids) {
        this.view.showBusyIndicator();
        this.service.deleteContentClassesById(ids, (AsyncCallback<List<UIContentClass>>)new NeptuneAsyncCallback<List<UIContentClass>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.Delete, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(List<UIContentClass> result) {
                ContentClassController.this.view.showContentClassListView(result);
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }

    @Override
    public void getNewContentClass() {
        this.view.showEmptyView();
        this.view.showBusyIndicator();
        this.service.getNewContentClass((AsyncCallback<UIContentClass>)new NeptuneAsyncCallback<UIContentClass>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.New, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(UIContentClass result) {
                ContentClassController.this.view.showContentClassNewView(result);
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }

    @Override
    public void getContentClass(long id) {
        this.view.showEmptyView();
        this.view.showBusyIndicator();
        this.service.getContentClassById(id, (AsyncCallback<UIContentClass>)new NeptuneAsyncCallback<UIContentClass>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.Get, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(UIContentClass result) {
                ContentClassController.this.view.showContentClassEditView(result);
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }

    @Override
    public void getContentClassPartner(long contentClassId, long partnerId) {
        this.view.showEmptyView();
        this.view.showBusyIndicator();
        this.service.getContentClassPartner(contentClassId, partnerId, (AsyncCallback<UIContentClassPartner>)new NeptuneAsyncCallback<UIContentClassPartner>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.GetPartner, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(UIContentClassPartner result) {
                ContentClassController.this.view.showContentClassPartnerEditView(result);
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }

    @Override
    public void saveContentClassPartner(UIContentClassPartner ccp) {
        this.view.showBusyIndicator();
        ContentClassValidator validator = new ContentClassValidator(1);
        validator.validate(ccp);
        if (validator.hasErrors()) {
            this.view.onError(ContentClassCommand.SavePartner, validator.getErrors());
            this.view.hideBusyindicator();
            return;
        }
        this.service.saveContentClassPartner(ccp, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentClassController.this.view.onError(ContentClassCommand.SavePartner, caught.getMessage());
                ContentClassController.this.view.hideBusyindicator();
            }

            public void onNeptuneSuccess(Void v) {
                ContentClassController.this.view.onAfterContentClassPartnerSave();
                ContentClassController.this.view.hideBusyindicator();
            }
        });
    }
}

