/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.ContentClassConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassMainView;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassMetadataView;
import com.tandbergtv.cms.portal.content.client.contentclass.IContentClassController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class ContentClassEditView
extends Composite {
    ContentClassConstants constants = (ContentClassConstants)GWT.create(ContentClassConstants.class);
    private IContentClassController controller;
    private UIContentClass contentClass;
    private SimpleContainer rootContainer;
    private ContentClassMainView mainView;
    private ContentClassMetadataView metadataView;
    private HeaderPanel header;
    private ResizableContainer resizableContainer;
    private ButtonWidget btnCopy;
    private ButtonWidget btnSave;
    private ButtonWidget btnCopy2;
    private ButtonWidget btnSave2;
    private static final String STYLE = "ContentClassEditView";
    private static final String TAB_PROPERTIES = "Properties";
    private static final String TAB_METADATA = "Metadata";

    public ContentClassEditView(IContentClassController pController) {
        this.controller = pController;
        this.rootContainer = new SimpleContainer();
        this.initWidget((Widget)this.rootContainer);
        this.addStyleName(STYLE);
        this.header = new HeaderPanel("");
        this.mainView = new ContentClassMainView();
        this.resizableContainer = new ResizableContainer((Widget)this.mainView, TAB_PROPERTIES, null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.btnSave = this.addSaveButton(TAB_PROPERTIES);
        this.btnCopy = this.addCopyButton(TAB_PROPERTIES);
        this.addCancelButton(TAB_PROPERTIES);
        this.metadataView = new ContentClassMetadataView();
        this.resizableContainer.addTab(this.metadataView.getLeftWidget(), this.metadataView.getRightWidget(), TAB_METADATA);
        this.btnSave2 = this.addSaveButton(TAB_METADATA);
        this.btnCopy2 = this.addCopyButton(TAB_METADATA);
        this.addCancelButton(TAB_METADATA);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)this.header);
        vp.add((Widget)this.resizableContainer);
        this.rootContainer.setWidget((Widget)vp);
    }

    private void onSaveClick() {
        String name = this.mainView.getName();
        if (name == null || name.trim().length() < 1) {
            this.resizableContainer.selectTab(TAB_PROPERTIES);
            this.resizableContainer.setErrorMessage(this.constants.errorBlankCCName());
            return;
        }
        if (this.controller != null) {
            this.contentClass.setName(name);
            this.contentClass.setDescription(this.mainView.getDescription());
            this.contentClass.setSpecialUsageId(this.mainView.getSpecialUsageId());
            this.controller.saveContentClass(this.contentClass);
        }
    }

    private void onCopyClick() {
        this.resizableContainer.reset();
        this.contentClass.setId(0L);
        this.contentClass.setDefault(false);
        this.contentClass.setName(this.mainView.getName());
        this.contentClass.setDescription(this.mainView.getDescription());
        this.contentClass.setSpecialUsageId(this.mainView.getSpecialUsageId());
        String oldName = this.contentClass.getName();
        if (oldName == null || !oldName.startsWith("Copy of ")) {
            this.contentClass.setName("Copy of " + oldName);
        }
        History.newItem((String)"Content.ContentClass.New", (boolean)false);
        this.setNewTitle();
        this.mainView.refresh(this.contentClass, true);
        this.resizableContainer.selectTab(TAB_PROPERTIES);
        this.resizableContainer.reset();
    }

    private void onCancelClick() {
        History.newItem((String)"Content.ContentClass");
    }

    private ButtonWidget addSaveButton(String tabName) {
        ButtonWidget btnSave = new ButtonWidget("Save");
        btnSave.removeStyleName("gwt-Button");
        btnSave.addStyleName("ebBtn");
        btnSave.addStyleName("ebBtn_color_green");
        btnSave.addStyleName("save_button_icon");
        btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContentClassEditView.this.onSaveClick();
            }
        });
        this.resizableContainer.addButton(tabName, btnSave);
        return btnSave;
    }

    private ButtonWidget addCopyButton(String tabName) {
        ButtonWidget btnCopy = new ButtonWidget("Copy");
        btnCopy.removeStyleName("gwt-Button");
        btnCopy.addStyleName("ebBtn");
        btnCopy.addStyleName("ebBtn_color_green");
        btnCopy.addStyleName("copy_button_icon");
        btnCopy.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContentClassEditView.this.onCopyClick();
            }
        });
        this.resizableContainer.addButton(tabName, btnCopy);
        return btnCopy;
    }

    private void addCancelButton(String tabName) {
        ButtonWidget btnCancel = new ButtonWidget("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContentClassEditView.this.onCancelClick();
            }
        });
        this.resizableContainer.addButton(tabName, btnCancel);
    }

    public void refresh(UIContentClass contentClass, boolean isNew) {
        boolean isEditable;
        this.resizableContainer.reset();
        this.contentClass = contentClass;
        if (isNew) {
            isEditable = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Create"});
            this.setNewTitle();
        } else {
            isEditable = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Modify"});
            this.setEditTitle(contentClass.getName());
        }
        this.btnSave.setEnabled(isEditable);
        this.btnSave2.setEnabled(isEditable);
        this.btnCopy.setEnabled(contentClass.getTypeId() == 0);
        this.btnCopy2.setEnabled(contentClass.getTypeId() == 0);
        this.mainView.refresh(contentClass, isEditable);
        this.metadataView.refresh(contentClass, isEditable);
        this.resizableContainer.selectTab(TAB_PROPERTIES);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ContentClassEditView.this.resizableContainer.updateSize();
            }
        });
    }

    public void setNewTitle() {
        this.header.setLabel("New Content Class");
        this.btnSave.setEnabled(ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Create"}));
        this.btnCopy.setEnabled(false);
    }

    public void setEditTitle(String name) {
        this.header.setLabel("Edit Content Class: " + name);
        this.btnCopy.setEnabled(this.contentClass.getTypeId() == 0 && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Create"}));
    }

    public void afterSave(Long id) {
        if (this.contentClass.getId() == 0L) {
            this.contentClass.setId(id);
            History.newItem((String)("Content.ContentClass.Edit." + id), (boolean)false);
        }
        this.resizableContainer.setInfoMessage(this.constants.ccSaved());
        this.setEditTitle(this.contentClass.getName());
    }

    public void onError(String message) {
        this.resizableContainer.setErrorMessage(message);
    }

    public void onError(List<ValidationError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("<p>Please fix the following validation errors before saving:</p>");
        bld.append("<ul>");
        int i = 0;
        while (i < errors.size()) {
            bld.append("<li>");
            ValidationError error = errors.get(i);
            if (error.getField() != null) {
                bld.append(error.getField().getDisplayName());
                bld.append(" ");
            }
            bld.append("[");
            bld.append(error.getAsset().getDisplayName());
            bld.append("]: ");
            bld.append(error.getMessage());
            bld.append("</li>");
            ++i;
        }
        bld.append("</ul>");
        this.resizableContainer.setErrorHTML(bld.toString());
    }

    public void onCCPError(List<CCPValidationError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("<p>Could not disable fields with default values at the partner level:</p>");
        int i = 0;
        while (i < errors.size()) {
            CCPValidationError error = errors.get(i);
            bld.append("<li>");
            bld.append("Partner: " + error.partnerId + ", Asset: " + error.assetPath + ", Field: " + error.fieldPath);
            bld.append("</li>");
            ++i;
        }
        this.resizableContainer.setErrorHTML(bld.toString());
    }
}

