/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassCommand;
import com.tandbergtv.cms.portal.content.client.contentclass.IContentClassController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContentClassListView
extends Composite {
    private IContentClassController controller;
    private Set<CheckBox> checkboxes = new HashSet<CheckBox>();
    private SimpleContainer rootContainer;
    private FlexTable table;
    ResizableContainer resizableContainer;
    private static final String TAB_NAME = "Content Classes";

    public ContentClassListView(IContentClassController controller) {
        this.controller = controller;
        this.rootContainer = new SimpleContainer();
        this.initWidget((Widget)this.rootContainer);
        this.addStyleName("ContentClassListView");
        VerticalPanel mainPanel = new VerticalPanel();
        HeaderPanel header = new HeaderPanel("Content Class Administration");
        header.setStyleName("content-header-style");
        mainPanel.add((Widget)header);
        this.table = new FlexTable();
        this.table.addStyleName("cc-list-table");
        this.createTableHeader();
        this.resizableContainer = new ResizableContainer((Widget)this.table, TAB_NAME, null);
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.resizableContainer.addHeightOffsettingWidget((Widget)header);
        mainPanel.add((Widget)this.resizableContainer);
        this.addButtons(this.resizableContainer);
        this.rootContainer.setWidget((Widget)mainPanel);
    }

    private void addButtons(final ResizableContainer resizableContainer) {
        ButtonWidget btnNew = new ButtonWidget("Create");
        btnNew.removeStyleName("gwt-Button");
        btnNew.addStyleName("ebBtn");
        btnNew.addStyleName("ebBtn_color_green");
        btnNew.addStyleName("create_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Create"})) {
            btnNew.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)"Content.ContentClass.New");
                }
            });
        } else {
            btnNew.setEnabled(false);
        }
        ButtonWidget btnDelete = new ButtonWidget("Delete");
        btnDelete.removeStyleName("gwt-Button");
        btnDelete.addStyleName("ebBtn");
        btnDelete.addStyleName("delete_button_icon");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Delete"})) {
            btnDelete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List selectedIds = ContentClassListView.this.getSelectedContentClassIds();
                    if (selectedIds.isEmpty()) {
                        resizableContainer.setInfoMessage("No content class is selected. There is nothing to delete.");
                        return;
                    }
                    if (ContentClassListView.this.controller != null && !selectedIds.isEmpty() && Window.confirm((String)"Are you sure you want to delete selected content classes?")) {
                        ContentClassListView.this.controller.deleteContentClasses(selectedIds);
                    }
                }
            });
        } else {
            btnDelete.setEnabled(false);
        }
        resizableContainer.addButton(TAB_NAME, btnNew);
        resizableContainer.addButton(TAB_NAME, btnDelete);
    }

    private void createTableHeader() {
        final CheckBox mcb = new CheckBox();
        mcb.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean selected = mcb.getValue();
                for (CheckBox cb : ContentClassListView.this.checkboxes) {
                    cb.setValue(Boolean.valueOf(selected));
                }
            }
        });
        this.table.setWidget(0, 0, (Widget)mcb);
        this.table.setWidget(0, 1, (Widget)new Label("ID"));
        this.table.setWidget(0, 2, (Widget)new Label("Name"));
        this.table.setWidget(0, 3, (Widget)new Label("Description"));
        this.table.setWidget(0, 4, (Widget)new Label("Special Usage"));
        this.table.getRowFormatter().setStyleName(0, "tr-header");
    }

    private void createTableDataRow(int row, UIContentClass contentClass) {
        if (contentClass.getTypeId() == 0 && !contentClass.isDefault()) {
            CheckBox cb = new CheckBox();
            cb.setFormValue("" + contentClass.getId());
            this.checkboxes.add(cb);
            this.table.setWidget(row, 0, (Widget)cb);
        }
        this.table.setWidget(row, 1, (Widget)new HyperlinkWidget("" + contentClass.getId(), "Content.ContentClass.Edit." + contentClass.getId()));
        this.table.setWidget(row, 2, (Widget)new Label(contentClass.getName()));
        String descr = contentClass.getDescription();
        if (descr != null && descr.length() > 100) {
            descr = String.valueOf(descr.substring(0, 100)) + "...";
        }
        this.table.setWidget(row, 3, (Widget)new Label(descr));
        String lbl = "";
        switch (contentClass.getSpecialUsageId()) {
            case 1: {
                lbl = "Pre Roll";
                break;
            }
            case 2: {
                lbl = "Post Roll";
            }
        }
        this.table.setWidget(row, 4, (Widget)new Label(lbl));
        this.table.getRowFormatter().setStyleName(row, "tr-body");
        this.table.getCellFormatter().setHorizontalAlignment(row, 0, HasHorizontalAlignment.ALIGN_CENTER);
        this.table.getCellFormatter().setHorizontalAlignment(row, 1, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    public void refresh(List<UIContentClass> list) {
        this.resizableContainer.getMessageArea().reset();
        this.checkboxes.clear();
        this.table.removeAllRows();
        this.createTableHeader();
        if (list != null) {
            Collections.sort(list);
            int i = 0;
            while (i < list.size()) {
                UIContentClass cc = list.get(i);
                this.createTableDataRow(i + 1, cc);
                ++i;
            }
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ContentClassListView.this.resizableContainer.updateSize();
            }
        });
    }

    private List<Long> getSelectedContentClassIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (CheckBox cb : this.checkboxes) {
            if (!cb.getValue().booleanValue()) continue;
            Long id = Long.parseLong(cb.getFormValue());
            ids.add(id);
        }
        return ids;
    }

    public void onError(ContentClassCommand cmd, String message) {
        this.resizableContainer.setErrorMessage(message);
    }
}

