/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.ContentClassConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class ContentClassMainView
extends Composite {
    private ContentClassConstants constants = (ContentClassConstants)GWT.create(ContentClassConstants.class);
    private static final int NAME_LENGTH = 24;
    private static final int DESCRIPTION_LENGTH = 254;
    private SimpleContainer rootContainer = new SimpleContainer();
    private TextBox nameField;
    private TextArea descriptionField;
    private ListBox specialUsageField;

    public ContentClassMainView() {
        this.initWidget((Widget)this.rootContainer);
        this.nameField = new TextBox();
        this.nameField.setMaxLength(24);
        this.nameField.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() != null) {
                    ContentClassMainView.this.nameField.setText(((String)event.getValue()).trim());
                }
            }
        });
        this.descriptionField = new TextArea();
        this.descriptionField.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String text = null;
                if (event.getValue() != null) {
                    text = ((String)event.getValue()).trim();
                }
                if (text != null && text.length() >= 254) {
                    ContentClassMainView.this.descriptionField.setText(text.substring(0, 254));
                } else {
                    ContentClassMainView.this.descriptionField.setText(text);
                }
            }
        });
        this.specialUsageField = new ListBox();
        this.specialUsageField.addItem("None", "0");
        this.specialUsageField.addItem("Pre Roll", "1");
        this.specialUsageField.addItem("Post Roll", "2");
        FlexTable table = new FlexTable();
        table.addStyleName("FormPanel");
        table.addStyleName("FormFieldTable");
        table.setWidget(0, 0, (Widget)new Label("Name"));
        table.setWidget(0, 1, (Widget)this.nameField);
        table.setWidget(1, 0, (Widget)new Label("Description"));
        table.getCellFormatter().addStyleName(1, 0, "descriptionCell");
        table.getWidget(1, 0).setStyleName("descriptionLabel");
        table.setWidget(1, 1, (Widget)this.descriptionField);
        table.setWidget(2, 0, (Widget)new Label("Special Usage"));
        table.setWidget(2, 1, (Widget)this.specialUsageField);
        this.rootContainer.setWidget((Widget)table);
    }

    public void refresh(UIContentClass contentClass, boolean isEditable) {
        if (contentClass == null) {
            this.nameField.setText(null);
            this.nameField.setEnabled(false);
            this.descriptionField.setText(null);
            this.descriptionField.setEnabled(false);
            this.specialUsageField.setSelectedIndex(0);
            this.specialUsageField.setEnabled(false);
        } else {
            this.nameField.setText(contentClass.getName());
            this.nameField.setEnabled(isEditable ? !contentClass.isDefault() : false);
            this.descriptionField.setText(contentClass.getDescription());
            this.descriptionField.setEnabled(isEditable);
            this.specialUsageField.setSelectedIndex(contentClass.getSpecialUsageId());
            this.specialUsageField.setEnabled(isEditable && !contentClass.isAssociatedWithTitle());
        }
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public int getSpecialUsageId() {
        return this.specialUsageField.getSelectedIndex();
    }
}

