/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.AssetPropertiesView;
import com.tandbergtv.cms.portal.content.client.contentclass.IAssetPropertiesController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.AssetTreeItemWidget;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassComplexFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Iterator;
import java.util.List;

public class ContentClassMetadataView {
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SimplePanel assetsViewPanel = new SimplePanel();
    private TabContainer tabContainer;
    private AssetPropertiesView assetPropertiesView;
    private SimplePanel fieldsViewPanel;
    private boolean isEditable;
    private Widget fieldsViewWidget = null;
    private UIContentClass contentClass;
    private VerticalContainer leftPanel;
    private static final String DOWN_ICON = "cms_contentmgmt_ui/resources/images/child-collapseAll-normalState.png";
    private static final String UP_ICON = "cms_contentmgmt_ui/resources/images/child-expandAll-normalState.png";
    HorizontalPanel horizontalPanel;

    public ContentClassMetadataView() {
        this.assetsViewPanel.addStyleName("AssetsViewPanel");
        this.leftPanel = new VerticalContainer();
        this.assetPropertiesView = new AssetPropertiesView(this.contentClass);
        this.assetPropertiesView.setController(new IAssetPropertiesController(){

            @Override
            public void onDisableAsset(UIContentClassAsset asset) {
                ContentClassMetadataView.this.tabContainer.getTabBar().setTabEnabled(1, false);
            }

            @Override
            public void onEnableAsset(UIContentClassAsset asset) {
                ContentClassMetadataView.this.tabContainer.getTabBar().setTabEnabled(1, true);
            }
        });
        this.fieldsViewPanel = new SimplePanel();
        this.fieldsViewPanel.addStyleName("FormPanel");
        this.tabContainer = new TabContainer();
        this.tabContainer.addStyleName("MetadataTabContainer");
        this.tabContainer.add((Widget)this.assetPropertiesView, "Asset");
        this.tabContainer.add((Widget)this.fieldsViewPanel, "Fields");
        this.tabContainer.selectTab(0);
        this.tabContainer.addBeforeSelectionHandler((BeforeSelectionHandler)new BeforeSelectionHandler<Integer>(){

            public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
                if ((Integer)event.getItem() == 1) {
                    ContentClassMetadataView.this.beforeShowFieldsTab();
                }
            }
        });
    }

    public Widget getLeftWidget() {
        return this.leftPanel;
    }

    public Widget getRightWidget() {
        return this.tabContainer;
    }

    private void beforeShowFieldsTab() {
        if (this.fieldsViewWidget == null) {
            this.busyIndicator.center();
            this.fieldsViewPanel.setWidget(null);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    UIContentClassAsset asset = ContentClassMetadataView.this.assetPropertiesView.getCurrentAsset();
                    UIContentClassFieldGroup rootGroup = new UIContentClassFieldGroup();
                    rootGroup.getFields().addAll(asset.getFields());
                    ContentClassMetadataView.this.fieldsViewWidget = (Widget)new ContentClassComplexFieldWidget(rootGroup, ContentClassMetadataView.this.isEditable, ContentClassMetadataView.this.contentClass);
                    ContentClassMetadataView.this.fieldsViewPanel.setWidget(ContentClassMetadataView.this.fieldsViewWidget);
                    ContentClassMetadataView.this.busyIndicator.hide();
                }
            });
        }
    }

    public void refresh(UIContentClass cc, boolean isEditable) {
        this.contentClass = cc;
        this.isEditable = isEditable;
        TreeResource images = new TreeResource();
        final TreeWidget tree = new TreeWidget((Tree.Resources)images);
        UIContentClassAsset rootAsset = this.contentClass == null ? null : this.contentClass.getRootAsset();
        TreeItem rootItem = this.createAssetTree(rootAsset);
        if (rootItem == null) {
            return;
        }
        rootItem.setState(true, false);
        tree.setSelectedItem(rootItem);
        tree.addItem(rootItem);
        tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                ContentClassMetadataView.this.showAssetPanel((TreeItem)event.getSelectedItem());
            }
        });
        this.assetPropertiesView.setContentClass(this.contentClass);
        this.assetsViewPanel.setWidget((Widget)tree);
        this.showAssetPanel(rootItem);
        LabelWidget textLabelExpand = new LabelWidget("Expand All");
        textLabelExpand.setStyleName("settings-view-expand-collapse-style");
        textLabelExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        LabelWidget textLabelCollapse = new LabelWidget("Collapse All");
        textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
        textLabelCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgCollapse = new ImageWidget(DOWN_ICON);
        dropDownImgCollapse.setStyleName("drop-arrow-asset-collapse-all");
        dropDownImgCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgExpand = new ImageWidget(UP_ICON);
        dropDownImgExpand.setStyleName("drop-arrow-expand-all");
        dropDownImgExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        if (this.horizontalPanel == null) {
            this.horizontalPanel = new HorizontalPanel();
            this.horizontalPanel.add((Widget)dropDownImgExpand);
            this.horizontalPanel.add((Widget)textLabelExpand);
            this.horizontalPanel.add((Widget)dropDownImgCollapse);
            this.horizontalPanel.add((Widget)textLabelCollapse);
            this.leftPanel.add((Widget)this.horizontalPanel);
        }
        this.leftPanel.add((Widget)this.assetsViewPanel);
    }

    private void showAssetPanel(TreeItem item) {
        UIContentClassAsset asset = (UIContentClassAsset)item.getUserObject();
        this.tabContainer.selectTab(0);
        this.assetPropertiesView.refresh(asset, item);
        this.fieldsViewWidget = null;
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    private TreeItem createAssetTree(UIContentClassAsset rootAsset) {
        TreeItem rootItem = this.createRootTreeItem(rootAsset);
        return rootItem;
    }

    private TreeItem createRootTreeItem(UIContentClassAsset asset) {
        TreeItem item = new TreeItem(asset.getDisplayName());
        item.setUserObject((Object)asset);
        if (asset.hasAssets()) {
            this.addTreeItemChildren(asset, item);
        }
        return item;
    }

    private void addTreeItemChildren(UIContentClassAsset asset, TreeItem item) {
        List<UIContentClassAsset> list = asset.getAssets();
        for (UIContentClassAsset childAsset : list) {
            AssetTreeItem childItem = new AssetTreeItem(childAsset);
            item.addItem((TreeItem)childItem);
            if (!childAsset.hasAssets()) continue;
            this.addTreeItemChildren(childAsset, childItem);
        }
    }

    private static class AssetTreeItem
    extends TreeItem {
        private static final String STYLE_TREEITEM_SELECTED = "sites-treeItem-selected";
        private static final String STYLE_TREEITEM = "sites-treeItem";

        public AssetTreeItem(UIContentClassAsset asset) {
            AssetTreeItemWidget widget = new AssetTreeItemWidget(asset.getDisplayName(), asset.isDisabled());
            widget.addStyleName(STYLE_TREEITEM);
            this.setWidget((Widget)widget);
            this.setUserObject(asset);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            if (selected) {
                this.getWidget().addStyleName(STYLE_TREEITEM_SELECTED);
            } else {
                this.getWidget().removeStyleName(STYLE_TREEITEM_SELECTED);
            }
        }
    }
}

