/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.bundle.ContentClassConstants;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassCommand;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassPartnerMetadataView;
import com.tandbergtv.cms.portal.content.client.contentclass.IContentClassController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class ContentClassPartnerEditView
extends Composite {
    private static final String TAB_METADATA = "Metadata";
    private ContentClassConstants constants = (ContentClassConstants)GWT.create(ContentClassConstants.class);
    private IContentClassController controller;
    private UIContentClassPartner contentClassPartner;
    private SimpleContainer rootContainer;
    private ContentClassPartnerMetadataView metadataView;
    private HeaderPanel header;
    private ResizableContainer resizableContainer;

    public ContentClassPartnerEditView(IContentClassController pController) {
        this.controller = pController;
        this.rootContainer = new SimpleContainer();
        this.initWidget((Widget)this.rootContainer);
        this.addStyleName("ContentClassEditView");
        this.header = new HeaderPanel("");
        this.metadataView = new ContentClassPartnerMetadataView();
        this.resizableContainer = new ResizableContainer(this.metadataView.getLeftWidget(), this.metadataView.getRightWidget(), TAB_METADATA, null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        ButtonWidget btnSave = new ButtonWidget("Save");
        btnSave.removeStyleName("gwt-Button");
        btnSave.addStyleName("ebBtn");
        btnSave.addStyleName("ebBtn_color_green");
        btnSave.addStyleName("save_button_icon");
        btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ContentClassPartnerEditView.this.controller != null) {
                    ContentClassPartnerEditView.this.controller.saveContentClassPartner(ContentClassPartnerEditView.this.contentClassPartner);
                }
            }
        });
        this.resizableContainer.addButton(TAB_METADATA, btnSave);
        ButtonWidget btnCancel = new ButtonWidget("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.back();
            }
        });
        this.resizableContainer.addButton(TAB_METADATA, btnCancel);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)this.header);
        vp.add((Widget)this.resizableContainer);
        vp.addStyleName("ContentClassPartnerMetadataView");
        this.rootContainer.setWidget((Widget)vp);
    }

    public void refresh(UIContentClassPartner ccp) {
        this.resizableContainer.reset();
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.contentClassPartner = ccp;
        this.header.setLabel("Edit Metadata: Partner: '" + ccp.getPartnerName() + "', Content Class: '" + ccp.getContentClassName() + "'");
        this.metadataView.refresh(ccp, true);
    }

    public void afterSave() {
        this.resizableContainer.setInfoMessage(this.constants.ccPartnerSaved());
    }

    public void onError(ContentClassCommand cmd, String message) {
        this.resizableContainer.setErrorMessage(message);
    }

    public void onError(List<ValidationError> errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("<p>Please fix the following validation errors before saving:</p>");
        bld.append("<ul>");
        int i = 0;
        while (i < errors.size()) {
            bld.append("<li>");
            ValidationError error = errors.get(i);
            if (error.getField() != null) {
                bld.append(error.getField().getDisplayName());
                bld.append(" ");
            }
            bld.append("[");
            bld.append(error.getAsset().getDisplayName());
            bld.append("]: ");
            bld.append(error.getMessage());
            bld.append("</li>");
            ++i;
        }
        bld.append("</ul>");
        this.resizableContainer.setErrorHTML(bld.toString());
    }
}

