/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassAsset;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassField;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassFieldWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeResource;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import java.util.Iterator;
import java.util.List;

public class ContentClassPartnerMetadataView {
    private BusyIndicator busyIndicator = new BusyIndicator();
    private TabContainer tabContainer;
    private SimplePanel assetsViewPanel = new SimplePanel();
    private SimplePanel fieldsViewPanel;
    private boolean isEditable;
    private static final String DOWN_ICON = "cms_contentmgmt_ui/resources/images/child-collapseAll-normalState.png";
    private static final String UP_ICON = "cms_contentmgmt_ui/resources/images/child-expandAll-normalState.png";

    public ContentClassPartnerMetadataView() {
        this.assetsViewPanel.addStyleName("AssetsViewPanel");
        this.fieldsViewPanel = new SimplePanel();
        this.fieldsViewPanel.addStyleName("FormPanel");
        this.tabContainer = new TabContainer();
        this.tabContainer.addStyleName("MetadataTabContainer");
        this.tabContainer.add((Widget)this.fieldsViewPanel, "Fields");
        this.tabContainer.getTabBar().setVisible(false);
        this.tabContainer.selectTab(0);
    }

    public Widget getLeftWidget() {
        return this.assetsViewPanel;
    }

    public Widget getRightWidget() {
        return this.tabContainer;
    }

    public void refresh(UIContentClassPartner ccp, boolean isEditable) {
        this.isEditable = isEditable;
        TreeResource images = new TreeResource();
        final TreeWidget tree = new TreeWidget((Tree.Resources)images);
        UIContentClassAsset rootAsset = ccp == null ? null : ccp.getRootAsset();
        TreeItem rootItem = this.createAssetTree(rootAsset);
        if (rootItem == null) {
            return;
        }
        rootItem.setState(true, false);
        tree.setSelectedItem(rootItem);
        tree.addItem(rootItem);
        tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                ContentClassPartnerMetadataView.this.showAssetPanel((TreeItem)event.getSelectedItem());
            }
        });
        LabelWidget textLabelExpand = new LabelWidget("Expand All");
        textLabelExpand.setStyleName("settings-view-expand-collapse-style");
        textLabelExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        LabelWidget textLabelCollapse = new LabelWidget("Collapse All");
        textLabelCollapse.setStyleName("settings-view-expand-collapse-style");
        textLabelCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgCollapse = new ImageWidget(DOWN_ICON);
        dropDownImgCollapse.setStyleName("drop-arrow-asset-collapse-all");
        dropDownImgCollapse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(false);
                }
            }
        });
        ImageWidget dropDownImgExpand = new ImageWidget(UP_ICON);
        dropDownImgExpand.setStyleName("drop-arrow-expand-all");
        dropDownImgExpand.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Iterator i = tree.treeItemIterator();
                while (i.hasNext()) {
                    TreeItem item = (TreeItem)i.next();
                    item.setState(true);
                }
            }
        });
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.add((Widget)dropDownImgExpand);
        horizontalPanel.add((Widget)textLabelExpand);
        horizontalPanel.add((Widget)dropDownImgCollapse);
        horizontalPanel.add((Widget)textLabelCollapse);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)horizontalPanel);
        panel.add((Widget)tree);
        this.assetsViewPanel.setWidget((Widget)panel);
        this.showAssetPanel(rootItem);
    }

    private void showAssetPanel(TreeItem item) {
        UIContentClassAsset asset = (UIContentClassAsset)item.getUserObject();
        this.showAssetPanel(asset);
    }

    private void showAssetPanel(UIContentClassAsset asset) {
        UIContentClassFieldGroup rootGroup = new UIContentClassFieldGroup();
        rootGroup.getFields().addAll(asset.getFields());
        Widget fieldsViewWidget = this.createFieldGroupWidget(asset, rootGroup);
        this.fieldsViewPanel.setWidget(fieldsViewWidget);
    }

    private Widget createFieldGroupWidget(UIContentClassAsset asset, UIContentClassFieldGroup group) {
        if (group == null) {
            return new Label("No Data");
        }
        List<UIContentClassField> fields = group.getFields();
        if (fields == null || fields.isEmpty()) {
            return new Label("No Data");
        }
        VerticalPanel vp = new VerticalPanel();
        FlexTable table = new FlexTable();
        table.addStyleName("FormFieldTable");
        int row = 0;
        for (UIContentClassField field : fields) {
            if (field instanceof UIContentClassFieldGroup || field.isDisabled()) continue;
            HTML label = new HTML();
            table.setWidget(row, 0, (Widget)label);
            table.getCellFormatter().setAlignment(row, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
            ContentClassFieldWidget widget = new ContentClassFieldWidget(ContentClassFieldWidget.Type.ContentClassPartner, field, this.isEditable, null, label);
            widget.setRequired(field.isRequired());
            table.setWidget(row, 1, (Widget)widget);
            ++row;
        }
        vp.add((Widget)table);
        for (UIContentClassField field : fields) {
            if (!(field instanceof UIContentClassFieldGroup) || field.isDisabled()) continue;
            UIContentClassFieldGroup childGroup = (UIContentClassFieldGroup)field;
            RoundedDisclosureContainer rdc = new RoundedDisclosureContainer(childGroup.getDisplayName());
            Widget groupWidget = this.createFieldGroupWidget(asset, childGroup);
            rdc.setContent(groupWidget);
            rdc.addStyleName("ContentClassComplexFieldWidget");
            vp.add((Widget)rdc);
        }
        return vp;
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    private TreeItem createAssetTree(UIContentClassAsset rootAsset) {
        TreeItem rootItem = this.createRootTreeItem(rootAsset);
        return rootItem;
    }

    private TreeItem createRootTreeItem(UIContentClassAsset asset) {
        TreeItem item = new TreeItem(asset.getDisplayName());
        item.setUserObject((Object)asset);
        if (asset.hasAssets()) {
            this.addTreeItemChildren(asset, item);
        }
        return item;
    }

    private void addTreeItemChildren(UIContentClassAsset asset, TreeItem item) {
        List<UIContentClassAsset> list = asset.getAssets();
        for (UIContentClassAsset childAsset : list) {
            if (childAsset.isDisabled()) continue;
            TreeItem childItem = new TreeItem(childAsset.getDisplayName());
            childItem.setUserObject((Object)childAsset);
            item.addItem(childItem);
            if (!childAsset.hasAssets()) continue;
            this.addTreeItemChildren(childAsset, childItem);
        }
    }
}

