/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassCommand;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassEditView;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassListView;
import com.tandbergtv.cms.portal.content.client.contentclass.ContentClassPartnerEditView;
import com.tandbergtv.cms.portal.content.client.contentclass.IContentClassController;
import com.tandbergtv.cms.portal.content.client.contentclass.model.CCPValidationError;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassPartner;
import com.tandbergtv.cms.portal.content.client.contentclass.model.ValidationError;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.List;

public class ContentClassView
extends Composite {
    private IContentClassController controller;
    private SimpleContainer rootContainer = new SimpleContainer();
    private BusyIndicator busyIndicator;
    private ContentClassEditView editView;
    private ContentClassPartnerEditView editPartnerView;
    private ContentClassListView listView;
    private VerticalPanel emptyPanel;
    private MessageArea errorPanel;

    public ContentClassView() {
        this.initWidget((Widget)this.rootContainer);
        this.addStyleName("ContentClassView");
        this.busyIndicator = new BusyIndicator();
        this.emptyPanel = new VerticalPanel();
        this.errorPanel = new MessageArea();
        this.emptyPanel.add((Widget)this.errorPanel);
        this.rootContainer.setWidget((Widget)this.emptyPanel);
    }

    public void setController(IContentClassController controller) {
        this.controller = controller;
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyindicator() {
        this.busyIndicator.hide();
    }

    public void showEmptyView() {
        this.errorPanel.reset();
        this.emptyPanel.setVisible(false);
        this.rootContainer.setWidget((Widget)this.emptyPanel);
    }

    public void showContentClassListView(List<UIContentClass> list) {
        if (this.listView == null) {
            this.listView = new ContentClassListView(this.controller);
        }
        this.rootContainer.setWidget((Widget)this.listView);
        this.listView.refresh(list);
    }

    public void showContentClassNewView(UIContentClass contentClass) {
        if (this.editView == null) {
            this.editView = new ContentClassEditView(this.controller);
        }
        this.rootContainer.setWidget((Widget)this.editView);
        this.editView.refresh(contentClass, true);
    }

    public void showContentClassEditView(UIContentClass contentClass) {
        if (this.editView == null) {
            this.editView = new ContentClassEditView(this.controller);
        }
        this.rootContainer.setWidget((Widget)this.editView);
        this.editView.refresh(contentClass, false);
    }

    public void showContentClassPartnerEditView(UIContentClassPartner ccp) {
        if (this.editPartnerView == null) {
            this.editPartnerView = new ContentClassPartnerEditView(this.controller);
        }
        this.rootContainer.setWidget((Widget)this.editPartnerView);
        this.editPartnerView.refresh(ccp);
    }

    public void onError(ContentClassCommand cmd, String message) {
        switch (cmd) {
            case List: 
            case Get: {
                this.showEmptyView();
                this.errorPanel.setErrorMessage(message);
                break;
            }
            case Save: {
                if (this.editView != null) {
                    this.editView.onError(message);
                    break;
                }
                this.showEmptyView();
                this.errorPanel.setErrorMessage(message);
                break;
            }
            case GetPartner: {
                this.showEmptyView();
                this.errorPanel.setErrorMessage(message);
                break;
            }
            case SavePartner: {
                if (this.editPartnerView != null) {
                    this.editPartnerView.onError(cmd, message);
                    break;
                }
                this.showEmptyView();
                this.errorPanel.setErrorMessage(message);
                break;
            }
            case Delete: {
                if (this.listView != null) {
                    this.listView.onError(cmd, message);
                    break;
                }
                this.showEmptyView();
                this.errorPanel.setErrorMessage(message);
                break;
            }
        }
    }

    public void onError(ContentClassCommand cmd, List<ValidationError> errors) {
        switch (cmd) {
            case Save: {
                if (this.editView != null) {
                    this.editView.onError(errors);
                    break;
                }
                this.showEmptyView();
                break;
            }
            case SavePartner: {
                if (this.editPartnerView != null) {
                    this.editPartnerView.onError(errors);
                    break;
                }
                this.showEmptyView();
                break;
            }
        }
    }

    public void onCCPError(List<CCPValidationError> errors) {
        if (this.editView != null) {
            this.editView.onCCPError(errors);
        } else {
            this.showEmptyView();
        }
    }

    public void onAfterContentClassSave(long id) {
        this.editView.afterSave(id);
    }

    public void onAfterContentClassPartnerSave() {
        this.editPartnerView.afterSave();
    }
}

