/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClassFieldGroup;
import com.tandbergtv.cms.portal.content.client.contentclass.widget.ContentClassComplexFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

public class ComplexFieldPropertiesDialog
extends DialogBox {
    private static final String TIP_MIN = "Enter positive integer from 1 to 99. Leave the field blank to use default (1) value.";
    private static final String TIP_MAX = "Enter positive integer from 1 to 99. Leave the field blank to use default (unlimited) value.";
    private static final String ERROR_STYLE = "WidgetValidationError";
    private ContentClassComplexFieldWidget widget;
    private TextBox txtName;
    private TextBox txtDataType;
    private TextBox txtMin;
    boolean minIsValid = true;
    private TextBox txtMax;
    boolean maxIsValid = true;
    private Button btnSave;

    public ComplexFieldPropertiesDialog(ContentClassComplexFieldWidget widget) {
        this.widget = widget;
        this.addStyleName("FieldPropertiesDialog");
        this.setModal(true);
        this.setText("Properties");
        this.setGlassEnabled(true);
        VerticalPanel rootPanel = new VerticalPanel();
        Panel mainView = this.createMainView();
        rootPanel.add((Widget)mainView);
        Widget buttonPanel = this.createButtonPanel();
        rootPanel.add(buttonPanel);
        this.refresh();
        this.setWidget((Widget)rootPanel);
    }

    private Panel createMainView() {
        SimplePanel panel = new SimplePanel();
        panel.addStyleName("ContentClassEditView");
        if (this.widget == null || this.widget.getGroup() == null) {
            return panel;
        }
        FlexTable table = new FlexTable();
        table.addStyleName("FormPanel");
        table.addStyleName("FormFieldTable");
        int row = 0;
        this.txtName = new TextBox();
        this.txtName.setEnabled(false);
        table.setWidget(row, 0, (Widget)new Label("Field Name"));
        table.setWidget(row, 1, (Widget)this.txtName);
        this.txtDataType = new TextBox();
        this.txtDataType.setEnabled(false);
        this.txtDataType.setValue((Object)"COMPLEX");
        table.setWidget(++row, 0, (Widget)new Label("Data Type"));
        table.setWidget(row, 1, (Widget)this.txtDataType);
        ++row;
        this.txtMin = new TextBox();
        this.txtMin.setMaxLength(2);
        this.txtMin.setTitle(TIP_MIN);
        this.txtMin.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Integer iVal;
                Widget widget = (Widget)event.getSource();
                String value = ComplexFieldPropertiesDialog.trim((String)event.getValue());
                if (!(ComplexFieldPropertiesDialog.isEmpty(value) || (iVal = ComplexFieldPropertiesDialog.parseInt(value)) != null && iVal >= 1)) {
                    widget.addStyleName(ComplexFieldPropertiesDialog.ERROR_STYLE);
                    ComplexFieldPropertiesDialog.this.minIsValid = false;
                    return;
                }
                widget.removeStyleName(ComplexFieldPropertiesDialog.ERROR_STYLE);
                ComplexFieldPropertiesDialog.this.minIsValid = true;
            }
        });
        table.setWidget(row, 0, (Widget)new Label("Min Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtMin);
        ++row;
        this.txtMax = new TextBox();
        this.txtMax.setMaxLength(2);
        this.txtMax.setTitle(TIP_MAX);
        this.txtMax.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                Integer iVal;
                Widget widget = (Widget)event.getSource();
                String value = ComplexFieldPropertiesDialog.trim((String)event.getValue());
                if (!(ComplexFieldPropertiesDialog.isEmpty(value) || (iVal = ComplexFieldPropertiesDialog.parseInt(value)) != null && iVal >= 1)) {
                    widget.addStyleName(ComplexFieldPropertiesDialog.ERROR_STYLE);
                    ComplexFieldPropertiesDialog.this.maxIsValid = false;
                    return;
                }
                widget.removeStyleName(ComplexFieldPropertiesDialog.ERROR_STYLE);
                ComplexFieldPropertiesDialog.this.maxIsValid = true;
            }
        });
        table.setWidget(row, 0, (Widget)new Label("Max Occurrence"));
        table.setWidget(row, 1, (Widget)this.txtMax);
        ++row;
        panel.add((Widget)table);
        return panel;
    }

    private Widget createButtonPanel() {
        this.btnSave = new Button("Save");
        this.btnSave.removeStyleName("gwt-Button");
        this.btnSave.addStyleName("ebBtn");
        this.btnSave.addStyleName("ebBtn_color_green");
        this.btnSave.addStyleName("save_button_icon");
        this.btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ComplexFieldPropertiesDialog.this.onSave();
            }
        });
        Button btnCancel = new Button("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ComplexFieldPropertiesDialog.this.onCancel();
            }
        });
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("ButtonPanel");
        buttonPanel.add((Widget)this.btnSave);
        buttonPanel.add((Widget)btnCancel);
        return buttonPanel;
    }

    private boolean validate() {
        if (!this.minIsValid) {
            return false;
        }
        return this.maxIsValid;
    }

    private void onSave() {
        if (!this.validate()) {
            return;
        }
        UIContentClassFieldGroup uiField = this.widget.getGroup();
        uiField.setMin(ComplexFieldPropertiesDialog.parseInt(this.txtMin.getValue()));
        uiField.setMax(ComplexFieldPropertiesDialog.parseInt(this.txtMax.getValue()));
        this.hide();
    }

    private void onCancel() {
        this.hide();
    }

    private void refresh() {
        if (this.widget == null) {
            return;
        }
        UIContentClassFieldGroup field = this.widget.getGroup();
        if (field == null) {
            return;
        }
        boolean canSave = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Modify"});
        this.btnSave.setEnabled(canSave);
        this.txtName.setValue((Object)field.getDisplayName());
        if (field.isMultiValue()) {
            this.txtMin.setValue((Object)(field.getMin() == null ? "" : String.valueOf(field.getMin())));
            this.txtMax.setValue((Object)(field.getMax() == null ? "" : String.valueOf(field.getMax())));
        }
    }

    private static Integer parseInt(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() < 1;
    }
}

