/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.contentclass.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.dialog.IEditOptionDialogListener;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

public class EditOptionDialog
extends DialogBox {
    private static final String STYLE_ERROR = "CCPopupError";
    private IEditOptionDialogListener listener;
    private Label lblMessage;
    private TextBox txtValue;
    private TextBox txtDisplayName;
    private Button btnSave;

    public EditOptionDialog(IEditOptionDialogListener listener) {
        this.listener = listener;
        this.addStyleName("FieldPropertiesDialog");
        this.setModal(true);
        this.setText("Edit Option");
        this.setGlassEnabled(true);
        VerticalPanel rootPanel = new VerticalPanel();
        this.lblMessage = new Label();
        this.lblMessage.setVisible(false);
        this.lblMessage.addStyleName(STYLE_ERROR);
        rootPanel.add((Widget)this.lblMessage);
        Panel editView = this.createEditView();
        rootPanel.add((Widget)editView);
        Widget buttonPanel = this.createButtonPanel();
        rootPanel.add(buttonPanel);
        this.setWidget((Widget)rootPanel);
    }

    private Panel createEditView() {
        SimplePanel panel = new SimplePanel();
        panel.addStyleName("ContentClassEditView");
        FlexTable table = new FlexTable();
        table.addStyleName("FormPanel");
        table.addStyleName("FormFieldTable");
        int row = 0;
        this.txtValue = new TextBox();
        table.setWidget(row, 0, (Widget)new Label("Value"));
        table.setWidget(row, 1, (Widget)this.txtValue);
        this.txtDisplayName = new TextBox();
        table.setWidget(++row, 0, (Widget)new Label("Display Name"));
        table.setWidget(row, 1, (Widget)this.txtDisplayName);
        ++row;
        panel.add((Widget)table);
        return panel;
    }

    private Widget createButtonPanel() {
        this.btnSave = new Button("Save");
        this.btnSave.removeStyleName("gwt-Button");
        this.btnSave.addStyleName("ebBtn");
        this.btnSave.addStyleName("ebBtn_color_green");
        this.btnSave.addStyleName("save_button_icon");
        this.btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditOptionDialog.this.onSave();
            }
        });
        Button btnCancel = new Button("Cancel");
        btnCancel.removeStyleName("gwt-Button");
        btnCancel.addStyleName("ebBtn");
        btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditOptionDialog.this.onCancel();
            }
        });
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("ButtonPanel");
        buttonPanel.add((Widget)this.btnSave);
        buttonPanel.add((Widget)btnCancel);
        return buttonPanel;
    }

    private void showError(String msg) {
        this.lblMessage.setText(msg);
        this.lblMessage.setVisible(true);
    }

    private void hideError() {
        this.lblMessage.setVisible(false);
    }

    private void onSave() {
        if (this.listener != null) {
            String validationError = this.listener.onSave(this.txtValue.getText(), this.txtDisplayName.getText());
            if (validationError != null) {
                this.showError(validationError);
                return;
            }
            this.hideError();
        }
        this.hide();
    }

    private void onCancel() {
        this.hide();
    }

    public void refresh(String value, String displayName) {
        boolean canSave = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Modify"});
        this.btnSave.setEnabled(canSave);
        this.setText("Edit Option");
        this.txtValue.setText(value);
        this.txtDisplayName.setText(displayName);
    }

    public void refresh() {
        boolean canSave = ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContentClassManagement_View", "ContentClassManagement_Modify"});
        this.btnSave.setEnabled(canSave);
        this.setText("Add Option");
        this.txtValue.setText("");
        this.txtDisplayName.setText("");
    }
}

